/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;

public class NodeImpl
extends IdentifiableElementImpl
implements Node {
    protected Node delegate = null;
    protected Graph graph = null;

    public NodeImpl() {
    }

    public NodeImpl(Node delegate) {
        this.delegate = delegate;
    }

    public Node getDelegate() {
        return this.delegate;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        Graph oldGraph = this.getGraph();
        if (graph != null) {
            graph.addNode(this);
        }
        if (oldGraph != null && oldGraph != graph && oldGraph instanceof GraphImpl) {
            ((GraphImpl)oldGraph).basicRemoveNode(this);
        }
        this.basicSetGraph(graph);
    }

    protected void basicSetGraph(Graph graph) {
        if (this.graph != graph && this.graph instanceof GraphImpl) {
            ((GraphImpl)this.graph).basicRemoveNode(this);
        }
        this.graph = graph;
    }

    @Override
    public Set<? extends Layer> getLayers() {
        Set allLayers;
        HashSet<Layer> layers = new HashSet<Layer>();
        if (this.getGraph() != null && (allLayers = this.getGraph().getLayers()) != null && allLayers.size() > 0) {
            for (Layer layer : allLayers) {
                if (!layer.getNodes().contains(this)) continue;
                layers.add(layer);
            }
        }
        return Collections.unmodifiableSet(layers);
    }

    @Override
    public void addLayer(Layer layer) {
        if (layer != null) {
            layer.addNode(this);
        }
    }

    @Override
    public void removeLayer(Layer layer) {
        if (layer != null) {
            layer.removeNode(this);
        }
    }
}

