/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;

public class RelationImpl<S extends Node, T extends Node>
extends IdentifiableElementImpl
implements Relation<S, T> {
    protected Relation<S, T> delegate = null;
    protected S source = null;
    private T target = null;
    protected Graph graph = null;

    public RelationImpl() {
    }

    public RelationImpl(Relation<S, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Relation<S, T> getDelegate() {
        return this.delegate;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public void setSource(S source) {
        S oldValue = this.getSource();
        this.source = source;
        if (this.getGraph() != null && this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).update(oldValue, this, GraphImpl.UPDATE_TYPE.RELATION_SOURCE);
        }
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(T target) {
        T oldValue = this.getTarget();
        this.target = target;
        if (this.getGraph() != null && this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).update(oldValue, this, GraphImpl.UPDATE_TYPE.RELATION_TARGET);
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        Graph oldGraph = this.getGraph();
        if (graph != null) {
            graph.addRelation(this);
        }
        if (oldGraph != null && oldGraph != graph && oldGraph instanceof GraphImpl) {
            ((GraphImpl)oldGraph).basicRemoveRelation(this);
        }
        this.basicSetGraph(graph);
    }

    protected void basicSetGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Set<? extends Layer> getLayers() {
        Set allLayers;
        HashSet<Layer> layers = new HashSet<Layer>();
        if (this.getGraph() != null && (allLayers = this.getGraph().getLayers()) != null && allLayers.size() > 0) {
            for (Layer layer : allLayers) {
                if (!layer.getRelations().contains(this)) continue;
                layers.add(layer);
            }
        }
        return layers;
    }

    @Override
    public void addLayer(Layer layer) {
        if (layer != null) {
            layer.addRelation(this);
        }
    }

    @Override
    public void removeLayer(Layer layer) {
        if (layer != null) {
            layer.removeRelation(this);
        }
    }
}

