/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;

public class Diff {
    private SDocumentGraph templateGraph = null;
    private SDocumentGraph otherGraph = null;
    private Map<String, Boolean> options = null;
    public static final String OPTION_IGNORE_FEATURES = "ignoreFeatures";
    public static final String OPTION_IGNORE_ANNOTATIONS = "ignoreAnnotations";
    public static final String OPTION_IGNORE_META_ANNOTATIONS = "ignoreMetaAnnotstaions";
    public static final String OPTION_IGNORE_PROCESSING_ANNOTATIONS = "ignoreProcessingAnnotations";
    public static final String OPTION_IGNORE_ID = "ignoreId";
    public static final String OPTION_IGNORE_NAME = "ignoreName";
    public static final String OPTION_IGNORE_LAYER = "ignoreLayer";
    private Set<Difference> differences = null;
    private boolean diffsRequested = false;
    private BiMap<SNode, SNode> isoNodes = null;

    public Diff(SDocumentGraph template, SDocumentGraph other) {
        this(template, other, null);
    }

    public Diff(SDocumentGraph template, SDocumentGraph other, Map<String, Boolean> optionMap) {
        this.templateGraph = template;
        this.otherGraph = other;
        if (optionMap == null) {
            optionMap = new DiffOptions();
        }
        this.options = optionMap;
    }

    private Set<Difference> getDifferences() {
        if (this.differences == null) {
            this.differences = new LinkedHashSet<Difference>();
        }
        return this.differences;
    }

    private void addDifference(Object templateObject, Object otherObject, Object container, DIFF_TYPES diffType, Set<Difference> subDiffs) {
        Difference tempDiff = new Difference(templateObject, otherObject, container, diffType);
        if (subDiffs != null) {
            tempDiff.addSubDiffs(subDiffs);
        }
        this.getDifferences().add(tempDiff);
    }

    public boolean isIsomorph() {
        this.diffsRequested = false;
        return this.findDiffs(false);
    }

    public Set<Difference> findDiffs() {
        this.diffsRequested = true;
        this.findDiffs(true);
        return this.getDifferences();
    }

    private boolean findDiffs(boolean diffsRequested) {
        if (!this.compareSize(this.templateGraph, this.otherGraph) && !diffsRequested) {
            return false;
        }
        if (!this.compareDataSources(this.templateGraph, this.otherGraph, diffsRequested) && !diffsRequested) {
            return false;
        }
        if (!this.compareTokens(this.templateGraph, this.otherGraph, diffsRequested) && !diffsRequested) {
            return false;
        }
        List<SNode> roots = this.otherGraph.getRootsByRelation(SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SDOMINANCE_RELATION);
        if (roots != null && roots.size() != 0) {
            ArrayList<SNode> remainingTemplateNodes = new ArrayList<SNode>(this.templateGraph.getSpans().size() + this.templateGraph.getStructures().size());
            remainingTemplateNodes.addAll(this.templateGraph.getSpans());
            remainingTemplateNodes.addAll(this.templateGraph.getStructures());
            DifferenceHandler handler = new DifferenceHandler();
            handler.remainingTemplateNodes = remainingTemplateNodes;
            this.otherGraph.traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "diff_" + this.templateGraph.getId(), handler, false);
            if (this.getDifferences().size() > 0) {
                return false;
            }
            if (remainingTemplateNodes.size() > 0) {
                for (SNode remainingNode : remainingTemplateNodes) {
                    if (!diffsRequested) {
                        return false;
                    }
                    this.addDifference(remainingNode, null, null, DIFF_TYPES.NODE_MISSING, null);
                }
            }
        }
        if (!this.compareRelations(this.templateGraph, this.templateGraph.getPointingRelations(), this.otherGraph, this.otherGraph.getPointingRelations(), diffsRequested) && !diffsRequested) {
            return false;
        }
        if (!this.compareRelations(this.templateGraph, this.templateGraph.getOrderRelations(), this.otherGraph, this.otherGraph.getOrderRelations(), diffsRequested) && !diffsRequested) {
            return false;
        }
        return this.options.get(OPTION_IGNORE_LAYER) != false || this.compareLayers(this.templateGraph, this.otherGraph, diffsRequested) || diffsRequested;
    }

    private boolean compareSize(SDocumentGraph template, SDocumentGraph other) {
        if (template.getNodes().size() != other.getNodes().size()) {
            return false;
        }
        if (template.getRelations().size() != other.getRelations().size()) {
            return false;
        }
        if (template.getTextualDSs().size() != other.getTextualDSs().size()) {
            return false;
        }
        if (template.getTextualRelations().size() != other.getTextualRelations().size()) {
            return false;
        }
        if (template.getTokens().size() != other.getTokens().size()) {
            return false;
        }
        if (template.getOrderRelations().size() != other.getOrderRelations().size()) {
            return false;
        }
        if (template.getPointingRelations().size() != other.getPointingRelations().size()) {
            return false;
        }
        if (template.getSpanningRelations().size() != other.getSpanningRelations().size()) {
            return false;
        }
        if (template.getSpans().size() != other.getSpans().size()) {
            return false;
        }
        if (template.getDominanceRelations().size() != other.getDominanceRelations().size()) {
            return false;
        }
        if (template.getStructures().size() != other.getStructures().size()) {
            return false;
        }
        if (template.getMedialDSs().size() != other.getMedialDSs().size()) {
            return false;
        }
        if (template.getMedialRelations().size() != other.getMedialRelations().size()) {
            return false;
        }
        if (template.getTimelineRelations().size() != other.getTimelineRelations().size()) {
            return false;
        }
        return this.options.get(OPTION_IGNORE_LAYER) != false || template.getLayers().size() == other.getLayers().size();
    }

    public BiMap<SNode, SNode> getIsoNodes() {
        if (this.isoNodes == null) {
            this.isoNodes = HashBiMap.create();
        }
        return this.isoNodes;
    }

    private boolean compareDataSources(SDocumentGraph template, SDocumentGraph other, boolean diff) {
        boolean retVal1 = this.compareDataSources(template.getTextualDSs(), other.getTextualDSs(), diff);
        if (!diff && !retVal1) {
            return retVal1;
        }
        boolean retVal2 = this.compareDataSources(template.getMedialDSs(), other.getMedialDSs(), diff);
        return retVal1 && retVal2;
    }

    private boolean compareDataSources(List<SSequentialDS> template, List<SSequentialDS> other, boolean diff) {
        boolean iso = true;
        Hashtable dataToDS = new Hashtable();
        HashSet<SSequentialDS> remainingTemplates = new HashSet<SSequentialDS>();
        for (SSequentialDS sSequentialDS : template) {
            dataToDS.put(sSequentialDS.getData(), sSequentialDS);
            remainingTemplates.add(sSequentialDS);
        }
        for (SSequentialDS sSequentialDS : other) {
            SSequentialDS templateDS = (SSequentialDS)dataToDS.get(sSequentialDS.getData());
            if (templateDS == null) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(null, sSequentialDS, null, DIFF_TYPES.NODE_MISSING, null);
                continue;
            }
            this.getIsoNodes().put((Object)templateDS, (Object)sSequentialDS);
            HashSet<Difference> subDiffs = new HashSet<Difference>();
            this.compareIdentifiableElements(templateDS, sSequentialDS, subDiffs);
            if (subDiffs.size() > 0) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateDS, sSequentialDS, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            subDiffs = new HashSet();
            this.compareAnnotationContainers(templateDS, sSequentialDS, subDiffs);
            if (subDiffs.size() > 0) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateDS, sSequentialDS, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            remainingTemplates.remove(templateDS);
        }
        if (remainingTemplates.size() > 0) {
            for (SSequentialDS sSequentialDS : remainingTemplates) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(sSequentialDS, null, null, DIFF_TYPES.NODE_MISSING, null);
            }
        }
        return iso;
    }

    private boolean compareTokens(SDocumentGraph template, SDocumentGraph other, boolean diff) {
        boolean iso = true;
        Hashtable textDSsToOffsetMap = new Hashtable();
        HashSet<STextualRelation> remainingTemplates = new HashSet<STextualRelation>();
        for (STextualRelation textRel : template.getTextualRelations()) {
            Hashtable<String, STextualRelation> offsetMap = (Hashtable<String, STextualRelation>)textDSsToOffsetMap.get(textRel.getTarget());
            if (offsetMap == null) {
                offsetMap = new Hashtable<String, STextualRelation>();
                textDSsToOffsetMap.put(textRel.getTarget(), offsetMap);
            }
            offsetMap.put(textRel.getStart() + "#" + textRel.getEnd(), textRel);
            remainingTemplates.add(textRel);
        }
        for (STextualRelation otherRel : other.getTextualRelations()) {
            STextualDS templateDS = (STextualDS)this.getIsoNodes().inverse().get(otherRel.getTarget());
            if (templateDS != null) {
                Map offsetMap = (Map)textDSsToOffsetMap.get(templateDS);
                STextualRelation templateRel = (STextualRelation)offsetMap.get(otherRel.getStart() + "#" + otherRel.getEnd());
                if (templateRel == null) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(null, otherRel.getTarget(), null, DIFF_TYPES.NODE_MISSING, null);
                    continue;
                }
                this.getIsoNodes().put(templateRel.getSource(), otherRel.getSource());
                HashSet<Difference> subDiffs = new HashSet<Difference>();
                this.compareIdentifiableElements((IdentifiableElement)templateRel.getSource(), (IdentifiableElement)otherRel.getSource(), (Set<Difference>)subDiffs);
                if (subDiffs.size() > 0) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(templateRel.getSource(), otherRel.getSource(), null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
                }
                subDiffs = new HashSet();
                this.compareAnnotationContainers((SAnnotationContainer)templateRel.getSource(), (SAnnotationContainer)otherRel.getSource(), subDiffs);
                if (subDiffs.size() > 0) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(templateRel.getSource(), otherRel.getSource(), null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
                }
                remainingTemplates.remove(templateRel);
                continue;
            }
            if (!diff) {
                return false;
            }
            iso = false;
            this.addDifference(null, otherRel.getTarget(), null, DIFF_TYPES.NODE_MISSING, null);
        }
        if (remainingTemplates.size() > 0) {
            for (STextualRelation templateRel : remainingTemplates) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateRel.getSource(), null, null, DIFF_TYPES.NODE_MISSING, null);
            }
        }
        return iso;
    }

    public boolean compareIdentifiableElements(IdentifiableElement template, IdentifiableElement other, Set<Difference> subDiffs) {
        boolean retVal = true;
        if (!this.options.get(OPTION_IGNORE_ID).booleanValue() && !template.getId().equals(other.getId())) {
            retVal = false;
            if (subDiffs != null) {
                subDiffs.add(new Difference(template, other, null, DIFF_TYPES.ID_DIFFERING));
            }
        }
        return retVal;
    }

    public boolean compareAnnotationContainers(SAnnotationContainer template, SAnnotationContainer other, Set<Difference> subDiffs) {
        Iterator<SAbstractAnnotation> templateIterator;
        Iterator<SAbstractAnnotation> otherIterator;
        boolean retVal1 = true;
        boolean retVal2 = true;
        boolean retVal3 = true;
        boolean retVal4 = true;
        if (!this.options.get(OPTION_IGNORE_ANNOTATIONS).booleanValue()) {
            otherIterator = other.iterator_SAnnotation();
            templateIterator = template.iterator_SAnnotation();
            retVal1 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!this.options.get(OPTION_IGNORE_META_ANNOTATIONS).booleanValue()) {
            otherIterator = other.iterator_SMetaAnnotation();
            templateIterator = template.iterator_SMetaAnnotation();
            retVal2 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!this.options.get(OPTION_IGNORE_PROCESSING_ANNOTATIONS).booleanValue()) {
            otherIterator = other.iterator_SProcessingAnnotation();
            templateIterator = template.iterator_SProcessingAnnotation();
            retVal3 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!this.options.get(OPTION_IGNORE_FEATURES).booleanValue()) {
            otherIterator = other.iterator_SFeature();
            templateIterator = template.iterator_SFeature();
            retVal4 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        return retVal1 && retVal2 && retVal3 && retVal4;
    }

    private boolean compareAnnotationContainers(SAnnotationContainer template, Iterator<SAbstractAnnotation> templateIterator, SAnnotationContainer other, Iterator<SAbstractAnnotation> otherIterator, Set<Difference> subDiffs) {
        boolean retVal = true;
        HashSet<SAbstractAnnotation> remainingLabels = new HashSet<SAbstractAnnotation>();
        while (otherIterator.hasNext()) {
            SAbstractAnnotation anno = otherIterator.next();
            if (anno instanceof SFeature && this.options.get(OPTION_IGNORE_NAME).booleanValue() && "salt::SNAME".equals(anno.getQName())) continue;
            remainingLabels.add(anno);
        }
        while (templateIterator.hasNext()) {
            SAbstractAnnotation templateAnno = templateIterator.next();
            if (templateAnno instanceof SFeature && this.options.get(OPTION_IGNORE_NAME).booleanValue() && "salt::SNAME".equals(templateAnno.getQName())) continue;
            SAbstractAnnotation otherAnno = (SAbstractAnnotation)other.getLabel(templateAnno.getQName());
            if (otherAnno == null) {
                if (subDiffs != null) {
                    subDiffs.add(new Difference(templateAnno, null, template, DIFF_TYPES.LABEL_MISSING));
                    retVal = false;
                    continue;
                }
                return false;
            }
            if (!otherAnno.getValue().equals(templateAnno.getValue())) {
                if (subDiffs != null) {
                    subDiffs.add(new Difference(templateAnno, otherAnno, null, DIFF_TYPES.LABEL_VALUE_DIFFERING));
                    retVal = false;
                    continue;
                }
                return false;
            }
            remainingLabels.remove(otherAnno);
        }
        if (remainingLabels.size() > 0) {
            if (subDiffs != null) {
                retVal = false;
                for (SAbstractAnnotation otherAnno : remainingLabels) {
                    subDiffs.add(new Difference(null, otherAnno, other, DIFF_TYPES.LABEL_MISSING));
                }
            } else {
                return false;
            }
        }
        return retVal;
    }

    public boolean compareRelations(SDocumentGraph template, List<? extends SRelation> templateRels, SDocumentGraph other, List<? extends SRelation> otherRels, Boolean diff) {
        boolean iso = true;
        HashSet<SRelation> otherRelSet = new HashSet<SRelation>();
        Iterator iterator = otherRels.iterator();
        while (iterator.hasNext()) {
            otherRelSet.add(iterator.next());
        }
        for (SRelation sRelation : templateRels) {
            SNode tempSource = (SNode)sRelation.getSource();
            SNode tempTarget = (SNode)sRelation.getTarget();
            SNode otherSource = (SNode)this.getIsoNodes().get((Object)tempSource);
            SNode otherTarget = (SNode)this.getIsoNodes().get((Object)tempTarget);
            if (otherSource == null || otherTarget == null) continue;
            Iterator inBetweenIterator = other.getInRelations(otherTarget.getId()).iterator();
            boolean isRelIso = true;
            while (inBetweenIterator.hasNext()) {
                isRelIso = true;
                SRelation otherRel = (SRelation)inBetweenIterator.next();
                if (((SNode)otherRel.getSource()).equals(otherSource) && sRelation.getClass().equals(otherRel.getClass())) {
                    HashSet<Difference> subDiffs = new HashSet<Difference>();
                    this.compareIdentifiableElements(sRelation, otherRel, subDiffs);
                    if (subDiffs.size() > 0) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        isRelIso = false;
                        this.addDifference(sRelation, otherRel, null, DIFF_TYPES.RELATION_DIFFERING, subDiffs);
                    }
                    subDiffs = new HashSet();
                    this.compareAnnotationContainers(sRelation, otherRel, subDiffs);
                    if (subDiffs.size() > 0) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        isRelIso = false;
                        this.addDifference(sRelation, otherRel, null, DIFF_TYPES.RELATION_DIFFERING, subDiffs);
                    }
                } else {
                    isRelIso = false;
                }
                if (!isRelIso) continue;
                otherRelSet.remove(otherRel);
                break;
            }
            if (isRelIso) continue;
            this.addDifference(sRelation, null, null, DIFF_TYPES.RELATION_MISSING, null);
            iso = false;
        }
        if (otherRelSet.size() > 0) {
            iterator = otherRelSet.iterator();
            while (iterator.hasNext()) {
                this.addDifference(null, iterator.next(), null, DIFF_TYPES.RELATION_MISSING, null);
            }
            iso = false;
        }
        return iso;
    }

    public boolean compareLayers(SDocumentGraph template, SDocumentGraph other, Boolean diff) {
        HashSet<SLayer> remainingLayers = new HashSet<SLayer>();
        HashMultimap nameToLayer = HashMultimap.create();
        for (SLayer templateLayer : template.getLayers()) {
            nameToLayer.put((Object)templateLayer.getName(), (Object)templateLayer);
            remainingLayers.add(templateLayer);
        }
        block1: for (SLayer otherLayer : other.getLayers()) {
            Collection templateLayers = nameToLayer.get((Object)otherLayer.getName());
            if (templateLayers == null || templateLayers.size() == 0) {
                if (!diff.booleanValue()) {
                    return false;
                }
                this.addDifference(null, otherLayer, null, DIFF_TYPES.LAYER_MISSING, null);
                continue;
            }
            int i = 0;
            for (SLayer templateLayer : templateLayers) {
                boolean morePotentialPartners = ++i < templateLayers.size();
                boolean matches = true;
                if (templateLayer.getNodes().size() != otherLayer.getNodes().size()) {
                    matches = false;
                    if (!morePotentialPartners) {
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, null);
                        if (!diff.booleanValue()) {
                            return false;
                        }
                    }
                }
                if (templateLayer.getRelations().size() != otherLayer.getRelations().size()) {
                    matches = false;
                    if (!morePotentialPartners) {
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, null);
                        if (!diff.booleanValue()) {
                            return false;
                        }
                    }
                }
                HashSet<Difference> subDiffs = new HashSet<Difference>();
                this.compareIdentifiableElements(templateLayer, otherLayer, subDiffs);
                if (subDiffs.size() > 0) {
                    matches = false;
                    if (!morePotentialPartners) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, subDiffs);
                    }
                }
                subDiffs = new HashSet();
                this.compareAnnotationContainers(templateLayer, otherLayer, subDiffs);
                if (subDiffs.size() > 0) {
                    matches = false;
                    if (!morePotentialPartners) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, subDiffs);
                    }
                }
                if (!matches) continue;
                remainingLayers.remove(templateLayer);
                continue block1;
            }
        }
        if (remainingLayers.size() > 0) {
            for (SLayer layer : remainingLayers) {
                if (!diff.booleanValue()) {
                    return false;
                }
                this.addDifference(layer, null, null, DIFF_TYPES.LAYER_MISSING, null);
            }
        }
        return true;
    }

    private class DifferenceHandler
    implements GraphTraverseHandler {
        List<SNode> remainingTemplateNodes = null;
        private boolean abort = false;
        private Set<SRelation> visitedRelations = new HashSet<SRelation>();

        private DifferenceHandler() {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation sRelation, SNode currNode, long order) {
            if (this.abort) {
                return false;
            }
            boolean retVal = true;
            if (sRelation != null) {
                if (sRelation instanceof SPointingRelation) {
                    retVal = false;
                } else if (currNode instanceof SToken) {
                    retVal = false;
                } else if (this.visitedRelations.contains(sRelation)) {
                    retVal = false;
                } else {
                    this.visitedRelations.add(sRelation);
                }
            }
            return retVal;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode otherNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode otherNode, long order) {
            if (currNode instanceof SSpan) {
                if (!this.findIsomorphicNode(currNode, SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SSPAN)) {
                    this.abort = true;
                }
            } else if (currNode instanceof SStructure) {
                if (!this.findIsomorphicNode(currNode, SALT_TYPE.SDOMINANCE_RELATION, SALT_TYPE.SSTRUCTURE)) {
                    this.abort = true;
                }
            } else if (!(currNode instanceof STextualDS)) {
                throw new SaltException("Computing of Differences is not implemented for this node type: " + currNode);
            }
        }

        private boolean findIsomorphicNode(SNode otherNode, SALT_TYPE sTypeRelations, SALT_TYPE nodeType) {
            SNode templateNode = null;
            List<SNode> children = Diff.this.otherGraph.getChildren(otherNode, sTypeRelations);
            ArrayList<SNode> templateChildren = new ArrayList<SNode>();
            for (SNode child : children) {
                SNode templateChild = (SNode)Diff.this.getIsoNodes().inverse().get((Object)child);
                if (templateChild == null) continue;
                templateChildren.add(templateChild);
            }
            List<Object> sharedParents = new ArrayList();
            if (templateChildren.size() > 0) {
                sharedParents = Diff.this.templateGraph.getSharedParent(templateChildren, nodeType);
            }
            if (sharedParents.size() == 1) {
                templateNode = (SNode)sharedParents.get(0);
            } else if (sharedParents.size() > 1) {
                List<SRelation> otherOutRels = otherNode.getOutRelations();
                HashSet<SNode> trueCandidates = new HashSet<SNode>();
                for (SNode sNode : sharedParents) {
                    List<SRelation> templateOutRels = sNode.getOutRelations();
                    if (otherOutRels.size() != templateOutRels.size()) continue;
                    HashSet<SNode> otherChldren = new HashSet<SNode>();
                    Iterator<SRelation> it = otherOutRels.iterator();
                    while (it.hasNext()) {
                        otherChldren.add((SNode)it.next().getTarget());
                    }
                    boolean trueCandidate = true;
                    Iterator<SRelation> it_template = templateOutRels.iterator();
                    while (it_template.hasNext()) {
                        SNode templateChild = (SNode)it_template.next().getTarget();
                        if (otherChldren.contains(Diff.this.getIsoNodes().get((Object)templateChild))) continue;
                        trueCandidate = false;
                        break;
                    }
                    if (!trueCandidate) continue;
                    trueCandidates.add(sNode);
                }
                if (trueCandidates.size() > 1) {
                    int minNumberOfDiffs = Integer.MAX_VALUE;
                    for (SNode trueCandidate : trueCandidates) {
                        HashSet<Difference> subDiff = new HashSet<Difference>();
                        Diff.this.compareAnnotationContainers(trueCandidate, otherNode, subDiff);
                        if (subDiff.size() >= minNumberOfDiffs) continue;
                        minNumberOfDiffs = subDiff.size();
                        templateNode = trueCandidate;
                    }
                } else if (!trueCandidates.isEmpty()) {
                    templateNode = (SNode)trueCandidates.iterator().next();
                }
            }
            if (templateNode == null) {
                if (!Diff.this.diffsRequested) {
                    return false;
                }
                Diff.this.addDifference(null, otherNode, null, DIFF_TYPES.NODE_MISSING, null);
                return false;
            }
            boolean isIsomorph = true;
            Diff.this.getIsoNodes().put((Object)templateNode, (Object)otherNode);
            this.remainingTemplateNodes.remove(templateNode);
            HashSet<Difference> subDiffs = new HashSet<Difference>();
            Diff.this.compareIdentifiableElements(templateNode, otherNode, subDiffs);
            if (subDiffs.size() > 0) {
                if (!Diff.this.diffsRequested) {
                    return false;
                }
                isIsomorph = false;
                Diff.this.addDifference(templateNode, otherNode, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            subDiffs = new HashSet();
            Diff.this.compareAnnotationContainers(templateNode, otherNode, subDiffs);
            if (subDiffs.size() > 0) {
                if (!Diff.this.diffsRequested) {
                    return false;
                }
                isIsomorph = false;
                Diff.this.addDifference(templateNode, otherNode, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            return isIsomorph;
        }
    }
}

