/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLWriter {
    private static final Logger log = LoggerFactory.getLogger(GraphMLWriter.class);
    public static final String NS = "http://graphml.graphdrawing.org/xmlns";

    public static void convertFromSalt(OutputStream out, SDocument ... docs) {
        GraphMLWriter.writeDocuments(out, Arrays.asList(docs));
    }

    public static void writeDocuments(OutputStream out, List<SDocument> docs) {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        try {
            XMLStreamWriter w = factory.createXMLStreamWriter(out);
            w.setDefaultNamespace(NS);
            w.writeStartDocument();
            w.writeStartElement(NS, "graphml");
            w.writeDefaultNamespace(NS);
            w.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            w.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd");
            HashSet<String> existingKeys = new HashSet<String>();
            IDManager ids = new IDManager();
            w.writeStartElement(NS, "key");
            w.writeAttribute("id", "salt::type");
            w.writeAttribute("attr.name", "salt::type");
            w.writeAttribute("for", "all");
            w.writeAttribute("attr.type", "string");
            w.writeEndElement();
            existingKeys.add("salt::type");
            if (docs != null) {
                for (SDocument doc : docs) {
                    SDocumentGraph g = doc.getDocumentGraph();
                    if (g == null) continue;
                    GraphMLWriter.writeKeys(w, g.getNodes(), existingKeys);
                    GraphMLWriter.writeKeys(w, g.getRelations(), existingKeys);
                    if (g.getDocument() == null) continue;
                    GraphMLWriter.writeKeys(w, g.getDocument().getLabels(), existingKeys);
                }
                for (SDocument d : docs) {
                    GraphMLWriter.writeSDocumentGraph(w, d.getDocumentGraph(), ids, existingKeys, true);
                }
            }
            w.writeEndDocument();
            w.close();
            out.flush();
        }
        catch (IOException | XMLStreamException ex) {
            log.error("Could not write GraphML", (Throwable)ex);
        }
    }

    private static void writeKeys(XMLStreamWriter w, Collection<? extends LabelableElement> elements, Set<String> existing) throws XMLStreamException {
        if (elements != null && !elements.isEmpty()) {
            for (LabelableElement labelableElement : elements) {
                Collection<Label> labels = labelableElement.getLabels();
                if (labels == null || labels.isEmpty()) continue;
                for (Label l : labels) {
                    String id = l.getQName();
                    if (existing.contains(id)) continue;
                    Object o = l.getValue();
                    String type = null;
                    if (o instanceof Boolean) {
                        type = "boolean";
                    } else if (o instanceof Integer) {
                        type = "int";
                    } else if (o instanceof Long) {
                        type = "long";
                    } else if (o instanceof Float) {
                        type = "float";
                    } else if (o instanceof Double) {
                        type = "double";
                    } else if (o instanceof String) {
                        type = "string";
                    }
                    if (type == null) continue;
                    w.writeStartElement(NS, "key");
                    w.writeAttribute("id", l.getQName());
                    w.writeAttribute("attr.name", l.getQName());
                    w.writeAttribute("for", "all");
                    w.writeAttribute("attr.type", type);
                    w.writeEndElement();
                    existing.add(id);
                }
            }
        }
    }

    private static void writeLabels(XMLStreamWriter w, Collection<Label> labels, Set<String> existingKeys) throws XMLStreamException {
        if (labels != null && !labels.isEmpty()) {
            for (Label l : labels) {
                String key = l.getQName();
                if (!existingKeys.contains(key)) continue;
                w.writeStartElement(NS, "data");
                w.writeAttribute("key", key);
                w.writeCharacters("" + l.getValue());
                w.writeEndElement();
            }
        }
    }

    private static void writeType(XMLStreamWriter w, Object o) throws XMLStreamException {
        Set<SALT_TYPE> types = SALT_TYPE.class2SaltType(o.getClass());
        if (!types.isEmpty()) {
            w.writeStartElement(NS, "data");
            w.writeAttribute("key", "salt::type");
            w.writeCharacters(types.iterator().next().name());
            w.writeEndElement();
        }
    }

    private static void writeNode(XMLStreamWriter w, Node c, IDManager ids, Set<String> existingKeys) throws XMLStreamException {
        w.writeStartElement(NS, "node");
        w.writeAttribute("id", ids.getID(c));
        GraphMLWriter.writeType(w, c);
        GraphMLWriter.writeLabels(w, c.getLabels(), existingKeys);
        w.writeEndElement();
    }

    private static void writeEdge(XMLStreamWriter w, Relation r, IDManager ids, Set<String> existingKeys) throws XMLStreamException {
        w.writeStartElement(NS, "edge");
        w.writeAttribute("id", ids.getID(r));
        w.writeAttribute("source", ids.getID(r.getSource()));
        w.writeAttribute("target", ids.getID(r.getTarget()));
        GraphMLWriter.writeType(w, r);
        GraphMLWriter.writeLabels(w, r.getLabels(), existingKeys);
        w.writeEndElement();
    }

    private static void writeSDocumentGraph(XMLStreamWriter w, SDocumentGraph g, IDManager ids, Set<String> existingKeys, boolean includeDocLabels) throws XMLStreamException {
        if (g == null) {
            return;
        }
        List nodes = g.getNodes();
        List relations = g.getRelations();
        if (nodes != null && !nodes.isEmpty()) {
            w.writeStartElement(NS, "graph");
            w.writeAttribute("id", ids.getID(g));
            w.writeAttribute("edgedefault", "directed");
            if (includeDocLabels && g.getDocument() != null) {
                GraphMLWriter.writeLabels(w, g.getDocument().getLabels(), existingKeys);
            }
            for (SNode n : nodes) {
                GraphMLWriter.writeNode(w, n, ids, existingKeys);
            }
            if (relations != null) {
                for (SRelation e : relations) {
                    GraphMLWriter.writeEdge(w, e, ids, existingKeys);
                }
            }
            w.writeEndElement();
        }
    }

    private static class IDManager {
        private final AtomicLong counter = new AtomicLong(0L);
        private final Map<IdentifiableElement, String> existing = new HashMap<IdentifiableElement, String>();

        private IDManager() {
        }

        private String getID(IdentifiableElement e) {
            String id = this.existing.get(e);
            if (id == null) {
                id = "_" + this.counter.getAndIncrement();
                this.existing.put(e, id);
            }
            return id;
        }
    }
}

