/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.common.impl.SCorpusGraphImpl;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;

public class SaltProjectImpl
implements SaltProject {
    private List<SCorpusGraph> corpusGraphs = new ArrayList<SCorpusGraph>();
    private String name = null;

    @Override
    public List<SCorpusGraph> getCorpusGraphs() {
        return Collections.unmodifiableList(this.corpusGraphs);
    }

    @Override
    public void addCorpusGraph(SCorpusGraph corpusGraph) {
        if (corpusGraph != null && corpusGraph instanceof SCorpusGraphImpl) {
            ((SCorpusGraphImpl)corpusGraph).basic_setSaltProject(this);
        }
        this.basic_addCorpusGraph(corpusGraph);
    }

    public void basic_addCorpusGraph(SCorpusGraph corpusGraph) {
        if (corpusGraph != null) {
            this.corpusGraphs.add(corpusGraph);
        }
    }

    @Override
    public void removeCorpusGraph(SCorpusGraph corpusGraph) {
        if (corpusGraph != null && corpusGraph instanceof SCorpusGraphImpl) {
            ((SCorpusGraphImpl)corpusGraph).basic_setSaltProject(null);
        }
        this.basic_removeCorpusGraph(corpusGraph);
    }

    public void basic_removeCorpusGraph(SCorpusGraph corpusGraph) {
        if (corpusGraph != null) {
            this.corpusGraphs.remove(corpusGraph);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void saveSaltProject(URI saltProjectURI) {
        SaltUtil.saveSaltProject(this, saltProjectURI);
    }

    @Override
    public void loadSaltProject(URI saltProjectURI) {
        if (saltProjectURI == null) {
            throw new SaltResourceException("Cannot load salt project, because the paassed uri is null.");
        }
        this.loadCorpusStructure(saltProjectURI);
        for (SCorpusGraph sCorpusGraph : this.getCorpusGraphs()) {
            for (SDocument sDoc : sCorpusGraph.getDocuments()) {
                try {
                    sDoc.loadDocumentGraph();
                }
                catch (SaltResourceException e) {
                    throw new SaltResourceException("A problem occured when loading salt project from '" + saltProjectURI + "', because one of its documents could not have been load '" + sDoc.getId() + "'.", e);
                }
                catch (Exception e) {
                    throw new SaltResourceException("A problem occured when loading salt project from '" + saltProjectURI + "', because of a nested exception during loading one of its documents '" + sDoc.getId() + "'.", e);
                }
            }
        }
    }

    @Override
    public void loadCorpusStructure(URI saltProjectURI) {
        List<SCorpusGraph> corpusGraphList = this.getCorpusGraphs();
        if (corpusGraphList != null) {
            for (SCorpusGraph corpusGraph : new LinkedList<SCorpusGraph>(corpusGraphList)) {
                this.removeCorpusGraph(corpusGraph);
            }
        }
        SaltProject loadedProject = SaltUtil.loadSaltProject(saltProjectURI);
        this.setName(loadedProject.getName());
        for (SCorpusGraph corpusGraph : new LinkedList<SCorpusGraph>(loadedProject.getCorpusGraphs())) {
            this.addCorpusGraph(corpusGraph);
        }
    }

    public String toString() {
        StringBuilder retStr = new StringBuilder();
        retStr.append("SaltProject(");
        retStr.append(this.getName());
        retStr.append(")");
        retStr.append(": ");
        retStr.append(this.getCorpusGraphs().size());
        retStr.append("corpus graphs");
        return retStr.toString();
    }

    @Override
    public SCorpusGraph createCorpusGraph() {
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        this.addCorpusGraph(corpGraph);
        return corpGraph;
    }
}

