/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.impl.LabelImpl;
import org.corpus_tools.salt.util.SaltUtil;

public abstract class LabelableElementImpl
implements LabelableElement,
Serializable {
    public static final int EXPECTED_NUMBER_OF_LABELS = 5;
    protected LabelableElement delegate = null;
    private Map<String, Label> labels = null;

    public LabelableElementImpl() {
    }

    protected LabelableElement getDelegate() {
        return this.delegate;
    }

    public LabelableElementImpl(LabelableElement delegatee) {
        this.delegate = delegatee;
    }

    @Override
    public Collection<Label> getLabels() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLabels();
        }
        Collection<Label> retVal = null;
        if (this.labels != null) {
            retVal = this.labels.values();
        }
        return retVal;
    }

    @Override
    public Label getLabel(String qName) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLabel(qName);
        }
        if (this.labels != null) {
            return this.labels.get(qName);
        }
        return null;
    }

    @Override
    public Label getLabel(String namespace, String name) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLabel(namespace, name);
        }
        String qName = SaltUtil.createQName(namespace, name);
        return this.getLabel(qName);
    }

    @Override
    public Set<Label> getLabelsByNamespace(String namespace) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLabelsByNamespace(namespace);
        }
        HashSet<Label> retVal = new HashSet<Label>(5);
        if (this.labels != null) {
            for (Label label : this.labels.values()) {
                if (namespace == null) {
                    if (label.getNamespace() != null) continue;
                    retVal.add(label);
                    continue;
                }
                if (!namespace.equals(label.getNamespace())) continue;
                retVal.add(label);
            }
        }
        return retVal;
    }

    @Override
    public void addLabel(Label label) {
        if (this.getDelegate() != null) {
            this.getDelegate().addLabel(label);
        } else if (label != null) {
            if (label instanceof LabelImpl) {
                if (label.getContainer() != null) {
                    label.getContainer().removeLabel(label.getQName());
                }
                ((LabelImpl)label).basicSetLabelableElement(this);
            }
            this.basicAddLabel(label);
        }
    }

    public void basicAddLabel(Label label) {
        if (this.getDelegate() != null && this.getDelegate() instanceof LabelableElementImpl) {
            ((LabelableElementImpl)this.getDelegate()).basicAddLabel(label);
        } else if (label != null) {
            String qName;
            if (label.getName() == null || label.getName().isEmpty()) {
                throw new SaltInsertionException(this, label, "Cannot add a label object without a name.");
            }
            if (this.labels == null) {
                this.labels = new HashMap<String, Label>(5);
            }
            if (this.labels.containsKey(qName = SaltUtil.createQName(label.getNamespace(), label.getName()))) {
                if (this instanceof IdentifiableElement) {
                    throw new SaltInsertionException(this, label, " Because an id already exists: " + this.labels.get(qName) + ".");
                }
                throw new SaltInsertionException(this, label, "Cannot add the given label object, because a label with this QName already exists: " + label.getQName());
            }
            this.labels.put(qName, label);
        }
    }

    @Override
    public void removeLabel(String qName) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeLabel(qName);
        } else {
            if (qName != null) {
                Label label = this.getLabel(qName);
                if (label instanceof LabelImpl) {
                    ((LabelImpl)label).setContainer((LabelableElement)null);
                }
                this.basicRemoveLabel(qName);
            }
            this.basicRemoveLabel(qName);
        }
    }

    public void basicRemoveLabel(String qName) {
        if (this.getDelegate() != null && this.getDelegate() instanceof LabelableElementImpl) {
            ((LabelableElementImpl)this.getDelegate()).basicRemoveLabel(qName);
        } else if (qName != null) {
            this.labels.remove(qName);
        }
    }

    @Override
    public void removeLabel(String namespace, String name) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeLabel(namespace, name);
        } else {
            this.removeLabel(SaltUtil.createQName(namespace, name));
        }
    }

    @Override
    public void removeAll() {
        if (this.getDelegate() != null) {
            this.getDelegate().removeAll();
        } else {
            this.labels = new HashMap<String, Label>(5);
        }
    }

    @Override
    public boolean containsLabel(String qName) {
        if (this.getDelegate() != null) {
            return this.getDelegate().containsLabel(qName);
        }
        return this.labels.containsKey(qName);
    }

    @Override
    public Integer sizeLabels() {
        if (this.getDelegate() != null) {
            return this.getDelegate().sizeLabels();
        }
        if (this.labels != null) {
            return this.labels.values().size();
        }
        return 0;
    }
}

