/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import com.google.common.io.ByteStreams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.salt.Beta;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.util.ExportFilter;
import org.corpus_tools.salt.util.StyleImporter;
import org.eclipse.emf.common.util.URI;
import org.json.JSONException;
import org.json.JSONWriter;

@Beta
public class VisJsVisualizer
implements GraphTraverseHandler {
    private long maxHeight;
    private int currHeight;
    private int maxLevel;
    private int currHeightFromToken;
    private SDocument doc;
    private String docId;
    public BufferedWriter nodeWriter;
    public BufferedWriter edgeWriter;
    private JSONWriter jsonWriterNodes;
    private JSONWriter jsonWriterEdges;
    private static final String TAG_HTML = "html";
    private static final String TAG_HEAD = "head";
    private static final String TAG_BODY = "body";
    private static final String TAG_TITLE = "title";
    private static final String TAG_P = "p";
    private static final String TAG_DIV = "div";
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_STYLE = "style";
    private static final String TAG_LINK = "link";
    private static final String TAG_H2 = "h2";
    private static final String TAG_INPUT = "input";
    private static final String ATT_TYPE = "type";
    private static final String ATT_ID = "id";
    private static final String ATT_VALUE = "value";
    private static final String ATT_SRC = "src";
    private static final String ATT_HREF = "href";
    private static final String ATT_REL = "rel";
    private static final String ATT_STYLE = "style";
    private static final String ATT_LANG = "language";
    private static final String ATT_CLASS = "class";
    private static final String TEXT_STYLE = "width:700px; font-size:14px; text-align: justify;";
    private static final String TRAV_MODE_CALC_LEVEL = "calcLevel";
    private static final String TRAV_MODE_READ_NODES = "readNodes";
    private final HashSet<SNode> readSpanNodes;
    private final HashSet<SNode> readStructNodes;
    private final HashSet<SRelation> readRelations;
    private final List<SNode> roots;
    private Map<SNode, Integer> rootToMinLevel;
    private int nGroupsId = 0;
    private static final String JSON_ID = "id";
    private static final String JSON_LABEL = "label";
    private static final String JSON_COLOR = "color";
    private static final String JSON_COLOR_BACKGROUND = "background";
    private static final String JSON_COLOR_BORDER = "border";
    private static final String JSON_X = "x";
    private static final String JSON_LEVEL = "level";
    private static final String JSON_GROUP = "group";
    private static final String JSON_PHYSICS = "physics";
    private static final String JSON_SMOOTH = "smooth";
    private static final String JSON_TYPE = "type";
    private static final String JSON_ROUNDNESS = "roundness";
    private static final String JSON_WIDTH = "width";
    private static final String JSON_EDGE_FROM = "from";
    private static final String JSON_EDGE_TO = "to";
    private static final String JSON_BORDER_WIDTH = "borderWidth";
    private static final String JSON_FONT = "font";
    private static final String JSON_FONT_SIZE = "size";
    private int xPosition = 0;
    private int nTokens = 0;
    private static final int NODE_DIST = 150;
    private static final String TOK_COLOR_VALUE = "#ccff99";
    private static final String SPAN_COLOR_VALUE = "#dbdcff";
    private static final String STRUCTURE_COLOR_VALUE = "#ffff7d";
    private static final String TOK_BORDER_COLOR_VALUE = "#b7e589";
    private static final String SPAN_BORDER_COLOR_VALUE = "#c5c6e5";
    private static final String STRUCTURE_BORDER_COLOR_VALUE = "#e5e570";
    private static final String HIGHLIGHTING_BORDER_WIDTH = "5";
    private static final String EDGE_WIDTH = "2";
    private static final String JSON_EDGE_TYPE_VALUE = "curvedCW";
    private static final String JSON_ROUNDNESS_VALUE = "0.95";
    private static final String JSON_FONT_SIZE_VALUE = "18";
    private static final String NEWLINE = System.lineSeparator();
    private final ExportFilter exportFilter;
    private final StyleImporter styleImporter;
    private boolean writeNodeImmediately = false;
    public static final String CSS_FOLDER_OUT = "css";
    public static final String IMG_FOLDER_OUT = "css" + System.getProperty("file.separator") + "img" + System.getProperty("file.separator") + "network";
    public static final String JS_FOLDER_OUT = "js";
    public static final String CSS_FILE = "vis.min.css";
    public static final String JS_FILE = "vis.min.js";
    public static final String JQUERY_FILE = "jquery.js";
    public static final String HTML_FILE = "saltVisJs.html";
    private final File tmpFile;
    private static final String JQUERY_SRC = "js" + System.getProperty("file.separator") + "jquery.js";
    private static final String VIS_JS_SRC = "js" + System.getProperty("file.separator") + "vis.min.js";
    private static final String VIS_CSS_SRC = "css" + System.getProperty("file.separator") + "vis.min.css";
    private static final String RESOURCE_FOLDER = System.getProperty("file.separator") + "visjs";
    private static final String RESOURCE_FOLDER_IMG_NETWORK = "visjs" + System.getProperty("file.separator") + "img" + System.getProperty("file.separator") + "network";
    private HashMap<String, Integer> spanClasses;
    private int maxSpanOffset = -1;
    private int nNodes = 0;
    private boolean withPhysics = false;

    public VisJsVisualizer(SDocument doc) throws IOException {
        this(doc, null, null);
    }

    public VisJsVisualizer(SDocument doc, ExportFilter exportFilter, StyleImporter styleImporter) throws IOException {
        if (doc == null) {
            throw new SaltParameterException("doc", "VisJsVisualizer", this.getClass());
        }
        this.doc = doc;
        this.docId = doc.getId();
        this.roots = doc.getDocumentGraph().getRoots();
        this.rootToMinLevel = new HashMap<SNode, Integer>();
        this.readSpanNodes = new HashSet();
        this.readStructNodes = new HashSet();
        this.readRelations = new HashSet();
        this.tmpFile = File.createTempFile("tmp_salt", "vis");
        this.exportFilter = exportFilter;
        this.styleImporter = styleImporter;
        this.spanClasses = new HashMap();
        this.tmpFile.deleteOnExit();
    }

    public VisJsVisualizer(URI inputFileUri) throws IOException {
        this(inputFileUri, null, null);
    }

    public VisJsVisualizer(URI inputFileUri, ExportFilter exportFilter, StyleImporter styleImporter) throws IOException {
        if (inputFileUri == null) {
            throw new SaltParameterException("inputUri", "VisJsVisualizer", this.getClass());
        }
        try {
            this.doc = SaltFactory.createSDocument();
            this.doc.loadDocumentGraph(inputFileUri);
            this.docId = this.doc.getId();
        }
        catch (SaltResourceException e) {
            throw new SaltResourceException("A problem occurred while loading salt project from '" + inputFileUri + "'.", e);
        }
        this.roots = this.doc.getDocumentGraph().getRoots();
        this.rootToMinLevel = new HashMap<SNode, Integer>();
        this.readSpanNodes = new HashSet();
        this.readStructNodes = new HashSet();
        this.readRelations = new HashSet();
        this.tmpFile = File.createTempFile("tmp_salt", "vis");
        this.exportFilter = exportFilter;
        this.styleImporter = styleImporter;
        this.spanClasses = new HashMap();
        this.tmpFile.deleteOnExit();
    }

    public void visualize(URI outputFolderUri) throws SaltParameterException, SaltResourceException, SaltException, SaltResourceException, IOException, XMLStreamException {
        try {
            File outputFolder = this.createOutputResources(outputFolderUri);
            this.writeNodeImmediately = true;
            try {
                this.writeHTML(outputFolder);
            }
            catch (SaltParameterException e) {
                throw new SaltParameterException(e.getMessage());
            }
            catch (SaltException e) {
                throw new SaltException(e.getMessage());
            }
            this.writeNodeImmediately = false;
        }
        catch (SaltParameterException e) {
            throw new SaltParameterException("outputFileUri", "writeHTML", this.getClass());
        }
        catch (FileNotFoundException e) {
            throw new SaltResourceException("The output auxiliary files cannot be created.");
        }
        catch (SecurityException e) {
            throw new SaltException("Either the output folder cannot be created or permission denied.");
        }
        catch (IOException e) {
            throw new SaltResourceException("A problem occurred while copying the vis-js ressource files");
        }
    }

    private void writeHTML(File outputFolder) throws XMLStreamException, IOException {
        int nodeDist = 0;
        int sprLength = 0;
        double sprConstant = 0.0;
        try (FileOutputStream os = new FileOutputStream(new File(outputFolder, HTML_FILE));
             FileOutputStream fos = new FileOutputStream(this.tmpFile);){
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(os, "UTF-8");
            this.setNodeWriter(os);
            this.setEdgeWriter(fos);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_HTML);
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_HEAD);
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_TITLE);
            xmlWriter.writeCharacters("Salt Document Tree");
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement("style");
            xmlWriter.writeAttribute("type", "text/css");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeCharacters("body {" + NEWLINE + "font: 10pt sans;" + NEWLINE + "}" + NEWLINE + "#mynetwork {" + NEWLINE + "height: 90%;" + NEWLINE + "width: 90%;" + NEWLINE + "border: 1px solid lightgray; " + NEWLINE + "text-align: center;" + NEWLINE + "}" + NEWLINE + "#loadingBar {" + NEWLINE + "position:absolute;" + NEWLINE + "top:0px;" + NEWLINE + "left:0px;" + NEWLINE + "width: 0px;" + NEWLINE + "height: 0px;" + NEWLINE + "background-color:rgba(200,200,200,0.8);" + NEWLINE + "-webkit-transition: all 0.5s ease;" + NEWLINE + "-moz-transition: all 0.5s ease;" + NEWLINE + "-ms-transition: all 0.5s ease;" + NEWLINE + "-o-transition: all 0.5s ease;" + NEWLINE + "transition: all 0.5s ease;" + NEWLINE + "opacity:1;" + NEWLINE + "}" + NEWLINE + "#wrapper {" + NEWLINE + "position:absolute;" + NEWLINE + "width: 1200px;" + NEWLINE + "height: 90%;" + NEWLINE + "}" + NEWLINE + "#text {" + NEWLINE + "position:absolute;" + NEWLINE + "top:8px;" + NEWLINE + "left:530px;" + NEWLINE + "width:30px;" + NEWLINE + "height:50px;" + NEWLINE + "margin:auto auto auto auto;" + NEWLINE + "font-size:16px;" + NEWLINE + "color: #000000;" + NEWLINE + "}" + NEWLINE + "div.outerBorder {" + NEWLINE + "position:relative;" + NEWLINE + "top:400px;" + NEWLINE + "width:600px;" + NEWLINE + "height:44px;" + NEWLINE + "margin:auto auto auto auto;" + NEWLINE + "border:8px solid rgba(0,0,0,0.1);" + NEWLINE + "background: rgb(252,252,252); /* Old browsers */" + NEWLINE + "background: -moz-linear-gradient(top,  rgba(252,252,252,1) 0%, rgba(237,237,237,1) 100%); /* FF3.6+ */" + NEWLINE + "background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(252,252,252,1)), color-stop(100%,rgba(237,237,237,1))); /* Chrome,Safari4+ */" + NEWLINE + "background: -webkit-linear-gradient(top,  rgba(252,252,252,1) 0%,rgba(237,237,237,1) 100%); /* Chrome10+,Safari5.1+ */" + NEWLINE + "background: -o-linear-gradient(top,  rgba(252,252,252,1) 0%,rgba(237,237,237,1) 100%); /* Opera 11.10+ */" + NEWLINE + "background: -ms-linear-gradient(top,  rgba(252,252,252,1) 0%,rgba(237,237,237,1) 100%); /* IE10+ */" + NEWLINE + "background: linear-gradient(to bottom,  rgba(252,252,252,1) 0%,rgba(237,237,237,1) 100%); /* W3C */" + NEWLINE + "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#fcfcfc', endColorstr='#ededed',GradientType=0 ); /* IE6-9 */" + NEWLINE + "border-radius:72px;" + NEWLINE + "box-shadow: 0px 0px 10px rgba(0,0,0,0.2);" + NEWLINE + "}" + NEWLINE + "#border {" + NEWLINE + "position:absolute;" + NEWLINE + "top:10px;" + NEWLINE + "left:10px;" + NEWLINE + "width:500px;" + NEWLINE + "height:23px;" + NEWLINE + "margin:auto auto auto auto;" + NEWLINE + "box-shadow: 0px 0px 4px rgba(0,0,0,0.2);" + NEWLINE + "border-radius:10px;" + NEWLINE + "}" + NEWLINE + "#bar {" + NEWLINE + "position:absolute;" + NEWLINE + "top:0px;" + NEWLINE + "left:0px;" + NEWLINE + "width:20px;" + NEWLINE + "height:20px;" + NEWLINE + "margin:auto auto auto auto;" + NEWLINE + "border-radius:6px;" + NEWLINE + "border:1px solid rgba(30,30,30,0.05);" + NEWLINE + "background: rgb(0, 173, 246); /* Old browsers */" + NEWLINE + "box-shadow: 2px 0px 4px rgba(0,0,0,0.4);" + NEWLINE + "}" + NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_SCRIPT);
            xmlWriter.writeAttribute(ATT_SRC, VIS_JS_SRC);
            xmlWriter.writeAttribute("type", "text/javascript");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_SCRIPT);
            xmlWriter.writeAttribute(ATT_SRC, JQUERY_SRC);
            xmlWriter.writeAttribute("type", "text/javascript");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEmptyElement(TAG_LINK);
            xmlWriter.writeAttribute(ATT_HREF, VIS_CSS_SRC);
            xmlWriter.writeAttribute(ATT_REL, "stylesheet");
            xmlWriter.writeAttribute("type", "text/css");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_SCRIPT);
            xmlWriter.writeAttribute("type", "text/javascript");
            xmlWriter.writeCharacters(NEWLINE + "function frameSize() {" + NEWLINE + "$(document).ready(function() {" + NEWLINE + "function elementResize() {" + NEWLINE + "var browserWidth = $(window).width()*0.98;" + NEWLINE + "document.getElementById('mynetwork').style.width = browserWidth;" + NEWLINE + "}" + NEWLINE + "elementResize();" + NEWLINE + "$(window).bind(\"resize\", function(){" + NEWLINE + "elementResize();" + NEWLINE + "});" + NEWLINE + "});" + NEWLINE + "}" + NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_SCRIPT);
            xmlWriter.writeAttribute("type", "text/javascript");
            xmlWriter.writeCharacters(NEWLINE + "function start(){" + NEWLINE + "loadSaltObjectAndDraw();" + NEWLINE + "frameSize();" + NEWLINE + "}" + NEWLINE + "var nodesJson = [];" + NEWLINE + "var edgesJson = [];" + NEWLINE + "var network = null;" + NEWLINE + "function loadSaltObjectAndDraw() {" + NEWLINE + "var nodesJson = " + NEWLINE);
            xmlWriter.flush();
            try {
                this.buildJSON();
            }
            catch (SaltParameterException e) {
                throw new SaltParameterException(e.getMessage());
            }
            catch (SaltException e) {
                throw new SaltException(e.getMessage());
            }
            if (this.nNodes < 20) {
                nodeDist = 120;
                sprConstant = 1.2;
                sprLength = 120;
            } else if (this.nNodes >= 20 && this.nNodes < 100) {
                nodeDist = 150;
                sprConstant = 1.1;
                sprLength = 160;
            } else if (this.nNodes >= 100 && this.nNodes < 400) {
                nodeDist = 180;
                sprConstant = 0.9;
                sprLength = 180;
            } else if (this.nNodes >= 400 && this.nNodes < 800) {
                nodeDist = 200;
                sprConstant = 0.6;
                sprLength = 200;
            } else {
                nodeDist = 250;
                sprConstant = 0.3;
                sprLength = 230;
            }
            this.nodeWriter.flush();
            xmlWriter.writeCharacters(";" + NEWLINE);
            xmlWriter.writeCharacters("var edgesJson = " + NEWLINE);
            xmlWriter.flush();
            this.edgeWriter.flush();
            ByteStreams.copy((InputStream)new FileInputStream(this.tmpFile), (OutputStream)os);
            xmlWriter.writeCharacters(";" + NEWLINE);
            xmlWriter.writeCharacters("var nodeDist =" + nodeDist + ";" + NEWLINE);
            xmlWriter.writeCharacters("draw(nodesJson, edgesJson, nodeDist);" + NEWLINE + "}" + NEWLINE + "var directionInput = document.getElementById(\"direction\");" + NEWLINE + "function destroy() {" + NEWLINE + "if (network !== null) {" + NEWLINE + "network.destroy();" + NEWLINE + "network = null;" + NEWLINE + "}" + NEWLINE + "}" + NEWLINE + NEWLINE + "function draw(nodesJson, edgesJson, nodeDist) {" + NEWLINE + "destroy();" + NEWLINE + "var connectionCount = [];" + NEWLINE + "var nodes = [];" + NEWLINE + "var edges = [];" + NEWLINE + NEWLINE + "nodes = new vis.DataSet(nodesJson);" + NEWLINE + "edges = new vis.DataSet(edgesJson);" + NEWLINE + "var container = document.getElementById('mynetwork');" + NEWLINE + "var data = {" + NEWLINE + "nodes: nodes," + NEWLINE + "edges: edges" + NEWLINE + "};" + NEWLINE + "var options = {" + NEWLINE + "nodes:{" + NEWLINE + "shape: \"box\"" + NEWLINE + "}," + NEWLINE + "edges: {" + NEWLINE + "smooth: true," + NEWLINE + "arrows: {" + NEWLINE + "to: {" + NEWLINE + "enabled: true" + NEWLINE + "}" + NEWLINE + "}" + NEWLINE + "}," + NEWLINE + "interaction: {" + NEWLINE + "navigationButtons: true," + NEWLINE + "keyboard: true" + NEWLINE + "}," + NEWLINE + "layout: {" + NEWLINE + "hierarchical:{" + NEWLINE + "direction: directionInput.value" + NEWLINE + "}" + NEWLINE + "}," + NEWLINE + "physics: {" + NEWLINE + "hierarchicalRepulsion: {" + NEWLINE + "centralGravity: 0.8," + NEWLINE + "springLength: " + sprLength + "," + NEWLINE + "springConstant: " + sprConstant + "," + NEWLINE + "nodeDistance: nodeDist," + NEWLINE + "damping: 0.04" + NEWLINE + "}," + NEWLINE + "maxVelocity: 50," + NEWLINE + "minVelocity: 1," + NEWLINE + "solver: 'hierarchicalRepulsion'," + NEWLINE + "timestep: 0.5," + NEWLINE + "stabilization: {" + NEWLINE + "iterations: 1000" + NEWLINE + "}" + NEWLINE + "}" + NEWLINE + "}" + NEWLINE + ";" + NEWLINE + "network = new vis.Network(container, data, options);" + NEWLINE);
            if (this.withPhysics) {
                xmlWriter.writeCharacters("network.on(\"stabilizationProgress\", function(params) {" + NEWLINE + "var maxWidth = 496;" + NEWLINE + "var minWidth = 20;" + NEWLINE + "var widthFactor = params.iterations/params.total;" + NEWLINE + "var width = Math.max(minWidth,maxWidth * widthFactor);" + NEWLINE + "document.getElementById('loadingBar').style.opacity = 1;" + NEWLINE + "document.getElementById('bar').style.width = width + 'px';" + NEWLINE + "document.getElementById('text').innerHTML = Math.round(widthFactor*100) + '%';" + NEWLINE + "});" + NEWLINE + "network.on(\"stabilizationIterationsDone\", function() {" + NEWLINE + "document.getElementById('text').innerHTML = '100%';" + NEWLINE + "document.getElementById('bar').style.width = '496px';" + NEWLINE + "document.getElementById('loadingBar').style.opacity = 0;" + NEWLINE + "});" + NEWLINE);
            }
            xmlWriter.writeCharacters("}" + NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_BODY);
            xmlWriter.writeAttribute("onload", "start();");
            xmlWriter.writeCharacters(NEWLINE);
            if (this.withPhysics) {
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute("id", "wrapper");
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute("id", "loadingBar");
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute(ATT_CLASS, "outerBorder");
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute("id", "text");
                xmlWriter.writeCharacters("0%");
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute("id", JSON_COLOR_BORDER);
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeStartElement(TAG_DIV);
                xmlWriter.writeAttribute("id", "bar");
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
            }
            xmlWriter.writeStartElement(TAG_H2);
            xmlWriter.writeCharacters("Dokument-Id: " + this.docId);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_DIV);
            xmlWriter.writeAttribute("style", TEXT_STYLE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_P);
            xmlWriter.writeEmptyElement(TAG_INPUT);
            xmlWriter.writeAttribute("type", "button");
            xmlWriter.writeAttribute("id", "btn-UD");
            xmlWriter.writeAttribute(ATT_VALUE, "Up-Down");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEmptyElement(TAG_INPUT);
            xmlWriter.writeAttribute("type", "button");
            xmlWriter.writeAttribute("id", "btn-DU");
            xmlWriter.writeAttribute(ATT_VALUE, "Down-Up");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEmptyElement(TAG_INPUT);
            xmlWriter.writeAttribute("type", "hidden");
            xmlWriter.writeAttribute("id", "direction");
            xmlWriter.writeAttribute(ATT_VALUE, "UD");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_DIV);
            xmlWriter.writeAttribute("id", "mynetwork");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_P);
            xmlWriter.writeAttribute("id", "selection");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeStartElement(TAG_SCRIPT);
            xmlWriter.writeAttribute(ATT_LANG, "JavaScript");
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeCharacters("var directionInput = document.getElementById(\"direction\");" + NEWLINE + "var btnUD = document.getElementById(\"btn-UD\");" + NEWLINE + "btnUD.onclick = function() {" + NEWLINE + "directionInput.value = \"UD\";" + NEWLINE + "start();" + NEWLINE + "};" + NEWLINE + "var btnDU = document.getElementById(\"btn-DU\");" + NEWLINE + "btnDU.onclick = function() {" + NEWLINE + "directionInput.value = \"DU\";" + NEWLINE + "start();" + NEWLINE + "};" + NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            if (this.withPhysics) {
                xmlWriter.writeEndElement();
                xmlWriter.writeCharacters(NEWLINE);
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters(NEWLINE);
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            this.nodeWriter.close();
            this.edgeWriter.close();
        }
    }

    private File createOutputResources(URI outputFileUri) throws SaltParameterException, SecurityException, FileNotFoundException, IOException {
        File outputFolder = null;
        if (outputFileUri == null) {
            throw new SaltParameterException("Cannot store salt-vis, because the passed output uri is empty. ");
        }
        outputFolder = new File(outputFileUri.path());
        if (!outputFolder.exists() && !outputFolder.mkdirs()) {
            throw new SaltException("Can't create folder " + outputFolder.getAbsolutePath());
        }
        File cssFolderOut = new File(outputFolder, CSS_FOLDER_OUT);
        if (!cssFolderOut.exists() && !cssFolderOut.mkdir()) {
            throw new SaltException("Can't create folder " + cssFolderOut.getAbsolutePath());
        }
        File jsFolderOut = new File(outputFolder, JS_FOLDER_OUT);
        if (!jsFolderOut.exists() && !jsFolderOut.mkdir()) {
            throw new SaltException("Can't create folder " + jsFolderOut.getAbsolutePath());
        }
        File imgFolderOut = new File(outputFolder, IMG_FOLDER_OUT);
        if (!imgFolderOut.exists() && !imgFolderOut.mkdirs()) {
            throw new SaltException("Can't create folder " + imgFolderOut.getAbsolutePath());
        }
        this.copyResourceFile(this.getClass().getResourceAsStream(RESOURCE_FOLDER + System.getProperty("file.separator") + CSS_FILE), outputFolder.getPath(), CSS_FOLDER_OUT, CSS_FILE);
        this.copyResourceFile(this.getClass().getResourceAsStream(RESOURCE_FOLDER + System.getProperty("file.separator") + JS_FILE), outputFolder.getPath(), JS_FOLDER_OUT, JS_FILE);
        this.copyResourceFile(this.getClass().getResourceAsStream(RESOURCE_FOLDER + System.getProperty("file.separator") + JQUERY_FILE), outputFolder.getPath(), JS_FOLDER_OUT, JQUERY_FILE);
        ClassLoader classLoader = this.getClass().getClassLoader();
        CodeSource srcCode = VisJsVisualizer.class.getProtectionDomain().getCodeSource();
        URL codeSourceUrl = srcCode.getLocation();
        File codeSourseFile = new File(codeSourceUrl.getPath());
        if (codeSourseFile.isDirectory()) {
            File imgFolder = new File(classLoader.getResource(RESOURCE_FOLDER_IMG_NETWORK).getFile());
            File[] imgFiles = imgFolder.listFiles();
            if (imgFiles != null) {
                for (File imgFile : imgFiles) {
                    InputStream inputStream = this.getClass().getResourceAsStream(System.getProperty("file.separator") + RESOURCE_FOLDER_IMG_NETWORK + System.getProperty("file.separator") + imgFile.getName());
                    this.copyResourceFile(inputStream, outputFolder.getPath(), IMG_FOLDER_OUT, imgFile.getName());
                }
            }
        } else if (codeSourseFile.getName().endsWith("jar")) {
            JarFile jarFile = new JarFile(codeSourseFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(RESOURCE_FOLDER_IMG_NETWORK) || entry.isDirectory()) continue;
                this.copyResourceFile(jarFile.getInputStream(entry), outputFolder.getPath(), IMG_FOLDER_OUT, entry.getName().replaceFirst(RESOURCE_FOLDER_IMG_NETWORK, ""));
            }
            jarFile.close();
        }
        return outputFolder;
    }

    private void copyResourceFile(InputStream inputStream, String outputFolder, String outSubFolder, String outFile) throws IOException {
        File outFileObject = outSubFolder != null ? new File(outputFolder + System.getProperty("file.separator") + outSubFolder + System.getProperty("file.separator") + outFile) : new File(outputFolder + System.getProperty("file.separator") + outFile);
        try (FileOutputStream fileOutStream = new FileOutputStream(outFileObject);){
            int bufferSize = 32768;
            byte[] bytes = new byte[bufferSize];
            int readBytes = 0;
            while ((readBytes = inputStream.read(bytes)) != -1) {
                fileOutStream.write(bytes, 0, readBytes);
            }
            fileOutStream.flush();
            fileOutStream.close();
            inputStream.close();
        }
    }

    public void setNodeWriter(OutputStream os) {
        this.nodeWriter = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        this.jsonWriterNodes = new JSONWriter((Writer)this.nodeWriter);
    }

    public void setEdgeWriter(OutputStream os) {
        this.edgeWriter = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        this.jsonWriterEdges = new JSONWriter((Writer)this.edgeWriter);
    }

    public void buildJSON() throws SaltException, SaltParameterException {
        this.maxLevel = this.getMaxLevel(this.doc);
        this.doc.getDocumentGraph().sortTokenByText();
        List<SToken> sTokens = this.doc.getDocumentGraph().getTokens();
        if (this.nodeWriter == null || this.jsonWriterNodes == null) {
            throw new SaltParameterException("A problem occurred while building JSON objects. Probably the node writer is not set.");
        }
        if (this.edgeWriter == null || this.jsonWriterEdges == null) {
            throw new SaltParameterException("A problem occurred while building JSON objects. Probably the edge writer is not set.");
        }
        try {
            this.jsonWriterNodes.array();
            for (SToken token : sTokens) {
                this.writeJsonNode(token, this.maxLevel);
                ++this.nNodes;
            }
            this.nTokens = sTokens.size();
            this.jsonWriterEdges.array();
            this.doc.getDocumentGraph().traverse(this.doc.getDocumentGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, TRAV_MODE_READ_NODES, this);
            this.jsonWriterNodes.endArray();
            this.jsonWriterEdges.endArray();
            this.nodeWriter.flush();
            this.edgeWriter.flush();
        }
        catch (JSONException e) {
            throw new SaltException("A problem occurred while building JSON objects.");
        }
        catch (IOException e) {
            throw new SaltException("A problem occurred while building JSON objects.");
        }
    }

    private static List<Map.Entry<String, String>> sortAnnotations(Set<SAnnotation> sAnnotations) {
        HashMap<String, String> annotationMap = new HashMap<String, String>();
        for (SAnnotation sAnnotation : sAnnotations) {
            annotationMap.put(sAnnotation.getName(), sAnnotation.getValue().toString());
        }
        List<Map.Entry<String, String>> sortedAnnotations = VisJsVisualizer.sortByKey(annotationMap);
        return sortedAnnotations;
    }

    private static <K, V> List<Map.Entry<K, V>> sortByKey(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            entries.add(e);
        }
        Comparator comparator = new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return e1.getKey().toString().compareToIgnoreCase(e2.getKey().toString());
            }
        };
        Collections.sort(entries, comparator);
        return entries;
    }

    private void writeJsonNode(SNode node, long levelValue) throws SaltParameterException, IOException {
        String nodeColorBorder;
        String nodeColorValue;
        String text;
        String highlightingColor = null;
        if (this.styleImporter != null) {
            highlightingColor = this.styleImporter.setHighlightingColor(node);
        }
        String idValue = node.getPath().fragment();
        String idLabel = "id=" + idValue;
        StringBuilder allLabels = new StringBuilder(idLabel);
        this.jsonWriterNodes.object();
        this.jsonWriterNodes.key("id");
        this.jsonWriterNodes.value((Object)idValue);
        this.jsonWriterNodes.key(JSON_LABEL);
        Set<SAnnotation> sAnnotations = node.getAnnotations();
        List<Map.Entry<String, String>> sortedAnnotations = VisJsVisualizer.sortAnnotations(sAnnotations);
        for (Map.Entry<String, String> annotation : sortedAnnotations) {
            allLabels.append(NEWLINE);
            allLabels.append(annotation.getKey()).append("=").append(annotation.getValue());
        }
        if (node instanceof SToken && (text = this.doc.getDocumentGraph().getText(node)) != null && !text.isEmpty()) {
            allLabels.append(NEWLINE).append(NEWLINE).append(text);
        }
        this.jsonWriterNodes.value((Object)allLabels.toString());
        if (node instanceof SToken) {
            nodeColorValue = TOK_COLOR_VALUE;
            nodeColorBorder = TOK_BORDER_COLOR_VALUE;
            this.jsonWriterNodes.key(JSON_X);
            this.jsonWriterNodes.value((long)(this.xPosition++ * 150));
            this.jsonWriterNodes.key(JSON_PHYSICS);
            this.jsonWriterNodes.value((Object)"false");
        } else if (node instanceof SSpan) {
            nodeColorValue = SPAN_COLOR_VALUE;
            nodeColorBorder = SPAN_BORDER_COLOR_VALUE;
            if (this.nGroupsId == 3) {
                this.jsonWriterNodes.key(JSON_GROUP);
                this.jsonWriterNodes.value((Object)"1");
            } else {
                this.jsonWriterNodes.key(JSON_GROUP);
                this.jsonWriterNodes.value((Object)"0");
            }
            this.jsonWriterNodes.key(JSON_X);
            this.jsonWriterNodes.value((long)(this.nTokens / 2 * 150));
        } else if (node instanceof SStructure) {
            nodeColorValue = STRUCTURE_COLOR_VALUE;
            nodeColorBorder = STRUCTURE_BORDER_COLOR_VALUE;
            this.jsonWriterNodes.key(JSON_GROUP);
            this.jsonWriterNodes.value((Object)"0");
            this.jsonWriterNodes.key(JSON_X);
            this.jsonWriterNodes.value((long)(this.nTokens / 2 * 150));
        } else {
            throw new SaltParameterException(node.getId(), "writeJsonNode", this.getClass());
        }
        this.jsonWriterNodes.key(JSON_COLOR);
        this.jsonWriterNodes.object();
        this.jsonWriterNodes.key(JSON_COLOR_BACKGROUND);
        this.jsonWriterNodes.value((Object)nodeColorValue);
        if (highlightingColor != null) {
            this.jsonWriterNodes.key(JSON_COLOR_BORDER);
            this.jsonWriterNodes.value((Object)highlightingColor);
            this.jsonWriterNodes.endObject();
            this.jsonWriterNodes.key(JSON_BORDER_WIDTH);
            this.jsonWriterNodes.value((Object)HIGHLIGHTING_BORDER_WIDTH);
        } else {
            this.jsonWriterNodes.key(JSON_COLOR_BORDER);
            this.jsonWriterNodes.value((Object)nodeColorBorder);
            this.jsonWriterNodes.endObject();
        }
        this.jsonWriterNodes.key(JSON_LEVEL);
        this.jsonWriterNodes.value(levelValue);
        this.jsonWriterNodes.key(JSON_FONT);
        this.jsonWriterNodes.object();
        this.jsonWriterNodes.key(JSON_FONT_SIZE);
        this.jsonWriterNodes.value((Object)JSON_FONT_SIZE_VALUE);
        this.jsonWriterNodes.endObject();
        this.jsonWriterNodes.endObject();
        this.nodeWriter.newLine();
        if (this.writeNodeImmediately) {
            this.nodeWriter.flush();
        }
    }

    private void writeJsonEdge(SNode fromNode, SNode toNode, SRelation relation) throws IOException, SaltParameterException {
        String edgeColor;
        if (fromNode instanceof SToken) {
            edgeColor = TOK_BORDER_COLOR_VALUE;
        } else if (fromNode instanceof SSpan) {
            edgeColor = SPAN_BORDER_COLOR_VALUE;
        } else if (fromNode instanceof SStructure) {
            edgeColor = STRUCTURE_BORDER_COLOR_VALUE;
        } else {
            throw new SaltParameterException(fromNode.getId(), "writeJsonEdge", this.getClass());
        }
        this.jsonWriterEdges.object();
        this.jsonWriterEdges.key(JSON_EDGE_FROM);
        this.jsonWriterEdges.value((Object)fromNode.getPath().fragment());
        this.jsonWriterEdges.key(JSON_EDGE_TO);
        this.jsonWriterEdges.value((Object)toNode.getPath().fragment());
        Set<SAnnotation> sAnnotations = relation.getAnnotations();
        if (sAnnotations.size() > 0) {
            StringBuilder allLabels = new StringBuilder();
            List<Map.Entry<String, String>> sortedAnnotations = VisJsVisualizer.sortAnnotations(sAnnotations);
            int i = 0;
            for (Map.Entry<String, String> annotation : sortedAnnotations) {
                allLabels.append(annotation.getKey()).append("=").append(annotation.getValue());
                if (i < sAnnotations.size()) {
                    allLabels.append(NEWLINE);
                }
                ++i;
            }
            this.jsonWriterEdges.key(JSON_LABEL);
            this.jsonWriterEdges.value((Object)allLabels.toString());
        }
        this.jsonWriterEdges.key(JSON_WIDTH);
        this.jsonWriterEdges.value((Object)EDGE_WIDTH);
        this.jsonWriterEdges.key(JSON_COLOR);
        this.jsonWriterEdges.value((Object)edgeColor);
        if (relation instanceof SPointingRelation) {
            this.jsonWriterEdges.key(JSON_SMOOTH);
            this.jsonWriterEdges.object();
            this.jsonWriterEdges.key("type");
            this.jsonWriterEdges.value((Object)JSON_EDGE_TYPE_VALUE);
            this.jsonWriterEdges.key(JSON_ROUNDNESS);
            this.jsonWriterEdges.value((Object)JSON_ROUNDNESS_VALUE);
            this.jsonWriterEdges.endObject();
        }
        this.jsonWriterEdges.endObject();
        this.edgeWriter.newLine();
    }

    private int getMaxLevel(SDocument doc) {
        this.maxLevel = this.getMaxHeightOfSDocGraph(doc);
        int nSpanClasses = this.spanClasses.size();
        if (this.readSpanNodes != null && this.readSpanNodes.size() > 0) {
            ++this.nGroupsId;
        }
        if (this.readStructNodes != null && this.readStructNodes.size() > 0) {
            this.nGroupsId += 2;
        }
        if (this.nGroupsId == 3) {
            this.maxLevel += nSpanClasses;
        } else if (this.nGroupsId == 1) {
            this.maxLevel += nSpanClasses - 1;
        }
        if (this.readSpanNodes != null) {
            this.readSpanNodes.clear();
        }
        if (this.readStructNodes != null) {
            this.readStructNodes.clear();
        }
        if (this.maxLevel > 0) {
            this.withPhysics = true;
        }
        return this.maxLevel;
    }

    private int getMaxHeightOfSDocGraph(SDocument doc) {
        doc.getDocumentGraph().traverse(doc.getDocumentGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, TRAV_MODE_CALC_LEVEL, this);
        if (this.maxHeight > 2147483547L) {
            throw new SaltException("The specified document cannot be visualized. It is too complex.");
        }
        return (int)this.maxHeight;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        if (traversalType == SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST && traversalId.equals(TRAV_MODE_CALC_LEVEL) && (this.exportFilter == null || this.exportFilter.includeNode(currNode))) {
            if (relation != null && !(relation instanceof SPointingRelation) && !(fromNode instanceof SToken)) {
                ++this.currHeight;
                if (this.maxHeight < (long)this.currHeight) {
                    this.maxHeight = this.currHeight;
                }
            }
            if (currNode instanceof SSpan) {
                String annClass = "";
                Set<SAnnotation> sAnnotations = currNode.getAnnotations();
                if (sAnnotations.size() > 0) {
                    List<Map.Entry<String, String>> sortedAnnotations = VisJsVisualizer.sortAnnotations(sAnnotations);
                    annClass = sortedAnnotations.iterator().next().getKey();
                }
                if (!this.spanClasses.containsKey(annClass)) {
                    this.spanClasses.put(annClass, -1);
                }
                this.readSpanNodes.add(currNode);
            }
            if (currNode instanceof SStructure) {
                this.readStructNodes.add(currNode);
            }
        }
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        if (traversalType == SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST) {
            if (traversalId.equals(TRAV_MODE_CALC_LEVEL)) {
                if (!(relation instanceof SPointingRelation || fromNode instanceof SToken || this.exportFilter != null && !this.exportFilter.includeNode(currNode) || relation == null)) {
                    --this.currHeight;
                }
            } else if (traversalId.equals(TRAV_MODE_READ_NODES)) {
                if (currNode instanceof SToken) {
                    this.currHeightFromToken = 1;
                    if (fromNode instanceof SSpan && !this.readSpanNodes.contains(fromNode) && (this.exportFilter == null || this.exportFilter.includeNode(fromNode))) {
                        int spanOffset;
                        String annotation = "";
                        Set<SAnnotation> sAnnotations = fromNode.getAnnotations();
                        if (sAnnotations.size() > 0) {
                            List<Map.Entry<String, String>> sortedAnnotations = VisJsVisualizer.sortAnnotations(sAnnotations);
                            annotation = sortedAnnotations.iterator().next().getKey();
                        }
                        if ((spanOffset = this.spanClasses.get(annotation).intValue()) == -1) {
                            this.maxSpanOffset = Math.max(spanOffset, this.maxSpanOffset) + 1;
                            this.spanClasses.put(annotation, this.maxSpanOffset);
                        }
                        spanOffset = this.spanClasses.get(annotation);
                        try {
                            this.writeJsonNode(fromNode, this.maxLevel - this.currHeightFromToken - spanOffset);
                            ++this.nNodes;
                        }
                        catch (IOException e) {
                            throw new SaltException("A problem occurred while building JSON objects.");
                        }
                        this.readSpanNodes.add(fromNode);
                    }
                } else if (currNode instanceof SStructure) {
                    if ((this.exportFilter == null || this.exportFilter.includeNode(currNode)) && !this.readStructNodes.contains(currNode)) {
                        ++this.currHeightFromToken;
                        int currLevel = this.maxLevel - this.currHeightFromToken - this.spanClasses.size() + 1;
                        try {
                            if (this.roots.contains(currNode)) {
                                int minRootLevel = this.rootToMinLevel.containsKey(currNode) ? Math.min(this.rootToMinLevel.get(currNode), currLevel) : currLevel;
                                this.writeJsonNode(currNode, minRootLevel);
                            } else {
                                this.writeJsonNode(currNode, currLevel);
                            }
                        }
                        catch (IOException e) {
                            throw new SaltException("A problem occurred while building JSON objects.");
                        }
                        ++this.nNodes;
                        this.readStructNodes.add(currNode);
                    }
                    if (fromNode instanceof SStructure && this.roots.contains(fromNode) && !this.readStructNodes.contains(fromNode) && (this.exportFilter == null || this.exportFilter.includeNode(fromNode))) {
                        int thisRootLevel = this.maxLevel - this.currHeightFromToken - this.spanClasses.size();
                        if (this.rootToMinLevel.containsKey(fromNode)) {
                            int oldLevel = this.rootToMinLevel.get(fromNode);
                            this.rootToMinLevel.put(fromNode, Math.min(oldLevel, thisRootLevel));
                        } else {
                            this.rootToMinLevel.put(fromNode, thisRootLevel);
                        }
                    }
                }
                if (relation != null && !this.readRelations.contains(relation) && (this.exportFilter == null || this.exportFilter.includeRelation(relation) && this.exportFilter.includeNode(fromNode) && this.exportFilter.includeNode(currNode))) {
                    try {
                        this.writeJsonEdge(fromNode, currNode, relation);
                    }
                    catch (IOException e) {
                        throw new SaltException("A problem occurred while building JSON objects.");
                    }
                    this.readRelations.add(relation);
                }
            }
        }
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        return relation instanceof SDominanceRelation || relation instanceof SSpanningRelation || relation instanceof SPointingRelation || relation == null;
    }
}

