/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.SaltUtil;

public abstract class AbstractDiff<G extends SGraph> {
    protected final G templateGraph;
    protected final G otherGraph;
    protected final DiffOptions options;
    protected Set<Difference> differences = null;
    private BiMap<SNode, SNode> isoNodes = null;
    protected boolean diffsRequested = false;

    protected BiMap<SNode, SNode> getIsoNodes() {
        if (this.isoNodes == null) {
            this.isoNodes = HashBiMap.create();
        }
        return this.isoNodes;
    }

    public AbstractDiff(G template, G other) {
        this(template, other, null);
    }

    public AbstractDiff(G template, G other, DiffOptions optionMap) {
        this.templateGraph = template;
        this.otherGraph = other;
        this.options = optionMap != null ? optionMap : new DiffOptions();
    }

    protected Set<Difference> getDifferences() {
        if (this.differences == null) {
            this.differences = new LinkedHashSet<Difference>();
        }
        return this.differences;
    }

    protected void addDifference(Object templateObject, Object otherObject, Object container, DIFF_TYPES diffType, Set<Difference> subDiffs) {
        Difference tempDiff = new Difference(templateObject, otherObject, container, diffType);
        if (subDiffs != null) {
            tempDiff.addSubDiffs(subDiffs);
        }
        this.getDifferences().add(tempDiff);
    }

    public boolean isIsomorph() {
        this.diffsRequested = false;
        return this.findDiffs(false);
    }

    public Set<Difference> findDiffs() {
        this.diffsRequested = true;
        this.findDiffs(true);
        return this.getDifferences();
    }

    protected boolean compareIdentifiableElements(IdentifiableElement template, IdentifiableElement other, Set<Difference> subDiffs) {
        boolean retVal = true;
        if (!((Boolean)this.options.get("ignoreId")).booleanValue() && !template.getId().equals(other.getId())) {
            retVal = false;
            if (subDiffs != null) {
                subDiffs.add(new Difference(template, other, null, DIFF_TYPES.ID_DIFFERING));
            }
        }
        return retVal;
    }

    protected boolean compareAnnotationContainers(SAnnotationContainer template, SAnnotationContainer other, Set<Difference> subDiffs) {
        Iterator<SAbstractAnnotation> templateIterator;
        Iterator<SAbstractAnnotation> otherIterator;
        boolean retVal1 = true;
        boolean retVal2 = true;
        boolean retVal3 = true;
        boolean retVal4 = true;
        if (!((Boolean)this.options.get("ignoreAnnotations")).booleanValue()) {
            otherIterator = other.iterator_SAnnotation();
            templateIterator = template.iterator_SAnnotation();
            retVal1 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!((Boolean)this.options.get("ignoreMetaAnnotstaions")).booleanValue()) {
            otherIterator = other.iterator_SMetaAnnotation();
            templateIterator = template.iterator_SMetaAnnotation();
            retVal2 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!((Boolean)this.options.get("ignoreProcessingAnnotations")).booleanValue()) {
            otherIterator = other.iterator_SProcessingAnnotation();
            templateIterator = template.iterator_SProcessingAnnotation();
            retVal3 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        if (!((Boolean)this.options.get("ignoreFeatures")).booleanValue()) {
            otherIterator = other.iterator_SFeature();
            templateIterator = template.iterator_SFeature();
            retVal4 = this.compareAnnotationContainers(template, templateIterator, other, otherIterator, subDiffs);
            if (!retVal1 && subDiffs != null) {
                return false;
            }
        }
        return retVal1 && retVal2 && retVal3 && retVal4;
    }

    private boolean ignoreAbstractAnnotation(SAbstractAnnotation anno) {
        if (anno == null) {
            return true;
        }
        if (anno instanceof SFeature) {
            if ("salt::SNAME".equals(anno.getQName())) {
                boolean belongsToCorpusStructure = SaltUtil.belongsToCorpusStructure(anno.getContainer());
                if (belongsToCorpusStructure && ((Boolean)this.options.get("ignoreCorpusStructureName")).booleanValue()) {
                    return true;
                }
                if (!belongsToCorpusStructure && ((Boolean)this.options.get("ignoreName")).booleanValue()) {
                    return true;
                }
            } else if ("salt::SDOCUMENT_GRAPH".equals(anno.getQName())) {
                return true;
            }
        }
        return false;
    }

    private boolean compareAnnotationContainers(SAnnotationContainer template, Iterator<SAbstractAnnotation> templateIterator, SAnnotationContainer other, Iterator<SAbstractAnnotation> otherIterator, Set<Difference> subDiffs) {
        boolean retVal = true;
        HashSet<SAbstractAnnotation> remainingLabels = new HashSet<SAbstractAnnotation>();
        while (otherIterator.hasNext()) {
            SAbstractAnnotation anno = otherIterator.next();
            if (this.ignoreAbstractAnnotation(anno)) continue;
            remainingLabels.add(anno);
        }
        while (templateIterator.hasNext()) {
            SAbstractAnnotation templateAnno = templateIterator.next();
            if (this.ignoreAbstractAnnotation(templateAnno)) continue;
            SAbstractAnnotation otherAnno = (SAbstractAnnotation)other.getLabel(templateAnno.getQName());
            if (otherAnno == null) {
                if (subDiffs != null) {
                    subDiffs.add(new Difference(templateAnno, null, template, DIFF_TYPES.LABEL_MISSING));
                    retVal = false;
                    continue;
                }
                return false;
            }
            if (!otherAnno.getValue().equals(templateAnno.getValue())) {
                if (subDiffs != null) {
                    subDiffs.add(new Difference(templateAnno, otherAnno, null, DIFF_TYPES.LABEL_VALUE_DIFFERING));
                    retVal = false;
                    continue;
                }
                return false;
            }
            remainingLabels.remove(otherAnno);
        }
        if (remainingLabels.size() > 0) {
            if (subDiffs != null) {
                retVal = false;
                for (SAbstractAnnotation otherAnno : remainingLabels) {
                    subDiffs.add(new Difference(null, otherAnno, other, DIFF_TYPES.LABEL_MISSING));
                }
            } else {
                return false;
            }
        }
        return retVal;
    }

    protected abstract boolean findDiffs(boolean var1);
}

