/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.internal.CorpusStructureDiff;
import org.corpus_tools.salt.util.internal.DocumentStructureDiff;

public class Diff {
    private DocumentStructureDiff documentStructureDiff = null;
    private CorpusStructureDiff corpusStructureDiff = null;

    public Diff(SDocumentGraph template, SDocumentGraph other) {
        this(template, other, (DiffOptions)null);
    }

    public Diff(SDocumentGraph template, SDocumentGraph other, DiffOptions optionMap) {
        this.documentStructureDiff = new DocumentStructureDiff(template, other, optionMap);
    }

    @Deprecated
    public Diff(SDocumentGraph template, SDocumentGraph other, Map<String, Boolean> optionMap) {
        DiffOptions options = new DiffOptions();
        options.putAll(optionMap);
        this.documentStructureDiff = new DocumentStructureDiff(template, other, options);
    }

    public Diff(SCorpusGraph template, SCorpusGraph other) {
        this(template, other, (DiffOptions)null);
    }

    public Diff(SCorpusGraph template, SCorpusGraph other, DiffOptions optionMap) {
        this.corpusStructureDiff = new CorpusStructureDiff(template, other, optionMap);
    }

    @Deprecated
    public Diff(SCorpusGraph template, SCorpusGraph other, Map<String, Boolean> optionMap) {
        DiffOptions options = new DiffOptions();
        options.putAll(optionMap);
        this.corpusStructureDiff = new CorpusStructureDiff(template, other, options);
    }

    public boolean isIsomorph() {
        if (this.documentStructureDiff != null) {
            return this.documentStructureDiff.isIsomorph();
        }
        return this.corpusStructureDiff.isIsomorph();
    }

    public Set<Difference> findDiffs() {
        if (this.documentStructureDiff != null) {
            return this.documentStructureDiff.findDiffs();
        }
        return this.corpusStructureDiff.findDiffs();
    }

    public static class Builder<G extends SGraph> {
        private final G templateGraph;

        public Builder(G templateGraph) {
            this.templateGraph = templateGraph;
        }

        public Builder2<G> with(G otherGraph) {
            return new Builder2<G>(this.templateGraph, otherGraph);
        }

        public static class Builder2<G> {
            private final G templateGraph;
            private final G otherGraph;
            private DiffOptions options = new DiffOptions();

            public Builder2(G templateGraph, G otherGraph) {
                this.templateGraph = templateGraph;
                this.otherGraph = otherGraph;
            }

            public boolean andCheckIsomorphie() {
                if (this.templateGraph instanceof SDocumentGraph && this.otherGraph instanceof SDocumentGraph) {
                    return new Diff((SDocumentGraph)this.templateGraph, (SDocumentGraph)this.otherGraph, this.options).isIsomorph();
                }
                if (this.templateGraph instanceof SCorpusGraph && this.otherGraph instanceof SCorpusGraph) {
                    return new Diff((SCorpusGraph)this.templateGraph, (SCorpusGraph)this.otherGraph, this.options).isIsomorph();
                }
                throw new SaltException("Cannot compare peaches with appels. ");
            }

            public Set<Difference> andFindDiffs() {
                if (this.templateGraph instanceof SDocumentGraph && this.otherGraph instanceof SDocumentGraph) {
                    return new Diff((SDocumentGraph)this.templateGraph, (SDocumentGraph)this.otherGraph, this.options).findDiffs();
                }
                if (this.templateGraph instanceof SCorpusGraph && this.otherGraph instanceof SCorpusGraph) {
                    return new Diff((SCorpusGraph)this.templateGraph, (SCorpusGraph)this.otherGraph, this.options).findDiffs();
                }
                throw new SaltException("Cannot compare peaches with appels. ");
            }

            public Builder2<G> useOption(String option) {
                this.options.put(option, true);
                return this;
            }

            public Builder2<G> useOption(String option, boolean value) {
                this.options.put(option, value);
                return this;
            }

            public Builder2<G> useOptions(DiffOptions options) {
                this.options = options;
                return this;
            }
        }
    }
}

