/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl.tests;

import java.util.List;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.impl.tests.SSequentialDSTest;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Graph;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class STextualDSTest
extends SSequentialDSTest<String, Integer> {
    public STextualDS getFixture() {
        return (STextualDS)this.fixture;
    }

    @Before
    public void setUp() {
        this.setFixture((SNode)SaltFactory.createSTextualDS());
    }

    @Override
    @Test
    public void testSetGetData() {
        String text = "text";
        this.getFixture().setData((Object)text);
        Assert.assertEquals((Object)text, (Object)this.getFixture().getData());
    }

    @Test
    public void testSetGetText() {
        String text = "text";
        this.getFixture().setText(text);
        Assert.assertEquals((Object)text, (Object)this.getFixture().getText());
    }

    @Test
    public void testSetGetText_SpecialCharacters() {
        String text = "text\n\t text";
        this.getFixture().setText(text);
        Assert.assertEquals((Object)text, (Object)this.getFixture().getText());
    }

    @Override
    @Test
    public void testGetStart() {
        Assert.assertEquals(null, (Object)this.getFixture().getStart());
        this.getFixture().setData((Object)"Test");
        Assert.assertEquals((Object)0, (Object)this.getFixture().getStart());
    }

    @Override
    @Test
    public void testGetEnd() {
        Assert.assertEquals(null, (Object)this.getFixture().getEnd());
        this.getFixture().setData((Object)"Test");
        Assert.assertEquals((Object)4, (Object)this.getFixture().getEnd());
    }

    @Test
    public void testTokenize() {
        SDocumentGraph graph = SaltFactory.createSDocumentGraph();
        this.getFixture().setText("This is a birthday pony!");
        this.getFixture().setGraph((Graph)graph);
        List tokens = this.getFixture().tokenize();
        graph = this.getFixture().getGraph();
        Assert.assertNotNull((Object)graph);
        Assert.assertTrue((boolean)(graph instanceof SDocumentGraph));
        tokens = graph.getSortedTokenByText();
        Assert.assertNotNull((Object)tokens);
        Assert.assertTrue((tokens.size() == 6 ? 1 : 0) != 0);
        String[] tokenArray = new String[]{"This", "is", "a", "birthday", "pony", "!"};
        for (int i = 0; i < graph.getTokens().size(); ++i) {
            Assert.assertEquals((Object)tokenArray[i], (Object)graph.getText((SNode)tokens.get(i)));
        }
    }
}

