/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.delegator.tests;

import java.util.Set;
import java.util.Vector;
import org.corpus_tools.salt.ISaltFactory;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.delegator.tests.DelegatorTestFactory;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.impl.SaltFactoryImpl;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegationDeletionTest {
    @Before
    public void setUp() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
    }

    @After
    public void tearDown() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new SaltFactoryImpl());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof SaltFactoryImpl));
    }

    @Test
    public void testDelegated_DeletePointingRelations() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)template_doc.getDocumentGraph().getRelations().size(), (long)fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(template_doc.getDocumentGraph().getPointingRelations());
        for (SRelation rel : rels) {
            template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        rels = new Vector();
        rels.addAll(fixture_doc.getDocumentGraph().getPointingRelations());
        for (SRelation rel : rels) {
            fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegated_DeleteSyntax() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)template_doc.getDocumentGraph().getRelations().size(), (long)fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(template_doc.getDocumentGraph().getDominanceRelations());
        for (SRelation rel : rels) {
            template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        Vector nodes = new Vector();
        nodes.addAll(template_doc.getDocumentGraph().getStructures());
        for (SNode node : nodes) {
            template_doc.getDocumentGraph().removeNode((Node)node);
        }
        rels = new Vector();
        rels.addAll(fixture_doc.getDocumentGraph().getDominanceRelations());
        for (SRelation rel : rels) {
            fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        nodes = new Vector();
        nodes.addAll(fixture_doc.getDocumentGraph().getStructures());
        for (SNode node : nodes) {
            fixture_doc.getDocumentGraph().removeNode((Node)node);
        }
        diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegated_DeleteInformationStructure() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)template_doc.getDocumentGraph().getRelations().size(), (long)fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(template_doc.getDocumentGraph().getSpanningRelations());
        for (SRelation rel : rels) {
            template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        Vector nodes = new Vector();
        nodes.addAll(template_doc.getDocumentGraph().getSpans());
        for (SNode node : nodes) {
            template_doc.getDocumentGraph().removeNode((Node)node);
        }
        rels = new Vector();
        rels.addAll(fixture_doc.getDocumentGraph().getSpanningRelations());
        for (SRelation rel : rels) {
            fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        nodes = new Vector();
        nodes.addAll(fixture_doc.getDocumentGraph().getSpans());
        for (SNode node : nodes) {
            fixture_doc.getDocumentGraph().removeNode((Node)node);
        }
        diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }
}

