/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.RelationImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GraphTest {
    protected Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> fixture = null;

    public Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> getFixture() {
        return this.fixture;
    }

    public void setFixture(Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture((Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>>)new GraphImpl());
    }

    private Pair<List<Node>, List<Relation<Node, Node>>> createSampleGraph() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node1 = GraphFactory.createNode();
        this.getFixture().addNode(node1);
        nodes.add(node1);
        Node node2 = GraphFactory.createNode();
        this.getFixture().addNode(node2);
        nodes.add(node2);
        Node node3 = GraphFactory.createNode();
        this.getFixture().addNode(node3);
        nodes.add(node3);
        Node node4 = GraphFactory.createNode();
        this.getFixture().addNode(node4);
        nodes.add(node4);
        Node node5 = GraphFactory.createNode();
        this.getFixture().addNode(node5);
        nodes.add(node5);
        Node node6 = GraphFactory.createNode();
        this.getFixture().addNode(node6);
        nodes.add(node6);
        Node node7 = GraphFactory.createNode();
        this.getFixture().addNode(node7);
        nodes.add(node7);
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Relation relation1 = GraphFactory.createRelation();
        relation1.setSource(node1);
        relation1.setTarget(node2);
        this.getFixture().addRelation(relation1);
        relations.add(relation1);
        Relation relation2 = GraphFactory.createRelation();
        relation2.setSource(node2);
        relation2.setTarget(node3);
        this.getFixture().addRelation(relation2);
        relations.add(relation2);
        Relation relation3 = GraphFactory.createRelation();
        relation3.setSource(node1);
        relation3.setTarget(node4);
        this.getFixture().addRelation(relation3);
        relations.add(relation3);
        Relation relation4 = GraphFactory.createRelation();
        relation4.setSource(node4);
        relation4.setTarget(node5);
        this.getFixture().addRelation(relation4);
        relations.add(relation4);
        Relation relation5 = GraphFactory.createRelation();
        relation5.setSource(node2);
        relation5.setTarget(node6);
        this.getFixture().addRelation(relation5);
        relations.add(relation5);
        Relation relation6 = GraphFactory.createRelation();
        relation6.setSource(node1);
        relation6.setTarget(node7);
        this.getFixture().addRelation(relation6);
        relations.add(relation6);
        return new ImmutablePair(nodes, relations);
    }

    @Test
    public void testGetId() {
        String id = "id1";
        this.getFixture().setId(id);
        Assert.assertEquals((Object)id, (Object)this.getFixture().getId());
    }

    @Test
    public void testDoubleChainingNode() {
        Node node = GraphFactory.createNode();
        this.getFixture().addNode(node);
        Assert.assertEquals(this.getFixture(), (Object)node.getGraph());
    }

    @Test
    public void testDoubleChainingRelation() {
        Relation rel = GraphFactory.createRelation();
        Node source = GraphFactory.createNode();
        Node target = GraphFactory.createNode();
        this.getFixture().addNode(source);
        this.getFixture().addNode(target);
        rel.setSource(source);
        rel.setTarget(target);
        this.getFixture().addRelation(rel);
        Assert.assertEquals(this.getFixture(), (Object)rel.getGraph());
    }

    @Test
    public void testDoubleChainingLayer() {
        Layer layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Assert.assertEquals(this.getFixture(), (Object)layer.getGraph());
    }

    @Test
    public void testAddNode() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
        try {
            this.getFixture().addNode(null);
            Assert.fail((String)"Null should not have been added as a node. ");
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        Node node = GraphFactory.createNode();
        this.getFixture().addNode(node);
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((Object)node, this.getFixture().getNodes().get(0));
        for (int i = 0; i < 50; ++i) {
            node = GraphFactory.createNode();
            this.getFixture().addNode(node);
            Assert.assertTrue((boolean)this.getFixture().getNodes().contains(node));
        }
    }

    @Test
    public void testAddNode_Id() {
        Node node = GraphFactory.createNode();
        this.getFixture().addNode(node);
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((Object)node, this.getFixture().getNodes().get(0));
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 50; ++i) {
            node = GraphFactory.createNode();
            this.getFixture().addNode(node);
            Assert.assertNotNull((Object)node.getId());
            if (ids.contains(node.getId())) {
                Assert.fail((String)"An id was given twice");
            }
            ids.add(node.getId());
            Assert.assertTrue((boolean)this.getFixture().getNodes().contains(node));
        }
        node = GraphFactory.createNode();
        node.setId("hello");
        this.getFixture().addNode(node);
        node = GraphFactory.createNode();
        node.setId("hello");
        this.getFixture().addNode(node);
        Assert.assertNotEquals((Object)"hello", (Object)node.getId());
    }

    @Test
    public void testAddXInList() {
        try {
            this.getFixture().getNodes().add(GraphFactory.createNode());
            Assert.fail((String)"A node shall not be added by the list");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.getFixture().getRelations().add(GraphFactory.createRelation());
            Assert.fail((String)"An relation shall not be added by the list");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.getFixture().getLayers().add(GraphFactory.createLayer());
            Assert.fail((String)"A layer shall not be added by the list");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNodes() throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = GraphFactory.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
        }
        Assert.assertEquals((long)nodes.size(), (long)this.getFixture().getNodes().size());
        for (Node node : nodes) {
            Assert.assertTrue((boolean)this.getFixture().getNodes().contains(node));
        }
    }

    @Test
    public void testGetNode() {
        Assert.assertNull((Object)this.getFixture().getNode(null));
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = GraphFactory.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
        }
        for (Node node : nodes) {
            Assert.assertEquals((Object)node, (Object)this.getFixture().getNode(node.getId()));
        }
    }

    @Test
    public void testRemoveNode() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = GraphFactory.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
            Assert.assertEquals((Object)node, (Object)this.getFixture().getNode(node.getId()));
        }
        for (Node node : nodes) {
            Assert.assertNotNull((Object)this.getFixture().getNode(node.getId()));
            this.getFixture().removeNode(node);
            Assert.assertNull((String)("node '" + node + "' should be removed"), (Object)this.getFixture().getNode(node.getId()));
        }
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
    }

    @Test
    public void testRemoveNodeFromList() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Node node : (List)pair.getLeft()) {
            if (this.getFixture().getNode(node.getId()) == null) continue;
            Assert.assertEquals((String)("this node '" + node.getId() + "' should be there"), (Object)node, (Object)this.getFixture().getNode(node.getId()));
            try {
                this.getFixture().getNodes().remove(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertNotNull((String)("this node '" + node.getId() + "' should still be there"), (Object)this.getFixture().getNode(node.getId()));
        }
    }

    @Test
    public void testRemoveNodeAlsoFromLayer() {
        Layer layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = GraphFactory.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
            layer.addNode(node);
        }
        Assert.assertEquals((long)nodes.size(), (long)layer.getNodes().size());
        for (Node node : nodes) {
            this.getFixture().removeNode(node);
        }
        Assert.assertEquals((long)0L, (long)layer.getNodes().size());
    }

    @Test
    public void testRemoveNodeAndAlsoRelations() {
        Node n1 = GraphFactory.createNode();
        this.getFixture().addNode(n1);
        Node n2 = GraphFactory.createNode();
        this.getFixture().addNode(n2);
        Relation r1 = GraphFactory.createRelation();
        r1.setSource(n1);
        r1.setTarget(n2);
        this.getFixture().addRelation(r1);
        Relation r2 = GraphFactory.createRelation();
        r2.setSource(n2);
        r2.setTarget(n1);
        this.getFixture().addRelation(r2);
        Assert.assertEquals((long)1L, (long)this.getFixture().getOutRelations(n1.getId()).size());
        Assert.assertTrue((boolean)this.getFixture().getOutRelations(n1.getId()).contains(r1));
        Assert.assertTrue((boolean)this.getFixture().getOutRelations(n2.getId()).contains(r2));
        Assert.assertEquals((long)1L, (long)this.getFixture().getInRelations(n1.getId()).size());
        Assert.assertTrue((boolean)this.getFixture().getInRelations(n1.getId()).contains(r2));
        Assert.assertTrue((boolean)this.getFixture().getInRelations(n2.getId()).contains(r1));
        this.getFixture().removeNode(n2);
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((long)0L, (long)this.getFixture().getInRelations(n1.getId()).size());
        Assert.assertEquals((long)0L, (long)this.getFixture().getOutRelations(n1.getId()).size());
    }

    @Test
    public void testAddDuplicatedNode() {
        Node n = GraphFactory.createNode();
        this.getFixture().addNode(n);
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodes().size());
        this.getFixture().addNode(n);
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodes().size());
    }

    @Test
    public void testAddNodeMoveGraph() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
        GraphImpl oldGraph = new GraphImpl();
        Node node = GraphFactory.createNode();
        oldGraph.addNode(node);
        Assert.assertEquals((long)1L, (long)oldGraph.getNodes().size());
        Assert.assertEquals((Object)node, oldGraph.getNodes().get(0));
        this.getFixture().addNode(node);
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((Object)node, this.getFixture().getNodes().get(0));
        Assert.assertEquals((long)0L, (long)oldGraph.getNodes().size());
        Assert.assertEquals(this.getFixture(), (Object)node.getGraph());
    }

    @Test
    public void testAddRelation() {
        try {
            this.getFixture().addRelation(null);
            Assert.fail((String)"Null should not have been added as a node. ");
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        RelationImpl relation = new RelationImpl();
        Node source = null;
        Node target = null;
        try {
            this.getFixture().addRelation((Relation)relation);
            Assert.fail();
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        source = GraphFactory.createNode();
        relation.setSource(source);
        try {
            this.getFixture().addRelation((Relation)relation);
            Assert.fail();
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        target = GraphFactory.createNode();
        relation.setTarget(target);
        try {
            this.getFixture().addRelation((Relation)relation);
            Assert.fail((String)"Cannot add relation, whose source and target does not belong to graph");
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        this.getFixture().addNode(source);
        this.getFixture().addNode(target);
        this.getFixture().addRelation((Relation)relation);
        Assert.assertTrue((boolean)this.getFixture().getRelations().contains(relation));
    }

    @Test
    public void testAddRelation_Id() {
        Node node = GraphFactory.createNode();
        this.getFixture().addNode(node);
        Relation relation = GraphFactory.createRelation();
        relation.setSource(node);
        relation.setTarget(node);
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations().size());
        this.getFixture().addRelation(relation);
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((Object)relation, this.getFixture().getRelations().get(0));
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 50; ++i) {
            relation = GraphFactory.createRelation();
            relation.setSource(node);
            relation.setTarget(node);
            this.getFixture().addRelation(relation);
            Assert.assertNotNull((Object)relation.getId());
            if (ids.contains(relation.getId())) {
                Assert.fail((String)"An id was given twice");
            }
            ids.add(relation.getId());
            Assert.assertTrue((boolean)this.getFixture().getRelations().contains(relation));
        }
        relation = GraphFactory.createRelation();
        relation.setId("hello");
        relation.setSource(node);
        relation.setTarget(node);
        this.getFixture().addRelation(relation);
        relation = GraphFactory.createRelation();
        relation.setId("hello");
        relation.setSource(node);
        relation.setTarget(node);
        this.getFixture().addRelation(relation);
        Assert.assertNotEquals((Object)"hello", (Object)relation.getId());
    }

    @Test
    public void testGetRelation() {
        Assert.assertNull((Object)this.getFixture().getRelation(null));
        Node node1 = GraphFactory.createNode();
        node1.setId("node1");
        Node node2 = GraphFactory.createNode();
        node2.setId("node2");
        Relation relation1 = GraphFactory.createRelation();
        relation1.setId("relation1");
        relation1.setSource(node1);
        relation1.setTarget(node2);
        Assert.assertNull((Object)this.getFixture().getRelation(relation1.getId()));
        this.getFixture().addNode(node1);
        this.getFixture().addNode(node2);
        this.getFixture().addRelation(relation1);
        Assert.assertEquals((Object)relation1, (Object)this.getFixture().getRelation(relation1.getId()));
    }

    @Test
    public void testGetRelationsBetweenNodes() {
        Node node1 = GraphFactory.createNode();
        this.getFixture().addNode(node1);
        Node node2 = GraphFactory.createNode();
        this.getFixture().addNode(node2);
        Node node3 = GraphFactory.createNode();
        this.getFixture().addNode(node3);
        Relation relation1 = GraphFactory.createRelation();
        relation1.setSource(node2);
        relation1.setTarget(node3);
        this.getFixture().addRelation(relation1);
        Relation relation2 = GraphFactory.createRelation();
        relation2.setSource(node2);
        relation2.setTarget(node3);
        this.getFixture().addRelation(relation2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getRelations(node2.getId(), node3.getId()).size());
        Assert.assertEquals((Object)relation1, this.getFixture().getRelations(node2.getId(), node3.getId()).get(0));
        Assert.assertEquals((Object)relation2, this.getFixture().getRelations(node2.getId(), node3.getId()).get(1));
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations(node1.getId(), node3.getId()).size());
    }

    @Test
    public void testGetInRelations() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation relation : (List)pair.getRight()) {
            Assert.assertTrue((String)("this inserted relation '" + relation.getId() + "' should be in getInRelations: " + this.getFixture().getInRelations(relation.getTarget().getId())), (boolean)this.getFixture().getInRelations(relation.getTarget().getId()).contains(relation));
        }
    }

    @Test
    public void testGetOutRelations() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation relation : (List)pair.getRight()) {
            Assert.assertTrue((String)("this inserted relation '" + relation.getId() + "' should be in getOutRelations: " + this.getFixture().getOutRelations(relation.getSource().getId())), (boolean)this.getFixture().getOutRelations(relation.getSource().getId()).contains(relation));
        }
    }

    @Test
    public void testRemoveRelation() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation rel : (List)pair.getRight()) {
            Assert.assertEquals((String)("this edge '" + rel.getId() + "' should be there"), (Object)rel, (Object)this.getFixture().getRelation(rel.getId()));
        }
        for (Relation rel : (List)pair.getRight()) {
            if (this.getFixture().getRelation(rel.getId()) == null) continue;
            Assert.assertEquals((String)("this edge '" + rel.getId() + "' should be there"), (Object)rel, (Object)this.getFixture().getRelation(rel.getId()));
            this.getFixture().removeRelation(rel);
            Assert.assertNull((String)("this edge '" + rel.getId() + "' shouldn't be there"), (Object)this.getFixture().getRelation(rel.getId()));
        }
        Relation rel = GraphFactory.createRelation();
        rel.setId("not there");
        this.getFixture().removeRelation(rel);
    }

    @Test
    public void testRemoveRelations() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation rel : (List)pair.getRight()) {
            Assert.assertEquals((String)("this relation '" + rel.getId() + "' should be there"), (Object)rel, (Object)this.getFixture().getRelation(rel.getId()));
        }
        this.getFixture().removeRelations();
        for (Relation rel : (List)pair.getRight()) {
            Assert.assertNull((String)("this relation '" + rel.getId() + "' shouldn't be there"), (Object)this.getFixture().getRelation(rel.getId()));
        }
    }

    @Test
    public void testRemoveRelation2() {
        Node node1 = GraphFactory.createNode();
        Node node2 = GraphFactory.createNode();
        this.getFixture().addNode(node1);
        this.getFixture().addNode(node2);
        Layer layer1 = GraphFactory.createLayer();
        this.getFixture().addLayer(layer1);
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (int i = 0; i < 5; ++i) {
            Relation relation = GraphFactory.createRelation();
            relation.setSource(node1);
            relation.setTarget(node2);
            this.getFixture().addRelation(relation);
            layer1.addRelation(relation);
            relations.add(relation);
        }
        Assert.assertEquals((long)5L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
        Assert.assertEquals((long)5L, (long)layer1.getRelations().size());
        for (Relation relation : relations) {
            this.getFixture().removeRelation(relation);
        }
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
        Assert.assertEquals((long)0L, (long)layer1.getRelations().size());
    }

    @Test
    public void testRemoveRelationFromList() {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation relation : (List)pair.getRight()) {
            if (this.getFixture().getRelation(relation.getId()) == null) continue;
            Assert.assertEquals((String)("this relation '" + relation.getId() + "' should be there"), (Object)relation, (Object)this.getFixture().getRelation(relation.getId()));
            try {
                this.getFixture().getRelations().remove(relation);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Assert.assertNotNull((String)("this relation '" + relation.getId() + "' should still be there"), (Object)this.getFixture().getRelation(relation.getId()));
        }
    }

    @Test
    public void testRemoveAllRelation() throws Exception {
        Pair<List<Node>, List<Relation<Node, Node>>> pair = this.createSampleGraph();
        for (Relation relation : (List)pair.getRight()) {
            Assert.assertEquals((String)("this relation '" + relation.getId() + "' should be there"), (Object)relation, (Object)this.getFixture().getRelation(relation.getId()));
        }
        this.getFixture().removeRelations();
        for (Relation relation : (List)pair.getRight()) {
            this.getFixture().addRelation(relation);
            Assert.assertEquals((String)"created relation has to be there", (Object)this.getFixture().getRelation(relation.getId()), (Object)relation);
        }
    }

    @Test
    public void testChangeRelationSource() {
        Node node1 = GraphFactory.createNode();
        this.getFixture().addNode(node1);
        Node node2 = GraphFactory.createNode();
        this.getFixture().addNode(node2);
        Relation relation = GraphFactory.createRelation();
        relation.setSource(node1);
        relation.setTarget(node2);
        this.getFixture().addRelation(relation);
        Assert.assertTrue((boolean)this.getFixture().getOutRelations(node1.getId()).contains(relation));
        Assert.assertTrue((boolean)this.getFixture().getInRelations(node2.getId()).contains(relation));
        Node node3 = GraphFactory.createNode();
        this.getFixture().addNode(node3);
        relation.setSource(node3);
        Assert.assertTrue((String)("all relations: " + this.getFixture().getOutRelations(node3.getId())), (boolean)this.getFixture().getOutRelations(node3.getId()).contains(relation));
        Assert.assertTrue((boolean)this.getFixture().getOutRelations(node1.getId()).isEmpty());
    }

    @Test
    public void testChangeRelationTarget() {
        Node node1 = GraphFactory.createNode();
        node1.setId("node1");
        this.getFixture().addNode(node1);
        Node node2 = GraphFactory.createNode();
        node2.setId("node2");
        this.getFixture().addNode(node2);
        Relation relation = GraphFactory.createRelation();
        relation.setId("relation1");
        relation.setSource(node1);
        relation.setTarget(node2);
        this.getFixture().addRelation(relation);
        Assert.assertTrue((boolean)this.getFixture().getOutRelations(node1.getId()).contains(relation));
        Assert.assertTrue((boolean)this.getFixture().getInRelations(node2.getId()).contains(relation));
        Node node3 = GraphFactory.createNode();
        node3.setId("node3");
        this.getFixture().addNode(node3);
        relation.setTarget(node3);
        Assert.assertTrue((boolean)this.getFixture().getInRelations(node3.getId()).contains(relation));
        Assert.assertTrue((boolean)this.getFixture().getInRelations(node2.getId()).isEmpty());
    }

    @Test
    public void testAddDuplicatedRelation() {
        Node n1 = GraphFactory.createNode();
        Node n2 = GraphFactory.createNode();
        this.getFixture().addNode(n1);
        this.getFixture().addNode(n2);
        Relation rel = GraphFactory.createRelation();
        rel.setSource(n1);
        rel.setTarget(n2);
        this.getFixture().addRelation(rel);
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelations().size());
        this.getFixture().addRelation(rel);
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelations().size());
    }

    @Test
    public void testAddLayer() {
        Layer layer = null;
        this.getFixture().addLayer(layer);
        Assert.assertEquals((String)"shall not add a null layer", (long)0L, (long)this.getFixture().getLayers().size());
        layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
        Assert.assertEquals((String)"shall not add a layer two times", (long)1L, (long)this.getFixture().getLayers().size());
    }

    @Test
    public void testGetLayer() {
        Assert.assertNull((Object)this.getFixture().getLayer(null));
        Layer layer = null;
        layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Assert.assertEquals((Object)layer, (Object)this.getFixture().getLayer(layer.getId()));
    }

    @Test
    public void testRemoveLayer() {
        Layer layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Assert.assertEquals((Object)layer, (Object)this.getFixture().getLayer(layer.getId()));
        this.getFixture().removeLayer(layer);
        Assert.assertNull((Object)this.getFixture().getLayer(layer.getId()));
        Assert.assertEquals((long)0L, (long)this.getFixture().getLayers().size());
    }

    @Test
    public void testRemoveLayerFromList() {
        Layer layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Assert.assertEquals((Object)layer, (Object)this.getFixture().getLayer(layer.getId()));
        try {
            this.getFixture().getLayers().remove(layer);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)layer, (Object)this.getFixture().getLayer(layer.getId()));
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
    }

    @Test
    public void testAddingLayerContainingNodeAndRelation() {
        Layer layer = GraphFactory.createLayer();
        Node node = GraphFactory.createNode();
        Node node2 = GraphFactory.createNode();
        Relation relation = GraphFactory.createRelation();
        relation.setSource(node);
        relation.setTarget(node2);
        layer.addNode(node);
        layer.addNode(node2);
        layer.addRelation(relation);
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations().size());
        this.getFixture().addLayer(layer);
        Assert.assertEquals((long)2L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((Object)node, (Object)this.getFixture().getNode(node.getId()));
        Assert.assertEquals((Object)node2, (Object)this.getFixture().getNode(node2.getId()));
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((Object)relation, (Object)this.getFixture().getRelation(relation.getId()));
    }

    @Test
    public void testAddNodeAndRelationToLayer() {
        Layer layer = GraphFactory.createLayer();
        this.getFixture().addLayer(layer);
        Node node = GraphFactory.createNode();
        Node node2 = GraphFactory.createNode();
        Relation relation = GraphFactory.createRelation();
        relation.setSource(node);
        relation.setTarget(node2);
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
        Assert.assertEquals((long)0L, (long)this.getFixture().getRelations().size());
        layer.addNode(node);
        Assert.assertEquals((Object)node, (Object)this.getFixture().getNode(node.getId()));
        layer.addNode(node2);
        Assert.assertEquals((Object)node2, (Object)this.getFixture().getNode(node2.getId()));
        layer.addRelation(relation);
        Assert.assertEquals((Object)relation, (Object)this.getFixture().getRelation(relation.getId()));
    }

    @Test
    public void testAddDuplicatedLayer() {
        Layer l = GraphFactory.createLayer();
        this.getFixture().addLayer(l);
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
        this.getFixture().addLayer(l);
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
    }
}

