/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IdentifierTest {
    private Identifier fixture = null;

    public Identifier getFixture() {
        return this.fixture;
    }

    public void setFixture(Identifier fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        MyContainer container = new MyContainer();
        this.setFixture(GraphFactory.createIdentifier((IdentifiableElement)container, (String)"myId"));
    }

    @After
    public void tearDown() throws Exception {
        this.setFixture(null);
    }

    @Test
    public void testQNameHandling() {
        String name = "id";
        String qName = "salt::" + name;
        this.getFixture().setQName(name);
        Assert.assertEquals((Object)qName, (Object)this.getFixture().getQName());
    }

    @Test
    public void testSetNamespace() {
        String ns = this.getFixture().getNamespace();
        this.getFixture().setNamespace("any");
        Assert.assertEquals((Object)ns, (Object)this.getFixture().getNamespace());
    }

    @Test
    public void testGetQName() {
        String qname = "salt::id";
        Assert.assertEquals((Object)qname, (Object)this.getFixture().getQName());
        this.getFixture().setName("something");
        Assert.assertEquals((Object)qname, (Object)this.getFixture().getQName());
    }

    @Test
    public void testGetId() {
        Assert.assertEquals((Object)"myId", (Object)this.getFixture().getId());
        Assert.assertEquals((Object)"myId", (Object)this.getFixture().getValue());
    }

    @Test
    public void testSetValue() {
        this.getFixture().setValue("newId");
        Assert.assertEquals((Object)"myId", (Object)this.getFixture().getValue());
    }

    @Test
    public void testSetName() {
        Assert.assertEquals((Object)"id", (Object)this.getFixture().getName());
        this.getFixture().setName("somename");
        Assert.assertEquals((Object)"id", (Object)this.getFixture().getName());
    }

    @Test
    public void testSetNameSpace() {
        Assert.assertEquals((Object)"salt", (Object)this.getFixture().getNamespace());
        this.getFixture().setNamespace("somename");
        Assert.assertEquals((Object)"salt", (Object)this.getFixture().getNamespace());
    }

    @Test
    public void testCheckOpposite() {
        MyContainer newContainer = new MyContainer();
        Identifier id = GraphFactory.createIdentifier((IdentifiableElement)newContainer, (String)"id");
        Assert.assertEquals((Object)newContainer.getIdentifier(), (Object)id);
        newContainer.setId("newId");
        Assert.assertFalse((boolean)((Object)((Object)newContainer)).equals(id));
    }

    @Test
    public void testGeneralNameHandling() {
        Assert.assertEquals((Object)"salt", (Object)this.getFixture().getNamespace());
    }

    static class MyContainer
    extends IdentifiableElementImpl {
        private static final long serialVersionUID = 5834449609454195900L;

        MyContainer() {
        }
    }
}

