/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.Vector;
import junit.framework.TestCase;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.impl.LabelableElementImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LabelableElementTest
extends TestCase {
    protected LabelableElement fixture = null;

    protected void setFixture(LabelableElement fixture) {
        this.fixture = fixture;
    }

    protected LabelableElement getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture((LabelableElement)new MyLabelableElement());
    }

    @After
    protected void tearDown() throws Exception {
        this.setFixture(null);
    }

    @Test
    public void testAddingGettingLabels() {
        String[] labelNames;
        Label label = null;
        this.getFixture().addLabel(null);
        LabelableElementTest.assertEquals(null, (Object)this.getFixture().getLabels());
        for (String labelName : labelNames = new String[]{"label1", "label2", "label3", "label4", "label5"}) {
            label = GraphFactory.createLabel();
            label.setName(labelName);
            this.getFixture().addLabel(label);
            LabelableElementTest.assertEquals((Object)label, (Object)this.getFixture().getLabel(labelName));
        }
    }

    @Test
    public void testAddingRemovingLabels() {
        LabelableElement labelableElement = this.getFixture();
        Label label = null;
        String[] labelNames = new String[]{"label1", "label2", "label3", "label4", "label5"};
        String label1 = "label1";
        Integer numOfLabels = labelNames.length + labelableElement.sizeLabels();
        for (String labelName : labelNames) {
            label = GraphFactory.createLabel();
            label.setName(labelName);
            labelableElement.addLabel(label);
        }
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        try {
            for (String labelName : labelNames) {
                label = GraphFactory.createLabel();
                label.setName(labelName);
                labelableElement.addLabel(label);
                LabelableElementTest.fail((String)"You should not add two labels with same name");
            }
        }
        catch (Exception arr$) {
            // empty catch block
        }
        for (String labelName : labelNames) {
            labelableElement.removeLabel(labelName);
        }
        numOfLabels = 0;
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        for (String labelName : labelNames) {
            label = GraphFactory.createLabel();
            label.setName(labelName);
            labelableElement.addLabel(label);
        }
        numOfLabels = labelNames.length;
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        for (String labelName : labelNames) {
            labelableElement.removeLabel(labelName);
        }
        for (String labelName : labelNames) {
            label = GraphFactory.createLabel();
            label.setName(labelName);
            labelableElement.addLabel(label);
        }
        numOfLabels = labelNames.length;
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        labelableElement.removeLabel(label1);
        numOfLabels = numOfLabels - 1;
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        label = GraphFactory.createLabel();
        label.setName(label1);
        labelableElement.addLabel(label);
        LabelableElementTest.assertEquals((Object)label, (Object)labelableElement.getLabel(label1));
    }

    @Test
    public void testRemoveAll() throws Exception {
        LabelableElement labelableElement = this.getFixture();
        Label label = null;
        String[] labelNames = new String[]{"label1", "label2", "label3", "label4", "label5"};
        Integer numOfLabels = labelNames.length + labelableElement.sizeLabels();
        for (String labelName : labelNames) {
            label = GraphFactory.createLabel();
            label.setName(labelName);
            labelableElement.addLabel(label);
            LabelableElementTest.assertEquals((Object)label, (Object)labelableElement.getLabel(labelName));
        }
        LabelableElementTest.assertEquals((Object)numOfLabels, (Object)labelableElement.sizeLabels());
        labelableElement.removeAll();
        LabelableElementTest.assertEquals((Object)0, (Object)labelableElement.sizeLabels());
        for (String labelName : labelNames) {
            LabelableElementTest.assertNull((Object)labelableElement.getLabel(labelName));
        }
    }

    @Test
    public void testGetLabelsByNamespace__String() {
        LabelableElement labelableElement = this.getFixture();
        Label label = null;
        String ns1 = "ns1";
        String ns2 = null;
        String ns3 = "ns2";
        String[] labelNames1 = new String[]{"ns1::label1", "ns1::label2"};
        String[] labelNames2 = new String[]{"label3"};
        String[] labelNames3 = new String[]{"ns2::label2", "ns2::label3", "ns2::label4"};
        Vector<String> labelNames = new Vector<String>();
        labelNames.addAll(new Vector<String>(Arrays.asList(labelNames1)));
        labelNames.addAll(new Vector<String>(Arrays.asList(labelNames2)));
        labelNames.addAll(new Vector<String>(Arrays.asList(labelNames3)));
        for (String labelName : labelNames) {
            label = GraphFactory.createLabel();
            label.setQName(labelName);
            labelableElement.addLabel(label);
        }
        Set labels = labelableElement.getLabelsByNamespace(ns1);
        LabelableElementTest.assertEquals((int)labelNames1.length, (int)labels.size());
        boolean found = false;
        for (String labelName : labelNames1) {
            found = false;
            for (Label searchLabel : labels) {
                if (!searchLabel.getQName().equalsIgnoreCase(labelName)) continue;
                found = true;
            }
            LabelableElementTest.assertTrue((String)"the searched value should be found", (boolean)found);
        }
        labels = labelableElement.getLabelsByNamespace(ns2);
        LabelableElementTest.assertEquals((int)labelNames2.length, (int)labels.size());
        found = false;
        for (String labelName : labelNames2) {
            found = false;
            for (Label searchLabel : labels) {
                if (!searchLabel.getQName().equalsIgnoreCase(labelName)) continue;
                found = true;
            }
            LabelableElementTest.assertTrue((String)"the searched value should be found", (boolean)found);
        }
        labels = labelableElement.getLabelsByNamespace(ns3);
        LabelableElementTest.assertEquals((int)labelNames3.length, (int)labels.size());
        found = false;
        for (String labelName : labelNames3) {
            found = false;
            for (Label searchLabel : labels) {
                if (!searchLabel.getQName().equalsIgnoreCase(labelName)) continue;
                found = true;
            }
            LabelableElementTest.assertTrue((String)"the searched value should be found", (boolean)found);
        }
    }

    @Test
    public void testHasLabel__String() {
        LabelableElement labelableElement = this.getFixture();
        Label label = null;
        String[] labelNamesOK = new String[]{"ns1::label1", "ns1::label2", "label1", "ns:label4", "label6"};
        String[] labelNamesNOTOK = new String[]{"label2", "ns1::label6"};
        for (String labelName : labelNamesOK) {
            label = GraphFactory.createLabel();
            label.setQName(labelName);
            labelableElement.addLabel(label);
        }
        for (String labelName : labelNamesOK) {
            LabelableElementTest.assertTrue((boolean)this.getFixture().containsLabel(labelName));
        }
        for (String labelName : labelNamesNOTOK) {
            LabelableElementTest.assertFalse((boolean)this.getFixture().containsLabel(labelName));
        }
    }

    @Test
    public void testRemoveLabel__String_String() {
        Label label = GraphFactory.createLabel();
        label.setNamespace("ns1");
        label.setName("name1");
        this.getFixture().addLabel(label);
        LabelableElementTest.assertTrue((boolean)this.getFixture().containsLabel(label.getQName()));
        this.getFixture().removeLabel(label.getNamespace(), label.getName());
        LabelableElementTest.assertFalse((boolean)this.getFixture().containsLabel(label.getQName()));
    }

    @Test
    public void testGetLabel__String_String() {
        Label label = GraphFactory.createLabel();
        label.setNamespace("sNS");
        label.setName("name");
        this.getFixture().addLabel(label);
        LabelableElementTest.assertEquals((Object)label, (Object)this.getFixture().getLabel(label.getNamespace(), label.getName()));
    }

    @Test
    public void testDoubleChaining() {
        Label label = GraphFactory.createLabel();
        label.setQName("labelName");
        LabelableElementTest.assertNull((Object)this.getFixture().getLabels());
        label.setContainer(this.getFixture());
        LabelableElementTest.assertEquals((int)1, (int)this.getFixture().getLabels().size());
        LabelableElementTest.assertTrue((boolean)this.getFixture().containsLabel(label.getQName()));
        label.setContainer(null);
        LabelableElementTest.assertFalse((boolean)this.getFixture().containsLabel(label.getQName()));
    }

    static class MyLabelableElement
    extends LabelableElementImpl {
        private static final long serialVersionUID = 1L;

        MyLabelableElement() {
        }
    }
}

