/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import org.assertj.core.api.Assertions;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.junit.Before;
import org.junit.Test;

public class ValidatorTest {
    private SDocumentGraph fixture = null;

    @Before
    public void beforeEach() {
        this.fixture = SaltFactory.createSDocumentGraph();
    }

    @Test
    public void whenValidatingCorpusAndACorpusContainsDocumentAndCorpus_thenInvalid() {
        SCorpusGraph graph = SaltFactory.createSCorpusGraph();
        graph.createCorpus(URI.createURI((String)"/corpus1/corpus2"));
        graph.createDocument(URI.createURI((String)"/corpus1/doc1"));
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)graph).andFindInvalidities().getInvalidities()).hasSize(1);
        SCorpusGraph graph1 = SaltFactory.createSCorpusGraph();
        graph1.createDocument(URI.createURI((String)"/corpus1/doc1"));
        graph1.createCorpus(URI.createURI((String)"/corpus1/corpus2"));
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)graph1).andFindInvalidities().getInvalidities()).hasSize(1);
    }

    @Test
    public void whenValidatingAndRelationHasSameSourceAndtarget_thenInvalid() {
        SPointingRelation rel = SaltFactory.createSPointingRelation();
        SToken tok = SaltFactory.createSToken();
        rel.setTarget((Node)tok);
        rel.setSource((Node)tok);
        this.fixture.addNode((Node)tok);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(1);
    }

    @Test
    public void whenValidatingAndSTextualDSHasNoText_thenInvalid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText(null);
        this.fixture.addNode((Node)text);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(1);
    }

    @Test
    public void whenValidatingSTextualRelationAndStartIsNotSet_thenThereShouldInvalid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(2);
    }

    @Test
    public void whenValidatingSTextualRelationAndStartIsSmallerThanTextSize_thenInvalid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)-1);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(2);
    }

    @Test
    public void whenRepairSTextualRelationAndStartIsSmallerThanTextSize_thenValid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)-1);
        rel.setEnd((Number)0);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andRepairInvalidities().getInvalidities()).hasSize(1);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(0);
    }

    @Test
    public void whenValidatingSTextualRelationAndStartIsBiggerThanTextSize_thenValid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)1);
        rel.setEnd((Number)1);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(2);
    }

    @Test
    public void whenValidatingSTextualRelationAndStartIsBiggerThanEnd_thenValid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("text");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)2);
        rel.setEnd((Number)1);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(1);
    }

    @Test
    public void whenValidatingSTextualRelationAndEndIsBiggerThanTextSize_thenInvalid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)0);
        rel.setEnd((Number)2);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(1);
    }

    @Test
    public void whenValidatingSTextualRelationAndEndIsSmallerThan0_thenInvalid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)0);
        rel.setEnd((Number)-1);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(2);
    }

    @Test
    public void whenRepairingSTextualRelationAndEndIsBiggerThanTextSize_thenValid() {
        STextualDS text = SaltFactory.createSTextualDS();
        text.setText("");
        SToken tok = SaltFactory.createSToken();
        this.fixture.addNode((Node)text);
        this.fixture.addNode((Node)tok);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setStart((Number)0);
        rel.setEnd((Number)2);
        rel.setSource((Node)tok);
        rel.setTarget((Node)text);
        this.fixture.addRelation((Relation)rel);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andRepairInvalidities().getInvalidities()).hasSize(1);
        Assertions.assertThat((Iterable)SaltUtil.validate((Object)this.fixture).andFindInvalidities().getInvalidities()).hasSize(0);
    }
}

