/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.persistence.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.tests.SaltTestsUtil;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.Diff;
import org.corpus_tools.salt.util.internal.persistence.SaltXML10Writer;
import org.eclipse.emf.common.util.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Persist_SaltXML10_Test {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testLoadStore_DocumentGraph_text() {
        SDocument template = SaltFactory.createSDocument();
        SampleGenerator.createPrimaryData((SDocument)template);
        SDocument other = SaltFactory.createSDocument();
        SampleGenerator.createPrimaryData((SDocument)other);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_text.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_DocumentGraph_text_specialCharacters() {
        SDocument template = SaltFactory.createSDocument();
        template.setDocumentGraph(SaltFactory.createSDocumentGraph());
        template.getDocumentGraph().createTextualDS("This is a text with linebreaks\n and tabs\t.");
        template.getDocumentGraph().createAnnotation("mnys", "myname", (Object)"This is a \"text\" with linebreaks\n and tabs\t.");
        SDocument other = SaltFactory.createSDocument();
        other.setDocumentGraph(SaltFactory.createSDocumentGraph());
        other.getDocumentGraph().createTextualDS("This is a text with linebreaks\n and tabs\t.");
        other.getDocumentGraph().createAnnotation("mnys", "myname", (Object)"This is a \"text\" with linebreaks\n and tabs\t.");
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_text_specialCharacters.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_DocumentGraph_tokenization() {
        SDocument template = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)template);
        SDocument other = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)other);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_tokenization.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_DocumentGraph_multilayer() {
        SDocument template = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)template);
        SampleGenerator.createMorphologyAnnotations((SDocument)template);
        SampleGenerator.createAnaphoricAnnotations((SDocument)template);
        SampleGenerator.createDependencies((SDocument)template);
        SampleGenerator.createInformationStructureAnnotations((SDocument)template);
        SampleGenerator.createSyntaxAnnotations((SDocument)template);
        SDocument other = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)other);
        SampleGenerator.createMorphologyAnnotations((SDocument)other);
        SampleGenerator.createAnaphoricAnnotations((SDocument)other);
        SampleGenerator.createDependencies((SDocument)other);
        SampleGenerator.createInformationStructureAnnotations((SDocument)other);
        SampleGenerator.createSyntaxAnnotations((SDocument)other);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_multilayer.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_DocumentGraph_dialogue() {
        SDocument template = SaltFactory.createSDocument();
        SampleGenerator.createDialogue((SDocument)template);
        SDocument other = SaltFactory.createSDocument();
        SampleGenerator.createDialogue((SDocument)other);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_dialogue.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_DocumentGraph_parallelData() {
        SDocument template = SaltFactory.createSDocument();
        SampleGenerator.createParallelData((SDocument)template);
        SDocument other = SaltFactory.createSDocument();
        SampleGenerator.createParallelData((SDocument)other);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_parallel.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)other.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Assert.assertTrue((boolean)template.getDocumentGraph().isIsomorph(graph));
    }

    @Test
    public void testLoadStore_SaltProjectOnlyStructure() {
        SaltProject project = SaltFactory.createSaltProject();
        SampleGenerator.createCorpusStructure((SaltProject)project);
        SampleGenerator.createCorpusStructure((SaltProject)project);
        String outFolder = SaltTestsUtil.getTempTestFolder("/testLoadStore_SaltProjectOnlyStructure") + "/saltProject";
        File tmpFile = new File(outFolder + "/" + "saltProject.salt");
        SaltUtil.saveSaltProject((SaltProject)project, (URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        SaltProject loaded = SaltUtil.loadSaltProject((URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        Assert.assertEquals((long)project.getCorpusGraphs().size(), (long)loaded.getCorpusGraphs().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getNodes().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getNodes().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getRelations().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getRelations().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(1)).getNodes().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(1)).getNodes().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(1)).getRelations().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(1)).getRelations().size());
        outFolder = SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/saltProject2";
        tmpFile = new File(outFolder);
        SaltUtil.saveSaltProject((SaltProject)project, (URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        loaded = SaltUtil.loadSaltProject((URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        Assert.assertEquals((long)project.getCorpusGraphs().size(), (long)loaded.getCorpusGraphs().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getNodes().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getNodes().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getRelations().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getRelations().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(1)).getNodes().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(1)).getNodes().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(1)).getRelations().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(1)).getRelations().size());
    }

    @Test
    public void testLoadStore_SaltProjectWithStructure() {
        SaltProject project = SampleGenerator.createSaltProject();
        String outFolder = SaltTestsUtil.getTempTestFolder("/testLoadStore_SaltProjectWithStructure") + "/saltProject";
        File tmpFile = new File(outFolder + "/" + "saltProject.salt");
        SaltUtil.saveSaltProject((SaltProject)project, (URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        SaltProject loaded = SaltUtil.loadSaltProject((URI)URI.createFileURI((String)tmpFile.getAbsolutePath()));
        Assert.assertEquals((long)project.getCorpusGraphs().size(), (long)loaded.getCorpusGraphs().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getNodes().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getNodes().size());
        Assert.assertEquals((long)((SCorpusGraph)project.getCorpusGraphs().get(0)).getRelations().size(), (long)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getRelations().size());
        Assert.assertNotNull((Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(0)).getDocumentGraphLocation());
        Assert.assertNotNull((Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(1)).getDocumentGraphLocation());
        Assert.assertNotNull((Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(2)).getDocumentGraphLocation());
        Assert.assertNotNull((Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(3)).getDocumentGraphLocation());
        Assert.assertEquals((Object)(outFolder + "/rootCorpus/subCorpus1/doc1.salt"), (Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(0)).getDocumentGraphLocation().toFileString());
        Assert.assertEquals((Object)(outFolder + "/rootCorpus/subCorpus1/doc2.salt"), (Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(1)).getDocumentGraphLocation().toFileString());
        Assert.assertEquals((Object)(outFolder + "/rootCorpus/subCorpus2/doc3.salt"), (Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(2)).getDocumentGraphLocation().toFileString());
        Assert.assertEquals((Object)(outFolder + "/rootCorpus/subCorpus2/doc4.salt"), (Object)((SDocument)((SCorpusGraph)loaded.getCorpusGraphs().get(0)).getDocuments().get(3)).getDocumentGraphLocation().toFileString());
    }

    @Test
    public void testLoadStore_DocumentGraph_DataTypes() {
        SDocument template = SaltFactory.createSDocument();
        template.setDocumentGraph(SaltFactory.createSDocumentGraph());
        template.getDocumentGraph().createFeature("test", "double", (Object)1.2345);
        template.getDocumentGraph().createFeature("test", "float", (Object)Float.valueOf(1.2345f));
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore") + "/DocumentGraph_DataTypes.salt");
        URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
        SaltUtil.saveDocumentGraph((SDocumentGraph)template.getDocumentGraph(), (URI)path);
        SDocumentGraph graph = SaltUtil.loadDocumentGraph((URI)path);
        Double d = graph.getFeature("test", "double").getValue_SFLOAT();
        Assert.assertEquals((double)1.2345, (double)d, (double)0.0);
        Float f = Float.valueOf(graph.getFeature("test", "float").getValue_SFLOAT().floatValue());
        Assert.assertEquals((float)1.2345f, (float)f.floatValue(), (float)0.0f);
    }

    @Test
    public void testLoadStore_MultipleContentRoots() {
        SaltProject proj = SaltFactory.createSaltProject();
        proj.setName("Test");
        SCorpusGraph cg = proj.createCorpusGraph();
        SCorpus rootCorpus = cg.createCorpus(null, "root");
        SDocument doc1 = cg.createDocument(rootCorpus, "doc1");
        SDocument doc2 = cg.createDocument(rootCorpus, "doc2");
        SampleGenerator.createDocumentStructure((SDocument)doc1);
        SampleGenerator.createDocumentStructure((SDocument)doc2);
        File tmpFile = new File(SaltTestsUtil.getTempTestFolder("/testLoadStore_MultipleContentRoots") + "/MultipleContentRoots.salt");
        XMLOutputFactory outFactory = XMLOutputFactory.newFactory();
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            XMLStreamWriter xml = outFactory.createXMLStreamWriter(fos, "UTF-8");
            SaltXML10Writer writer = new SaltXML10Writer();
            xml.writeStartDocument("1.0");
            xml.writeCharacters("\n");
            writer.writeXMIRootElement(xml);
            writer.writeObjects(xml, new Object[]{proj, doc1.getDocumentGraph()});
            writer.writeObjects(xml, new Object[]{doc2.getDocumentGraph()});
            xml.writeEndDocument();
            URI path = URI.createFileURI((String)tmpFile.getAbsolutePath());
            List roots = SaltUtil.loadObjects((URI)path);
            Assert.assertEquals((long)3L, (long)roots.size());
            Assert.assertTrue((boolean)(roots.get(0) instanceof SaltProject));
            Assert.assertTrue((boolean)(roots.get(1) instanceof SDocumentGraph));
            Assert.assertTrue((boolean)(roots.get(2) instanceof SDocumentGraph));
            SDocumentGraph loadedDoc1 = (SDocumentGraph)roots.get(1);
            SDocumentGraph loadedDoc2 = (SDocumentGraph)roots.get(2);
            Diff diff1 = new Diff(doc1.getDocumentGraph(), loadedDoc1);
            Set differencesForDoc1 = diff1.findDiffs();
            Assert.assertEquals((long)0L, (long)differencesForDoc1.size());
            Diff diff2 = new Diff(doc2.getDocumentGraph(), loadedDoc2);
            Set differencesForDoc2 = diff2.findDiffs();
            Assert.assertEquals((long)0L, (long)differencesForDoc2.size());
        }
        catch (IOException | XMLStreamException ex) {
            Assert.assertNull((Object)ex);
        }
    }
}

