/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.junit.Before;
import org.junit.Test;

public class SCorpusGraphTest
extends TestCase
implements GraphTraverseHandler {
    public static final String FILE_RESOURCE_DIR = "./src/test/resources/SCorpusGraphTest/";
    public static final String FILE_TMP_DIR = "./_TMP/";
    private List<SNode> traversedNodes;
    protected SCorpusGraph fixture = null;
    private SCorpus alibiCorpus = null;
    private SDocument alibiDocument = null;

    protected void setFixture(SCorpusGraph fixture) {
        this.fixture = fixture;
    }

    protected SCorpusGraph getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(SaltFactory.createSCorpusGraph());
        this.alibiCorpus = SaltFactory.createSCorpus();
        this.alibiDocument = SaltFactory.createSDocument();
    }

    @Test
    public void testSetGetSaltProjetc() {
        SCorpusGraphTest.assertNull((Object)this.getFixture().getSaltProject());
        SaltProject project = SaltFactory.createSaltProject();
        this.getFixture().setSaltProject(project);
        SCorpusGraphTest.assertEquals((Object)project, (Object)this.getFixture().getSaltProject());
    }

    @Test
    public void testSaltProject_doubleChaining() {
        SaltProject project = SaltFactory.createSaltProject();
        SCorpusGraphTest.assertEquals((int)0, (int)project.getCorpusGraphs().size());
        this.getFixture().setSaltProject(project);
        SCorpusGraphTest.assertEquals((int)1, (int)project.getCorpusGraphs().size());
        SCorpusGraphTest.assertEquals((Object)this.getFixture(), project.getCorpusGraphs().get(0));
        this.getFixture().setSaltProject(null);
        SCorpusGraphTest.assertEquals((int)0, (int)project.getCorpusGraphs().size());
    }

    @Test
    public void testGetDocuments() {
        String[] ids = new String[]{"salt:/graph1#doc1", "salt:/graph1#doc2", "salt:/graph1#doc3", "salt:/graph1#doc4"};
        ArrayList<SDocument> docDSs = new ArrayList<SDocument>();
        for (String id : ids) {
            SDocument docDs = SaltFactory.createSDocument();
            docDs.setId(id);
            this.getFixture().addNode((Node)docDs);
            docDSs.add(docDs);
        }
        SCorpusGraphTest.assertTrue((boolean)docDSs.containsAll(this.getFixture().getDocuments()));
        SCorpusGraphTest.assertTrue((boolean)this.getFixture().getDocuments().containsAll(docDSs));
    }

    @Test
    public void testGetCorpora() {
        String[] ids = new String[]{"salt:/graph1#corp1", "salt:/graph1#corp2", "salt:/graph1#corp3", "salt:/graph1#corp4"};
        ArrayList<SCorpus> corpDSs = new ArrayList<SCorpus>();
        for (String id : ids) {
            SCorpus corpDs = SaltFactory.createSCorpus();
            corpDs.setId(id);
            this.getFixture().addNode((Node)corpDs);
            corpDSs.add(corpDs);
        }
        SCorpusGraphTest.assertTrue((boolean)corpDSs.containsAll(this.getFixture().getCorpora()));
        SCorpusGraphTest.assertTrue((boolean)this.getFixture().getCorpora().containsAll(corpDSs));
    }

    @Test
    public void testGetSCorpusRelations() {
        String[] ids = new String[]{"salt:/graph1#corpRel1", "salt:/graph1#corpRel2", "salt:/graph1#corpRel3", "salt:/graph1#corpRel4"};
        ArrayList<SCorpusRelation> corpRelDSs = new ArrayList<SCorpusRelation>();
        this.getFixture().addNode((Node)this.alibiCorpus);
        for (String id : ids) {
            SCorpusRelation corpRel = SaltFactory.createSCorpusRelation();
            corpRel.setId(id);
            corpRel.setSource((Node)this.alibiCorpus);
            corpRel.setTarget((Node)this.alibiCorpus);
            this.getFixture().addRelation((Relation)corpRel);
            corpRelDSs.add(corpRel);
        }
        SCorpusGraphTest.assertTrue((boolean)corpRelDSs.containsAll(this.getFixture().getCorpusRelations()));
        SCorpusGraphTest.assertTrue((boolean)this.getFixture().getCorpusRelations().containsAll(corpRelDSs));
    }

    @Test
    public void testGetCorpusDocumentRelations() {
        String[] ids = new String[]{"salt:/graph1#corpRel1", "salt:/graph1#corpRel2", "salt:/graph1#corpRel3", "salt:/graph1#corpRel4"};
        ArrayList<SCorpusDocumentRelation> corpRelDSs = new ArrayList<SCorpusDocumentRelation>();
        this.getFixture().addNode((Node)this.alibiCorpus);
        this.getFixture().addNode((Node)this.alibiDocument);
        for (String id : ids) {
            SCorpusDocumentRelation corpDocRel = SaltFactory.createSCorpusDocumentRelation();
            corpDocRel.setId(id);
            corpDocRel.setSource((Node)this.alibiCorpus);
            corpDocRel.setTarget((Node)this.alibiDocument);
            this.getFixture().addRelation((Relation)corpDocRel);
            corpRelDSs.add(corpDocRel);
        }
        SCorpusGraphTest.assertTrue((boolean)corpRelDSs.containsAll(this.getFixture().getCorpusDocumentRelations()));
        SCorpusGraphTest.assertTrue((boolean)this.getFixture().getCorpusDocumentRelations().containsAll(corpRelDSs));
    }

    @Test
    public void testGetSCorpus__SId() {
        String[] ids = new String[]{"salt:/graph1#corp1", "salt:/graph1#corp2", "salt:/graph1#corp3", "salt:/graph1#corp4"};
        ArrayList<SCorpus> corpDSs = new ArrayList<SCorpus>();
        for (String id : ids) {
            SCorpus corpDs = SaltFactory.createSCorpus();
            corpDs.setId(id);
            this.getFixture().addNode((Node)corpDs);
            corpDSs.add(corpDs);
        }
        for (SCorpus corpus : corpDSs) {
            SCorpusGraphTest.assertEquals((Object)corpus, (Object)this.getFixture().getCorpus(corpus.getIdentifier()));
        }
    }

    @Test
    public void testGetDocument__SId() {
        String[] ids = new String[]{"salt:/graph1#doc1", "salt:/graph1#doc2", "salt:/graph1#doc3", "salt:/graph1#doc4"};
        ArrayList<SDocument> docDSs = new ArrayList<SDocument>();
        for (String id : ids) {
            SDocument docDs = SaltFactory.createSDocument();
            docDs.setId(id);
            this.getFixture().addNode((Node)docDs);
            docDSs.add(docDs);
        }
        for (SDocument corpus : docDSs) {
            SCorpusGraphTest.assertEquals((Object)corpus, (Object)this.getFixture().getDocument(corpus.getIdentifier()));
        }
    }

    @Test
    public void testAddSSubCorpus__SCorpus_SCorpus() {
        SCorpus superCorpus = null;
        SCorpus subCorpus = null;
        try {
            this.getFixture().addSubCorpus(superCorpus, subCorpus);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        superCorpus = SaltFactory.createSCorpus();
        try {
            this.getFixture().addSubCorpus(superCorpus, subCorpus);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        superCorpus = null;
        subCorpus = SaltFactory.createSCorpus();
        try {
            this.getFixture().addSubCorpus(superCorpus, subCorpus);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        superCorpus = SaltFactory.createSCorpus();
        try {
            this.getFixture().addSubCorpus(superCorpus, subCorpus);
            SCorpusGraphTest.fail((String)"An exception must be thrown, because the root corpus has not been inserted yet.");
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        superCorpus.setId("fakeId");
        try {
            this.getFixture().addSubCorpus(superCorpus, subCorpus);
            SCorpusGraphTest.fail((String)"An exception must be thrown, because the root corpus has not been inserted yet.");
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        this.getFixture().addNode((Node)superCorpus);
        SCorpusGraphTest.assertNotNull((Object)this.getFixture().addSubCorpus(superCorpus, subCorpus));
        List relations = this.getFixture().getOutRelations(superCorpus.getId());
        SCorpusGraphTest.assertNotNull((Object)relations);
        SCorpusGraphTest.assertTrue((relations.size() == 1 ? 1 : 0) != 0);
        SCorpusGraphTest.assertEquals((Object)subCorpus, (Object)((SRelation)relations.get(0)).getTarget());
        relations = this.getFixture().getInRelations(subCorpus.getId());
        SCorpusGraphTest.assertNotNull((Object)relations);
        SCorpusGraphTest.assertTrue((relations.size() == 1 ? 1 : 0) != 0);
        SCorpusGraphTest.assertEquals((Object)superCorpus, (Object)((SRelation)relations.get(0)).getSource());
    }

    @Test
    public void testAddSDocument__SCorpus_SDocument() {
        SCorpus corpus = null;
        SDocument document = null;
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        corpus = SaltFactory.createSCorpus();
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        corpus = null;
        document = SaltFactory.createSDocument();
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail();
        }
        catch (SaltParameterException saltParameterException) {
            // empty catch block
        }
        corpus = SaltFactory.createSCorpus();
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail((String)"An exception must be thrown, because the root corpus has not been inserted yet.");
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        corpus.setId("fakeId");
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail((String)"An exception must be thrown, because the root corpus has not been inserted yet.");
        }
        catch (SaltInsertionException saltInsertionException) {
            // empty catch block
        }
        try {
            this.getFixture().addDocument(corpus, document);
            SCorpusGraphTest.fail((String)"An exception must be thrown, because the corpus has not been inserted yet.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getFixture().addNode((Node)corpus);
        SCorpusGraphTest.assertNotNull((Object)this.getFixture().addDocument(corpus, document));
        List relations = this.getFixture().getOutRelations(corpus.getId());
        SCorpusGraphTest.assertNotNull((Object)relations);
        SCorpusGraphTest.assertTrue((relations.size() == 1 ? 1 : 0) != 0);
        SCorpusGraphTest.assertEquals((Object)document, (Object)((SRelation)relations.get(0)).getTarget());
        relations = this.getFixture().getInRelations(document.getId());
        SCorpusGraphTest.assertNotNull((Object)relations);
        SCorpusGraphTest.assertTrue((relations.size() == 1 ? 1 : 0) != 0);
        SCorpusGraphTest.assertEquals((Object)corpus, (Object)((SRelation)relations.get(0)).getSource());
    }

    @Test
    public void testGetSCorpus__SDocument() {
        this.getFixture().getCorpus((SDocument)null);
        SCorpus sCorpus = null;
        SCorpus sSubCorpus = null;
        SDocument sDocument = null;
        sCorpus = SaltFactory.createSCorpus();
        this.getFixture().addNode((Node)sCorpus);
        sDocument = SaltFactory.createSDocument();
        this.getFixture().addDocument(sCorpus, sDocument);
        SCorpusGraphTest.assertEquals((Object)sCorpus, (Object)this.getFixture().getCorpus(sDocument));
        sSubCorpus = SaltFactory.createSCorpus();
        this.getFixture().addSubCorpus(sCorpus, sSubCorpus);
        sDocument = SaltFactory.createSDocument();
        this.getFixture().addDocument(sSubCorpus, sDocument);
        SCorpusGraphTest.assertEquals((Object)sSubCorpus, (Object)this.getFixture().getCorpus(sDocument));
        SCorpusGraphTest.assertFalse((boolean)sCorpus.equals(this.getFixture().getCorpus(sDocument)));
    }

    @Test
    public void testGetSRootCorpus() {
        SCorpus sCorp1 = SaltFactory.createSCorpus();
        SCorpus sCorp2 = SaltFactory.createSCorpus();
        SCorpus sCorp3 = SaltFactory.createSCorpus();
        this.getFixture().addNode((Node)sCorp1);
        this.getFixture().addSubCorpus(sCorp1, sCorp2);
        this.getFixture().addSubCorpus(sCorp1, sCorp3);
        SCorpusGraphTest.assertTrue((boolean)this.getFixture().getRoots().contains(sCorp1));
        SCorpusGraphTest.assertEquals((int)1, (int)this.getFixture().getRoots().size());
    }

    @Test
    public void testCreateSCorpus_NoRoot() {
        List corpora = this.getFixture().createCorpus(URI.createURI((String)"corp1"));
        SCorpusGraphTest.assertNotNull((Object)corpora);
        SCorpusGraphTest.assertEquals((int)1, (int)corpora.size());
        SCorpusGraphTest.assertEquals((String)"corp1", (String)((SCorpus)corpora.get(0)).getName());
    }

    @Test
    public void testCreateSCorpus__SCorpus_String() {
        SCorpus sCorpus = SaltFactory.createSCorpus();
        this.getFixture().addNode((Node)sCorpus);
        SCorpus sCorp2 = this.getFixture().createCorpus(sCorpus, "corp2");
        SCorpusGraphTest.assertNotNull((Object)this.getFixture().getNode(sCorp2.getId()));
        SCorpusGraphTest.assertEquals((int)2, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)1, (int)this.getFixture().getRelations().size());
    }

    @Test
    public void testCreateSDocument__SCorpus_String() {
        SCorpus sCorpus = SaltFactory.createSCorpus();
        this.getFixture().addNode((Node)sCorpus);
        SDocument sDoc = this.getFixture().createDocument(sCorpus, "doc1");
        SCorpusGraphTest.assertNotNull((Object)this.getFixture().getNode(sDoc.getId()));
        SCorpusGraphTest.assertEquals((int)2, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)1, (int)this.getFixture().getRelations().size());
    }

    @Test
    public void testwhenCreatingCorporaViaURIWithoutScheme_thenShouldBeEqualToWithScheme() {
        URI path = URI.createURI((String)"/c1/c2/c3");
        List corpora = this.getFixture().createCorpus(path);
        SCorpusGraphTest.assertNotNull((Object)corpora);
        SCorpusGraphTest.assertEquals((int)3, (int)corpora.size());
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)2, (int)this.getFixture().getRelations().size());
        path = URI.createURI((String)"/c1/c2/c4");
        corpora = this.getFixture().createCorpus(path);
        SCorpusGraphTest.assertNotNull((Object)corpora);
        SCorpusGraphTest.assertEquals((int)1, (int)corpora.size());
        SCorpusGraphTest.assertEquals((int)4, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getRelations().size());
    }

    @Test
    public void testwhenCreatingTwoCorporaViaCorpusPathes_thenFourCorporaShouldExist() {
        URI path = URI.createURI((String)"salt:/c1/c2/c3");
        List corpora = this.getFixture().createCorpus(path);
        SCorpusGraphTest.assertNotNull((Object)corpora);
        SCorpusGraphTest.assertEquals((int)3, (int)corpora.size());
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)2, (int)this.getFixture().getRelations().size());
        path = URI.createURI((String)"salt:/c1/c2/c4");
        corpora = this.getFixture().createCorpus(path);
        SCorpusGraphTest.assertNotNull((Object)corpora);
        SCorpusGraphTest.assertEquals((int)1, (int)corpora.size());
        SCorpusGraphTest.assertEquals((int)4, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getRelations().size());
    }

    @Test
    public void testCreateSDocument__URI() {
        URI path = URI.createURI((String)"salt:/c1/c2/c3");
        SDocument sDoc = this.getFixture().createDocument(path);
        SCorpusGraphTest.assertNotNull((Object)sDoc);
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)2, (int)this.getFixture().getRelations().size());
        path = URI.createURI((String)"salt:/c1/c2/c4");
        sDoc = this.getFixture().createDocument(path);
        SCorpusGraphTest.assertNotNull((Object)sDoc);
        SCorpusGraphTest.assertEquals((int)4, (int)this.getFixture().getNodes().size());
        SCorpusGraphTest.assertEquals((int)3, (int)this.getFixture().getRelations().size());
    }

    @Test
    public void testCheckElementId() {
        SCorpus sCorpus = SaltFactory.createSCorpus();
        this.getFixture().addNode((Node)sCorpus);
        SCorpusGraphTest.assertEquals((String)"salt:/corp1", (String)sCorpus.getId());
        SDocument sDocument = SaltFactory.createSDocument();
        this.getFixture().addNode((Node)sDocument);
        SCorpusGraphTest.assertEquals((String)"salt:/doc1", (String)sDocument.getId());
    }

    @Test
    public void testGraphTraversion() {
        this.traversedNodes = new ArrayList<SNode>();
        this.createCorpusStructure(this.getFixture());
        this.getFixture().traverse(this.getFixture().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "", (GraphTraverseHandler)this);
        SCorpusGraphTest.assertTrue((String)("GraphTraversionTest: First traversed object is not null, but " + this.traversedNodes.get(0) + "!"), (this.traversedNodes.get(0) == null ? 1 : 0) != 0);
        SCorpusGraphTest.assertTrue((String)("GraphTraversionTest: Second traversed object is not the corpus, but " + this.traversedNodes.get(1) + "!"), (boolean)(this.traversedNodes.get(1) instanceof SCorpus));
        SCorpusGraphTest.assertTrue((String)("GraphTraversionTest: Third traversed object is not the corpus, but " + this.traversedNodes.get(2) + "!"), (boolean)(this.traversedNodes.get(2) instanceof SCorpus));
        SCorpusGraphTest.assertTrue((String)("GraphTraversionTest: Fourth traversed object is not the document, but " + this.traversedNodes.get(3) + "!"), (boolean)(this.traversedNodes.get(3) instanceof SDocument));
    }

    @Test
    private SDocument createCorpusStructure(SCorpusGraph corpGraph) {
        SCorpus corp1 = SaltFactory.createSCorpus();
        corp1.setName("corp1");
        corp1.setId("corp1");
        GraphFactory.createIdentifier((IdentifiableElement)corp1, (String)"corp1");
        corpGraph.addNode((Node)corp1);
        SDocument doc1 = SaltFactory.createSDocument();
        GraphFactory.createIdentifier((IdentifiableElement)doc1, (String)"doc1");
        doc1.setName("doc1");
        corpGraph.addNode((Node)doc1);
        doc1.setDocumentGraph(SaltFactory.createSDocumentGraph());
        SCorpusDocumentRelation corpDocRel1 = SaltFactory.createSCorpusDocumentRelation();
        GraphFactory.createIdentifier((IdentifiableElement)corpDocRel1, (String)"rel1");
        corpDocRel1.setName("rel1");
        corpDocRel1.setSource((Node)corp1);
        corpDocRel1.setTarget((Node)doc1);
        corpGraph.addRelation((Relation)corpDocRel1);
        return doc1;
    }

    @Test
    public void testwhenPrintingCorpusGraphToTreeString_thenTreeStringShouldBeReturned() {
        this.getFixture().createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.getFixture().createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.getFixture().createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.getFixture().createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        Assertions.assertThat((String)this.fixture.toTreeString()).isEqualTo((Object)"\u2514\u2500\u2500 corpus1\n    \u251c\u2500\u2500 corpus2\n    \u2502   \u251c\u2500\u2500 document1\n    \u2502   \u2514\u2500\u2500 document2\n    \u2514\u2500\u2500 corpus3\n        \u2514\u2500\u2500 corpus4\n            \u251c\u2500\u2500 document3\n            \u2514\u2500\u2500 document4\n");
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
        this.traversedNodes.add(fromNode);
        this.traversedNodes.add(currNode);
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        return true;
    }
}

