/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl.tests;

import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaltProjectImplTest {
    private SaltProject fixture = null;

    public SaltProject getFixture() {
        return this.fixture;
    }

    public void setFixture(SaltProject fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(SaltFactory.createSaltProject());
    }

    @Test
    public void testSetGetName() {
        Assert.assertNull((Object)this.getFixture().getName());
        String name = "myProject";
        this.getFixture().setName(name);
        Assert.assertEquals((Object)name, (Object)this.getFixture().getName());
    }

    @Test
    public void testAddGetCorpusGraph() {
        Assert.assertNotNull((Object)this.getFixture().getCorpusGraphs());
        Assert.assertEquals((long)0L, (long)this.getFixture().getCorpusGraphs().size());
        SCorpusGraph graph1 = SaltFactory.createSCorpusGraph();
        SCorpusGraph graph2 = SaltFactory.createSCorpusGraph();
        this.getFixture().addCorpusGraph(graph1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getCorpusGraphs().size());
        this.getFixture().addCorpusGraph(graph2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getCorpusGraphs().size());
    }

    @Test
    public void testRemoveCorpusGraph() {
        SCorpusGraph graph1 = SaltFactory.createSCorpusGraph();
        SCorpusGraph graph2 = SaltFactory.createSCorpusGraph();
        this.getFixture().addCorpusGraph(graph1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getCorpusGraphs().size());
        this.getFixture().addCorpusGraph(graph2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getCorpusGraphs().size());
        this.getFixture().removeCorpusGraph(graph1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getCorpusGraphs().size());
        this.getFixture().removeCorpusGraph(graph1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getCorpusGraphs().size());
        this.getFixture().removeCorpusGraph(graph2);
        Assert.assertEquals((long)0L, (long)this.getFixture().getCorpusGraphs().size());
    }

    @Test
    public void testCorpusGraph_DoubleChaining() {
        SCorpusGraph graph1 = SaltFactory.createSCorpusGraph();
        SCorpusGraph graph2 = SaltFactory.createSCorpusGraph();
        Assert.assertNull((Object)graph1.getSaltProject());
        this.getFixture().addCorpusGraph(graph1);
        Assert.assertEquals((Object)this.getFixture(), (Object)graph1.getSaltProject());
        this.getFixture().addCorpusGraph(graph2);
        Assert.assertEquals((Object)this.getFixture(), (Object)graph2.getSaltProject());
        this.getFixture().removeCorpusGraph(graph1);
        Assert.assertNull((Object)graph1.getSaltProject());
        Assert.assertEquals((Object)this.getFixture(), (Object)graph2.getSaltProject());
        this.getFixture().removeCorpusGraph(graph2);
        Assert.assertNull((Object)graph2.getSaltProject());
    }

    @Test
    public void testCreateCorpusGraph() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getCorpusGraphs().size());
        Assert.assertNotNull((Object)this.getFixture().createCorpusGraph());
        Assert.assertEquals((long)1L, (long)this.getFixture().getCorpusGraphs().size());
    }
}

