/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.tokenizer.tests;

import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.tokenizer.SimpleTokenizer;
import org.corpus_tools.salt.core.SNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleTokenizerTest {
    private SimpleTokenizer fixture = null;

    public void setFixture(SimpleTokenizer fixture) {
        this.fixture = fixture;
    }

    public SimpleTokenizer getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() {
        this.setFixture(new SimpleTokenizer());
    }

    @Test
    public void testTokenize_ByBlanks1() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("This is a test text.");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, new Character[]{Character.valueOf(' ')});
        Assert.assertEquals((long)5L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"This", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(3)));
        Assert.assertEquals((Object)"text.", (Object)docGraph.getText((SNode)docGraph.getTokens().get(4)));
    }

    @Test
    public void testTokenize_ByBlanks2() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("    This   is   a test  text.  ");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, new Character[]{Character.valueOf(' ')});
        Assert.assertEquals((long)5L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"This", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(3)));
        Assert.assertEquals((Object)"text.", (Object)docGraph.getText((SNode)docGraph.getTokens().get(4)));
    }

    @Test
    public void testTokenize_ByBlanksAndPunc() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("    This   is   a test  text.  ");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, new Character[]{Character.valueOf(' '), Character.valueOf('.')});
        Assert.assertEquals((long)5L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"This", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(3)));
        Assert.assertEquals((Object)"text", (Object)docGraph.getText((SNode)docGraph.getTokens().get(4)));
    }

    @Test
    public void testTokenize_SubstringMiddle() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("This is a test text.");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, Integer.valueOf(4), Integer.valueOf(14), new Character[]{Character.valueOf(' '), Character.valueOf('.')});
        Assert.assertEquals((long)3L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
    }

    @Test
    public void testTokenize_SubstringFront() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("This is a test text.");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, Integer.valueOf(0), Integer.valueOf(14), new Character[]{Character.valueOf(' '), Character.valueOf('.')});
        Assert.assertEquals((long)4L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"This", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(3)));
    }

    @Test
    public void testTokenize_SubstringEnd() {
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        STextualDS primText = docGraph.createTextualDS("This is a test text.");
        this.getFixture().setDocumentGraph(docGraph);
        this.getFixture().tokenize(primText, Integer.valueOf(4), Integer.valueOf(20), new Character[]{Character.valueOf(' '), Character.valueOf('.')});
        Assert.assertEquals((long)4L, (long)docGraph.getTokens().size());
        Assert.assertEquals((Object)"is", (Object)docGraph.getText((SNode)docGraph.getTokens().get(0)));
        Assert.assertEquals((Object)"a", (Object)docGraph.getText((SNode)docGraph.getTokens().get(1)));
        Assert.assertEquals((Object)"test", (Object)docGraph.getText((SNode)docGraph.getTokens().get(2)));
        Assert.assertEquals((Object)"text", (Object)docGraph.getText((SNode)docGraph.getTokens().get(3)));
    }
}

