/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl.tests;

import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.core.impl.GraphTraverserModule;
import org.corpus_tools.salt.core.impl.tests.TestHelper;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GraphTraverserModuleTest {
    private GraphTraverserModule fixture = null;

    public void setFixture(GraphTraverserModule fixture) {
        this.fixture = fixture;
    }

    public GraphTraverserModule getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() {
        this.setFixture(new GraphTraverserModule());
    }

    @Test
    public void testTraverseParameters() {
        ArrayList<SNode> startNodes = null;
        SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        TraverserChecker handler = null;
        startNodes = null;
        traverseType = SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST;
        handler = new TraverserChecker();
        try {
            this.getFixture().traverse(startNodes, traverseType, "test_TOP_DOWN_DEPTH_FIRST_Tree", (GraphTraverseHandler)handler);
            Assert.fail((String)"null parameters are not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        startNodes = new ArrayList<SNode>();
        startNodes.add(SaltFactory.createSNode());
        traverseType = null;
        handler = new TraverserChecker();
        try {
            this.getFixture().traverse(startNodes, traverseType, "test_TOP_DOWN_DEPTH_FIRST_Tree", (GraphTraverseHandler)handler);
            Assert.fail((String)"null parameters are not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        startNodes = new ArrayList();
        startNodes.add(SaltFactory.createSNode());
        traverseType = SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST;
        handler = null;
        try {
            this.getFixture().traverse(startNodes, traverseType, "test_TOP_DOWN_DEPTH_FIRST_Tree", (GraphTraverseHandler)handler);
            Assert.fail((String)"null parameters are not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetRoots() {
        ArrayList<Node> expectedRoots = null;
        List roots = null;
        SGraph graph = null;
        graph = TestHelper.createGraph_Tree();
        this.getFixture().setGraph(graph);
        expectedRoots = new ArrayList<Node>();
        expectedRoots.add(graph.getNode("node1"));
        roots = this.getFixture().getGraph().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (Node expectedRoot : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + expectedRoot.getId() + "'."), (boolean)roots.contains(expectedRoot));
        }
        graph = TestHelper.createGraph_DAG();
        this.getFixture().setGraph(graph);
        expectedRoots = new ArrayList();
        expectedRoots.add(graph.getNode("node1"));
        expectedRoots.add(graph.getNode("node4"));
        roots = this.getFixture().getGraph().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (Node expectedRoot : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + expectedRoot.getId() + "'."), (boolean)roots.contains(expectedRoot));
        }
        graph = TestHelper.createGraph_Cycle();
        this.getFixture().setGraph(graph);
        expectedRoots = new ArrayList();
        expectedRoots.add(graph.getNode("node1"));
        expectedRoots.add(graph.getNode("node4"));
        roots = this.getFixture().getGraph().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (Node expectedRoot : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + expectedRoot.getId() + "'."), (boolean)roots.contains(expectedRoot));
        }
    }

    @Test
    public void testGetLeafs() {
        ArrayList<Node> expectedLeafs = null;
        List leafs = null;
        SGraph graph = null;
        graph = TestHelper.createGraph_Tree();
        this.getFixture().setGraph(graph);
        expectedLeafs = new ArrayList<Node>();
        expectedLeafs.add(graph.getNode("node3"));
        expectedLeafs.add(graph.getNode("node6"));
        expectedLeafs.add(graph.getNode("node5"));
        expectedLeafs.add(graph.getNode("node7"));
        leafs = this.getFixture().getGraph().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (Node expectedLeaf : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected leaf '" + expectedLeaf.getId() + "'."), (boolean)leafs.contains(expectedLeaf));
        }
        graph = TestHelper.createGraph_DAG();
        this.getFixture().setGraph(graph);
        expectedLeafs = new ArrayList();
        expectedLeafs.add(graph.getNode("node3"));
        expectedLeafs.add(graph.getNode("node6"));
        leafs = this.getFixture().getGraph().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (Node expectedLeaf : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned leafs does not contain expected leaf '" + expectedLeaf.getId() + "'."), (boolean)leafs.contains(expectedLeaf));
        }
        graph = TestHelper.createGraph_Cycle();
        this.getFixture().setGraph(graph);
        expectedLeafs = new ArrayList();
        expectedLeafs.add(graph.getNode("node3"));
        leafs = this.getFixture().getGraph().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (Node expectedLeaf : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected leaf '" + expectedLeaf.getId() + "'."), (boolean)leafs.contains(expectedLeaf));
        }
    }

    @Test
    public void testThreading_TOP_DOWN_DEPTH_FIRST() throws Exception {
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        List startNodes = null;
        SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        String traverseId = null;
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        startNodes = this.getFixture().getGraph().getRoots();
        traverseType = SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST;
        TraverserChecker traverseChecker1 = null;
        TraverserChecker traverseChecker2 = null;
        TraverserChecker traverseChecker3 = null;
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node4", "node5", "node7"};
        String[] nodeOrderWayBack = new String[]{"node3", "node6", "node2", "node5", "node4", "node7", "node1"};
        traverseId = "testThreading_1";
        traverseChecker1 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker1, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker1, nodeOrderWayBack);
        traverseChecker1.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_2";
        traverseChecker2 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker2, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker2, nodeOrderWayBack);
        traverseChecker2.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_3";
        traverseChecker3 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker3, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker3, nodeOrderWayBack);
        traverseChecker3.start(startNodes, traverseType, traverseId);
        while (traverseChecker1.runs < 1 || traverseChecker2.runs < 1 || traverseChecker3.runs < 1) {
            Thread.sleep(100L);
        }
        ArrayList<TraverserChecker> traverseCheckers = new ArrayList<TraverserChecker>();
        traverseCheckers.add(traverseChecker1);
        traverseCheckers.add(traverseChecker2);
        traverseCheckers.add(traverseChecker3);
        for (TraverserChecker traverseChecker : traverseCheckers) {
            if (traverseChecker.exception == null) continue;
            throw traverseChecker.exception;
        }
    }

    @Test
    public void testThreading_TOP_DOWN_BREADTH_FIRST() throws Exception {
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        List startNodes = null;
        SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        String traverseId = null;
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        startNodes = this.getFixture().getGraph().getRoots();
        traverseType = SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST;
        TraverserChecker traverseChecker1 = null;
        TraverserChecker traverseChecker2 = null;
        TraverserChecker traverseChecker3 = null;
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node4", "node7", "node3", "node6", "node5"};
        String[] nodeOrderWayBack = new String[]{"node1", "node2", "node4", "node7", "node3", "node6", "node5"};
        traverseId = "testThreading_1";
        traverseChecker1 = new TraverserChecker();
        traverseChecker1.isCycleSafe = false;
        TraverserChecker.access$002(traverseChecker1, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker1, nodeOrderWayBack);
        traverseChecker1.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_2";
        traverseChecker2 = new TraverserChecker();
        traverseChecker2.isCycleSafe = false;
        TraverserChecker.access$002(traverseChecker2, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker2, nodeOrderWayBack);
        traverseChecker2.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_3";
        traverseChecker3 = new TraverserChecker();
        traverseChecker3.isCycleSafe = false;
        TraverserChecker.access$002(traverseChecker3, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker3, nodeOrderWayBack);
        traverseChecker3.start(startNodes, traverseType, traverseId);
        traverseChecker3.traverseThread.join();
        traverseChecker2.traverseThread.join();
        traverseChecker1.traverseThread.join();
        ArrayList<TraverserChecker> traverseCheckers = new ArrayList<TraverserChecker>();
        traverseCheckers.add(traverseChecker1);
        traverseCheckers.add(traverseChecker2);
        traverseCheckers.add(traverseChecker3);
        for (TraverserChecker traverseChecker : traverseCheckers) {
            if (traverseChecker.exception == null) continue;
            throw traverseChecker.exception;
        }
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_Tree() {
        SGraph graph = TestHelper.createGraph_Tree();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node4", "node5", "node7"};
        String[] nodeOrderWayBack = new String[]{"node3", "node6", "node2", "node5", "node4", "node7", "node1"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_Tree", (GraphTraverseHandler)checker);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_DAG() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node4", "node2", "node3", "node6"};
        String[] nodeOrderWayBack = new String[]{"node3", "node6", "node2", "node1", "node3", "node6", "node2", "node4"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_DAG", (GraphTraverseHandler)checker);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_Cycle() throws Exception {
        SGraph graph = TestHelper.createGraph_Cycle();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node7", "node2", "node6", "node7", "node2"};
        String[] nodeOrderWayBack = new String[]{"node3", "node6", "node2", "node1", "node3", "node6", "node2", "node4"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        try {
            this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_Cycle", (GraphTraverseHandler)checker);
            Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
            Assert.fail((String)"The graph contains a cycle, that shall invoke an exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_CycleUnsafe() {
        SGraph graph = TestHelper.createGraph_SimpleCycle();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node7", "node2", "node3", "node6", "node7"};
        String[] nodeOrderWayBack = new String[]{"node3", "node3", "node7", "node6", "node2", "node7", "node6", "node2", "node1"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        checker.isCycleSafe = false;
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_Cycle", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_DEPTH_FIRST_Tree() {
        SGraph graph = TestHelper.createGraph_Tree();
        String[] nodeOrderWayThere = new String[]{"node3", "node2", "node1", "node5", "node4", "node1", "node6", "node2", "node1", "node7", "node1"};
        String[] nodeOrderWayBack = new String[]{"node1", "node2", "node3", "node1", "node4", "node5", "node1", "node2", "node6", "node1", "node7"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, "test_BOTTOM_UP_DEPTH_FIRST_Tree", (GraphTraverseHandler)checker);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_DEPTH_FIRST_DAG() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node3", "node2", "node1", "node4", "node6", "node2", "node1", "node4"};
        String[] nodeOrderWayBack = new String[]{"node1", "node4", "node2", "node3", "node1", "node4", "node2", "node6"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, "test_BOTTOM_UP_DEPTH_FIRST_DAG", (GraphTraverseHandler)checker);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_DEPTH_FIRST_Cycle() {
        SGraph graph = TestHelper.createGraph_Cycle();
        String[] nodeOrderWayThere = new String[]{"node3", "node2", "node1", "node4", "node7", "node6", "node2", "node1", "node4"};
        String[] nodeOrderWayBack = new String[]{"node1", "node4", "node2", "node3", "node1", "node4", "node2", "node6"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        try {
            this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, "test_BOTTOM_UP_DEPTH_FIRST_Cycle", (GraphTraverseHandler)checker);
            Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
            Assert.fail((String)"The graph contains a cycle, that shall invoke an exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testThreading_BOTTOM_UP_DEPTH_FIRST() throws Exception {
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        List startNodes = null;
        SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        String traverseId = null;
        this.getFixture().setGraph(TestHelper.createGraph_Tree());
        startNodes = this.getFixture().getGraph().getLeafs();
        traverseType = SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST;
        TraverserChecker traverseChecker1 = null;
        TraverserChecker traverseChecker2 = null;
        TraverserChecker traverseChecker3 = null;
        String[] nodeOrderWayThere = new String[]{"node3", "node2", "node1", "node5", "node4", "node1", "node6", "node2", "node1", "node7", "node1"};
        String[] nodeOrderWayBack = new String[]{"node1", "node2", "node3", "node1", "node4", "node5", "node1", "node2", "node6", "node1", "node7"};
        traverseId = "testThreading_1";
        traverseChecker1 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker1, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker1, nodeOrderWayBack);
        traverseChecker1.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_2";
        traverseChecker2 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker2, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker2, nodeOrderWayBack);
        traverseChecker2.start(startNodes, traverseType, traverseId);
        traverseId = "testThreading_3";
        traverseChecker3 = new TraverserChecker();
        TraverserChecker.access$002(traverseChecker3, nodeOrderWayThere);
        TraverserChecker.access$102(traverseChecker3, nodeOrderWayBack);
        traverseChecker3.start(startNodes, traverseType, traverseId);
        while (traverseChecker1.runs < 1 || traverseChecker2.runs < 1 || traverseChecker3.runs < 1) {
            Thread.sleep(100L);
        }
        ArrayList<TraverserChecker> traverseCheckers = new ArrayList<TraverserChecker>();
        traverseCheckers.add(traverseChecker1);
        traverseCheckers.add(traverseChecker2);
        traverseCheckers.add(traverseChecker3);
        for (TraverserChecker traverseChecker : traverseCheckers) {
            if (traverseChecker.exception == null) continue;
            throw traverseChecker.exception;
        }
        for (TraverserChecker checker : traverseCheckers) {
            Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
        }
    }

    @Test
    public void testTraverse_TOP_DOWN_BREADTH_FIRST_Tree() {
        SGraph graph = TestHelper.createGraph_Tree();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node4", "node7", "node3", "node6", "node5"};
        String[] nodeOrderWayBack = new String[]{"node1", "node2", "node4", "node7", "node3", "node6", "node5"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST, "test_TOP_DOWN_BREADTH_FIRST_Tree", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_BREADTH_FIRST_DAG() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node1", "node4", "node2", "node2", "node3", "node6", "node3", "node6"};
        String[] nodeOrderWayBack = new String[]{"node1", "node4", "node2", "node2", "node3", "node6", "node3", "node6"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST, "test_TOP_DOWN_BREADTH_FIRST_DAG", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_BREADTH_FIRST_DAG_NON_ROOT_START() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node2", "node3", "node6"};
        String[] nodeOrderWayBack = new String[]{"node2", "node3", "node6"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(this.getFixture().getGraph().getNode("node2"));
        this.getFixture().traverse(startNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST, "test_TOP_DOWN_BREADTH_FIRST_DAG", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_DAG_NON_ROOT_START() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node2", "node3", "node6"};
        String[] nodeOrderWayBack = new String[]{"node3", "node6", "node2"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        ArrayList<Node> startNode = new ArrayList<Node>();
        startNode.add(this.getFixture().getGraph().getNode("node2"));
        this.getFixture().traverse(startNode, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_DAG_NON_ROOT_START", (GraphTraverseHandler)checker);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_TOP_DOWN_DEPTH_FIRST_NO_REAL_CYCLES() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("graph1");
        SNode node1 = SaltFactory.createSNode();
        graph.addNode((Node)node1);
        SNode node2 = SaltFactory.createSNode();
        graph.addNode((Node)node2);
        SNode node3 = SaltFactory.createSNode();
        graph.addNode((Node)node3);
        SRelation edge1 = SaltFactory.createSRelation();
        edge1.setSource((Node)node1);
        edge1.setTarget((Node)node2);
        graph.addRelation((Relation)edge1);
        SRelation edge2 = SaltFactory.createSRelation();
        edge2.setSource((Node)node2);
        edge2.setTarget((Node)node3);
        graph.addRelation((Relation)edge2);
        SRelation edge3 = SaltFactory.createSRelation();
        edge3.setSource((Node)node3);
        edge3.setTarget((Node)node2);
        Label label = GraphFactory.createLabel();
        label.setName("name");
        label.setValue((Object)"notCheck");
        edge3.addLabel(label);
        graph.addRelation((Relation)edge3);
        GraphTraverseHandler graphTraverseHandler = new GraphTraverseHandler(){

            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation<SNode, SNode> relation, SNode currNode, long order) {
                return relation == null || relation.getLabel("name") == null || !relation.getLabel("name").getValue().equals("notCheck");
            }
        };
        this.getFixture().setGraph(graph);
        ArrayList<SNode> startNode = new ArrayList<SNode>();
        startNode.add(node1);
        this.getFixture().traverse(startNode, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "test_TOP_DOWN_DEPTH_FIRST_NO_REAL_CYCLES", graphTraverseHandler);
    }

    @Test
    public void testTraverse_TOP_DOWN_BREADTH_FIRST_CycleUnsafe() {
        SGraph graph = TestHelper.createGraph_SimpleCycle();
        String[] nodeOrderWayThere = new String[]{"node1", "node2", "node3", "node6", "node7", "node2", "node3", "node6", "node7"};
        String[] nodeOrderWayBack = (String[])nodeOrderWayThere.clone();
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        checker.isCycleSafe = false;
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST, "test_TOP_DOWN_BREADTH_FIRST_Cycle", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_BREADTH_FIRST_Tree() {
        SGraph graph = TestHelper.createGraph_Tree();
        String[] nodeOrderWayThere = new String[]{"node3", "node5", "node6", "node7", "node2", "node4", "node2", "node1", "node1", "node1", "node1"};
        String[] nodeOrderWayBack = (String[])nodeOrderWayThere.clone();
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, "test_BOTTOM_UP_BREADTH_FIRST_Tree", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_BREADTH_FIRST_DAG() {
        SGraph graph = TestHelper.createGraph_DAG();
        String[] nodeOrderWayThere = new String[]{"node3", "node6", "node2", "node2", "node1", "node4", "node1", "node4"};
        String[] nodeOrderWayBack = (String[])nodeOrderWayThere.clone();
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, "test_BOTTOM_UP_BREADTH_FIRST_DAG", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    @Test
    public void testTraverse_BOTTOM_UP_BREADTH_FIRST_Cycle() {
        SGraph graph = TestHelper.createGraph_Cycle();
        String[] nodeOrderWayThere = new String[]{"node3", "node2", "node1", "node4"};
        String[] nodeOrderWayBack = new String[]{"node3", "node2", "node1", "node4"};
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        this.getFixture().setGraph(graph);
        try {
            this.getFixture().traverse(this.getFixture().getGraph().getLeafs(), SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, "test_BOTTOM_UP_BREADTH_FIRST_Cycle", (GraphTraverseHandler)checker);
            Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
            Assert.fail((String)"The graph contains a cycle, that shall invoke an exception.");
        }
        catch (SaltException saltException) {
            // empty catch block
        }
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(graph.getNode("node3"));
        startNodes.add(graph.getNode("node7"));
        String[] nodeOrderWayThere2 = new String[]{"node3", "node7", "node2", "node6", "node1", "node4", "node7"};
        String[] nodeOrderWayBack2 = new String[]{"node3", "node7", "node2", "node6", "node1", "node4", "node7"};
        TraverserChecker checker2 = new TraverserChecker();
        TraverserChecker.access$002(checker2, nodeOrderWayThere2);
        TraverserChecker.access$102(checker2, nodeOrderWayBack2);
        this.getFixture().setGraph(graph);
        this.getFixture().setGraph(graph);
        try {
            this.getFixture().traverse(startNodes, SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, "test_BOTTOM_UP_BREADTH_FIRST_Cycle", (GraphTraverseHandler)checker2);
            Assert.assertTrue((boolean)checker2.checkNumberOfTraversedNodes());
            Assert.fail((String)"The graph contains a cycle, that shall invoke an exception.");
        }
        catch (SaltException saltException) {
            // empty catch block
        }
    }

    @Test
    public void testTraverse_BOTTOM_UP_BREADTH_FIRST_CycleUnsafe() {
        SGraph graph = TestHelper.createGraph_SimpleCycle();
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(graph.getNode("node3"));
        startNodes.add(graph.getNode("node7"));
        String[] nodeOrderWayThere = new String[]{"node3", "node7", "node2", "node6", "node1", "node7", "node2", "node6", "node1"};
        String[] nodeOrderWayBack = (String[])nodeOrderWayThere.clone();
        TraverserChecker checker = new TraverserChecker();
        TraverserChecker.access$002(checker, nodeOrderWayThere);
        TraverserChecker.access$102(checker, nodeOrderWayBack);
        checker.isCycleSafe = false;
        this.getFixture().setGraph(graph);
        this.getFixture().traverse(startNodes, SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, "test_BOTTOM_UP_BREADTH_FIRST_Cycle", (GraphTraverseHandler)checker, false);
        Assert.assertTrue((boolean)checker.checkNumberOfTraversedNodes());
    }

    class TraverserChecker
    implements GraphTraverseHandler,
    Runnable {
        public boolean isCycleSafe = true;
        private String[] nodeOrderWayThere;
        private int posInWayThere = 0;
        private String[] nodeOrderWayBack;
        private int posInWayBack = 0;
        private List<SNode> currentPath = new ArrayList<SNode>();
        private List<SNode> startNodes = null;
        private SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        private String traverseId = null;
        private Exception exception = null;
        public int runs = 0;
        Thread traverseThread;

        TraverserChecker() {
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> rel, SNode fromNode, long order) {
            this.currentPath.add(currNode);
            if (!currNode.getId().equalsIgnoreCase(this.nodeOrderWayThere[this.posInWayThere])) {
                String path = null;
                for (String nodeName : this.nodeOrderWayThere) {
                    path = path == null ? nodeName : path + "->" + nodeName;
                }
                throw new RuntimeException("Test fails, another way than expected has been traversed on way there. Expected way was '" + path + "', but instead of node '" + this.nodeOrderWayThere[this.posInWayThere] + "' at position '" + this.posInWayThere + "', node '" + currNode.getId() + "' was found.");
            }
            ++this.posInWayThere;
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> rel, SNode fromNode, long order) {
            if (SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST == traversalType || SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST == traversalType) {
                this.currentPath.remove(this.currentPath.size() - 1);
            }
            if (!currNode.getId().equalsIgnoreCase(this.nodeOrderWayBack[this.posInWayBack])) {
                String path = null;
                for (String nodeName : this.nodeOrderWayBack) {
                    path = path == null ? nodeName : path + "->" + nodeName;
                }
                throw new RuntimeException("Test fails, another way than expected has been traversed on way back. Expected way was '" + path + "', but instead of node '" + this.nodeOrderWayBack[this.posInWayBack] + "' at position '" + (this.posInWayBack + 1) + "', node '" + currNode.getId() + "' was found.");
            }
            ++this.posInWayBack;
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation<SNode, SNode> rel, SNode currNode, long order) {
            boolean retVal = true;
            if (!this.isCycleSafe) {
                Integer numOfOccurences = 0;
                for (int i = 0; i < this.currentPath.size(); ++i) {
                    if (!this.currentPath.get(i).equals(currNode)) continue;
                    Integer n = numOfOccurences;
                    Integer n2 = numOfOccurences = Integer.valueOf(numOfOccurences + 1);
                }
                if (numOfOccurences >= 2) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public boolean checkNumberOfTraversedNodes() {
            return this.posInWayThere == this.nodeOrderWayThere.length && this.posInWayBack == this.nodeOrderWayBack.length;
        }

        public void start(List<SNode> startNodes, SGraph.GRAPH_TRAVERSE_TYPE traverseType, String traverseId) {
            this.startNodes = startNodes;
            this.traverseType = traverseType;
            this.traverseId = traverseId;
            this.traverseThread = new Thread((Runnable)this, "traverse_" + traverseId);
            this.traverseThread.start();
        }

        @Override
        public void run() {
            try {
                GraphTraverserModuleTest.this.getFixture().traverse(this.startNodes, this.traverseType, this.traverseId, (GraphTraverseHandler)this, this.isCycleSafe);
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                ++this.runs;
            }
        }

        static /* synthetic */ String[] access$002(TraverserChecker x0, String[] x1) {
            x0.nodeOrderWayThere = x1;
            return x1;
        }

        static /* synthetic */ String[] access$102(TraverserChecker x0, String[] x1) {
            x0.nodeOrderWayBack = x1;
            return x1;
        }
    }
}

