/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import java.util.ArrayList;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerTest {
    private Layer<Node, Relation<Node, Node>> fixture = null;

    @Before
    public void setUp() throws Exception {
        this.setFixture(this.createLayer());
    }

    public Layer<Node, Relation<Node, Node>> getFixture() {
        return this.fixture;
    }

    public void setFixture(Layer<Node, Relation<Node, Node>> fixture) {
        this.fixture = fixture;
    }

    protected Layer<Node, Relation<Node, Node>> createLayer() {
        return GraphFactory.createLayer();
    }

    protected Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> createGraph() {
        return GraphFactory.createGraph();
    }

    protected Node createNode() {
        return GraphFactory.createNode();
    }

    protected Relation createRelation() {
        return GraphFactory.createRelation();
    }

    @Test
    public void testSetGetGraph() {
        Assert.assertNull((Object)this.getFixture().getGraph());
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        this.getFixture().setGraph(graph);
        Assert.assertEquals((Object)this.getFixture().getGraph(), graph);
        this.getFixture().setGraph(null);
        Assert.assertNull((Object)this.getFixture().getGraph());
        Assert.assertEquals((long)0L, (long)graph.getLayers().size());
    }

    @Test
    public void testDoubleChaining() {
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        this.getFixture().setGraph(graph);
        Assert.assertTrue((String)("only contains " + graph.getLayers()), (boolean)graph.getLayers().contains(this.getFixture()));
    }

    @Test
    public void testGetId() {
        String id = null;
        id = "id";
        this.getFixture().setId(id);
        Assert.assertEquals((Object)id, (Object)this.getFixture().getId());
    }

    @Test
    public void testGetNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = this.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
        }
        Assert.assertEquals((long)nodes.size(), (long)this.getFixture().getNodes().size());
        for (Node node : nodes) {
            Assert.assertTrue((boolean)this.getFixture().getNodes().contains(node));
        }
    }

    @Test
    public void testAddNode() {
        try {
            this.getFixture().getNodes().add(this.createNode());
            Assert.fail((String)"Should not add a node in layer's node list directly.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRelation() {
        try {
            this.getFixture().getRelations().add(this.createRelation());
            Assert.fail((String)"Should not add a node in layer's node list directly.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleChainingAddNode() {
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        graph.addLayer(this.getFixture());
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = this.createNode();
            nodes.add(node);
            graph.addNode(node);
            this.getFixture().addNode(node);
        }
        Assert.assertEquals((long)nodes.size(), (long)this.getFixture().getNodes().size());
        for (Node node : nodes) {
            Assert.assertTrue((boolean)node.getLayers().contains(this.getFixture()));
        }
    }

    @Test
    public void testDoubleChainingRemoveNode() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < 50; ++i) {
            Node node = this.createNode();
            nodes.add(node);
            this.getFixture().addNode(node);
        }
        Assert.assertEquals((long)nodes.size(), (long)this.getFixture().getNodes().size());
        for (Node node : nodes) {
            node.removeLayer(this.getFixture());
        }
        Assert.assertEquals((long)0L, (long)this.getFixture().getNodes().size());
    }

    @Test
    public void testGetRelations() {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Node node = this.createNode();
        for (int i = 0; i < 50; ++i) {
            Relation relation = this.createRelation();
            relation.setSource(node);
            relation.setTarget(node);
            relations.add(relation);
            this.getFixture().addRelation(relation);
        }
        Assert.assertEquals((long)relations.size(), (long)this.getFixture().getRelations().size());
        for (Relation relation : relations) {
            Assert.assertTrue((boolean)this.getFixture().getRelations().contains(relation));
        }
    }
}

