/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.corpus_tools.salt.exceptions.SaltResourceException;

public class SaltTestsUtil {
    public static final String FILE_RESOURCE_DIR = "./src/test/resources/";

    public static synchronized File getTempTestFolder(String segments) {
        File file = null;
        file = segments == null ? SaltTestsUtil.getTempTestFolder() : new File(SaltTestsUtil.getTempTestFolder().getAbsolutePath() + (segments.startsWith("/") ? segments : "/" + segments));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static synchronized File getTempTestFolder() {
        String usr = System.getProperty("user.name");
        String path = null;
        if (usr != null && !usr.isEmpty()) {
            path = System.getProperty("java.io.tmpdir");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + "salt-test_" + usr + "/";
        } else {
            try {
                path = Files.createTempDirectory("salt-test_", new FileAttribute[0]).toFile().getAbsolutePath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
            }
            catch (IOException e) {
                throw new SaltResourceException("Cannot create temporary folder at " + System.getProperty("java.io.tmpdir") + ". ");
            }
        }
        File file = null;
        file = new File(path);
        return file;
    }
}

