/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import org.assertj.core.api.Assertions;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.CorpusStructureDiff;
import org.eclipse.emf.common.util.URI;
import org.junit.Before;
import org.junit.Test;

public class CorpusStructureDiffTest {
    private CorpusStructureDiff fixture;
    private SCorpusGraph template;
    private SCorpusGraph other;
    private DiffOptions options;

    @Before
    public void beforeEach() {
        this.template = SaltFactory.createSCorpusGraph();
        this.other = SaltFactory.createSCorpusGraph();
        this.options = new DiffOptions();
        this.fixture = new CorpusStructureDiff(this.template, this.other, this.options);
    }

    @Test
    public void whenTwoCorpusStructuresAreIdentical_thenTheyAreIsomorphAndHaveNoDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isTrue();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).isEmpty();
    }

    @Test
    public void whenTwoCorpusStructuresWithDocumentsAreIdentical_thenTheyAreIsomorphAndHaveNoDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1")).createDocumentGraph();
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2")).createDocumentGraph().createTextualDS("sample text");
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3")).createDocumentGraph();
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4")).createDocumentGraph().createTextualDS("sample text");
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1")).createDocumentGraph();
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2")).createDocumentGraph().createTextualDS("sample text");
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3")).createDocumentGraph();
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4")).createDocumentGraph().createTextualDS("sample text");
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isTrue();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).isEmpty();
    }

    @Test
    public void whenTwoCorpusStructuresAreIdenticalButDocumentStructuresDont_thenTheyAreNotIsomorphAndHaveDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1")).createDocumentGraph();
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2")).createDocumentGraph().createTextualDS("sample text");
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3")).createDocumentGraph();
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4")).createDocumentGraph().createTextualDS("sample text");
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1")).createDocumentGraph().createTextualDS("sample text");
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2")).createDocumentGraph();
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3")).createDocumentGraph().createTextualDS("sample text");
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4")).createDocumentGraph();
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isFalse();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).hasSize(4);
    }

    @Test
    public void whenTwoCorpusStructuresAreNotIdentical_thenTheyAreNotIsomorphAndHaveDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document5"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isFalse();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).hasSize(1);
    }

    @Test
    public void whenTwoCorpusStructuresWithMultipleRootsAreIdentical_thenTheyAreIsomorphAndHaveNoDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        this.template.createDocument(URI.createURI((String)"/corpus4/corpus5/document5"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        this.other.createDocument(URI.createURI((String)"/corpus4/corpus5/document5"));
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isTrue();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).isEmpty();
    }

    @Test
    public void whenComparingOneCorpusStructureWithMultipleRootsAndOneWithout_thenTheyAreNotIsomorphAndHaveDifferences() {
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.template.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        this.template.createDocument(URI.createURI((String)"/corpus4/corpus5/document5"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document1"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus2/document2"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document3"));
        this.other.createDocument(URI.createURI((String)"/corpus1/corpus3/corpus4/document4"));
        Assertions.assertThat((boolean)SaltUtil.compare((Object)this.template).with((Object)this.other).andCheckIsomorphie()).isFalse();
        Assertions.assertThat((Iterable)SaltUtil.compare((Object)this.template).with((Object)this.other).andFindDiffs()).hasSize(3);
    }
}

