/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.internal.DocumentStructureDiff;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentStructureDiffTest {
    protected DocumentStructureDiff fixture = null;
    private SDocumentGraph template = null;
    private SDocumentGraph other = null;

    protected void setFixture(DocumentStructureDiff fixture) {
        this.fixture = fixture;
    }

    protected DocumentStructureDiff getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.template = SaltFactory.createSDocumentGraph();
        this.template.setDocument(SaltFactory.createSDocument());
        this.template.getDocument().setId("doc1");
        this.template.getDocument().getDocumentGraph().setId("doc1");
        this.other = SaltFactory.createSDocumentGraph();
        this.other.setDocument(SaltFactory.createSDocument());
        this.other.getDocument().setId("doc2");
        this.other.getDocument().getDocumentGraph().setId("doc2");
        this.setFixture(new DocumentStructureDiff(this.template, this.other));
    }

    @Test
    public void testSize() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(1), Integer.valueOf(20));
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testTextualDS_iso() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        STextualDS otherText = SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        otherText.setText("a template text");
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testTextualDS_diff() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        STextualDS otherText = SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        otherText.setText("a template text");
        diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)2L, (long)diffs.size());
    }

    @Test
    public void testCompareAnnotationContainer() {
        STextualDS text1 = this.template.createTextualDS("Test");
        SToken templateTok = this.template.createToken((SSequentialDS)text1, Integer.valueOf(0), Integer.valueOf(5));
        STextualDS otherText = this.other.createTextualDS("Test");
        SToken otherTok = this.other.createToken((SSequentialDS)otherText, Integer.valueOf(0), Integer.valueOf(5));
        HashSet diffs = new HashSet();
        this.getFixture().compareAnnotationContainers((SAnnotationContainer)templateTok, (SAnnotationContainer)otherTok, diffs);
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        templateTok.createAnnotation(null, "anno", (Object)"annoVal");
        diffs = new HashSet();
        this.getFixture().compareAnnotationContainers((SAnnotationContainer)templateTok, (SAnnotationContainer)otherTok, diffs);
        Assert.assertEquals((String)("" + diffs), (long)1L, (long)diffs.size());
        otherTok.createAnnotation(null, "anno", (Object)"annoVal");
        diffs = new HashSet();
        this.getFixture().compareAnnotationContainers((SAnnotationContainer)templateTok, (SAnnotationContainer)otherTok, diffs);
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        templateTok.createAnnotation("namespace", "anno", (Object)"annoVal");
        diffs = new HashSet();
        this.getFixture().compareAnnotationContainers((SAnnotationContainer)templateTok, (SAnnotationContainer)otherTok, diffs);
        Assert.assertEquals((String)("" + diffs), (long)1L, (long)diffs.size());
    }

    @Test
    public void testTokenCompare() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(12), Integer.valueOf(20));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(12), Integer.valueOf(15));
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
        Assert.assertEquals((long)3L, (long)this.getFixture().getIsoNodes().size());
    }

    @Test
    public void testTokenCompareIsoObjects() {
        SampleGenerator.createTokens((SDocument)this.template.getDocument());
        SampleGenerator.createTokens((SDocument)this.other.getDocument());
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        int i = 0;
        for (SToken tok : this.template.getDocument().getDocumentGraph().getTokens()) {
            Assert.assertNotNull((Object)this.getFixture().getIsoNodes().get((Object)tok));
            Assert.assertEquals((Object)tok, this.template.getDocument().getDocumentGraph().getTokens().get(i));
            ++i;
        }
    }

    @Test
    public void testSNodeCompare() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(5));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(5));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(6), Integer.valueOf(8));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(6), Integer.valueOf(8));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(9), Integer.valueOf(11));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(9), Integer.valueOf(11));
        SDominanceRelation sDominatingRelation = SaltFactory.createSDominanceRelation();
        SStructure templ_struc = SaltFactory.createSStructure();
        sDominatingRelation.setSource((Node)templ_struc);
        sDominatingRelation.setTarget((Node)this.template.getTokens().get(0));
        this.template.addNode((Node)templ_struc);
        this.template.addRelation((Relation)sDominatingRelation);
        SDominanceRelation sDominatingRelation2 = SaltFactory.createSDominanceRelation();
        SStructure other_struc = SaltFactory.createSStructure();
        sDominatingRelation2.setSource((Node)other_struc);
        sDominatingRelation2.setTarget((Node)this.other.getTokens().get(0));
        this.other.addNode((Node)other_struc);
        this.other.addRelation((Relation)sDominatingRelation2);
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        SDominanceRelation sDominatingRelation3 = SaltFactory.createSDominanceRelation();
        sDominatingRelation3.setSource((Node)templ_struc);
        sDominatingRelation3.setTarget((Node)this.template.getTokens().get(1));
        this.template.addRelation((Relation)sDominatingRelation3);
        SDominanceRelation sDominatingRelation4 = SaltFactory.createSDominanceRelation();
        sDominatingRelation4.setSource((Node)other_struc);
        sDominatingRelation4.setTarget((Node)this.other.getTokens().get(2));
        this.other.addRelation((Relation)sDominatingRelation4);
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testPrimaryData() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        Assert.assertEquals((long)0L, (long)this.getFixture().findDiffs().size());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        ((STextualDS)this.other.getTextualDSs().get(0)).setText("a different text");
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testToken() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createTokens((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        SampleGenerator.createTokens((SDocument)this.other.getDocument());
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(1), Integer.valueOf(3));
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        SampleGenerator.createTokens((SDocument)this.other.getDocument());
        this.other.removeNode((Node)this.other.getTokens().get(this.other.getTokens().size() - 1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(1), Integer.valueOf(20));
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testTokenAnnotation() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createTokens((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        SampleGenerator.createTokens((SDocument)this.other.getDocument());
        for (SToken tok : this.template.getTokens()) {
            tok.createAnnotation(null, "annoName", (Object)"annoVal");
        }
        for (SToken tok : this.other.getTokens()) {
            tok.createAnnotation(null, "annoName", (Object)"annoVal");
        }
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        ((SToken)this.other.getTokens().get(0)).createAnnotation(null, "annoName2", (Object)"annoVal");
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        SampleGenerator.createTokens((SDocument)this.other.getDocument());
        for (SToken tok : this.other.getTokens()) {
            tok.createAnnotation(null, "otherName", (Object)"annoVal");
        }
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testCheckAnno() throws FileNotFoundException {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        ((SToken)this.template.getTokens().get(0)).createAnnotation(null, "A", (Object)"B");
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testSPointing() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        SPointingRelation pr1 = SaltFactory.createSPointingRelation();
        pr1.setSource((Node)((SToken)this.template.getNodes().get(1)));
        pr1.setTarget((Node)((SToken)this.template.getNodes().get(2)));
        pr1.setGraph((Graph)this.template);
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void testTwoLayers() {
        SampleGenerator.createPrimaryData((SDocument)this.template.getDocument());
        SampleGenerator.createPrimaryData((SDocument)this.other.getDocument());
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(0), Integer.valueOf(1));
        this.template.createToken((SSequentialDS)this.template.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        this.other.createToken((SSequentialDS)this.other.getTextualDSs().get(0), Integer.valueOf(2), Integer.valueOf(11));
        SLayer tempLayer = SaltFactory.createSLayer();
        this.template.addLayer((Layer)tempLayer);
        SLayer otherLayer = SaltFactory.createSLayer();
        this.other.addLayer((Layer)otherLayer);
        ((SToken)this.template.getTokens().get(0)).addLayer((Layer)tempLayer);
        ((SToken)this.other.getTokens().get(0)).addLayer((Layer)otherLayer);
        Assert.assertTrue((boolean)this.getFixture().isIsomorph());
        ((SToken)this.template.getTokens().get(1)).addLayer((Layer)tempLayer);
        Assert.assertFalse((boolean)this.getFixture().isIsomorph());
    }

    @Test
    public void test_SyntaxAnnotation() {
        SampleGenerator.createSyntaxAnnotations((SDocument)this.template.getDocument());
        SampleGenerator.createSyntaxAnnotations((SDocument)this.other.getDocument());
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void test_InformationStructureAnnotations() {
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.template.getDocument());
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.other.getDocument());
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void test_InformationStructureAnnotations_Fail() {
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.template.getDocument());
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.other.getDocument());
        this.other.getDocument().getDocumentGraph().removeNode((Node)this.other.getDocument().getDocumentGraph().getSpans().get(0));
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)1L, (long)diffs.size());
    }

    @Test
    public void test_Dependencies() {
        SampleGenerator.createDependencies((SDocument)this.template.getDocument());
        SampleGenerator.createDependencies((SDocument)this.other.getDocument());
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((long)0L, (long)diffs.size());
    }

    @Test
    public void test_AllSamples() {
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.template.getDocument());
        SampleGenerator.createSyntaxAnnotations((SDocument)this.template.getDocument());
        SampleGenerator.createDependencies((SDocument)this.template.getDocument());
        SampleGenerator.createInformationStructureAnnotations((SDocument)this.other.getDocument());
        SampleGenerator.createSyntaxAnnotations((SDocument)this.other.getDocument());
        SampleGenerator.createDependencies((SDocument)this.other.getDocument());
        Set diffs = this.getFixture().findDiffs();
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testMultipleChildsMultipleParents() {
        SDocument doc1 = SaltFactory.createSDocument();
        SDocument doc2 = SaltFactory.createSDocument();
        doc2.setId("doc");
        SDocumentGraph dg1 = null;
        dg1 = SaltFactory.createSDocumentGraph();
        doc1.setDocumentGraph(dg1);
        dg1.createTextualDS("hallo hallo hallo");
        dg1.tokenize();
        dg1.createSpan(new SToken[]{(SToken)dg1.getTokens().get(0)}).createAnnotation("ns", "function", (Object)"being nice");
        ArrayList tokens = new ArrayList();
        tokens.add(dg1.getTokens().get(1));
        tokens.add(dg1.getTokens().get(2));
        dg1.createSpan(tokens).createAnnotation("ns", "function", (Object)"none");
        dg1.createSpan(new SToken[]{(SToken)dg1.getTokens().get(2)}).createAnnotation("ns", "function", (Object)"tail");
        dg1.createSpan(dg1.getTokens()).createAnnotation("ns", "function", (Object)"all");
        SDocumentGraph dg2 = null;
        dg2 = SaltFactory.createSDocumentGraph();
        doc2.setDocumentGraph(dg2);
        dg2.createTextualDS("hallo hallo hallo");
        dg2.tokenize();
        dg2.createSpan(new SToken[]{(SToken)dg2.getTokens().get(0)}).createAnnotation("ns", "function", (Object)"being nice");
        ArrayList tokens2 = new ArrayList();
        tokens2.add(dg2.getTokens().get(1));
        tokens2.add(dg2.getTokens().get(2));
        dg2.createSpan(tokens2).createAnnotation("ns", "function", (Object)"none");
        dg2.createSpan(new SToken[]{(SToken)dg2.getTokens().get(2)}).createAnnotation("ns", "function", (Object)"tail");
        dg2.createSpan(dg2.getTokens()).createAnnotation("ns", "function", (Object)"all");
        Set diffs = dg1.findDiffs(dg2, new DiffOptions().setOption("ignoreId", Boolean.valueOf(true)));
        Assert.assertEquals((String)diffs.toString(), (long)0L, (long)diffs.size());
    }

    @Test
    public void test_Options() {
        SDocumentGraph graph1 = SaltFactory.createSDocumentGraph();
        STextualDS text1 = graph1.createTextualDS("This is a sample");
        graph1.addNode((Node)text1);
        SToken tok1 = SaltFactory.createSToken();
        tok1.setName("tok");
        graph1.addNode((Node)tok1);
        STextualRelation rel = SaltFactory.createSTextualRelation();
        rel.setSource((Node)tok1);
        rel.setTarget((Node)text1);
        rel.setStart((Number)0);
        rel.setEnd((Number)4);
        graph1.addRelation((Relation)rel);
        SDocumentGraph graph2 = SaltFactory.createSDocumentGraph();
        STextualDS text2 = graph2.createTextualDS("This is a sample");
        graph2.addNode((Node)text2);
        SToken tok2 = SaltFactory.createSToken();
        tok2.setName("other");
        graph2.addNode((Node)tok2);
        rel = SaltFactory.createSTextualRelation();
        rel.setSource((Node)tok2);
        rel.setTarget((Node)text2);
        rel.setStart((Number)0);
        rel.setEnd((Number)4);
        graph2.addRelation((Relation)rel);
        tok2.setName("tok");
        DiffOptions options = new DiffOptions();
        options.setOption("ignoreId", Boolean.valueOf(true));
        Set diffs = graph1.findDiffs(graph2, options);
        Assert.assertEquals((String)(diffs + ""), (long)0L, (long)diffs.size());
        options.setOption("ignoreId", Boolean.valueOf(false));
        diffs = graph1.findDiffs(graph2, options);
        Assert.assertEquals((String)(diffs + ""), (long)1L, (long)diffs.size());
    }

    @Test
    public void testTwoIdenticalGraphs() {
        SDocument doc1 = this.createSampleGraph();
        SDocument doc2 = this.createSampleGraph();
        Set diffs = doc1.getDocumentGraph().findDiffs(doc2.getDocumentGraph(), new DiffOptions().setOption("ignoreId", Boolean.valueOf(true)));
        Assert.assertEquals((String)diffs.toString(), (long)0L, (long)diffs.size());
    }

    public SDocument createSampleGraph() {
        String exampleText = "Is this example more complicated than it appears to be?";
        String layerTextStructure = "textstructure";
        String type = "type";
        SDocument doc1 = SaltFactory.createSDocument();
        doc1.setId("doc");
        SDocumentGraph docGraph = SaltFactory.createSDocumentGraph();
        doc1.setDocumentGraph(docGraph);
        docGraph.createTextualDS(exampleText);
        docGraph.tokenize();
        List docTokens = docGraph.getTokens();
        SLayer docTextLayer = SaltFactory.createSLayer();
        docTextLayer.setName(layerTextStructure);
        docGraph.addLayer((Layer)docTextLayer);
        SSpan sSpan = null;
        ArrayList spanTokens = new ArrayList();
        spanTokens.clear();
        spanTokens.add(docTokens.get(5));
        spanTokens.add(docTokens.get(6));
        spanTokens.add(docTokens.get(7));
        spanTokens.add(docTokens.get(8));
        spanTokens.add(docTokens.get(9));
        spanTokens.add(docTokens.get(10));
        sSpan = docGraph.createSpan(spanTokens);
        sSpan.createAnnotation(layerTextStructure, type, (Object)"page");
        sSpan.addLayer((Layer)docTextLayer);
        spanTokens.clear();
        spanTokens.add(docTokens.get(5));
        spanTokens.add(docTokens.get(6));
        spanTokens.add(docTokens.get(7));
        spanTokens.add(docTokens.get(8));
        spanTokens.add(docTokens.get(9));
        spanTokens.add(docTokens.get(10));
        sSpan = docGraph.createSpan(spanTokens);
        sSpan.createAnnotation(layerTextStructure, type, (Object)"line");
        sSpan.addLayer((Layer)docTextLayer);
        return doc1;
    }

    @Test
    public void testSameGraph() {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxAnnotations((SDocument)doc);
        SampleGenerator.createAnaphoricAnnotations((SDocument)doc);
        SampleGenerator.createInformationStructureAnnotations((SDocument)doc);
        SampleGenerator.createDependencies((SDocument)doc);
        Set diffs = doc.getDocumentGraph().findDiffs(doc.getDocumentGraph());
        Assert.assertEquals((String)diffs.toString(), (long)0L, (long)diffs.size());
    }
}

