/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.delegator.tests;

import java.util.Set;
import java.util.Vector;
import org.corpus_tools.salt.ISaltFactory;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.delegator.tests.DelegatorTestFactory;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.impl.SaltFactoryImpl;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegationDeletionTest {
    private SDocument template_doc;
    private SDocument fixture_doc;

    @Before
    public void setUp() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new SaltFactoryImpl());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof SaltFactoryImpl));
        this.template_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)this.template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        this.fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)this.fixture_doc);
    }

    @After
    public void tearDown() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new SaltFactoryImpl());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof SaltFactoryImpl));
    }

    @Test
    public void testDelegated_DeletePointingRelations() {
        Set diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)this.template_doc.getDocumentGraph().getRelations().size(), (long)this.fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(this.template_doc.getDocumentGraph().getPointingRelations());
        for (SRelation rel : rels) {
            this.template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        rels = new Vector();
        rels.addAll(this.fixture_doc.getDocumentGraph().getPointingRelations());
        for (SRelation rel : rels) {
            this.fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegated_DeleteSyntax() {
        Set diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)this.template_doc.getDocumentGraph().getRelations().size(), (long)this.fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(this.template_doc.getDocumentGraph().getDominanceRelations());
        for (SRelation rel : rels) {
            this.template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        Vector nodes = new Vector();
        nodes.addAll(this.template_doc.getDocumentGraph().getStructures());
        for (SNode node : nodes) {
            this.template_doc.getDocumentGraph().removeNode((Node)node);
        }
        rels = new Vector();
        rels.addAll(this.fixture_doc.getDocumentGraph().getDominanceRelations());
        for (SRelation rel : rels) {
            this.fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        nodes = new Vector();
        nodes.addAll(this.fixture_doc.getDocumentGraph().getStructures());
        for (SNode node : nodes) {
            this.fixture_doc.getDocumentGraph().removeNode((Node)node);
        }
        diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegated_DeleteInformationStructure() {
        Set diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)this.template_doc.getDocumentGraph().getRelations().size(), (long)this.fixture_doc.getDocumentGraph().getRelations().size());
        Vector rels = new Vector();
        rels.addAll(this.template_doc.getDocumentGraph().getSpanningRelations());
        for (SRelation rel : rels) {
            this.template_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        Vector nodes = new Vector();
        nodes.addAll(this.template_doc.getDocumentGraph().getSpans());
        for (SNode node : nodes) {
            this.template_doc.getDocumentGraph().removeNode((Node)node);
        }
        rels = new Vector();
        rels.addAll(this.fixture_doc.getDocumentGraph().getSpanningRelations());
        for (SRelation rel : rels) {
            this.fixture_doc.getDocumentGraph().removeRelation((Relation)rel);
        }
        nodes = new Vector();
        nodes.addAll(this.fixture_doc.getDocumentGraph().getSpans());
        for (SNode node : nodes) {
            this.fixture_doc.getDocumentGraph().removeNode((Node)node);
        }
        diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegated_DeleteAllStructureNodes() {
        Set diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
        Assert.assertEquals((long)this.template_doc.getDocumentGraph().getNodes().size(), (long)this.fixture_doc.getDocumentGraph().getNodes().size());
        Vector nodes = new Vector();
        nodes.addAll(this.template_doc.getDocumentGraph().getStructures());
        for (SStructure n : nodes) {
            this.template_doc.getDocumentGraph().removeNode((Node)n);
        }
        nodes = new Vector();
        nodes.addAll(this.fixture_doc.getDocumentGraph().getStructures());
        for (SStructure n : nodes) {
            this.fixture_doc.getDocumentGraph().removeNode((Node)n);
        }
        Assert.assertEquals((long)this.template_doc.getDocumentGraph().getNodes().size(), (long)this.fixture_doc.getDocumentGraph().getNodes().size());
        diffs = this.template_doc.getDocumentGraph().findDiffs(this.fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }
}

