/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeTest {
    protected Node fixture = null;

    public Node getFixture() {
        return this.fixture;
    }

    public void setFixture(Node fixture) {
        this.fixture = fixture;
    }

    public Graph createGraph() {
        return GraphFactory.createGraph();
    }

    public Layer createLayer() {
        return GraphFactory.createLayer();
    }

    public Node createNode() {
        return GraphFactory.createNode();
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(this.createNode());
    }

    @Test
    public void testDoubleChaining() {
        Graph graph = this.createGraph();
        this.getFixture().setGraph(graph);
        Assert.assertTrue((String)("only contains " + graph.getNodes()), (boolean)graph.getNodes().contains(this.getFixture()));
    }

    @Test
    public void testDoubleChaining_SetGraph_remove() {
        Graph graph = this.createGraph();
        this.getFixture().setGraph(graph);
        Assert.assertEquals((Object)graph, (Object)this.getFixture().getGraph());
        this.getFixture().setGraph(null);
        Assert.assertNull((Object)this.getFixture().getGraph());
        this.getFixture().setGraph(graph);
        Assert.assertEquals((Object)graph, (Object)this.getFixture().getGraph());
        Graph graph2 = this.createGraph();
        this.getFixture().setGraph(graph2);
        Assert.assertEquals((Object)graph2, (Object)this.getFixture().getGraph());
    }

    @Test
    public void testAddGetLayers() {
        Layer layer = this.createLayer();
        Graph graph = this.createGraph();
        graph.addNode(this.getFixture());
        graph.addLayer(layer);
        this.getFixture().addLayer(layer);
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
    }

    @Test
    public void testRemoveLayers() {
        Assert.assertNotNull((Object)this.getFixture().getLayers());
        Layer layer = this.createLayer();
        Graph graph = this.createGraph();
        graph.addNode(this.getFixture());
        graph.addLayer(layer);
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
        this.getFixture().removeLayer(layer);
        Assert.assertEquals((long)0L, (long)this.getFixture().getLayers().size());
    }

    @Test
    public void testDoubleChainingLayer() {
        Layer layer = this.createLayer();
        Graph graph = this.createGraph();
        graph.addNode(this.getFixture());
        graph.addLayer(layer);
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)layer.getNodes().contains(this.getFixture()));
        this.getFixture().removeLayer(layer);
        Assert.assertFalse((boolean)layer.getNodes().contains(this.getFixture()));
    }
}

