/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.index.tests;

import org.corpus_tools.salt.index.IndexMgr;
import org.corpus_tools.salt.index.IndexMgrImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexMgrTest {
    protected IndexMgr fixture = null;

    public IndexMgr getFixture() {
        return this.fixture;
    }

    public void setFixture(IndexMgr fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture((IndexMgr)new IndexMgrImpl());
    }

    @Test
    public void testCreateIndex() {
        String index1 = "index01";
        String index2 = "index02";
        this.getFixture().createIndex(index1, String.class, String.class);
        Assert.assertTrue((boolean)this.getFixture().containsIndex(index1));
        this.getFixture().createIndex(index2, Object.class, Object.class);
        Assert.assertTrue((boolean)this.getFixture().containsIndex(index1));
        Assert.assertTrue((boolean)this.getFixture().containsIndex(index2));
    }

    @Test
    public void testAddValues() {
        String indexId = "index";
        this.getFixture().createIndex(indexId, String.class, String.class);
        try {
            this.getFixture().put(indexId, (Object)"wrongObject", (Object)4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.getFixture().put(indexId, (Object)"key", (Object)"val1");
        Assert.assertEquals((Object)"val1", (Object)this.getFixture().get(indexId, (Object)"key"));
        this.getFixture().put(indexId, (Object)"key", (Object)"val2");
        Assert.assertTrue((boolean)this.getFixture().getAll(indexId, (Object)"key").contains("val1"));
        Assert.assertTrue((boolean)this.getFixture().getAll(indexId, (Object)"key").contains("val2"));
    }

    @Test
    public void testRemoveValue() {
        String index1 = "index1";
        String index2 = "index2";
        String index3 = "index3";
        String key = "key";
        Object value = new Object();
        this.getFixture().createIndex(index1, String.class, Object.class);
        this.getFixture().createIndex(index2, String.class, Object.class);
        this.getFixture().createIndex(index3, String.class, Object.class);
        this.getFixture().put(index1, (Object)"key1", (Object)"val1");
        this.getFixture().put(index1, (Object)key, value);
        this.getFixture().put(index1, (Object)key, (Object)"val2");
        this.getFixture().put(index2, (Object)"key1", (Object)"val1");
        this.getFixture().put(index2, (Object)key, value);
        this.getFixture().put(index2, (Object)key, (Object)"val2");
        this.getFixture().put(index3, (Object)"key1", (Object)"val1");
        this.getFixture().put(index3, (Object)key, value);
        this.getFixture().put(index3, (Object)key, (Object)"val2");
        Assert.assertTrue((boolean)this.getFixture().getAll(index1, (Object)key).contains(value));
        Assert.assertTrue((boolean)this.getFixture().getAll(index2, (Object)key).contains(value));
        Assert.assertTrue((boolean)this.getFixture().getAll(index3, (Object)key).contains(value));
        this.getFixture().removeValue(value);
        Assert.assertFalse((boolean)this.getFixture().getAll(index1, (Object)key).contains(value));
        Assert.assertFalse((boolean)this.getFixture().getAll(index2, (Object)key).contains(value));
        Assert.assertFalse((boolean)this.getFixture().getAll(index3, (Object)key).contains(value));
    }
}

