/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.util.internal.Diff;
import org.corpus_tools.salt.util.internal.Validator;
import org.corpus_tools.salt.util.internal.persistence.SaltXML10Handler;
import org.corpus_tools.salt.util.internal.persistence.SaltXML10Writer;
import org.corpus_tools.salt.util.internal.persistence.dot.SCorpusGraphDOTWriter;
import org.corpus_tools.salt.util.internal.persistence.dot.SDocumentGraphDOTWriter;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaltUtil {
    public static final String SALT_SCHEME = "salt";
    public static final String FILE_ENDING_SALT_XML = "salt";
    public static final String FILE_ENDING_DOT = "dot";
    public static final String FILE_SALT_PROJECT = "saltProject.salt";
    public static final String SALT_NAMESPACE = "salt";
    public static final String NAMESPACE_SEPERATOR = "::";
    public static final String SALT_NULL_VALUE = "salt::NULL";
    public static final String IDX_NODETYPE = "idx_sNodeType";
    public static final String IDX_RELATIONTYPE = "idx_sRelationType";
    public static final String IDX_ID_NODES = "idx_id_nodes";
    public static final String IDX_ID_NODES_INVERSE = "idx_id_nodes_inverse";
    public static final String IDX_ID_RELATIONS = "idx_id_relation";
    public static final String IDX_ID_RELATIONS_INVERSE = "idx_id_relation_inverse";
    public static final String IDX_ID_LAYER = "idx_id_layer";
    public static final String IDX_OUT_RELATIONS = "idx_out_relations";
    public static final String IDX_IN_RELATIONS = "idx_in_relations";
    public static final String LABEL_ID = "id";
    public static final String LABEL_ID_QNAME = "salt::id";
    public static final String FEAT_VALUE_DATATYPE = "SVAL_TYPE";
    public static final String FEAT_NAME = "SNAME";
    public static final String FEAT_NAME_QNAME = "salt::SNAME";
    public static final String FEAT_TYPE = "STYPE";
    public static final String FEAT_TYPE_QNAME = "salt::STYPE";
    public static final String FEAT_SDOCUMENT_GRAPH = "SDOCUMENT_GRAPH";
    public static final String FEAT_SDOCUMENT_GRAPH_QNAME = "salt::SDOCUMENT_GRAPH";
    public static final String FEAT_SDOCUMENT = "SDOCUMENT";
    public static final String FEAT_SDOCUMENT_QNAME = "salt::SDOCUMENT";
    public static final String FEAT_SDOCUMENT_GRAPH_LOCATION = "SDOCUMENT_GRAPH_LOCATION";
    public static final String FEAT_SDOCUMENT_GRAPH_LOCATION_QNAME = "salt::SDOCUMENT_GRAPH_LOCATION";
    public static final String FEAT_SMEDIA_REFERNCE = "SAUDIO_REFERENCE";
    public static final String FEAT_SMEDIA_REFERNCE_QNAME = "salt::SAUDIO_REFERENCE";
    public static final String FEAT_SSTART = "SSTART";
    public static final String FEAT_SSTART_QNAME = "salt::SSTART";
    public static final String FEAT_SEND = "SEND";
    public static final String FEAT_SEND_QNAME = "salt::SEND";
    public static final String FEAT_SDATA = "SDATA";
    public static final String FEAT_SDATA_QNAME = "salt::SDATA";
    public static final String SEMANTICS_CAT = "cat";
    public static final String SEMANTICS_POS = "pos";
    public static final String SEMANTICS_LEMMA = "lemma";
    public static final String SEMANTICS_SENTENCE = "sentence";
    public static final String SEMANTICS_TYPE = "type";
    public static final String SEMANTICS_WORD = "word";
    public static final String SEMANTICS_UNIT = "unit";

    public static String createQName(String namespace, String name) {
        if (namespace == null || namespace.isEmpty()) {
            return name;
        }
        if (name == null || name.isEmpty()) {
            return String.valueOf(namespace) + NAMESPACE_SEPERATOR;
        }
        return String.valueOf(namespace) + NAMESPACE_SEPERATOR + name;
    }

    public static Pair<String, String> splitQName(String qName) {
        ImmutablePair retVal = null;
        if (qName != null && !qName.isEmpty()) {
            String[] fullName = qName.split(NAMESPACE_SEPERATOR);
            StringBuffer ns = new StringBuffer();
            String name = null;
            int i = 0;
            while (i < fullName.length) {
                if (i == fullName.length - 1) {
                    name = fullName[i];
                } else if (ns.toString().isEmpty()) {
                    ns.append(fullName[i]);
                } else {
                    ns.append(NAMESPACE_SEPERATOR);
                    ns.append(fullName[i]);
                }
                ++i;
            }
            if (ns.length() != 0 && name.length() != 0) {
                retVal = new ImmutablePair((Object)ns.toString(), (Object)name);
            } else if (ns.length() != 0) {
                retVal = new ImmutablePair((Object)ns.toString(), null);
            } else if (name.length() != 0) {
                retVal = new ImmutablePair(null, (Object)name);
            }
        }
        return retVal;
    }

    public static URI createSaltURI(URI path) {
        if (path == null) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)path.scheme())) {
            return path;
        }
        return SaltUtil.createSaltURI(path.toString());
    }

    public static URI createSaltURI(String path) {
        URI uri = null;
        if (path != null && !path.isEmpty()) {
            uri = path.startsWith("salt:") ? URI.createURI((String)path) : (path.startsWith("/") ? URI.createURI((String)("salt:" + path)) : URI.createURI((String)("salt:/" + path)));
        }
        return uri;
    }

    public static String getGlobalId(Identifier id) {
        StringBuffer globalId = new StringBuffer();
        if (id != null && id.getIdentifiableElement() != null) {
            SRelation sRel;
            SCorpusGraph graph = null;
            if (id.getIdentifiableElement() instanceof SDocument && ((SDocument)id.getIdentifiableElement()).getGraph() != null) {
                graph = ((SDocument)id.getIdentifiableElement()).getGraph();
            } else if (id.getIdentifiableElement() instanceof SCorpus && ((SCorpus)id.getIdentifiableElement()).getGraph() != null) {
                graph = ((SCorpus)id.getIdentifiableElement()).getGraph();
            } else if (id.getIdentifiableElement() instanceof SNode) {
                SNode sNode = (SNode)id.getIdentifiableElement();
                if (sNode.getGraph() != null) {
                    if (sNode.getGraph() instanceof SCorpusGraph) {
                        graph = (SCorpusGraph)sNode.getGraph();
                    } else if (sNode.getGraph() instanceof SDocumentGraph) {
                        graph = ((SDocumentGraph)sNode.getGraph()).getDocument().getGraph();
                    }
                }
            } else if (id.getIdentifiableElement() instanceof SRelation && (sRel = (SRelation)id.getIdentifiableElement()).getGraph() != null) {
                if (sRel.getGraph() instanceof SCorpusGraph) {
                    graph = (SCorpusGraph)sRel.getGraph();
                } else if (sRel.getGraph() instanceof SDocumentGraph) {
                    graph = ((SDocumentGraph)sRel.getGraph()).getDocument().getGraph();
                }
            }
            if (graph != null) {
                String actualId;
                globalId.append("salt:");
                SaltProject project = graph.getSaltProject();
                if (project != null) {
                    globalId.append("/");
                    globalId.append(project.getCorpusGraphs().indexOf(graph));
                    globalId.append("/");
                }
                if ((actualId = id.getId().replace("salt:", "")).startsWith("/")) {
                    actualId = actualId.substring(1, actualId.length());
                }
                globalId.append(actualId);
                if (id.getIdentifiableElement() instanceof SCorpus) {
                    globalId.append("/");
                }
            } else {
                globalId.append(id.getId());
            }
        }
        return globalId.toString();
    }

    public static Object load(URI location) {
        List<Object> objects = SaltUtil.loadObjects(location);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return objects.get(0);
    }

    public static List<Object> loadObjects(URI location) {
        XMLReader xmlReader;
        SAXParser parser;
        if (location == null) {
            throw new SaltResourceException("Cannot load Salt object, because the given uri is null.");
        }
        File objectFile = new File(location.toFileString() == null ? location.toString() : location.toFileString());
        if (!objectFile.exists()) {
            throw new SaltResourceException("Cannot load Salt object, because the file '" + objectFile.getAbsolutePath() + "' does not exist.");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SaltXML10Handler contentHandler = new SaltXML10Handler();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(contentHandler);
        }
        catch (ParserConfigurationException e) {
            throw new SaltResourceException("Cannot load Salt object from file '" + objectFile.getAbsolutePath() + "'.", e);
        }
        catch (Exception e) {
            throw new SaltResourceException("Cannot load Salt object from file '" + objectFile.getAbsolutePath() + "'.", e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(objectFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            xmlReader.parse(is);
        }
        catch (SAXException e) {
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(objectFile.getAbsolutePath());
            }
            catch (Exception e1) {
                throw new SaltResourceException("Cannot load Salt object from file '" + objectFile.getAbsolutePath() + "'.", e1);
            }
        }
        catch (Exception e) {
            if (e instanceof SaltException) {
                throw (SaltException)e;
            }
            throw new SaltResourceException("Cannot load Salt object from file'" + objectFile + "', because of a nested exception. ", e);
        }
        return contentHandler.getRootObjects();
    }

    private static void insertDocumentGraphLocations(SCorpusGraph corpusGraph, URI root) {
        if (corpusGraph == null || root == null) {
            return;
        }
        File rootFile = new File(root.toFileString());
        if (rootFile.isFile()) {
            rootFile = rootFile.getParentFile();
            root = URI.createFileURI((String)rootFile.getAbsolutePath());
        }
        for (SDocument doc : corpusGraph.getDocuments()) {
            URI location = root;
            location = location.appendSegments(doc.getPath().segments());
            File f = new File((location = location.appendFileExtension("salt")).toFileString());
            if (!f.exists()) continue;
            doc.setDocumentGraphLocation(location);
        }
    }

    public static void moveCorpusGraph(SCorpusGraph source, SCorpusGraph target) {
        for (SRelation sRelation : new LinkedList(source.getRelations())) {
            if (target.getNode(((SNode)sRelation.getSource()).getId()) == null) {
                target.addNode((SNode)sRelation.getSource());
            }
            if (target.getNode(((SNode)sRelation.getTarget()).getId()) == null) {
                target.addNode((SNode)sRelation.getTarget());
            }
            target.addRelation(sRelation);
        }
        for (SNode sNode : new LinkedList(source.getNodes())) {
            if (target.getNode(sNode.getId()) == null) {
                target.addNode(sNode);
            }
            target.addNode(sNode);
        }
        for (SAnnotation sAnno : source.getAnnotations()) {
            target.addAnnotation(sAnno);
        }
        for (SMetaAnnotation sMetaAnno : source.getMetaAnnotations()) {
            target.addMetaAnnotation(sMetaAnno);
        }
        for (SProcessingAnnotation sProcAnno : source.getProcessingAnnotations()) {
            target.addProcessingAnnotation(sProcAnno);
        }
        for (SFeature sfeature : source.getFeatures()) {
            target.addFeature(sfeature);
        }
        target.setIdentifier(source.getIdentifier());
        for (SLayer sLayer : new LinkedList(source.getLayers())) {
            target.addLayer(sLayer);
        }
    }

    public static void saveDocumentGraph(SDocumentGraph documentGraph, URI location) {
        if (documentGraph != null && location != null) {
            String path = location.toFileString();
            if (path == null || path.isEmpty()) {
                path = location.toString();
            }
            File out = new File(path);
            out.getParentFile().mkdirs();
            SaltXML10Writer writer = new SaltXML10Writer(out);
            writer.writeDocumentGraph(documentGraph);
        }
    }

    public static SDocumentGraph loadDocumentGraph(URI location) {
        SDocumentGraph retVal = null;
        Object obj = SaltUtil.load(location);
        if (obj == null) {
            throw new SaltResourceException("Cannot load the requested " + SDocumentGraph.class.getName() + ", because file located at contains no such object, the returned object was null.");
        }
        if (!(obj instanceof SDocumentGraph)) {
            throw new SaltResourceException("Cannot load the requested " + SDocumentGraph.class.getName() + ", because file located at contains no such object. It contains: " + obj.getClass());
        }
        retVal = (SDocumentGraph)obj;
        return retVal;
    }

    public static void saveCorpusGraph(SCorpusGraph corpusGraph, URI location) {
        if (corpusGraph.getDocuments() != null && corpusGraph.getDocuments().size() > 0) {
            for (SDocument doc : corpusGraph.getDocuments()) {
                URI docURI = location;
                String[] stringArray = doc.getPath().segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String seg = stringArray[n2];
                    docURI = docURI.appendSegment(seg);
                    ++n2;
                }
                docURI = docURI.appendFileExtension("salt");
                if (doc.getDocumentGraph() != null) {
                    doc.saveDocumentGraph(docURI);
                    continue;
                }
                URI corpUri = docURI.trimFileExtension().trimSegments(1);
                String str = corpUri.toFileString();
                if (str == null || str.isEmpty()) {
                    str = corpUri.toString();
                }
                File corpFile = new File(str);
                corpFile.mkdirs();
            }
        }
    }

    public static SCorpusGraph loadCorpusGraph(URI corpusPath) {
        return SaltUtil.loadCorpusGraph(corpusPath, 0);
    }

    public static SCorpusGraph loadCorpusGraph(URI corpusPath, Integer idxOfSCorpusGraph) {
        Object obj;
        if (corpusPath == null) {
            throw new SaltResourceException("Cannot load '" + SCorpusGraph.class.getSimpleName() + "' object, because the passed uri is empty. ");
        }
        SCorpusGraph retVal = null;
        if (!corpusPath.toFileString().endsWith(".salt")) {
            if (corpusPath.toString().endsWith("/")) {
                corpusPath = corpusPath.trimSegments(1);
            }
            corpusPath = corpusPath.appendSegment(FILE_SALT_PROJECT);
        }
        if ((obj = SaltUtil.load(corpusPath)) instanceof SCorpusGraph) {
            retVal = (SCorpusGraph)obj;
        } else if (obj instanceof SaltProject && ((SaltProject)obj).getCorpusGraphs() != null && ((SaltProject)obj).getCorpusGraphs().size() >= idxOfSCorpusGraph) {
            retVal = ((SaltProject)obj).getCorpusGraphs().get(idxOfSCorpusGraph);
        }
        if (retVal != null) {
            SaltUtil.insertDocumentGraphLocations(retVal, corpusPath);
        }
        return retVal;
    }

    public static void saveSaltProject(SaltProject saltProject, URI location) {
        if (location == null) {
            throw new SaltResourceException("Cannot save SaltProject, because the given uri is null.");
        }
        URI saltProjectFolder = null;
        URI saltProjectFile = null;
        if ("salt".equals(location.fileExtension())) {
            saltProjectFile = location;
            saltProjectFolder = location.trimFileExtension().trimSegments(1);
        } else {
            saltProjectFile = location.appendSegment(FILE_SALT_PROJECT);
            saltProjectFolder = location;
        }
        String str = saltProjectFolder.toFileString();
        if (str == null || str.isEmpty()) {
            str = saltProjectFolder.toString();
        }
        File folder = new File(str);
        folder.mkdirs();
        SaltXML10Writer writer = new SaltXML10Writer(saltProjectFile);
        writer.writeSaltProject(saltProject);
        if (saltProject.getCorpusGraphs() != null && saltProject.getCorpusGraphs().size() > 0) {
            for (SCorpusGraph cGraph : saltProject.getCorpusGraphs()) {
                SaltUtil.saveCorpusGraph(cGraph, saltProjectFolder);
            }
        }
    }

    public static SaltProject loadCompleteSaltProject(URI location) {
        SaltProject project = SaltUtil.loadSaltProject(location);
        if (project != null) {
            for (SCorpusGraph cGraph : project.getCorpusGraphs()) {
                for (SDocument document : cGraph.getDocuments()) {
                    document.loadDocumentGraph();
                }
            }
        }
        return project;
    }

    public static SaltProject loadSaltProject(URI location) {
        if (!"salt".equals(location.fileExtension())) {
            location = location.appendSegment(FILE_SALT_PROJECT);
        }
        SaltProject saltProject = null;
        if (location == null) {
            throw new SaltResourceException("Can not load SaltProject, because the given uri is null. ");
        }
        File saltProjectFile = null;
        try {
            saltProjectFile = new File(location.toFileString());
        }
        catch (Exception e) {
            throw new SaltResourceException("Can not load SaltProject. ", e);
        }
        if (!saltProjectFile.exists()) {
            throw new SaltResourceException("Can not load SaltProject, because path '" + saltProjectFile.getAbsolutePath() + "' does not exist. ");
        }
        Object project = SaltUtil.load(location);
        if (!(project instanceof SaltProject)) {
            throw new SaltResourceException("Can not load SaltProject, because the file at '" + saltProjectFile + "' does not contain a Salt project. ");
        }
        saltProject = (SaltProject)project;
        for (SCorpusGraph corpusGraph : saltProject.getCorpusGraphs()) {
            SaltUtil.insertDocumentGraphLocations(corpusGraph, location);
        }
        return saltProject;
    }

    public static void saveCorpusGraph_DOT(SCorpusGraph corpusGraph, URI location) {
        URI targetUri = null;
        if (location.fileExtension() == null) {
            if (corpusGraph.getSaltProject() != null && corpusGraph.getSaltProject().getCorpusGraphs().size() > 1) {
                Integer pos = corpusGraph.getSaltProject().getCorpusGraphs().indexOf(corpusGraph);
                targetUri = location.appendSegment(pos.toString()).appendFileExtension(FILE_ENDING_DOT);
            } else {
                List<SNode> roots = corpusGraph.getRoots();
                targetUri = roots != null && !roots.isEmpty() ? location.appendSegment(((SCorpus)roots.get(0)).getName()).appendFileExtension(FILE_ENDING_DOT) : location.appendSegment(corpusGraph.getName()).appendFileExtension(FILE_ENDING_DOT);
            }
        } else {
            targetUri = location;
        }
        SCorpusGraphDOTWriter writer = new SCorpusGraphDOTWriter();
        writer.setSCorpusGraph(corpusGraph);
        writer.setOutputURI(targetUri);
        writer.save();
    }

    public static void saveDocumentGraph_DOT(SDocumentGraph documentGraph, URI location) {
        URI targetUri = null;
        targetUri = location.fileExtension() == null ? (documentGraph.getDocument() != null ? location.appendSegment(documentGraph.getDocument().getName()).appendFileExtension(FILE_ENDING_DOT) : location.appendSegment(documentGraph.getName()).appendFileExtension(FILE_ENDING_DOT)) : location;
        SDocumentGraphDOTWriter writer = new SDocumentGraphDOTWriter();
        writer.setDocumentGraph(documentGraph);
        writer.setOutputURI(targetUri);
        writer.save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void save_DOT(Object saltObject, URI location) {
        if (location == null) {
            throw new SaltResourceException("Exception in storing Salt model to dot file, because no uri was given.");
        }
        if (saltObject == null) {
            throw new SaltResourceException("Exception in storing Salt model to dot file. Cannot write more than one content per file.");
        }
        if (saltObject instanceof SCorpus) {
            SCorpus sCorpus = (SCorpus)saltObject;
            if (sCorpus.getGraph() == null) throw new SaltResourceException("Cannot save Salt model to DOT format, because the given " + SCorpus.class.getSimpleName() + " is not part of a " + SCorpusGraph.class.getSimpleName() + " container");
            saltObject = sCorpus.getGraph();
        } else if (saltObject instanceof SDocument) {
            SDocument sDocument = (SDocument)saltObject;
            if (sDocument.getDocumentGraph() == null) throw new SaltResourceException("Cannot save Salt model to DOT format, because the given " + SDocument.class.getSimpleName() + " does not contain a " + SDocumentGraph.class.getSimpleName() + " content");
            saltObject = sDocument.getDocumentGraph();
        }
        if (saltObject instanceof SCorpusGraph) {
            SaltUtil.saveCorpusGraph_DOT((SCorpusGraph)saltObject, location);
            return;
        } else if (saltObject instanceof SDocumentGraph) {
            SaltUtil.saveDocumentGraph_DOT((SDocumentGraph)saltObject, location);
            return;
        } else {
            if (!(saltObject instanceof SaltProject)) throw new SaltResourceException("Cannot save Salt model to DOT format, because content is neither " + SCorpusGraph.class.getSimpleName() + ", " + SDocumentGraph.class.getSimpleName() + " nor " + SaltProject.class.getSimpleName() + " content. The given content is of type: '" + saltObject.getClass() + "'.");
            Collection<SCorpusGraph> corpGraphs = Collections.synchronizedCollection(((SaltProject)saltObject).getCorpusGraphs());
            Integer corpIndex = 0;
            for (SCorpusGraph sCorpusGraph : corpGraphs) {
                URI corpUri = location;
                SaltUtil.saveCorpusGraph_DOT(sCorpusGraph, corpUri);
                if (corpGraphs.size() > 1) {
                    corpUri = corpUri.appendSegment(corpIndex.toString());
                }
                int docIndex = 0;
                while (docIndex < sCorpusGraph.getDocuments().size()) {
                    SDocument sDocument = sCorpusGraph.getDocuments().get(docIndex);
                    if (sDocument.getDocumentGraph() != null) {
                        URI docURI = corpUri;
                        String[] stringArray = sDocument.getPath().segments();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String seg = stringArray[n2];
                            docURI = docURI.appendSegment(seg);
                            ++n2;
                        }
                        SDocumentGraph sDocGraph = sDocument.getDocumentGraph();
                        SaltUtil.saveDocumentGraph_DOT(sDocGraph, docURI.appendFileExtension(FILE_ENDING_DOT));
                        sDocument.setDocumentGraph(sDocGraph);
                    }
                    ++docIndex;
                }
                corpIndex = corpIndex + 1;
            }
        }
    }

    public static <P extends Label> P getAnnotation(Integer idx, Set<P> annotations) {
        Label retVal = null;
        if (annotations != null && annotations.size() < idx) {
            Iterator<P> it = annotations.iterator();
            int i = 0;
            while (i <= idx) {
                retVal = (Label)it.next();
                ++i;
            }
        }
        return (P)retVal;
    }

    public static void moveAnnotations(SAnnotationContainer from, SAnnotationContainer to) {
        if (from != null && to != null) {
            for (SAnnotation fromSAnno : from.getAnnotations()) {
                String newSName = fromSAnno.getName();
                if (to.getAnnotation(fromSAnno.getQName()) != null) {
                    int i = 1;
                    while (to.getAnnotation(String.valueOf(fromSAnno.getQName()) + "_" + i) != null) {
                        ++i;
                    }
                    newSName = String.valueOf(fromSAnno.getName()) + "_" + i;
                    fromSAnno.setName(newSName);
                    to.addAnnotation(fromSAnno);
                    continue;
                }
                to.addAnnotation(fromSAnno);
            }
        }
    }

    public static void moveMetaAnnotations(SAnnotationContainer from, SAnnotationContainer to) {
        if (from != null && to != null) {
            for (SMetaAnnotation fromSAnno : from.getMetaAnnotations()) {
                String newSName = fromSAnno.getName();
                if (to.getMetaAnnotation(fromSAnno.getQName()) != null) {
                    int i = 1;
                    while (to.getMetaAnnotation(String.valueOf(fromSAnno.getQName()) + "_" + i) != null) {
                        ++i;
                    }
                    newSName = String.valueOf(fromSAnno.getName()) + "_" + i;
                    fromSAnno.setName(newSName);
                    to.addMetaAnnotation(fromSAnno);
                    continue;
                }
                to.addMetaAnnotation(fromSAnno);
            }
        }
    }

    public static Collection<String[]> unmarshalAnnotation(String marshalledString) {
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        String left = null;
        String middle = null;
        String right = null;
        if (marshalledString != null && !marshalledString.isEmpty()) {
            String[] annotations;
            String[] stringArray = annotations = marshalledString.split(";");
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String rest;
                String annotation = stringArray[n2];
                left = null;
                middle = null;
                right = null;
                String[] nsParts = annotation.split(NAMESPACE_SEPERATOR);
                if (nsParts.length > 2) {
                    throw new SaltException("The given annotation String '" + annotation + "' is not conform to language: (SNS::)?SNAME(=SVALUE)?(;SNS::SNAME=SVALUE)++");
                }
                if (nsParts.length == 2) {
                    left = nsParts[0].trim();
                    if (left.isEmpty()) {
                        left = null;
                    }
                    rest = nsParts[1].trim();
                } else {
                    rest = nsParts[0].trim();
                }
                String[] nameParts = rest.split("=");
                if (nameParts.length > 2) {
                    throw new SaltException("The given annotation String '" + annotation + "' is not conform to language: (SNS::)?SNAME(=SVALUE)?(;SNS::SNAME=SVALUE)++");
                }
                if (nameParts.length == 2) {
                    middle = nameParts[0].trim();
                    if (middle.isEmpty()) {
                        middle = null;
                    }
                    if ((right = nameParts[1].trim()).isEmpty()) {
                        right = null;
                    }
                } else {
                    middle = nameParts[0].trim();
                    if (middle.isEmpty()) {
                        middle = null;
                    }
                }
                String[] triple = new String[]{left, middle, right};
                retVal.add(triple);
                ++n2;
            }
        }
        return retVal;
    }

    public static <S> Diff.Builder<S> compare(S saltElement) {
        return new Diff.Builder<S>(saltElement);
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotNullOrEmpty(Collection<T> collection) {
        return !SaltUtil.isNullOrEmpty(collection);
    }

    public static boolean belongsToCorpusStructure(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof SCorpusGraph) {
            return true;
        }
        if (element instanceof SCorpus) {
            return true;
        }
        if (element instanceof SDocument) {
            return true;
        }
        if (element instanceof SCorpusRelation) {
            return true;
        }
        return element instanceof SCorpusDocumentRelation;
    }

    public static <T> Validator.Builder<T> validate(T saltObject) {
        return new Validator.Builder<T>(saltObject);
    }
}

