/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.util.SaltUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SAnnotationContainerTest {
    protected SAnnotationContainer fixture = null;

    public SAnnotationContainer getFixture() {
        return this.fixture;
    }

    public void setFixture(SAnnotationContainer fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        throw new UnsupportedOperationException("Please implement method setUp() to run tests. ");
    }

    @After
    public void tearDown() throws Exception {
        this.setFixture(null);
    }

    @Test
    public void testGetAnnotations() {
        String[] qNames = new String[]{"ns::name1", "ns::name2", "ns::name3", "ns::name4"};
        ArrayList<SAnnotation> annos = new ArrayList<SAnnotation>();
        for (String qName : qNames) {
            SAnnotation anno = SaltFactory.createSAnnotation();
            anno.setQName(qName);
            this.getFixture().addAnnotation(anno);
            annos.add(anno);
        }
        Assert.assertTrue((boolean)annos.containsAll(this.getFixture().getAnnotations()));
        Assert.assertTrue((boolean)this.getFixture().getAnnotations().containsAll(annos));
    }

    @Test
    public void testAddSAnnotation() {
        String QName = "ns::name";
        SAnnotation anno = SaltFactory.createSAnnotation();
        anno.setQName(QName);
        this.getFixture().addAnnotation(anno);
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getAnnotation(QName));
    }

    @Test
    public void testCreateAnnotations() {
        String annotationString = "blub";
        this.getFixture().createAnnotations(annotationString);
        Assert.assertNotNull((Object)this.getFixture().getAnnotation("blub"));
        annotationString = "myNS::bla=blub;foo;x=y";
        this.getFixture().createAnnotations(annotationString);
        Assert.assertNotNull((Object)this.getFixture().getAnnotations());
        Assert.assertEquals((long)4L, (long)this.getFixture().getAnnotations().size());
        Assert.assertNotNull((Object)this.getFixture().getAnnotation("myNS::bla"));
        Assert.assertEquals((Object)"blub", (Object)this.getFixture().getAnnotation("myNS::bla").getValue());
        Assert.assertNotNull((Object)this.getFixture().getAnnotation("foo"));
        Assert.assertNotNull((Object)this.getFixture().getAnnotation("x"));
        Assert.assertEquals((Object)"y", (Object)this.getFixture().getAnnotation("x").getValue());
    }

    @Test
    public void testCreateSAnnotation() {
        String name = "name";
        String namespace = "namespace";
        String value = "value";
        SAnnotation anno = this.getFixture().createAnnotation(namespace, name, (Object)value);
        Assert.assertEquals((long)1L, (long)this.getFixture().getAnnotations().size());
        Assert.assertTrue((boolean)this.getFixture().getAnnotations().contains(anno));
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getAnnotation(SaltUtil.createQName((String)namespace, (String)name)));
    }

    @Test
    public void testDoubleChaining_SAnnotation() {
        SAnnotation anno = SaltFactory.createSAnnotation();
        anno.setName("labelName");
        this.getFixture().addLabel((Label)anno);
        Assert.assertEquals((Object)this.getFixture(), (Object)anno.getContainer());
    }

    @Test
    public void testIterator_SAnnotation() {
        HashSet<SAnnotation> annos = new HashSet<SAnnotation>();
        annos.add(this.getFixture().createAnnotation("stts", "pos", (Object)"VVFIN"));
        this.getFixture().createMetaAnnotation(null, "meta1", (Object)"val1");
        this.getFixture().createMetaAnnotation(null, "meta2", (Object)"val2");
        annos.add(this.getFixture().createAnnotation(null, "lemma", (Object)"go"));
        annos.add(this.getFixture().createAnnotation(null, "text", (Object)"went"));
        this.getFixture().createMetaAnnotation(null, "meta3", (Object)"val3");
        annos.add(this.getFixture().createAnnotation(null, "other", null));
        Iterator it = this.getFixture().iterator_SAnnotation();
        HashSet itAnnos = new HashSet();
        while (it.hasNext()) {
            itAnnos.add(it.next());
        }
        Assert.assertEquals((long)itAnnos.size(), (long)annos.size());
        Assert.assertTrue((boolean)itAnnos.containsAll(annos));
        Assert.assertTrue((boolean)annos.containsAll(itAnnos));
    }

    @Test
    public void testGetMetaAnnotations() {
        String[] qNames = new String[]{"ns::name1", "ns::name2", "ns::name3", "ns::name4"};
        ArrayList<SMetaAnnotation> annos = new ArrayList<SMetaAnnotation>();
        for (String qName : qNames) {
            SMetaAnnotation anno = SaltFactory.createSMetaAnnotation();
            anno.setQName(qName);
            this.getFixture().addMetaAnnotation(anno);
            annos.add(anno);
        }
        Assert.assertTrue((boolean)annos.containsAll(this.getFixture().getMetaAnnotations()));
        Assert.assertTrue((boolean)this.getFixture().getMetaAnnotations().containsAll(annos));
    }

    @Test
    public void testAddSMetaAnnotation() {
        String QName = "ns::name";
        SMetaAnnotation anno = SaltFactory.createSMetaAnnotation();
        anno.setQName(QName);
        this.getFixture().addMetaAnnotation(anno);
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getMetaAnnotation(QName));
    }

    @Test
    public void testCreateMetaAnnotations() {
        String MetaAnnotationString = "blub";
        this.getFixture().createMetaAnnotations(MetaAnnotationString);
        Assert.assertNotNull((Object)this.getFixture().getMetaAnnotation("blub"));
        MetaAnnotationString = "myNS::bla=blub;foo;x=y";
        this.getFixture().createMetaAnnotations(MetaAnnotationString);
        Assert.assertNotNull((Object)this.getFixture().getMetaAnnotations());
        Assert.assertEquals((long)4L, (long)this.getFixture().getMetaAnnotations().size());
        Assert.assertNotNull((Object)this.getFixture().getMetaAnnotation("myNS::bla"));
        Assert.assertEquals((Object)"blub", (Object)this.getFixture().getMetaAnnotation("myNS::bla").getValue());
        Assert.assertNotNull((Object)this.getFixture().getMetaAnnotation("foo"));
        Assert.assertNotNull((Object)this.getFixture().getMetaAnnotation("x"));
        Assert.assertEquals((Object)"y", (Object)this.getFixture().getMetaAnnotation("x").getValue());
    }

    @Test
    public void testCreateSMetaAnnotation() {
        String name = "name";
        String namespace = "namespace";
        String value = "value";
        SMetaAnnotation anno = this.getFixture().createMetaAnnotation(namespace, name, (Object)value);
        Assert.assertEquals((long)1L, (long)this.getFixture().getMetaAnnotations().size());
        Assert.assertTrue((boolean)this.getFixture().getMetaAnnotations().contains(anno));
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getMetaAnnotation(SaltUtil.createQName((String)namespace, (String)name)));
    }

    @Test
    public void testDoubleChaining_SMetaAnnotation() {
        SMetaAnnotation anno = SaltFactory.createSMetaAnnotation();
        anno.setName("labelName");
        this.getFixture().addLabel((Label)anno);
        Assert.assertEquals((Object)this.getFixture(), (Object)anno.getContainer());
    }

    @Test
    public void testIterator_SMetaAnnotation() {
        HashSet<SMetaAnnotation> metaAnnos = new HashSet<SMetaAnnotation>();
        this.getFixture().createAnnotation("stts", "pos", (Object)"VVFIN");
        metaAnnos.add(this.getFixture().createMetaAnnotation(null, "meta1", (Object)"val1"));
        metaAnnos.add(this.getFixture().createMetaAnnotation(null, "meta2", (Object)"val2"));
        this.getFixture().createAnnotation(null, "lemma", (Object)"go");
        this.getFixture().createAnnotation(null, "text", (Object)"went");
        metaAnnos.add(this.getFixture().createMetaAnnotation(null, "meta3", (Object)"val3"));
        this.getFixture().createAnnotation(null, "other", null);
        Iterator it = this.getFixture().iterator_SMetaAnnotation();
        HashSet itAnnos = new HashSet();
        while (it.hasNext()) {
            itAnnos.add(it.next());
        }
        Assert.assertEquals((long)itAnnos.size(), (long)metaAnnos.size());
        Assert.assertTrue((boolean)itAnnos.containsAll(metaAnnos));
        Assert.assertTrue((boolean)metaAnnos.containsAll(itAnnos));
    }

    @Test
    public void testGetProcessingAnnotations() {
        String[] qNames = new String[]{"ns::name1", "ns::name2", "ns::name3", "ns::name4"};
        ArrayList<SProcessingAnnotation> annos = new ArrayList<SProcessingAnnotation>();
        for (String qName : qNames) {
            SProcessingAnnotation anno = SaltFactory.createSProcessingAnnotation();
            anno.setQName(qName);
            this.getFixture().addProcessingAnnotation(anno);
            annos.add(anno);
        }
        Assert.assertTrue((boolean)annos.containsAll(this.getFixture().getProcessingAnnotations()));
        Assert.assertTrue((boolean)this.getFixture().getProcessingAnnotations().containsAll(annos));
    }

    @Test
    public void testAddSProcessingAnnotation() {
        String QName = "ns::name";
        SProcessingAnnotation anno = SaltFactory.createSProcessingAnnotation();
        anno.setQName(QName);
        this.getFixture().addProcessingAnnotation(anno);
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getProcessingAnnotation(QName));
    }

    @Test
    public void testCreateProcessingAnnotations() {
        String ProcessingAnnotationString = "blub";
        this.getFixture().createProcessingAnnotations(ProcessingAnnotationString);
        Assert.assertNotNull((Object)this.getFixture().getProcessingAnnotation("blub"));
        ProcessingAnnotationString = "myNS::bla=blub;foo;x=y";
        this.getFixture().createProcessingAnnotations(ProcessingAnnotationString);
        Assert.assertNotNull((Object)this.getFixture().getProcessingAnnotations());
        Assert.assertEquals((long)4L, (long)this.getFixture().getProcessingAnnotations().size());
        Assert.assertNotNull((Object)this.getFixture().getProcessingAnnotation("myNS::bla"));
        Assert.assertEquals((Object)"blub", (Object)this.getFixture().getProcessingAnnotation("myNS::bla").getValue());
        Assert.assertNotNull((Object)this.getFixture().getProcessingAnnotation("foo"));
        Assert.assertNotNull((Object)this.getFixture().getProcessingAnnotation("x"));
        Assert.assertEquals((Object)"y", (Object)this.getFixture().getProcessingAnnotation("x").getValue());
    }

    @Test
    public void testCreateSProcessingAnnotation() {
        String name = "name";
        String namespace = "namespace";
        String value = "value";
        SProcessingAnnotation anno = this.getFixture().createProcessingAnnotation(namespace, name, (Object)value);
        Assert.assertEquals((long)1L, (long)this.getFixture().getProcessingAnnotations().size());
        Assert.assertTrue((boolean)this.getFixture().getProcessingAnnotations().contains(anno));
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getProcessingAnnotation(SaltUtil.createQName((String)namespace, (String)name)));
    }

    @Test
    public void testDoubleChaining_SProcessingAnnotation() {
        SProcessingAnnotation anno = SaltFactory.createSProcessingAnnotation();
        anno.setName("labelName");
        this.getFixture().addLabel((Label)anno);
        Assert.assertEquals((Object)this.getFixture(), (Object)anno.getContainer());
    }

    @Test
    public void testGetFeatures() {
        String[] qNames = new String[]{"ns::name1", "ns::name2", "ns::name3", "ns::name4"};
        ArrayList<SFeature> annos = new ArrayList<SFeature>();
        for (String qName : qNames) {
            SFeature anno = SaltFactory.createSFeature();
            anno.setQName(qName);
            this.getFixture().addFeature(anno);
            annos.add(anno);
        }
        Assert.assertTrue((boolean)annos.containsAll(this.getFixture().getFeatures()));
        Assert.assertTrue((boolean)this.getFixture().getFeatures().containsAll(annos));
    }

    @Test
    public void testAddSFeature() {
        String QName = "ns::name";
        SFeature anno = SaltFactory.createSFeature();
        anno.setQName(QName);
        this.getFixture().addFeature(anno);
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getFeature(QName));
    }

    @Test
    public void testCreateFeatures() {
        String FeatureString = "blub";
        this.getFixture().createFeatures(FeatureString);
        Assert.assertNotNull((Object)this.getFixture().getFeature("blub"));
        FeatureString = "myNS::bla=blub;foo;x=y";
        this.getFixture().createFeatures(FeatureString);
        Assert.assertNotNull((Object)this.getFixture().getFeatures());
        Assert.assertEquals((long)4L, (long)this.getFixture().getFeatures().size());
        Assert.assertNotNull((Object)this.getFixture().getFeature("myNS::bla"));
        Assert.assertEquals((Object)"blub", (Object)this.getFixture().getFeature("myNS::bla").getValue());
        Assert.assertNotNull((Object)this.getFixture().getFeature("foo"));
        Assert.assertNotNull((Object)this.getFixture().getFeature("x"));
        Assert.assertEquals((Object)"y", (Object)this.getFixture().getFeature("x").getValue());
    }

    @Test
    public void testCreateSFeature() {
        String name = "name";
        String namespace = "namespace";
        String value = "value";
        SFeature anno = this.getFixture().createFeature(namespace, name, (Object)value);
        Assert.assertEquals((long)1L, (long)this.getFixture().getFeatures().size());
        Assert.assertTrue((boolean)this.getFixture().getFeatures().contains(anno));
        Assert.assertEquals((Object)anno, (Object)this.getFixture().getFeature(SaltUtil.createQName((String)namespace, (String)name)));
    }

    @Test
    public void testDoubleChaining_SFeature() {
        SFeature anno = SaltFactory.createSFeature();
        anno.setName("labelName");
        this.getFixture().addLabel((Label)anno);
        Assert.assertEquals((Object)this.getFixture(), (Object)anno.getContainer());
    }
}

