/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.delegator.tests;

import java.util.Set;
import org.corpus_tools.salt.ISaltFactory;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.delegator.tests.DelegatorTestFactory;
import org.corpus_tools.salt.impl.SaltFactoryImpl;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegationCreationTest {
    @Before
    public void setUp() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new SaltFactoryImpl());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof SaltFactoryImpl));
    }

    @After
    public void tearDown() throws Exception {
        SaltFactory.setFactory((ISaltFactory)new SaltFactoryImpl());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof SaltFactoryImpl));
    }

    @Test
    public void testDelegatedPrimaryData() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createPrimaryData((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createPrimaryData((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedTokens() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedMorphologyAnnotations() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createMorphologyAnnotations((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createMorphologyAnnotations((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedInformationStructureSpan() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createInformationStructureSpan((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createInformationStructureSpan((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedInformationStructureAnnotations() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createInformationStructureAnnotations((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createInformationStructureAnnotations((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedSyntaxStructure() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxStructure((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxStructure((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedSyntaxAnnotations() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxAnnotations((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxAnnotations((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedAnaphoricAnnotations() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createAnaphoricAnnotations((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createAnaphoricAnnotations((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }

    @Test
    public void testDelegatedDocumentStructure() {
        SDocument template_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)template_doc);
        SaltFactory.setFactory((ISaltFactory)new DelegatorTestFactory());
        Assert.assertTrue((boolean)(SaltFactory.getFactory() instanceof DelegatorTestFactory));
        SDocument fixture_doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)fixture_doc);
        Set diffs = template_doc.getDocumentGraph().findDiffs(fixture_doc.getDocumentGraph());
        Assert.assertEquals((String)("" + diffs), (long)0L, (long)diffs.size());
    }
}

