/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.junit.Assert;
import org.junit.Test;

public class SaltUtilTest {
    @Test
    public void testMoveSMetaAnnotations() throws Exception {
        SCorpus sCorp = SaltFactory.createSCorpus();
        SDocument sDoc = SaltFactory.createSDocument();
        String annoName = "metaAnno";
        String annoValue = "metaValue";
        sCorp.createMetaAnnotation(null, annoName, (Object)annoValue);
        SaltUtil.moveMetaAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)sDoc);
        Assert.assertNull((Object)sCorp.getMetaAnnotation(annoName));
        Assert.assertEquals((long)1L, (long)sDoc.getMetaAnnotations().size());
        Assert.assertNotNull((Object)sDoc.getMetaAnnotation(annoName));
        Assert.assertEquals((Object)annoName, (Object)sDoc.getMetaAnnotation(annoName).getName());
        Assert.assertEquals((Object)annoValue, (Object)sDoc.getMetaAnnotation(annoName).getValue());
        sCorp = SaltFactory.createSCorpus();
        String annoName2 = "metaAnno";
        String annoValue2 = "metaValue_1";
        sCorp.createMetaAnnotation(null, annoName2, (Object)annoValue2);
        SaltUtil.moveMetaAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)sDoc);
        Assert.assertEquals((long)2L, (long)sDoc.getMetaAnnotations().size());
        Assert.assertNotNull((Object)sDoc.getMetaAnnotation(annoName2));
        Assert.assertEquals((Object)(annoName2 + "_1"), (Object)sDoc.getMetaAnnotation(annoName2 + "_1").getName());
        Assert.assertEquals((Object)annoValue2, (Object)sDoc.getMetaAnnotation(annoName2 + "_1").getValue());
    }

    @Test
    public void testMoveSAnnotations() throws Exception {
        SCorpus sCorp = SaltFactory.createSCorpus();
        SDocument sDoc = SaltFactory.createSDocument();
        String annoName = "anno";
        String annoValue = "value";
        sCorp.createAnnotation(null, annoName, (Object)annoValue);
        SaltUtil.moveAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)sDoc);
        Assert.assertNull((Object)sCorp.getAnnotation(annoName));
        Assert.assertEquals((long)1L, (long)sDoc.getAnnotations().size());
        Assert.assertNotNull((Object)sDoc.getAnnotation(annoName));
        Assert.assertEquals((Object)annoName, (Object)sDoc.getAnnotation(annoName).getName());
        Assert.assertEquals((Object)annoValue, (Object)sDoc.getAnnotation(annoName).getValue());
        sCorp = SaltFactory.createSCorpus();
        String annoName2 = "anno";
        String annoValue2 = "value_1";
        sCorp.createAnnotation(null, annoName2, (Object)annoValue2);
        SaltUtil.moveAnnotations((SAnnotationContainer)sCorp, (SAnnotationContainer)sDoc);
        Assert.assertEquals((long)2L, (long)sDoc.getAnnotations().size());
        Assert.assertNotNull((Object)sDoc.getAnnotation(annoName2));
        Assert.assertEquals((Object)(annoName2 + "_1"), (Object)sDoc.getAnnotation(annoName2 + "_1").getName());
        Assert.assertEquals((Object)annoValue2, (Object)sDoc.getAnnotation(annoName2 + "_1").getValue());
    }

    @Test
    public void testCreateSaltURI() {
        SaltProject project = SaltFactory.createSaltProject();
        SCorpusGraph graph = SaltFactory.createSCorpusGraph();
        project.addCorpusGraph(graph);
        SCorpus corp1 = SaltFactory.createSCorpus();
        corp1.setName("corp1");
        graph.addNode((Node)corp1);
        URI path = SaltUtil.createSaltURI((String)corp1.getId());
        Assert.assertEquals((Object)URI.createURI((String)"salt:/corp1"), (Object)path);
        SCorpus corp2 = graph.createCorpus(corp1, "corp2");
        path = SaltUtil.createSaltURI((String)corp2.getId());
        Assert.assertEquals((Object)URI.createURI((String)"salt:/corp1/corp2"), (Object)path);
        SDocument doc1 = graph.createDocument(corp2, "doc1");
        path = SaltUtil.createSaltURI((String)doc1.getId());
        Assert.assertEquals((Object)URI.createURI((String)"salt:/corp1/corp2/doc1"), (Object)path);
    }

    @Test
    public void testUnmarshalAnnotation() {
        Collection triples = SaltUtil.unmarshalAnnotation((String)"salt::pos=NN");
        Assert.assertEquals((long)1L, (long)triples.size());
        Assert.assertEquals((Object)"salt", (Object)((String[])triples.iterator().next())[0]);
        Assert.assertEquals((Object)"pos", (Object)((String[])triples.iterator().next())[1]);
        Assert.assertEquals((Object)"NN", (Object)((String[])triples.iterator().next())[2]);
        triples = SaltUtil.unmarshalAnnotation((String)" salt  ::  pos  =  NN ");
        Assert.assertEquals((long)1L, (long)triples.size());
        Assert.assertEquals((Object)"salt", (Object)((String[])triples.iterator().next())[0]);
        Assert.assertEquals((Object)"pos", (Object)((String[])triples.iterator().next())[1]);
        Assert.assertEquals((Object)"NN", (Object)((String[])triples.iterator().next())[2]);
        triples = SaltUtil.unmarshalAnnotation((String)" pos  =  NN ");
        Assert.assertEquals((long)1L, (long)triples.size());
        Assert.assertNull((Object)((String[])triples.iterator().next())[0]);
        Assert.assertEquals((Object)"pos", (Object)((String[])triples.iterator().next())[1]);
        Assert.assertEquals((Object)"NN", (Object)((String[])triples.iterator().next())[2]);
        triples = SaltUtil.unmarshalAnnotation((String)" pos");
        Assert.assertEquals((long)1L, (long)triples.size());
        Assert.assertNull((Object)((String[])triples.iterator().next())[0]);
        Assert.assertEquals((Object)"pos", (Object)((String[])triples.iterator().next())[1]);
        Assert.assertNull((Object)((String[])triples.iterator().next())[2]);
        triples = SaltUtil.unmarshalAnnotation((String)" salt :: ");
        Assert.assertEquals((long)1L, (long)triples.size());
        Assert.assertEquals((Object)"salt", (Object)((String[])triples.iterator().next())[0]);
        Assert.assertNull((Object)((String[])triples.iterator().next())[1]);
        Assert.assertNull((Object)((String[])triples.iterator().next())[2]);
        triples = SaltUtil.unmarshalAnnotation((String)" salt  ::  pos  =  NN ; other  ::  lemma  =  I");
        Assert.assertEquals((long)2L, (long)triples.size());
        for (String[] triple : triples) {
            if ("salt".equals(triple[0])) {
                Assert.assertEquals((Object)"pos", (Object)triple[1]);
                Assert.assertEquals((Object)"NN", (Object)triple[2]);
                continue;
            }
            if (!"other".equals(triple[0])) continue;
            Assert.assertEquals((Object)"lemma", (Object)triple[1]);
            Assert.assertEquals((Object)"I", (Object)triple[2]);
        }
    }

    @Test
    public void whenElementBelongsToCorpusStructure_thenReturnTrue() {
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSCorpusGraph())).isTrue();
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSCorpus())).isTrue();
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSDocument())).isTrue();
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSCorpusRelation())).isTrue();
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSCorpusDocumentRelation())).isTrue();
    }

    @Test
    public void whenElementDoesNotBelongToCorpusStructure_thenReturnFalse() {
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)new Object())).isFalse();
        Assertions.assertThat((boolean)SaltUtil.belongsToCorpusStructure((Object)SaltFactory.createSToken())).isFalse();
    }
}

