/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.persistence.tests;

import java.io.File;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.tests.SaltTestsUtil;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.junit.Assert;
import org.junit.Test;

public class DOTStoringTest {
    @Test
    public void testSave_SDocumentGraph() {
        URI uri = URI.createFileURI((String)SaltTestsUtil.getTempTestFolder("document").getAbsolutePath());
        String docName = "doc1";
        SDocument sDocument = SaltFactory.createSDocument();
        sDocument.setName(docName);
        SampleGenerator.createDocumentStructure((SDocument)sDocument);
        SaltUtil.save_DOT((Object)sDocument, (URI)uri);
        Assert.assertTrue((boolean)new File(uri.toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.toFileString()).isDirectory());
        Assert.assertTrue((boolean)new File(uri.appendSegment(docName).appendFileExtension("dot").toFileString()).exists());
        uri = URI.createFileURI((String)SaltTestsUtil.getTempTestFolder().getAbsolutePath()).appendSegment(docName).appendFileExtension("dot");
        SaltUtil.save_DOT((Object)sDocument, (URI)uri);
        Assert.assertTrue((boolean)new File(uri.toFileString()).exists());
    }

    @Test
    public void testSave_SCorpusGraph() {
        URI uri = URI.createFileURI((String)SaltTestsUtil.getTempTestFolder("corpusGraph").getAbsolutePath());
        SCorpusGraph sCorpGraph = SampleGenerator.createCorpusStructure();
        SaltUtil.save_DOT((Object)sCorpGraph, (URI)uri);
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendFileExtension("dot").toFileString()).exists());
    }

    @Test
    public void testSave_SProject() {
        URI uri = URI.createFileURI((String)SaltTestsUtil.getTempTestFolder("salt_project").getAbsolutePath());
        SaltProject saltProject = SampleGenerator.createSaltProject();
        SaltUtil.save_DOT((Object)saltProject, (URI)uri);
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendSegment("subCorpus1").appendSegment("doc1").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendSegment("subCorpus1").appendSegment("doc2").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendSegment("subCorpus2").appendSegment("doc3").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("rootCorpus").appendSegment("subCorpus2").appendSegment("doc4").appendFileExtension("dot").toFileString()).exists());
    }

    @Test
    public void testSave_SProject2() {
        URI uri = URI.createFileURI((String)SaltTestsUtil.getTempTestFolder("salt_project2").getAbsolutePath());
        SaltProject saltProject = SampleGenerator.createSaltProject();
        saltProject.addCorpusGraph(SampleGenerator.createCorpusStructure());
        SaltUtil.save_DOT((Object)saltProject, (URI)uri);
        Assert.assertTrue((boolean)new File(uri.appendSegment("0").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("0").appendSegment("rootCorpus").appendSegment("subCorpus1").appendSegment("doc1").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("0").appendSegment("rootCorpus").appendSegment("subCorpus1").appendSegment("doc2").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("0").appendSegment("rootCorpus").appendSegment("subCorpus2").appendSegment("doc3").appendFileExtension("dot").toFileString()).exists());
        Assert.assertTrue((boolean)new File(uri.appendSegment("0").appendSegment("rootCorpus").appendSegment("subCorpus2").appendSegment("doc4").appendFileExtension("dot").toFileString()).exists());
    }
}

