/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl.tests;

import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNamedElement;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.core.impl.tests.SAnnotationContainerTest;
import org.corpus_tools.salt.core.impl.tests.TestHelper;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SGraphTest
extends SAnnotationContainerTest {
    public SGraph getFixture() {
        return (SGraph)super.getFixture();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.setFixture((SAnnotationContainer)SaltFactory.createSGraph());
    }

    @Test
    public void testGetName() {
        TestHelper.testGetName((SNamedElement)this.getFixture());
    }

    @Test
    public void testGetRoots() {
        ArrayList<Node> expectedRoots = null;
        List roots = null;
        SGraph graph = null;
        graph = TestHelper.createGraph_Tree();
        this.setFixture((SAnnotationContainer)graph);
        expectedRoots = new ArrayList<Node>();
        expectedRoots.add(graph.getNode("node1"));
        roots = this.getFixture().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (SNode sNode : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + sNode.getId() + "'."), (boolean)roots.contains(sNode));
        }
        graph = TestHelper.createGraph_DAG();
        this.setFixture((SAnnotationContainer)graph);
        expectedRoots = new ArrayList();
        expectedRoots.add(graph.getNode("node1"));
        expectedRoots.add(graph.getNode("node4"));
        roots = this.getFixture().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (SNode sNode : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + sNode.getId() + "'."), (boolean)roots.contains(sNode));
        }
        graph = TestHelper.createGraph_Cycle();
        this.setFixture((SAnnotationContainer)graph);
        expectedRoots = new ArrayList();
        expectedRoots.add(graph.getNode("node1"));
        expectedRoots.add(graph.getNode("node4"));
        roots = this.getFixture().getRoots();
        Assert.assertEquals((String)"The expected number of roots are not the same, as the returned number", (long)expectedRoots.size(), (long)roots.size());
        for (SNode sNode : expectedRoots) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected root '" + sNode.getId() + "'."), (boolean)roots.contains(sNode));
        }
    }

    @Test
    public void testGetLeafs() {
        ArrayList<Node> expectedLeafs = null;
        List leafs = null;
        SGraph graph = null;
        graph = TestHelper.createGraph_Tree();
        this.setFixture((SAnnotationContainer)graph);
        expectedLeafs = new ArrayList<Node>();
        expectedLeafs.add(graph.getNode("node3"));
        expectedLeafs.add(graph.getNode("node6"));
        expectedLeafs.add(graph.getNode("node5"));
        expectedLeafs.add(graph.getNode("node7"));
        leafs = this.getFixture().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (SNode sNode : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected leaf '" + sNode.getId() + "'."), (boolean)leafs.contains(sNode));
        }
        graph = TestHelper.createGraph_DAG();
        this.setFixture((SAnnotationContainer)graph);
        expectedLeafs = new ArrayList();
        expectedLeafs.add(graph.getNode("node3"));
        expectedLeafs.add(graph.getNode("node6"));
        leafs = this.getFixture().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (SNode sNode : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned leafs does not contain expected leaf '" + sNode.getId() + "'."), (boolean)leafs.contains(sNode));
        }
        graph = TestHelper.createGraph_Cycle();
        this.setFixture((SAnnotationContainer)graph);
        expectedLeafs = new ArrayList();
        expectedLeafs.add(graph.getNode("node3"));
        leafs = this.getFixture().getLeafs();
        Assert.assertEquals((String)"The expected number of leafs are not the same, as the returned number", (long)expectedLeafs.size(), (long)leafs.size());
        for (SNode sNode : expectedLeafs) {
            Assert.assertTrue((String)("The list of returned roots does not contain expected leaf '" + sNode.getId() + "'."), (boolean)leafs.contains(sNode));
        }
    }

    @Test
    public void testGetLayersByName() {
        SLayer layer = SaltFactory.createSLayer();
        layer.setName("one");
        this.getFixture().addLayer((Layer)layer);
        layer = SaltFactory.createSLayer();
        layer.setName("two");
        this.getFixture().addLayer((Layer)layer);
        layer = SaltFactory.createSLayer();
        layer.setName("one");
        this.getFixture().addLayer((Layer)layer);
        layer = SaltFactory.createSLayer();
        layer.setName("three");
        this.getFixture().addLayer((Layer)layer);
        Assert.assertEquals((long)2L, (long)this.getFixture().getLayerByName("one").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayerByName("two").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayerByName("three").size());
    }

    @Test
    public void testGetNodesByName() {
        SNode node = SaltFactory.createSNode();
        node.setName("one");
        this.getFixture().addNode((Node)node);
        node = SaltFactory.createSNode();
        node.setName("two");
        this.getFixture().addNode((Node)node);
        node = SaltFactory.createSNode();
        node.setName("one");
        this.getFixture().addNode((Node)node);
        node = SaltFactory.createSNode();
        node.setName("three");
        this.getFixture().addNode((Node)node);
        Assert.assertEquals((long)2L, (long)this.getFixture().getNodesByName("one").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodesByName("two").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getNodesByName("three").size());
    }

    @Test
    public void testGetRelationsByName() {
        SNode node = SaltFactory.createSNode();
        this.getFixture().addNode((Node)node);
        SRelation rel = SaltFactory.createSRelation();
        rel.setSource((Node)node);
        rel.setTarget((Node)node);
        rel.setName("one");
        this.getFixture().addRelation((Relation)rel);
        rel = SaltFactory.createSRelation();
        rel.setName("two");
        rel.setSource((Node)node);
        rel.setTarget((Node)node);
        this.getFixture().addRelation((Relation)rel);
        rel = SaltFactory.createSRelation();
        rel.setSource((Node)node);
        rel.setTarget((Node)node);
        rel.setName("one");
        this.getFixture().addRelation((Relation)rel);
        rel = SaltFactory.createSRelation();
        rel.setSource((Node)node);
        rel.setTarget((Node)node);
        rel.setName("three");
        this.getFixture().addRelation((Relation)rel);
        Assert.assertEquals((long)2L, (long)this.getFixture().getRelationsByName("one").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelationsByName("two").size());
        Assert.assertEquals((long)1L, (long)this.getFixture().getRelationsByName("three").size());
    }
}

