/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.internal.CorpusStructureDiff;
import org.corpus_tools.salt.util.internal.DocumentStructureDiff;
import org.corpus_tools.salt.util.internal.SaltProjectDiff;

public class Diff {
    private DocumentStructureDiff documentStructureDiff = null;
    private CorpusStructureDiff corpusStructureDiff = null;
    private SaltProjectDiff saltProjectDiff = null;

    public Diff(SDocumentGraph template, SDocumentGraph other) {
        this(template, other, (DiffOptions)null);
    }

    public Diff(SDocumentGraph template, SDocumentGraph other, DiffOptions optionMap) {
        this.documentStructureDiff = new DocumentStructureDiff(template, other, optionMap);
    }

    @Deprecated
    public Diff(SDocumentGraph template, SDocumentGraph other, Map<String, Boolean> optionMap) {
        DiffOptions options = new DiffOptions();
        options.putAll(optionMap);
        this.documentStructureDiff = new DocumentStructureDiff(template, other, options);
    }

    public Diff(SCorpusGraph template, SCorpusGraph other) {
        this(template, other, (DiffOptions)null);
    }

    public Diff(SCorpusGraph template, SCorpusGraph other, DiffOptions optionMap) {
        this.corpusStructureDiff = new CorpusStructureDiff(template, other, optionMap);
    }

    public Diff(SaltProject template, SaltProject other, DiffOptions optionMap) {
        this.saltProjectDiff = new SaltProjectDiff(template, other, optionMap);
    }

    @Deprecated
    public Diff(SCorpusGraph template, SCorpusGraph other, Map<String, Boolean> optionMap) {
        DiffOptions options = new DiffOptions();
        options.putAll(optionMap);
        this.corpusStructureDiff = new CorpusStructureDiff(template, other, options);
    }

    public boolean isIsomorph() {
        if (this.documentStructureDiff != null) {
            return this.documentStructureDiff.isIsomorph();
        }
        if (this.corpusStructureDiff != null) {
            return this.corpusStructureDiff.isIsomorph();
        }
        return this.saltProjectDiff.isIsomorph();
    }

    public Set<Difference> findDiffs() {
        if (this.documentStructureDiff != null) {
            return this.documentStructureDiff.findDiffs();
        }
        if (this.corpusStructureDiff != null) {
            return this.corpusStructureDiff.findDiffs();
        }
        return this.saltProjectDiff.findDiffs();
    }

    public static class Builder<S> {
        private final S saltElement;

        public Builder(S templateGraph) {
            this.saltElement = templateGraph;
        }

        public Builder2<S> with(S otherGraph) {
            return new Builder2<S>(this.saltElement, otherGraph);
        }

        public static class Builder2<S> {
            private final S templateObject;
            private final S otherObject;
            private DiffOptions options = new DiffOptions();

            public Builder2(S templateGraph, S otherGraph) {
                this.templateObject = templateGraph;
                this.otherObject = otherGraph;
            }

            public boolean andCheckIsomorphie() {
                if (this.templateObject == null || this.otherObject == null) {
                    return false;
                }
                if (this.templateObject instanceof SDocumentGraph && this.otherObject instanceof SDocumentGraph) {
                    return new Diff((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject, this.options).isIsomorph();
                }
                if (this.templateObject instanceof SCorpusGraph && this.otherObject instanceof SCorpusGraph) {
                    return new Diff((SCorpusGraph)this.templateObject, (SCorpusGraph)this.otherObject, this.options).isIsomorph();
                }
                if (this.templateObject instanceof SaltProject && this.otherObject instanceof SaltProject) {
                    return new Diff((SaltProject)this.templateObject, (SaltProject)this.otherObject, this.options).isIsomorph();
                }
                throw new SaltException("Cannot compare peaches with appels. ");
            }

            public Set<Difference> andFindDiffs() {
                if (this.templateObject == null || this.otherObject == null) {
                    return Sets.newHashSet((Object[])new Difference[]{new Difference(null, null, null, DIFF_TYPES.NULL_OBJECT)});
                }
                if (this.templateObject instanceof SDocumentGraph && this.otherObject instanceof SDocumentGraph) {
                    return new Diff((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject, this.options).findDiffs();
                }
                if (this.templateObject instanceof SCorpusGraph && this.otherObject instanceof SCorpusGraph) {
                    return new Diff((SCorpusGraph)this.templateObject, (SCorpusGraph)this.otherObject, this.options).findDiffs();
                }
                if (this.templateObject instanceof SaltProject && this.otherObject instanceof SaltProject) {
                    return new Diff((SaltProject)this.templateObject, (SaltProject)this.otherObject, this.options).findDiffs();
                }
                throw new SaltException("Cannot compare peaches with appels. ");
            }

            public Builder2<S> useOption(String option) {
                this.options.put(option, true);
                return this;
            }

            public Builder2<S> useOption(String option, boolean value) {
                this.options.put(option, value);
                return this;
            }

            public Builder2<S> useOptions(DiffOptions options) {
                this.options = options;
                return this;
            }
        }
    }
}

