/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl.tests;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltElementNotInGraphException;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.Diff;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SDocumentGraphTest {
    protected SDocumentGraph fixture = null;

    public SDocumentGraph getFixture() {
        return this.fixture;
    }

    public void setFixture(SDocumentGraph fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(SaltFactory.createSDocumentGraph());
    }

    @Test
    public void testSetGetDocument() {
        Assert.assertNull((Object)this.getFixture().getDocument());
        SDocument document = SaltFactory.createSDocument();
        this.getFixture().setDocument(document);
        Assert.assertNotNull((Object)this.getFixture().getDocument());
        Assert.assertEquals((Object)document, (Object)this.getFixture().getDocument());
        Assert.assertEquals((Object)this.getFixture(), (Object)document.getDocumentGraph());
        this.getFixture().setDocument(null);
        Assert.assertNull((Object)document.getDocumentGraph());
        Assert.assertNull((Object)this.getFixture().getDocument());
    }

    @Test
    public void testGetSTextualDSs() {
        String[] ids = new String[]{"salt:/graph1#text1", "salt:/graph1#text2", "salt:/graph1#text3", "salt:/graph1#text4"};
        ArrayList<STextualDS> textDSs = new ArrayList<STextualDS>();
        for (String id : ids) {
            STextualDS textDs = SaltFactory.createSTextualDS();
            textDs.setId(id);
            this.getFixture().addNode((Node)textDs);
            textDSs.add(textDs);
        }
        Assert.assertTrue((boolean)textDSs.containsAll(this.getFixture().getTextualDSs()));
        Assert.assertTrue((boolean)this.getFixture().getTextualDSs().containsAll(textDSs));
    }

    @Test
    public void testGetSTextualRelations() {
        String[] ids = new String[]{"salt:/graph1#textRel1", "salt:/graph1#textRel2", "salt:/graph1#textRel3", "salt:/graph1#textRel4"};
        SToken source = SaltFactory.createSToken();
        this.getFixture().addNode((Node)source);
        STextualDS target = SaltFactory.createSTextualDS();
        this.getFixture().addNode((Node)target);
        ArrayList<STextualRelation> rels = new ArrayList<STextualRelation>();
        for (String id : ids) {
            STextualRelation rel = SaltFactory.createSTextualRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            rel.setId(id);
            this.getFixture().addRelation((Relation)rel);
            rels.add(rel);
        }
        Assert.assertTrue((boolean)rels.containsAll(this.getFixture().getTextualRelations()));
        Assert.assertTrue((boolean)this.getFixture().getTextualRelations().containsAll(rels));
    }

    @Test
    public void testGetSTokens() {
        String[] ids = new String[]{"salt:/graph1#tok1", "salt:/graph1#tok2", "salt:/graph1#tok3", "salt:/graph1#tok4"};
        ArrayList<SToken> toks = new ArrayList<SToken>();
        for (String id : ids) {
            SToken tok = SaltFactory.createSToken();
            tok.setId(id);
            this.getFixture().addNode((Node)tok);
            toks.add(tok);
        }
        Assert.assertTrue((boolean)toks.containsAll(this.getFixture().getTokens()));
        Assert.assertTrue((boolean)this.getFixture().getTokens().containsAll(toks));
    }

    @Test
    public void testGetSTimelineRelations() {
        ArrayList<STimelineRelation> timeRels = new ArrayList<STimelineRelation>();
        SToken source = SaltFactory.createSToken();
        this.getFixture().addNode((Node)source);
        STimeline target = SaltFactory.createSTimeline();
        this.getFixture().addNode((Node)target);
        for (int i = 0; i < 10; ++i) {
            STimelineRelation rel = SaltFactory.createSTimelineRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            timeRels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)timeRels.containsAll(this.getFixture().getTimelineRelations()));
        Assert.assertTrue((boolean)this.getFixture().getTimelineRelations().containsAll(timeRels));
    }

    @Test
    public void testGetSSpanningRelations() {
        ArrayList<SSpanningRelation> spanRels = new ArrayList<SSpanningRelation>();
        SSpan source = SaltFactory.createSSpan();
        this.getFixture().addNode((Node)source);
        SToken target = SaltFactory.createSToken();
        this.getFixture().addNode((Node)target);
        for (int i = 0; i < 10; ++i) {
            SSpanningRelation rel = SaltFactory.createSSpanningRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            spanRels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)spanRels.containsAll(this.getFixture().getSpanningRelations()));
        Assert.assertTrue((boolean)this.getFixture().getSpanningRelations().containsAll(spanRels));
    }

    @Test
    public void testGetSSpans() {
        String[] names = new String[]{"salt:/graph1#span1", "salt:/graph1#span2", "salt:/graph1#span3", "salt:/graph1#span4"};
        ArrayList<SSpan> spans = new ArrayList<SSpan>();
        for (String name : names) {
            SSpan span = SaltFactory.createSSpan();
            span.setName(name);
            this.getFixture().addNode((Node)span);
            spans.add(span);
        }
        Assert.assertTrue((boolean)spans.containsAll(this.getFixture().getSpans()));
        Assert.assertTrue((boolean)this.getFixture().getSpans().containsAll(spans));
    }

    @Test
    public void testGetSStructures() {
        String[] names = new String[]{"salt:/graph1#structure1", "salt:/graph1#structure2", "salt:/graph1#structure3", "salt:/graph1#structure4"};
        ArrayList<SStructure> structures = new ArrayList<SStructure>();
        for (String name : names) {
            SStructure structure = SaltFactory.createSStructure();
            structure.setName(name);
            this.getFixture().addNode((Node)structure);
            structures.add(structure);
        }
        Assert.assertTrue((boolean)structures.containsAll(this.getFixture().getStructures()));
        Assert.assertTrue((boolean)this.getFixture().getStructures().containsAll(structures));
    }

    @Test
    public void testGetSDominanceRelations() {
        SStructure source = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)source);
        SStructure target = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)target);
        ArrayList<SDominanceRelation> rels = new ArrayList<SDominanceRelation>();
        for (int i = 0; i < 10; ++i) {
            SDominanceRelation rel = SaltFactory.createSDominanceRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            rels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)rels.containsAll(this.getFixture().getDominanceRelations()));
        Assert.assertTrue((boolean)this.getFixture().getDominanceRelations().containsAll(rels));
    }

    @Test
    public void testGetSPointingRelations() {
        SStructure source = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)source);
        SStructure target = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)target);
        ArrayList<SPointingRelation> rels = new ArrayList<SPointingRelation>();
        for (int i = 0; i < 10; ++i) {
            SPointingRelation rel = SaltFactory.createSPointingRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            rels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)rels.containsAll(this.getFixture().getPointingRelations()));
        Assert.assertTrue((boolean)this.getFixture().getPointingRelations().containsAll(rels));
    }

    @Test
    public void testGetSMedialRelations() {
        ArrayList<SMedialRelation> sAudioRels = new ArrayList<SMedialRelation>();
        SToken source = SaltFactory.createSToken();
        this.getFixture().addNode((Node)source);
        SMedialDS target = SaltFactory.createSMedialDS();
        this.getFixture().addNode((Node)target);
        for (int i = 0; i < 10; ++i) {
            SMedialRelation rel = SaltFactory.createSMedialRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            sAudioRels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)sAudioRels.containsAll(this.getFixture().getMedialRelations()));
        Assert.assertTrue((boolean)this.getFixture().getMedialRelations().containsAll(sAudioRels));
    }

    @Test
    public void testGetSMediaDSs() {
        SMedialDS sAudioDS = SaltFactory.createSMedialDS();
        this.getFixture().addNode((Node)sAudioDS);
        Assert.assertTrue((boolean)this.getFixture().getMedialDSs().contains(sAudioDS));
    }

    @Test
    public void testGetSOrderRelations() {
        ArrayList<SOrderRelation> orderRels = new ArrayList<SOrderRelation>();
        SToken source = SaltFactory.createSToken();
        this.getFixture().addNode((Node)source);
        SToken target = SaltFactory.createSToken();
        this.getFixture().addNode((Node)target);
        for (int i = 0; i < 10; ++i) {
            SOrderRelation rel = SaltFactory.createSOrderRelation();
            rel.setSource((Node)source);
            rel.setTarget((Node)target);
            orderRels.add(rel);
            this.getFixture().addRelation((Relation)rel);
        }
        Assert.assertTrue((boolean)orderRels.containsAll(this.getFixture().getOrderRelations()));
        Assert.assertTrue((boolean)this.getFixture().getOrderRelations().containsAll(orderRels));
    }

    @Test
    public void testAddSNode__SNode_SNode_SALT_TYPE() {
        SToken source = SaltFactory.createSToken();
        SToken target = SaltFactory.createSToken();
        try {
            this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SPOINTING_RELATION);
            Assert.fail();
        }
        catch (SaltElementNotInGraphException saltElementNotInGraphException) {
            // empty catch block
        }
        this.getFixture().addNode((Node)source);
        SRelation sRelation22 = this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SPOINTING_RELATION);
        Assert.assertTrue((boolean)(sRelation22 instanceof SPointingRelation));
        source = SaltFactory.createSToken();
        target = SaltFactory.createSTextualDS();
        try {
            this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.STEXTUAL_RELATION);
            Assert.fail();
        }
        catch (SaltElementNotInGraphException sRelation22) {
            // empty catch block
        }
        this.getFixture().addNode((Node)source);
        sRelation22 = this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.STEXTUAL_RELATION);
        Assert.assertTrue((boolean)(sRelation22 instanceof STextualRelation));
        source = SaltFactory.createSStructure();
        target = SaltFactory.createSToken();
        try {
            this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SDOMINANCE_RELATION);
            Assert.fail();
        }
        catch (SaltElementNotInGraphException sRelation) {
            // empty catch block
        }
        this.getFixture().addNode((Node)source);
        sRelation22 = this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SDOMINANCE_RELATION);
        Assert.assertTrue((boolean)(sRelation22 instanceof SDominanceRelation));
        source = SaltFactory.createSSpan();
        target = SaltFactory.createSToken();
        try {
            this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SSPANNING_RELATION);
            Assert.fail();
        }
        catch (SaltElementNotInGraphException sRelation) {
            // empty catch block
        }
        this.getFixture().addNode((Node)source);
        sRelation22 = this.getFixture().addNode((SNode)source, (SNode)target, SALT_TYPE.SSPANNING_RELATION);
        Assert.assertTrue((boolean)(sRelation22 instanceof SSpanningRelation));
    }

    @Test
    public void testCreateSTextualDS__String() {
        String sText = "This is a new primary text.";
        STextualDS sTextualDS = this.getFixture().createTextualDS(sText);
        Assert.assertNotNull((Object)sTextualDS);
        Assert.assertEquals((Object)sText, (Object)sTextualDS.getText());
        Assert.assertTrue((boolean)this.getFixture().getTextualDSs().contains(sTextualDS));
    }

    @Test
    public void testcreateToken__EList() {
        String text = "This is a sample text.";
        STextualDS stext = this.getFixture().createTextualDS(text);
        ArrayList<DataSourceSequence> sequences = null;
        try {
            this.getFixture().createToken(sequences);
            Assert.fail((String)"empty param");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequences = new ArrayList<DataSourceSequence>();
        DataSourceSequence sequence = null;
        sequences.add(sequence);
        try {
            this.getFixture().createToken(sequences);
            Assert.fail((String)"empty data-source value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequences = new ArrayList();
        sequence = new DataSourceSequence();
        sequences.add(sequence);
        sequence.setDataSource((SSequentialDS)stext);
        try {
            this.getFixture().createToken(sequences);
            Assert.fail((String)"empty start value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence.setStart((Number)0);
        try {
            this.getFixture().createToken(sequences);
            Assert.fail((String)"empty end value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence.setEnd((Number)4);
        SToken sToken = this.getFixture().createToken(sequences);
        Assert.assertNotNull((Object)sToken);
        Assert.assertEquals((Object)sToken, (Object)this.getFixture().getNode(sToken.getId()));
    }

    @Test
    public void testcreateToken__DataSourceSequence() {
        String text = "This is a sample text.";
        DataSourceSequence sequence = null;
        STextualDS stext = this.getFixture().createTextualDS(text);
        try {
            this.getFixture().createToken(sequence);
            Assert.fail((String)"empty data-source value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence = new DataSourceSequence();
        sequence.setDataSource((SSequentialDS)stext);
        try {
            this.getFixture().createToken(sequence);
            Assert.fail((String)"empty start value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence.setStart((Number)0);
        try {
            this.getFixture().createToken(sequence);
            Assert.fail((String)"empty end value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence.setEnd((Number)4);
        SToken sToken = this.getFixture().createToken(sequence);
        Assert.assertNotNull((Object)sToken);
        Assert.assertEquals((Object)sToken, (Object)this.getFixture().getNode(sToken.getId()));
    }

    @Test
    public void testCreateSTimeline() {
        STextualDS sText1 = SaltFactory.createSTextualDS();
        sText1.setText("Hello, text1.");
        this.getFixture().addNode((Node)sText1);
        SToken sToken = null;
        STextualRelation sTextRel = null;
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText1);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)0);
        sTextRel.setEnd((Number)5);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText1);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)5);
        sTextRel.setEnd((Number)6);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText1);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)7);
        sTextRel.setEnd((Number)12);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText1);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)12);
        sTextRel.setEnd((Number)13);
        this.getFixture().addRelation((Relation)sTextRel);
        STextualDS sText2 = SaltFactory.createSTextualDS();
        sText2.setText("Hello, Text2.");
        this.getFixture().addNode((Node)sText2);
        sToken = null;
        sTextRel = null;
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText2);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)0);
        sTextRel.setEnd((Number)5);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText2);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)5);
        sTextRel.setEnd((Number)6);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText2);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)7);
        sTextRel.setEnd((Number)12);
        this.getFixture().addRelation((Relation)sTextRel);
        sToken = SaltFactory.createSToken();
        this.getFixture().addNode((Node)sToken);
        sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setTarget((Node)sText2);
        sTextRel.setSource((Node)sToken);
        sTextRel.setStart((Number)12);
        sTextRel.setEnd((Number)13);
        this.getFixture().addRelation((Relation)sTextRel);
        this.getFixture().createTimeline();
        Assert.assertNotNull((Object)this.getFixture().getTimeline());
        Assert.assertEquals((long)8L, (long)this.getFixture().getTimelineRelations().size());
        Assert.assertEquals((Object)0, (Object)this.getFixture().getTimeline().getStart());
        Assert.assertEquals((Object)8, (Object)this.getFixture().getTimeline().getEnd());
    }

    @Test
    public void testGetSNodeBySequence__DataSourceSequence() {
        String text1 = "This is a sample text.";
        String text2 = "A sample text.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(5), Integer.valueOf(7));
        tok2.setName("tok2");
        SToken tok6 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(21), Integer.valueOf(22));
        tok6.setName("tok6");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(4));
        tok1.setName("tok1");
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(10), Integer.valueOf(16));
        tok4.setName("tok4");
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(17), Integer.valueOf(21));
        tok5.setName("tok5");
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(9));
        tok3.setName("tok3");
        STextualDS sText2 = this.getFixture().createTextualDS(text2);
        SToken tok3_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(9), Integer.valueOf(13));
        tok3_1.setName("tok3_1");
        SToken tok2_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(2), Integer.valueOf(8));
        tok2_1.setName("tok2_1");
        SToken tok1_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(0), Integer.valueOf(1));
        tok1_1.setName("tok1_1");
        DataSourceSequence sequence = null;
        List coveredSTokens = null;
        sequence = new DataSourceSequence();
        sequence.setDataSource((SSequentialDS)sText1);
        sequence.setStart((Number)0);
        sequence.setEnd((Number)4);
        coveredSTokens = this.getFixture().getNodesBySequence(sequence);
        Assert.assertNotNull((Object)coveredSTokens);
        Assert.assertEquals((String)("covered tokens are: " + coveredSTokens), (long)1L, (long)coveredSTokens.size());
        Assert.assertTrue((boolean)coveredSTokens.contains(tok1));
        sequence = new DataSourceSequence();
        sequence.setDataSource((SSequentialDS)sText1);
        sequence.setStart((Number)5);
        sequence.setEnd((Number)16);
        coveredSTokens = this.getFixture().getNodesBySequence(sequence);
        Assert.assertNotNull((Object)coveredSTokens);
        Assert.assertEquals((long)3L, (long)coveredSTokens.size());
        Assert.assertTrue((boolean)coveredSTokens.contains(tok2));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok3));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok4));
        sequence = new DataSourceSequence();
        sequence.setDataSource((SSequentialDS)sText1);
        sequence.setStart((Number)0);
        sequence.setEnd((Number)sText1.getText().length());
        coveredSTokens = this.getFixture().getNodesBySequence(sequence);
        Assert.assertNotNull((Object)coveredSTokens);
        Assert.assertEquals((long)6L, (long)coveredSTokens.size());
        Assert.assertTrue((boolean)coveredSTokens.contains(tok1));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok2));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok3));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok4));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok5));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok6));
        sequence = new DataSourceSequence();
        sequence.setDataSource((SSequentialDS)sText2);
        sequence.setStart((Number)0);
        sequence.setEnd((Number)sText2.getText().length());
        coveredSTokens = this.getFixture().getNodesBySequence(sequence);
        Assert.assertNotNull((Object)coveredSTokens);
        Assert.assertEquals((long)3L, (long)coveredSTokens.size());
        Assert.assertTrue((boolean)coveredSTokens.contains(tok1_1));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok2_1));
        Assert.assertTrue((boolean)coveredSTokens.contains(tok3_1));
    }

    @Test
    public void testGetOverlappedDSSequences__SNode_EList() {
        String text = "This is a sample text.";
        DataSourceSequence dsSequence = new DataSourceSequence();
        STextualDS sText = this.getFixture().createTextualDS(text);
        dsSequence.setDataSource((SSequentialDS)sText);
        dsSequence.setStart((Number)0);
        dsSequence.setEnd((Number)4);
        SToken tok1 = this.getFixture().createToken(dsSequence);
        tok1.setName("tok1");
        dsSequence.setStart((Number)5);
        dsSequence.setEnd((Number)7);
        SToken tok2 = this.getFixture().createToken(dsSequence);
        tok2.setName("tok2");
        dsSequence.setStart((Number)8);
        dsSequence.setEnd((Number)9);
        SToken tok3 = this.getFixture().createToken(dsSequence);
        tok3.setName("tok3");
        dsSequence.setStart((Number)10);
        dsSequence.setEnd((Number)16);
        SToken tok4 = this.getFixture().createToken(dsSequence);
        tok4.setName("tok4");
        dsSequence.setStart((Number)17);
        dsSequence.setEnd((Number)21);
        SToken tok5 = this.getFixture().createToken(dsSequence);
        tok5.setName("tok5");
        dsSequence.setStart((Number)21);
        dsSequence.setEnd((Number)22);
        SToken tok6 = this.getFixture().createToken(dsSequence);
        tok6.setName("tok6");
        ArrayList<Object> overlappedNodes = null;
        ArrayList<SToken> overlappedTokens = null;
        SStructure struct2 = this.getFixture().createStructure(new SStructuredNode[]{tok1});
        struct2.setName("struct2");
        overlappedTokens = new ArrayList<SToken>();
        overlappedTokens.add(tok2);
        overlappedTokens.add(tok3);
        SSpan span1 = this.getFixture().createSpan(overlappedTokens);
        span1.setName("span1");
        overlappedNodes = new ArrayList<Object>();
        overlappedNodes.add(struct2);
        overlappedNodes.add(span1);
        SStructure struct1 = this.getFixture().createStructure(overlappedNodes);
        struct1.setName("struct1");
        overlappedNodes = new ArrayList();
        overlappedNodes.add(span1);
        overlappedNodes.add(tok5);
        SStructure struct3 = this.getFixture().createStructure(overlappedNodes);
        struct3.setName("struct3");
        DataSourceSequence sequence = null;
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)struct2, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertNotNull((Object)sequence);
        Assert.assertEquals((Object)0, (Object)sequence.getStart());
        Assert.assertEquals((Object)4, (Object)sequence.getEnd());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)struct1, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertNotNull((Object)sequence);
        Assert.assertEquals((Object)0, (Object)sequence.getStart());
        Assert.assertEquals((Object)9, (Object)sequence.getEnd());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)span1, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertNotNull((Object)sequence);
        Assert.assertEquals((Object)5, (Object)sequence.getStart());
        Assert.assertEquals((Object)9, (Object)sequence.getEnd());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)struct3, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertNotNull((Object)sequence);
        Assert.assertEquals((Object)5, (Object)sequence.getStart());
        Assert.assertEquals((Object)21, (Object)sequence.getEnd());
    }

    @Test
    public void testGetOverlappedDSSequences__STextualDS_EList() {
        STextualDS sTextualDs = SaltFactory.createSTextualDS();
        this.getFixture().addNode((Node)sTextualDs);
        DataSourceSequence sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)sTextualDs, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)sTextualDs, (Object)sequence.getDataSource());
        sTextualDs.setText("This is a sample text.");
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)sTextualDs, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)sTextualDs, (Object)sequence.getDataSource());
        Assert.assertEquals((Object)sTextualDs, (Object)sequence.getDataSource());
        Assert.assertEquals((Object)0, (Object)sequence.getStart());
        Assert.assertEquals((Object)sTextualDs.getText().length(), (Object)sequence.getEnd());
    }

    @Test
    public void testIsContinuousByText__EList() {
        String text = "This is a sample text.";
        DataSourceSequence dsSequence = new DataSourceSequence();
        STextualDS sText = this.getFixture().createTextualDS(text);
        dsSequence.setDataSource((SSequentialDS)sText);
        dsSequence.setStart((Number)5);
        dsSequence.setEnd((Number)7);
        SToken tok2 = this.getFixture().createToken(dsSequence);
        tok2.setName("tok2");
        dsSequence.setStart((Number)21);
        dsSequence.setEnd((Number)22);
        SToken tok6 = this.getFixture().createToken(dsSequence);
        tok6.setName("tok6");
        dsSequence.setStart((Number)0);
        dsSequence.setEnd((Number)4);
        SToken tok1 = this.getFixture().createToken(dsSequence);
        tok1.setName("tok1");
        dsSequence.setStart((Number)10);
        dsSequence.setEnd((Number)16);
        SToken tok4 = this.getFixture().createToken(dsSequence);
        tok4.setName("tok4");
        dsSequence.setStart((Number)17);
        dsSequence.setEnd((Number)21);
        SToken tok5 = this.getFixture().createToken(dsSequence);
        tok5.setName("tok5");
        dsSequence.setStart((Number)8);
        dsSequence.setEnd((Number)9);
        SToken tok3 = this.getFixture().createToken(dsSequence);
        tok3.setName("tok3");
        ArrayList<SToken> sTokens = null;
        sTokens = new ArrayList<SToken>();
        sTokens.add(tok1);
        Assert.assertTrue((boolean)this.getFixture().isContinuousByText(sTokens));
        sTokens = new ArrayList();
        sTokens.add(tok2);
        sTokens.add(tok4);
        Assert.assertFalse((boolean)this.getFixture().isContinuousByText(sTokens));
        sTokens = new ArrayList();
        sTokens.add(tok2);
        sTokens.add(tok4);
        sTokens.add(tok3);
        Assert.assertTrue((boolean)this.getFixture().isContinuousByText(sTokens));
    }

    @Test
    public void testIsContinuousByText__EList_EList() {
        String text = "This is a sample text.";
        DataSourceSequence dsSequence = new DataSourceSequence();
        STextualDS sText = this.getFixture().createTextualDS(text);
        dsSequence.setDataSource((SSequentialDS)sText);
        dsSequence.setStart((Number)5);
        dsSequence.setEnd((Number)7);
        SToken tok2 = this.getFixture().createToken(dsSequence);
        tok2.setName("tok2");
        dsSequence.setStart((Number)21);
        dsSequence.setEnd((Number)22);
        SToken tok6 = this.getFixture().createToken(dsSequence);
        tok6.setName("tok6");
        dsSequence.setStart((Number)0);
        dsSequence.setEnd((Number)4);
        SToken tok1 = this.getFixture().createToken(dsSequence);
        tok1.setName("tok1");
        dsSequence.setStart((Number)10);
        dsSequence.setEnd((Number)16);
        SToken tok4 = this.getFixture().createToken(dsSequence);
        tok4.setName("tok4");
        dsSequence.setStart((Number)17);
        dsSequence.setEnd((Number)21);
        SToken tok5 = this.getFixture().createToken(dsSequence);
        tok5.setName("tok5");
        dsSequence.setStart((Number)8);
        dsSequence.setEnd((Number)9);
        SToken tok3 = this.getFixture().createToken(dsSequence);
        tok3.setName("tok3");
        ArrayList<SToken> fullList = new ArrayList<SToken>();
        fullList.add(tok1);
        fullList.add(tok2);
        fullList.add(tok3);
        fullList.add(tok4);
        ArrayList<SToken> sTokens = null;
        sTokens = new ArrayList<SToken>();
        sTokens.add(tok1);
        Assert.assertTrue((boolean)this.getFixture().isContinuousByText(sTokens, fullList));
        sTokens = new ArrayList();
        sTokens.add(tok2);
        sTokens.add(tok4);
        Assert.assertFalse((boolean)this.getFixture().isContinuousByText(sTokens, fullList));
        sTokens = new ArrayList();
        sTokens.add(tok2);
        sTokens.add(tok4);
        sTokens.add(tok3);
        Assert.assertTrue((boolean)this.getFixture().isContinuousByText(sTokens, fullList));
    }

    @Test
    public void testSortSTokenByText() {
        ArrayList<SToken> sTokens = new ArrayList<SToken>();
        String text1 = "This is a sample text.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(5), Integer.valueOf(7));
        tok2.setName("tok2");
        SToken tok6 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(21), Integer.valueOf(22));
        tok6.setName("tok6");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(4));
        tok1.setName("tok1");
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(10), Integer.valueOf(16));
        tok4.setName("tok4");
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(17), Integer.valueOf(21));
        tok5.setName("tok5");
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(9));
        tok3.setName("tok3");
        sTokens.add(tok1);
        sTokens.add(tok2);
        sTokens.add(tok3);
        sTokens.add(tok4);
        sTokens.add(tok5);
        sTokens.add(tok6);
        this.getFixture().sortTokenByText();
        Assert.assertNotNull((Object)this.getFixture().getTokens());
        Assert.assertEquals((long)sTokens.size(), (long)this.getFixture().getTokens().size());
        ImmutableList controllSTokens = ImmutableList.copyOf((Collection)this.getFixture().getTokens());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((String)("tokens of index '" + i + "' aren't equal"), sTokens.get(i), controllSTokens.get(i));
            boolean hasTextualRelation = false;
            for (SRelation rel : ((SToken)controllSTokens.get(i)).getOutRelations()) {
                if (!(rel instanceof STextualRelation)) continue;
                hasTextualRelation = true;
                break;
            }
            Assert.assertTrue((String)("token of inde " + i + " does not have a textual relation"), (boolean)hasTextualRelation);
        }
        int prevStart = -1;
        List textRels = this.getFixture().getTextualRelations();
        Assert.assertEquals((String)"there must be a textual relation for each token", (long)sTokens.size(), (long)textRels.size());
        for (STextualRelation curSTextRel : this.getFixture().getTextualRelations()) {
            Assert.assertTrue((String)("this textrel does not follow previous texrel: " + this.getFixture().getTextualRelations()), ((Integer)curSTextRel.getStart() > prevStart ? 1 : 0) != 0);
            prevStart = (Integer)curSTextRel.getStart();
        }
    }

    @Test
    public void testGetSortedSTokenByText__EList() {
        String text1 = "This is a sample text.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(5), Integer.valueOf(7));
        tok2.setName("tok2");
        SToken tok6 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(21), Integer.valueOf(22));
        tok6.setName("tok6");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(4));
        tok1.setName("tok1");
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(10), Integer.valueOf(16));
        tok4.setName("tok4");
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(17), Integer.valueOf(21));
        tok5.setName("tok5");
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(9));
        tok3.setName("tok3");
        ArrayList<SToken> sTokens2Sort = new ArrayList<SToken>();
        sTokens2Sort.add(tok5);
        sTokens2Sort.add(tok3);
        sTokens2Sort.add(tok4);
        List sortedSTokens = this.getFixture().getSortedTokenByText(sTokens2Sort);
        Assert.assertNotNull((Object)sortedSTokens);
        Assert.assertEquals((long)sTokens2Sort.size(), (long)sortedSTokens.size());
        Assert.assertEquals(sTokens2Sort.get(1), sortedSTokens.get(0));
        Assert.assertEquals(sTokens2Sort.get(2), sortedSTokens.get(1));
        Assert.assertEquals(sTokens2Sort.get(0), sortedSTokens.get(2));
    }

    @Test
    public void testGetSortedSTokenByText() {
        ArrayList<SToken> sTokens = new ArrayList<SToken>();
        String text1 = "This is a sample text.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(5), Integer.valueOf(7));
        tok2.setName("tok2");
        SToken tok6 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(21), Integer.valueOf(22));
        tok6.setName("tok6");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(4));
        tok1.setName("tok1");
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(10), Integer.valueOf(16));
        tok4.setName("tok4");
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(17), Integer.valueOf(21));
        tok5.setName("tok5");
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(9));
        tok3.setName("tok3");
        sTokens.add(tok1);
        sTokens.add(tok2);
        sTokens.add(tok3);
        sTokens.add(tok4);
        sTokens.add(tok5);
        sTokens.add(tok6);
        List sortedSTokens = this.getFixture().getSortedTokenByText();
        Assert.assertNotNull((Object)sortedSTokens);
        Assert.assertEquals((long)sTokens.size(), (long)sortedSTokens.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals(sTokens.get(i), sortedSTokens.get(i));
        }
    }

    @Test
    public void testGetSortedSTokenByText_2() {
        ArrayList<SToken> sTokens = new ArrayList<SToken>();
        String text1 = "This is a sample text.";
        String text2 = "A sample text.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(5), Integer.valueOf(7));
        tok2.setName("tok2");
        SToken tok6 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(21), Integer.valueOf(22));
        tok6.setName("tok6");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(4));
        tok1.setName("tok1");
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(10), Integer.valueOf(16));
        tok4.setName("tok4");
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(17), Integer.valueOf(21));
        tok5.setName("tok5");
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(9));
        tok3.setName("tok3");
        STextualDS sText2 = this.getFixture().createTextualDS(text2);
        SToken tok3_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(9), Integer.valueOf(13));
        tok3_1.setName("tok3_1");
        SToken tok2_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(2), Integer.valueOf(8));
        tok2_1.setName("tok2_1");
        SToken tok1_1 = this.getFixture().createToken((SSequentialDS)sText2, Integer.valueOf(0), Integer.valueOf(1));
        tok1_1.setName("tok1_1");
        sTokens.add(tok1);
        sTokens.add(tok2);
        sTokens.add(tok3);
        sTokens.add(tok4);
        sTokens.add(tok5);
        sTokens.add(tok6);
        sTokens.add(tok1_1);
        sTokens.add(tok2_1);
        sTokens.add(tok3_1);
        List sortedSTokens = this.getFixture().getSortedTokenByText();
        Assert.assertNotNull((Object)sortedSTokens);
        Assert.assertEquals((long)sTokens.size(), (long)sortedSTokens.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals(sTokens.get(i), sortedSTokens.get(i));
        }
    }

    @Test
    public void testGetRootsBySRelation__SALT_TYPE() {
        SToken tok1 = null;
        SToken tok2 = null;
        SToken tok3 = null;
        SToken tok4 = null;
        SToken tok5 = null;
        SSpan span1 = null;
        SSpan span2 = null;
        SStructure struct1 = null;
        SStructure struct2 = null;
        tok1 = SaltFactory.createSToken();
        tok1.setName("tok1");
        this.getFixture().addNode((Node)tok1);
        Assert.assertEquals((Object)tok1, (Object)this.getFixture().getNode(tok1.getId()));
        tok2 = SaltFactory.createSToken();
        tok2.setName("tok2");
        this.getFixture().addNode((Node)tok2);
        Assert.assertEquals((Object)tok2, (Object)this.getFixture().getNode(tok2.getId()));
        tok3 = SaltFactory.createSToken();
        tok3.setName("tok3");
        this.getFixture().addNode((Node)tok3);
        Assert.assertEquals((Object)tok3, (Object)this.getFixture().getNode(tok3.getId()));
        tok4 = SaltFactory.createSToken();
        tok4.setName("tok4");
        this.getFixture().addNode((Node)tok4);
        Assert.assertEquals((Object)tok4, (Object)this.getFixture().getNode(tok4.getId()));
        tok5 = SaltFactory.createSToken();
        tok5.setName("tok5");
        this.getFixture().addNode((Node)tok5);
        Assert.assertEquals((Object)tok5, (Object)this.getFixture().getNode(tok5.getId()));
        span1 = SaltFactory.createSSpan();
        span1.setName("span1");
        this.getFixture().addNode((Node)span1);
        Assert.assertEquals((Object)span1, (Object)this.getFixture().getNode(span1.getId()));
        span2 = SaltFactory.createSSpan();
        span2.setName("span2");
        this.getFixture().addNode((Node)span2);
        Assert.assertEquals((Object)span2, (Object)this.getFixture().getNode(span2.getId()));
        struct1 = SaltFactory.createSStructure();
        struct1.setName("struct1");
        this.getFixture().addNode((Node)struct1);
        Assert.assertEquals((Object)struct1, (Object)this.getFixture().getNode(struct1.getId()));
        struct2 = SaltFactory.createSStructure();
        struct2.setName("struct2");
        this.getFixture().addNode((Node)struct2);
        Assert.assertEquals((Object)struct2, (Object)this.getFixture().getNode(struct2.getId()));
        SSpanningRelation sSpanRel = null;
        sSpanRel = SaltFactory.createSSpanningRelation();
        sSpanRel.setTarget((Node)tok1);
        sSpanRel.setSource((Node)span1);
        this.getFixture().addRelation((Relation)sSpanRel);
        Assert.assertEquals((Object)sSpanRel, (Object)this.getFixture().getRelation(sSpanRel.getId()));
        sSpanRel = SaltFactory.createSSpanningRelation();
        sSpanRel.setTarget((Node)tok2);
        sSpanRel.setSource((Node)span1);
        this.getFixture().addRelation((Relation)sSpanRel);
        Assert.assertEquals((Object)sSpanRel, (Object)this.getFixture().getRelation(sSpanRel.getId()));
        sSpanRel = SaltFactory.createSSpanningRelation();
        sSpanRel.setTarget((Node)tok2);
        sSpanRel.setSource((Node)span2);
        this.getFixture().addRelation((Relation)sSpanRel);
        Assert.assertEquals((Object)sSpanRel, (Object)this.getFixture().getRelation(sSpanRel.getId()));
        sSpanRel = SaltFactory.createSSpanningRelation();
        sSpanRel.setTarget((Node)tok4);
        sSpanRel.setSource((Node)span2);
        this.getFixture().addRelation((Relation)sSpanRel);
        Assert.assertEquals((Object)sSpanRel, (Object)this.getFixture().getRelation(sSpanRel.getId()));
        SDominanceRelation sDomRel = null;
        sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setSource((Node)struct1);
        sDomRel.setTarget((Node)tok1);
        this.getFixture().addRelation((Relation)sDomRel);
        Assert.assertEquals((Object)sDomRel, (Object)this.getFixture().getRelation(sDomRel.getId()));
        sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setSource((Node)struct1);
        sDomRel.setTarget((Node)span1);
        this.getFixture().addRelation((Relation)sDomRel);
        Assert.assertEquals((Object)sDomRel, (Object)this.getFixture().getRelation(sDomRel.getId()));
        sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setSource((Node)struct2);
        sDomRel.setTarget((Node)struct1);
        this.getFixture().addRelation((Relation)sDomRel);
        Assert.assertEquals((Object)sDomRel, (Object)this.getFixture().getRelation(sDomRel.getId()));
        sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setSource((Node)struct1);
        sDomRel.setTarget((Node)span1);
        this.getFixture().addRelation((Relation)sDomRel);
        Assert.assertEquals((Object)sDomRel, (Object)this.getFixture().getRelation(sDomRel.getId()));
        sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setSource((Node)struct1);
        sDomRel.setTarget((Node)span2);
        this.getFixture().addRelation((Relation)sDomRel);
        Assert.assertEquals((Object)sDomRel, (Object)this.getFixture().getRelation(sDomRel.getId()));
        SPointingRelation sPRel = null;
        sPRel = SaltFactory.createSPointingRelation();
        sPRel.setSource((Node)tok1);
        sPRel.setTarget((Node)tok2);
        this.getFixture().addRelation((Relation)sPRel);
        Assert.assertEquals((Object)sPRel, (Object)this.getFixture().getRelation(sPRel.getId()));
        sPRel = SaltFactory.createSPointingRelation();
        sPRel.setSource((Node)tok3);
        sPRel.setTarget((Node)tok4);
        this.getFixture().addRelation((Relation)sPRel);
        Assert.assertEquals((Object)sPRel, (Object)this.getFixture().getRelation(sPRel.getId()));
        sPRel = SaltFactory.createSPointingRelation();
        sPRel.setSource((Node)tok4);
        sPRel.setTarget((Node)tok2);
        this.getFixture().addRelation((Relation)sPRel);
        Assert.assertEquals((Object)sPRel, (Object)this.getFixture().getRelation(sPRel.getId()));
        ArrayList<Object> roots = null;
        roots = new ArrayList<Object>();
        roots.add(span1);
        roots.add(span2);
        Assert.assertTrue((boolean)roots.containsAll(this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION})));
        Assert.assertTrue((boolean)this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION}).containsAll(roots));
        roots = new ArrayList();
        roots.add(struct2);
        Assert.assertTrue((boolean)roots.containsAll(this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SDOMINANCE_RELATION})));
        Assert.assertTrue((boolean)this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SDOMINANCE_RELATION}).containsAll(roots));
        roots = new ArrayList();
        roots.add(tok1);
        roots.add(tok3);
        Assert.assertTrue((boolean)roots.containsAll(this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SPOINTING_RELATION})));
        Assert.assertTrue((boolean)this.getFixture().getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SPOINTING_RELATION}).containsAll(roots));
    }

    @Test
    public void testGetRootsBySRelationSType__SALT_TYPE() {
        SToken node1 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)node1);
        SToken node2 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)node2);
        SToken node3 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)node3);
        String type1 = "type1";
        String type2 = "type2";
        SPointingRelation rel1 = SaltFactory.createSPointingRelation();
        rel1.setType(type1);
        rel1.setSource((Node)node1);
        rel1.setTarget((Node)node2);
        this.getFixture().addRelation((Relation)rel1);
        SPointingRelation rel2 = SaltFactory.createSPointingRelation();
        rel2.setType(type2);
        rel2.setSource((Node)node2);
        rel2.setTarget((Node)node1);
        this.getFixture().addRelation((Relation)rel2);
        Multimap roots = this.getFixture().getRootsByRelationType(SALT_TYPE.SPOINTING_RELATION);
        Assert.assertTrue((boolean)roots.containsKey((Object)type1));
        Assert.assertTrue((boolean)roots.containsKey((Object)type2));
        Assert.assertEquals((long)1L, (long)roots.get((Object)type1).size());
        Assert.assertEquals((long)1L, (long)roots.get((Object)type2).size());
        Assert.assertTrue((boolean)roots.get((Object)type1).contains(node1));
        Assert.assertTrue((boolean)roots.get((Object)type2).contains(node2));
    }

    @Test
    public void testcreateToken__SSequentialDS_Integer_Integer() {
        String sampleText = "This is a sample.";
        STextualDS primaryText = this.getFixture().createTextualDS(sampleText);
        SToken tok1 = this.getFixture().createToken((SSequentialDS)primaryText, Integer.valueOf(0), Integer.valueOf(4));
        SToken tok2 = this.getFixture().createToken((SSequentialDS)primaryText, Integer.valueOf(5), Integer.valueOf(7));
        SToken tok3 = this.getFixture().createToken((SSequentialDS)primaryText, Integer.valueOf(8), Integer.valueOf(9));
        SToken tok4 = this.getFixture().createToken((SSequentialDS)primaryText, Integer.valueOf(10), Integer.valueOf(16));
        SToken tok5 = this.getFixture().createToken((SSequentialDS)primaryText, Integer.valueOf(16), Integer.valueOf(17));
        DataSourceSequence sequence = null;
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)tok1, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)0, (Object)sequence.getStart());
        Assert.assertEquals((Object)4, (Object)sequence.getEnd());
        Assert.assertEquals((Object)primaryText, (Object)sequence.getDataSource());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)tok2, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)5, (Object)sequence.getStart());
        Assert.assertEquals((Object)7, (Object)sequence.getEnd());
        Assert.assertEquals((Object)primaryText, (Object)sequence.getDataSource());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)tok3, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)8, (Object)sequence.getStart());
        Assert.assertEquals((Object)9, (Object)sequence.getEnd());
        Assert.assertEquals((Object)primaryText, (Object)sequence.getDataSource());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)tok4, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)10, (Object)sequence.getStart());
        Assert.assertEquals((Object)16, (Object)sequence.getEnd());
        Assert.assertEquals((Object)primaryText, (Object)sequence.getDataSource());
        sequence = (DataSourceSequence)this.getFixture().getOverlappedDataSourceSequence((SNode)tok5, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        Assert.assertEquals((Object)16, (Object)sequence.getStart());
        Assert.assertEquals((Object)17, (Object)sequence.getEnd());
        Assert.assertEquals((Object)primaryText, (Object)sequence.getDataSource());
    }

    @Test
    public void testTokenize() {
        String text1 = "This is a sample.";
        String text2 = "This is the second sample.";
        STextualDS sText1 = this.getFixture().createTextualDS(text1);
        STextualDS sText2 = this.getFixture().createTextualDS(text2);
        this.getFixture().tokenize();
        Assert.assertEquals((long)11L, (long)this.getFixture().getTokens().size());
        Assert.assertEquals((long)11L, (long)this.getFixture().getTextualRelations().size());
        int relTosText1 = 0;
        int relTosText2 = 0;
        for (STextualRelation textRel : this.getFixture().getTextualRelations()) {
            if (((STextualDS)textRel.getTarget()).equals(sText2)) {
                ++relTosText2;
                continue;
            }
            if (!((STextualDS)textRel.getTarget()).equals(sText1)) continue;
            ++relTosText1;
        }
        Assert.assertEquals((long)5L, (long)relTosText1);
        Assert.assertEquals((long)6L, (long)relTosText2);
    }

    @Test
    public void testTokenize2() {
        String text = "This is a sample.";
        STextualDS sText1 = this.getFixture().createTextualDS(text);
        this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(7));
        this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(16));
        this.getFixture().tokenize();
        Assert.assertEquals((long)5L, (long)this.getFixture().getTokens().size());
        Assert.assertEquals((long)5L, (long)this.getFixture().getTextualRelations().size());
        Assert.assertEquals((long)2L, (long)this.getFixture().getSpans().size());
    }

    @Test
    public void testTokenize3() {
        String text = "This is a sample.";
        STextualDS sText1 = this.getFixture().createTextualDS(text);
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(0), Integer.valueOf(7));
        tok1.createAnnotation(null, "a", (Object)"b");
        tok1.createAnnotation(null, "c", (Object)"d");
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText1, Integer.valueOf(8), Integer.valueOf(16));
        tok2.createAnnotation(null, "1", (Object)"2");
        tok2.createAnnotation(null, "3", (Object)"4");
        this.getFixture().tokenize();
        Assert.assertEquals((long)5L, (long)this.getFixture().getTokens().size());
        Assert.assertEquals((long)5L, (long)this.getFixture().getTextualRelations().size());
        Assert.assertEquals((long)2L, (long)this.getFixture().getSpans().size());
        Assert.assertEquals((long)2L, (long)((SSpan)this.getFixture().getSpans().get(0)).getAnnotations().size());
        Assert.assertEquals((long)2L, (long)((SSpan)this.getFixture().getSpans().get(1)).getAnnotations().size());
    }

    @Test
    public void testCreateTokenizer() {
        Tokenizer tokenizer = this.getFixture().createTokenizer();
        Assert.assertNotNull((Object)tokenizer);
        Assert.assertEquals((Object)this.getFixture(), (Object)tokenizer.getDocumentGraph());
    }

    @Test
    public void testInsertSTokenAt__STextualDS_Integer_String_Boolean() {
        ArrayList<String> origText = new ArrayList<String>();
        origText.add("This");
        origText.add("is");
        origText.add("the");
        origText.add("original");
        origText.add("Text");
        StringBuilder str = new StringBuilder();
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        this.getFixture().addNode((Node)sTextualDS);
        for (String text : origText) {
            int start = str.length();
            str.append(text);
            int end = str.length();
            str.append(" ");
            this.getFixture().createToken((SSequentialDS)sTextualDS, Integer.valueOf(start), Integer.valueOf(end));
        }
        sTextualDS.setText(str.toString());
        String text = "addition";
        SToken token = this.getFixture().insertTokenAt(sTextualDS, Integer.valueOf(5), text, Boolean.valueOf(true));
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((long)6L, (long)this.getFixture().getTokens().size());
        Assert.assertEquals((Object)"This addition is the original Text ", (Object)sTextualDS.getText());
        Assert.assertEquals((long)6L, (long)this.getFixture().getTextualRelations().size());
        Assert.assertEquals((Object)0, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(0)).getStart());
        Assert.assertEquals((Object)4, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(0)).getEnd());
        Assert.assertEquals((Object)5, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(5)).getStart());
        Assert.assertEquals((Object)13, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(5)).getEnd());
        Assert.assertEquals((Object)14, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(1)).getStart());
        Assert.assertEquals((Object)16, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(1)).getEnd());
    }

    @Test
    public void testInsertSTokensAt__STextualDS_Integer_EList_Boolean() {
        ArrayList<String> origText = new ArrayList<String>();
        origText.add("This");
        origText.add("is");
        origText.add("the");
        origText.add("original");
        origText.add("Text");
        StringBuilder str = new StringBuilder();
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        this.getFixture().addNode((Node)sTextualDS);
        for (String text : origText) {
            int start = str.length();
            str.append(text);
            int end = str.length();
            str.append(" ");
            this.getFixture().createToken((SSequentialDS)sTextualDS, Integer.valueOf(start), Integer.valueOf(end));
        }
        sTextualDS.setText(str.toString());
        ArrayList<String> text = new ArrayList<String>();
        text.add("is");
        text.add("the");
        text.add("text");
        text.add("to");
        text.add("be");
        text.add("added");
        List tokens = this.getFixture().insertTokensAt(sTextualDS, Integer.valueOf(5), text, Boolean.valueOf(true));
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((long)6L, (long)tokens.size());
        Assert.assertEquals((long)11L, (long)this.getFixture().getTokens().size());
        Assert.assertEquals((Object)"This is the text to be added is the original Text ", (Object)sTextualDS.getText());
        Assert.assertEquals((long)11L, (long)this.getFixture().getTextualRelations().size());
        Assert.assertEquals((Object)0, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(0)).getStart());
        Assert.assertEquals((Object)4, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(0)).getEnd());
        Assert.assertEquals((Object)5, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(5)).getStart());
        Assert.assertEquals((Object)7, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(5)).getEnd());
        Assert.assertEquals((Object)23, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(10)).getStart());
        Assert.assertEquals((Object)28, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(10)).getEnd());
        Assert.assertEquals((Object)29, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(1)).getStart());
        Assert.assertEquals((Object)31, (Object)((STextualRelation)this.getFixture().getTextualRelations().get(1)).getEnd());
    }

    @Test
    public void testCreateSRelation__SNode_SNode_SALT_TYPE_String() {
        STextualDS sText = this.getFixture().createTextualDS("This is a sample text");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(0), Integer.valueOf(4));
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(5), Integer.valueOf(7));
        SSpan sSpan = SaltFactory.createSSpan();
        this.getFixture().addNode((Node)sSpan);
        SStructure sStruct = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)sStruct);
        SRelation sRel = null;
        Assert.assertEquals((long)2L, (long)this.getFixture().getRelations().size());
        sRel = this.getFixture().createRelation((SNode)tok1, (SNode)tok2, SALT_TYPE.SPOINTING_RELATION, "myNS::coref=anaphor;anotherNS::foo=bar");
        Assert.assertEquals((long)3L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((Object)tok1, (Object)sRel.getSource());
        Assert.assertEquals((Object)tok2, (Object)sRel.getTarget());
        Assert.assertEquals((long)2L, (long)sRel.getAnnotations().size());
        Assert.assertNotNull((Object)sRel.getAnnotation(SaltUtil.createQName((String)"myNS", (String)"coref")));
        Assert.assertEquals((Object)"anaphor", (Object)sRel.getAnnotation(SaltUtil.createQName((String)"myNS", (String)"coref")).getValue());
        Assert.assertNotNull((Object)sRel.getAnnotation(SaltUtil.createQName((String)"anotherNS", (String)"foo")));
        Assert.assertEquals((Object)"bar", (Object)sRel.getAnnotation(SaltUtil.createQName((String)"anotherNS", (String)"foo")).getValue());
        sRel = this.getFixture().createRelation((SNode)sSpan, (SNode)tok2, SALT_TYPE.SSPANNING_RELATION, null);
        Assert.assertEquals((long)4L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((Object)sSpan, (Object)sRel.getSource());
        Assert.assertEquals((Object)tok2, (Object)sRel.getTarget());
        Assert.assertEquals((long)0L, (long)sRel.getAnnotations().size());
        sRel = this.getFixture().createRelation((SNode)sStruct, (SNode)tok2, SALT_TYPE.SDOMINANCE_RELATION, null);
        Assert.assertEquals((long)5L, (long)this.getFixture().getRelations().size());
        Assert.assertEquals((Object)sStruct, (Object)sRel.getSource());
        Assert.assertEquals((Object)tok2, (Object)sRel.getTarget());
        Assert.assertEquals((long)0L, (long)sRel.getAnnotations().size());
    }

    @Test
    public void testGetOverlappedSTokens__SNode_List() {
        STextualDS sText = this.getFixture().createTextualDS("This is a sample text");
        SToken tok1 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(0), Integer.valueOf(4));
        SToken tok2 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(5), Integer.valueOf(7));
        SToken tok3 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(8), Integer.valueOf(9));
        SToken tok4 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(10), Integer.valueOf(15));
        SToken tok5 = this.getFixture().createToken((SSequentialDS)sText, Integer.valueOf(16), Integer.valueOf(20));
        ArrayList<SToken> tokenList = new ArrayList<SToken>();
        tokenList.add(tok1);
        tokenList.add(tok2);
        tokenList.add(tok3);
        SSpan sSpan = this.fixture.createSpan(tokenList);
        this.getFixture().createRelation((SNode)sSpan, (SNode)tok4, SALT_TYPE.SPOINTING_RELATION, null);
        ArrayList<Object> nodeList = new ArrayList<Object>();
        nodeList.add(sSpan);
        nodeList.add(tok4);
        nodeList.add(tok5);
        SStructure sStructure = this.fixture.createStructure(nodeList);
        List overlappedTokenList1 = this.fixture.getOverlappedTokens((SNode)sSpan, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
        Assert.assertNotNull((Object)overlappedTokenList1);
        Assert.assertTrue((boolean)overlappedTokenList1.containsAll(tokenList));
        Assert.assertFalse((boolean)overlappedTokenList1.contains(tok4));
        tokenList.add(tok4);
        List overlappedTokenListWithPointing = this.fixture.getOverlappedTokens((SNode)sSpan, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SPOINTING_RELATION});
        Assert.assertNotNull((Object)overlappedTokenListWithPointing);
        Assert.assertTrue((boolean)overlappedTokenListWithPointing.containsAll(tokenList));
        ArrayList<SToken> allTokenList = new ArrayList<SToken>();
        allTokenList.add(tok1);
        allTokenList.add(tok2);
        allTokenList.add(tok3);
        allTokenList.add(tok4);
        allTokenList.add(tok5);
        List overlappedTokenList2 = this.fixture.getOverlappedTokens((SNode)sStructure, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SPOINTING_RELATION, SALT_TYPE.SDOMINANCE_RELATION});
        Assert.assertNotNull((Object)overlappedTokenList2);
        Assert.assertTrue((boolean)overlappedTokenList2.containsAll(allTokenList));
        nodeList.add(tok2);
        SStructure sStructure2 = this.fixture.createStructure(nodeList);
        List overlappedTokenList3 = this.fixture.getOverlappedTokens((SNode)sStructure2, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SPOINTING_RELATION, SALT_TYPE.SDOMINANCE_RELATION});
        Assert.assertNotNull((Object)overlappedTokenList3);
        Assert.assertTrue((boolean)overlappedTokenList3.containsAll(allTokenList));
        for (SToken token : allTokenList) {
            overlappedTokenList3.remove(token);
        }
        Assert.assertTrue((boolean)overlappedTokenList3.isEmpty());
    }

    @Test
    public void testGetSText__SNode() {
        SDocumentGraph fixGraph = this.getFixture();
        Assert.assertNull((Object)fixGraph.getText(null));
        String testText = "Is this example more complicated than it appears to be";
        fixGraph.createTextualDS(testText);
        fixGraph.tokenize();
        String sText = fixGraph.getText((SNode)fixGraph.getTokens().get(4));
        Assert.assertNotNull((Object)sText);
        Assert.assertFalse((boolean)sText.isEmpty());
        Assert.assertEquals((Object)"complicated", (Object)sText);
    }

    @Test
    public void testGetSText__SNode__withDiscontinuesSpan() {
        SDocumentGraph fixGraph = this.getFixture();
        String testText = "Is this example more complicated than it appears to be";
        fixGraph.createTextualDS(testText);
        fixGraph.tokenize();
        ArrayList sTokens = new ArrayList();
        sTokens.add(fixGraph.getTokens().get(0));
        sTokens.add(fixGraph.getTokens().get(1));
        sTokens.add(fixGraph.getTokens().get(fixGraph.getTokens().size() - 1));
        String sText = fixGraph.getText((SNode)fixGraph.createSpan(sTokens));
        Assert.assertNotNull((Object)sText);
        Assert.assertFalse((boolean)sText.isEmpty());
        Assert.assertEquals((Object)testText, (Object)sText);
    }

    @Test
    public void testGetSText__SNode__SStructure() {
        SDocumentGraph fixGraph = this.getFixture();
        SStructure sStructure = SaltFactory.createSStructure();
        fixGraph.addNode((Node)sStructure);
        Assert.assertNull((Object)fixGraph.getText((SNode)sStructure));
    }

    public void testGetTokens() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getTokens().size());
        SToken tok1 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)tok1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getTokens().size());
        Assert.assertTrue((boolean)this.getFixture().getTokens().contains(tok1));
        SToken tok2 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)tok2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getTokens().size());
        Assert.assertTrue((boolean)this.getFixture().getTokens().contains(tok1));
        Assert.assertTrue((boolean)this.getFixture().getTokens().contains(tok2));
        SToken tok3 = SaltFactory.createSToken();
        this.getFixture().addNode((Node)tok3);
        Assert.assertEquals((long)3L, (long)this.getFixture().getTokens().size());
        Assert.assertTrue((boolean)this.getFixture().getTokens().contains(tok3));
        Assert.assertTrue((boolean)this.getFixture().getTokens().contains(tok3));
    }

    public void testGetSpans() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getSpans().size());
        SSpan span1 = SaltFactory.createSSpan();
        this.getFixture().addNode((Node)span1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getSpans().size());
        Assert.assertTrue((boolean)this.getFixture().getSpans().contains(span1));
        SSpan span2 = SaltFactory.createSSpan();
        this.getFixture().addNode((Node)span2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getSpans().size());
        Assert.assertTrue((boolean)this.getFixture().getSpans().contains(span1));
        Assert.assertTrue((boolean)this.getFixture().getSpans().contains(span2));
        SSpan span3 = SaltFactory.createSSpan();
        this.getFixture().addNode((Node)span3);
        Assert.assertEquals((long)3L, (long)this.getFixture().getSpans().size());
        Assert.assertTrue((boolean)this.getFixture().getSpans().contains(span3));
        Assert.assertTrue((boolean)this.getFixture().getSpans().contains(span3));
    }

    public void testGetStructures() {
        Assert.assertEquals((long)0L, (long)this.getFixture().getStructures().size());
        SStructure struct1 = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)struct1);
        Assert.assertEquals((long)1L, (long)this.getFixture().getStructures().size());
        Assert.assertTrue((boolean)this.getFixture().getStructures().contains(struct1));
        SStructure struct2 = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)struct2);
        Assert.assertEquals((long)2L, (long)this.getFixture().getStructures().size());
        Assert.assertTrue((boolean)this.getFixture().getStructures().contains(struct1));
        Assert.assertTrue((boolean)this.getFixture().getStructures().contains(struct2));
        SStructure struct3 = SaltFactory.createSStructure();
        this.getFixture().addNode((Node)struct3);
        Assert.assertEquals((long)3L, (long)this.getFixture().getStructures().size());
        Assert.assertTrue((boolean)this.getFixture().getStructures().contains(struct3));
        Assert.assertTrue((boolean)this.getFixture().getStructures().contains(struct3));
    }

    @Test
    public void testStoreLoadIsomorph() throws IOException, ClassNotFoundException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)doc);
        SDocumentGraph docGraph = doc.getDocumentGraph();
        File tmpFile = File.createTempFile("testSerializationOfSDocumentGraph", ".obj");
        FileOutputStream fOut = new FileOutputStream(tmpFile);
        try (ObjectOutputStream oOut = new ObjectOutputStream(fOut);){
            oOut.writeObject(docGraph);
        }
        FileInputStream fIn = new FileInputStream(tmpFile);
        ObjectInputStream oIn = new ObjectInputStream(fIn);
        SDocumentGraph restored = (SDocumentGraph)oIn.readObject();
        Diff diffCreator = new Diff(docGraph, restored);
        Set diffs = diffCreator.findDiffs();
        Assert.assertEquals((String)("Serialization failed. Diff: " + Joiner.on((String)"\n").join((Iterable)diffs)), (long)0L, (long)diffs.size());
    }

    @Test
    public void testGetSharedParent() {
        SDocument doc1 = SaltFactory.createSDocument();
        SDocument doc2 = SaltFactory.createSDocument();
        doc2.setId("doc");
        this.getFixture().createTextualDS("hallo hallo hallo");
        this.getFixture().tokenize();
        SToken tok1 = (SToken)this.getFixture().getTokens().get(0);
        SToken tok2 = (SToken)this.getFixture().getTokens().get(1);
        SToken tok3 = (SToken)this.getFixture().getTokens().get(2);
        SSpan span1 = this.getFixture().createSpan(new SToken[]{tok1});
        ArrayList<SToken> tokens = new ArrayList<SToken>();
        tokens.add(tok2);
        tokens.add(tok3);
        SSpan span2 = this.getFixture().createSpan(tokens);
        SSpan span3 = this.getFixture().createSpan(new SToken[]{tok3});
        SSpan span4 = this.getFixture().createSpan(this.getFixture().getTokens());
        ArrayList<SToken> children = new ArrayList<SToken>();
        children.add(tok1);
        List parents = this.getFixture().getSharedParent(children, SALT_TYPE.SSPAN);
        Assert.assertEquals((long)2L, (long)parents.size());
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span1));
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span4));
        children = new ArrayList();
        children.add(tok2);
        children.add(tok3);
        parents = this.getFixture().getSharedParent(children, SALT_TYPE.SSPAN);
        Assert.assertEquals((long)2L, (long)parents.size());
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span2));
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span4));
        children = new ArrayList();
        children.add(tok1);
        children.add(tok2);
        parents = this.getFixture().getSharedParent(children, SALT_TYPE.SSPAN);
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span4));
        children = new ArrayList();
        children.add(tok1);
        children.add(tok2);
        children.add(tok3);
        parents = this.getFixture().getSharedParent(children, SALT_TYPE.SSPAN);
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertTrue((String)(parents + ""), (boolean)parents.contains(span4));
    }

    @Test
    public void testGetChildren() {
        SDocument doc1 = SaltFactory.createSDocument();
        SDocument doc2 = SaltFactory.createSDocument();
        doc2.setId("doc");
        this.getFixture().createTextualDS("hallo hallo hallo");
        this.getFixture().tokenize();
        SToken tok1 = (SToken)this.getFixture().getTokens().get(0);
        SToken tok2 = (SToken)this.getFixture().getTokens().get(1);
        SToken tok3 = (SToken)this.getFixture().getTokens().get(2);
        SSpan span1 = this.getFixture().createSpan(new SToken[]{tok1});
        ArrayList<SToken> tokens = new ArrayList<SToken>();
        tokens.add(tok2);
        tokens.add(tok3);
        SSpan span2 = this.getFixture().createSpan(tokens);
        SSpan span3 = this.getFixture().createSpan(new SToken[]{tok3});
        SSpan span4 = this.getFixture().createSpan(this.getFixture().getTokens());
        List children = this.getFixture().getChildren((SNode)span1, SALT_TYPE.SSPANNING_RELATION);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok1));
        children = this.getFixture().getChildren((SNode)span2, SALT_TYPE.SSPANNING_RELATION);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok2));
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok3));
        children = this.getFixture().getChildren((SNode)span3, SALT_TYPE.SSPANNING_RELATION);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok3));
        children = this.getFixture().getChildren((SNode)span4, SALT_TYPE.SSPANNING_RELATION);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok1));
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok2));
        Assert.assertTrue((String)(children + ""), (boolean)children.contains(tok3));
    }
}

