/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl.tests;

import java.io.File;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.tests.SaltTestsUtil;
import org.eclipse.emf.common.util.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SDocumentTest {
    protected SDocument fixture = null;

    public void setFixture(SDocument fixture) {
        this.fixture = fixture;
    }

    protected SDocument getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(SaltFactory.createSDocument());
    }

    @Test
    public void testGetSDocumentGraphLocation() {
        Assert.assertNull((Object)this.getFixture().getDocumentGraphLocation());
        File file = SaltTestsUtil.getTempTestFolder("bla.salt");
        URI graphLocation = URI.createFileURI((String)file.getAbsolutePath());
        this.getFixture().setDocumentGraphLocation(graphLocation);
        Assert.assertEquals((Object)graphLocation, (Object)this.getFixture().getDocumentGraphLocation());
    }

    @Test
    public void testSetGetDocumentStructure() {
        Assert.assertNull((Object)this.getFixture().getDocumentGraph());
        SDocumentGraph graph = SaltFactory.createSDocumentGraph();
        this.getFixture().setDocumentGraph(graph);
        Assert.assertEquals((Object)graph, (Object)this.getFixture().getDocumentGraph());
    }

    @Test
    public void testSetDocumentGraphId() {
        SaltFactory.createIdentifier((IdentifiableElement)this.getFixture(), (String)"myDoc");
        this.getFixture().setDocumentGraph(SaltFactory.createSDocumentGraph());
        Assert.assertEquals((Object)this.getFixture().getId(), (Object)this.getFixture().getDocumentGraph().getId());
    }

    @Test
    public void testSetDocumentGraphId_wayaround() {
        this.getFixture().setDocumentGraph(SaltFactory.createSDocumentGraph());
        SaltFactory.createIdentifier((IdentifiableElement)this.getFixture(), (String)"myDoc");
        Assert.assertEquals((Object)this.getFixture().getId(), (Object)this.getFixture().getDocumentGraph().getId());
    }
}

