/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.tokenizer.tests;

import com.neovisionaries.i18n.LanguageCode;
import java.util.List;
import java.util.Vector;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.tokenizer.Clitics;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokenizerTest {
    private Tokenizer fixture = null;

    public void setFixture(Tokenizer fixture) {
        this.fixture = fixture;
    }

    public Tokenizer getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() {
        this.setFixture(new Tokenizer());
    }

    @Test
    public void testLANGUAGE_DESCRIPTION() {
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.de, (Object)Tokenizer.mapISOLanguageCode((String)"german"));
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.en, (Object)Tokenizer.mapISOLanguageCode((String)"english"));
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.fr, (Object)Tokenizer.mapISOLanguageCode((String)"french"));
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.it, (Object)Tokenizer.mapISOLanguageCode((String)"italian"));
    }

    @Test
    public void testDetectLanguage() {
        String text = null;
        text = "The Java Text Categorizing Library (JTCL) is a pure java 1.5 implementation of libTextCat which in turn is \"a library that was primarily developed for language guessing, a task on which it is known to perform with near-perfect accuracy\".";
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.en, (Object)Tokenizer.checkLanguage((String)text));
        text = "Die Java-Text Kategorisierung Library (JTCL) ist eine reine Java 1.5 Implementierung von libtextcat die wiederum \"eine Bibliothek, die vor allem f\u00fcr die Sprache zu raten, eine Aufgabe, auf denen bekannt ist, mit nahezu perfekter Genauigkeit durchzuf\u00fchren ist, wurde entwickelt.\"";
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.de, (Object)Tokenizer.checkLanguage((String)text));
        text = "La biblioth\u00e8que Java Cat\u00e9gorisation Texte (JTCL) est un pur Java 1.5 mise en \u0153uvre de libtextcat qui \u00e0 son tour \"une biblioth\u00e8que qui a \u00e9t\u00e9 d\u00e9velopp\u00e9 pour la langue deviner Primar, une t\u00e2che sur laquelle il est connu de r\u00e9aliser avec une pr\u00e9cision quasi-parfaite.\"";
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.fr, (Object)Tokenizer.checkLanguage((String)text));
        text = "Text Library Java Categorizzare (JTCL) \u00e8 un puro Java 1.5 realizzazione di libtextcat che a sua volta \u00e8 \"una libreria che \u00e8 stato sviluppato per la lingua indovinare Primar, un compito su cui \u00e8 conosciuto per eseguire con precisione quasi perfetta.\"";
        this.getFixture();
        Assert.assertEquals((Object)LanguageCode.it, (Object)Tokenizer.checkLanguage((String)text));
    }

    public List<Token> createCase1() {
        Vector<Token> expectedToken = new Vector<Token>();
        expectedToken.add(new Token("Die", 0, 3));
        expectedToken.add(new Token("\u00d6lpest", 4, 10));
        expectedToken.add(new Token("im", 11, 13));
        expectedToken.add(new Token("Golf", 14, 18));
        expectedToken.add(new Token("von", 19, 22));
        expectedToken.add(new Token("Mexiko", 23, 29));
        expectedToken.add(new Token("sei", 30, 33));
        expectedToken.add(new Token("eine", 34, 38));
        expectedToken.add(new Token("\"", 39, 40));
        expectedToken.add(new Token("f\ufffdrchterliche", 40, 53));
        expectedToken.add(new Token("Trag\ufffddie", 54, 62));
        expectedToken.add(new Token(",", 62, 63));
        expectedToken.add(new Token("f\ufffdr", 64, 67));
        expectedToken.add(new Token("die", 68, 71));
        expectedToken.add(new Token("ich", 72, 75));
        expectedToken.add(new Token("als", 76, 79));
        expectedToken.add(new Token("Verantwortlicher", 80, 96));
        expectedToken.add(new Token("bei", 97, 100));
        expectedToken.add(new Token("BP", 101, 103));
        expectedToken.add(new Token("immer", 104, 109));
        expectedToken.add(new Token("eine", 110, 114));
        expectedToken.add(new Token("gro\ufffde", 115, 120));
        expectedToken.add(new Token("Verantwortung", 121, 134));
        expectedToken.add(new Token("f\ufffdhlen", 135, 141));
        expectedToken.add(new Token("werde", 142, 147));
        expectedToken.add(new Token("\"", 147, 148));
        expectedToken.add(new Token(",", 148, 149));
        expectedToken.add(new Token("erkl\ufffdrte", 150, 158));
        expectedToken.add(new Token("der", 159, 162));
        expectedToken.add(new Token("scheidende", 163, 173));
        expectedToken.add(new Token("Konzernchef", 174, 185));
        expectedToken.add(new Token("Hayward", 186, 193));
        expectedToken.add(new Token(".", 193, 194));
        expectedToken.add(new Token("BP", 195, 197));
        expectedToken.add(new Token("werde", 198, 203));
        expectedToken.add(new Token("sich", 204, 208));
        expectedToken.add(new Token("durch", 209, 214));
        expectedToken.add(new Token("den", 215, 218));
        expectedToken.add(new Token("Vorfall", 219, 226));
        expectedToken.add(new Token("ver\ufffdndern", 227, 236));
        expectedToken.add(new Token("und", 237, 240));
        expectedToken.add(new Token("solle", 241, 246));
        expectedToken.add(new Token("unter", 247, 252));
        expectedToken.add(new Token("neuer", 253, 258));
        expectedToken.add(new Token("F\ufffdhrung", 259, 266));
        expectedToken.add(new Token("in", 267, 269));
        expectedToken.add(new Token("diese", 270, 275));
        expectedToken.add(new Token("Phase", 276, 281));
        expectedToken.add(new Token("starten", 282, 289));
        expectedToken.add(new Token(",", 289, 290));
        expectedToken.add(new Token("begr\ufffdndete", 291, 301));
        expectedToken.add(new Token("er", 302, 304));
        expectedToken.add(new Token("seinen", 305, 311));
        expectedToken.add(new Token("R\ufffdckzug", 312, 319));
        expectedToken.add(new Token("zum", 320, 323));
        expectedToken.add(new Token("1.", 324, 326));
        expectedToken.add(new Token("Oktober", 327, 334));
        expectedToken.add(new Token(".", 334, 335));
        return expectedToken;
    }

    @Test
    public void testCase1() {
        String text = "Die \u00d6lpest im Golf von Mexiko sei eine \"f\ufffdrchterliche Trag\ufffddie, f\ufffdr die ich als Verantwortlicher bei BP immer eine gro\ufffde Verantwortung f\ufffdhlen werde\", erkl\ufffdrte der scheidende Konzernchef Hayward. BP werde sich durch den Vorfall ver\ufffdndern und solle unter neuer F\ufffdhrung in diese Phase starten, begr\ufffdndete er seinen R\ufffdckzug zum 1. Oktober.";
        List<Token> expectedToken = this.createCase1();
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull((Object)expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)expectedToken.get((int)i).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)expectedToken.get((int)i).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)expectedToken.get((int)i).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testCase2() {
        String text = "Die \u00d6lpest im Golf von Mexiko sei eine \"f\ufffdrchterliche Trag\ufffddie, f\ufffdr die ich als Verantwortlicher bei BP immer eine gro\ufffde Verantwortung f\ufffdhlen werde\", erkl\ufffdrte der scheidende Konzernchef Hayward. BP werde sich durch den Vorfall ver\ufffdndern und solle unter neuer F\ufffdhrung in diese Phase starten, begr\ufffdndete er seinen R\ufffdckzug zum 1. Oktober.";
        List<Token> expectedToken = this.createCase1();
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.de);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull((Object)expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)expectedToken.get((int)i).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)expectedToken.get((int)i).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)expectedToken.get((int)i).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testCase4() {
        String text = "Die \u00d6lpest";
        Vector<Token> expectedToken = null;
        expectedToken = new Vector<Token>();
        expectedToken.add(new Token("Die", 0, 3));
        expectedToken.add(new Token("\u00d6lpest", 4, 10));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.de);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testCase5() {
        String text = "Feigenblatt  ";
        Vector<Token> expectedToken = null;
        expectedToken = new Vector<Token>();
        expectedToken.add(new Token("Feigenblatt", 0, 11));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.de);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testCase6() {
        String text = "Die \u00d6lpest";
        Vector<Token> expectedToken = null;
        expectedToken = new Vector<Token>();
        expectedToken.add(new Token("Die", 0, 3));
        expectedToken.add(new Token("\u00d6lpest", 4, 10));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.de);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testCase7() {
        String text = "O.K., so the answer's obvious.";
        Vector<Token> expectedToken = new Vector<Token>();
        expectedToken.add(new Token("O.K.", 0, 4));
        expectedToken.add(new Token(",", 4, 5));
        expectedToken.add(new Token("so", 6, 8));
        expectedToken.add(new Token("the", 9, 12));
        expectedToken.add(new Token("answer", 13, 19));
        expectedToken.add(new Token("'s", 19, 21));
        expectedToken.add(new Token("obvious", 22, 29));
        expectedToken.add(new Token(".", 29, 30));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(text);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.en);
        Assert.assertEquals((long)expectedToken.size(), (long)sDocGraph.getTokens().size());
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testDefaultClitics() {
        String francais = "ou ceux-l\u00e0 m\u00eames qu'il s'affirmaient";
        String italiano = "Riuscire all'universit\u00e0";
        Vector<Token> expectedItalianoToken = new Vector<Token>();
        Vector<Token> expectedFrancaisToken = new Vector<Token>();
        expectedItalianoToken.add(new Token("Riuscire", 0, 8));
        expectedItalianoToken.add(new Token("all'", 9, 13));
        expectedItalianoToken.add(new Token("universit\u00e0", 13, 23));
        expectedFrancaisToken.add(new Token("ou", 0, 2));
        expectedFrancaisToken.add(new Token("ceux", 3, 7));
        expectedFrancaisToken.add(new Token("-l\u00e0", 7, 10));
        expectedFrancaisToken.add(new Token("m\u00eames", 11, 16));
        expectedFrancaisToken.add(new Token("qu'", 17, 20));
        expectedFrancaisToken.add(new Token("il", 20, 22));
        expectedFrancaisToken.add(new Token("s'", 23, 25));
        expectedFrancaisToken.add(new Token("affirmaient", 25, 36));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(francais);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.fr);
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedFrancaisToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedFrancaisToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
        sDocGraph = SaltFactory.createSDocumentGraph();
        sTextualDS = sDocGraph.createTextualDS(italiano);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS, LanguageCode.it);
        i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedItalianoToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedItalianoToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
        sDocGraph = SaltFactory.createSDocumentGraph();
        sTextualDS = sDocGraph.createTextualDS(francais);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS);
        i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedFrancaisToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedFrancaisToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedFrancaisToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
        sDocGraph = SaltFactory.createSDocumentGraph();
        sTextualDS = sDocGraph.createTextualDS(italiano);
        this.getFixture().setsDocumentGraph(sDocGraph);
        this.getFixture().tokenize(sTextualDS);
        i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedItalianoToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedItalianoToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedItalianoToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    @Test
    public void testFantasyClitics() {
        String fantasy = "S Z-S-z X-S-x Y^S^y Z.S.z x^S.Y";
        String fantasyProclitics = "([Xx]-|[Yy]\\^|[Zz]\\.)";
        String fantasyEnclitics = "(-[Xx]|\\^[Yy]|\\.[Zz])";
        Vector<Token> expectedToken = new Vector<Token>();
        expectedToken.add(new Token("S", 0, 1));
        expectedToken.add(new Token("Z-S-z", 2, 7));
        expectedToken.add(new Token("X-", 8, 10));
        expectedToken.add(new Token("S", 10, 11));
        expectedToken.add(new Token("-x", 11, 13));
        expectedToken.add(new Token("Y^", 14, 16));
        expectedToken.add(new Token("S", 16, 17));
        expectedToken.add(new Token("^y", 17, 19));
        expectedToken.add(new Token("Z.", 20, 22));
        expectedToken.add(new Token("S", 22, 23));
        expectedToken.add(new Token(".z", 23, 25));
        expectedToken.add(new Token("x^S.Y", 26, 31));
        SDocumentGraph sDocGraph = SaltFactory.createSDocumentGraph();
        STextualDS sTextualDS = sDocGraph.createTextualDS(fantasy);
        this.getFixture().addClitics(LanguageCode.aa, new Clitics(fantasyProclitics, fantasyEnclitics));
        this.getFixture().tokenize(sTextualDS, LanguageCode.aa);
        int i = 0;
        for (STextualRelation sTextRel : sDocGraph.getTextualRelations()) {
            Assert.assertTrue((expectedToken.size() >= i ? 1 : 0) != 0);
            Assert.assertNotNull(expectedToken.get(i));
            Assert.assertNotNull((Object)sTextRel.getSource());
            Assert.assertNotNull((Object)sTextRel.getTarget());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).startPos, (Object)sTextRel.getStart());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).endPos, (Object)sTextRel.getEnd());
            Assert.assertEquals((Object)((Token)expectedToken.get((int)i)).text, (Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
            ++i;
        }
    }

    static class Token {
        String text;
        Integer startPos;
        Integer endPos;

        public Token(String text, int startPos, int endPos) {
            this.text = text;
            this.startPos = startPos;
            this.endPos = endPos;
        }
    }
}

