/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl.tests;

import java.util.ArrayList;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNamedElement;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.junit.Assert;

public class TestHelper {
    public static void testGetName(SNamedElement namedElement) {
        Assert.assertNull((Object)namedElement.getName());
        namedElement.setName("myName");
        Assert.assertEquals((Object)"myName", (Object)namedElement.getName());
        namedElement.setName(null);
        Assert.assertNull((Object)namedElement.getName());
        if (namedElement instanceof SAnnotationContainer) {
            ((SAnnotationContainer)namedElement).removeLabel("salt::SNAME");
            Assert.assertNull((Object)namedElement.getName());
            ((SAnnotationContainer)namedElement).createFeature("salt", "SNAME", (Object)"myName2");
            Assert.assertEquals((Object)"myName2", (Object)namedElement.getName());
        }
    }

    public static void createGraph(SGraph graph, String[] nodeNames, String[][] relationNames) {
        ArrayList<SNode> nodes = new ArrayList<SNode>();
        for (String nodeName : nodeNames) {
            SNode node = SaltFactory.createSNode();
            node.setId(nodeName);
            nodes.add(node);
            graph.addNode((Node)node);
        }
        SRelation relation = null;
        block1: for (int i = 0; i < relationNames.length; ++i) {
            for (SNode srcNode : nodes) {
                if (!srcNode.getId().equalsIgnoreCase(relationNames[i][0])) continue;
                for (SNode dstNode : nodes) {
                    if (!dstNode.getId().equalsIgnoreCase(relationNames[i][1])) continue;
                    relation = SaltFactory.createSRelation();
                    relation.setId(relationNames[i][2]);
                    relation.setSource((Node)srcNode);
                    relation.setTarget((Node)dstNode);
                    graph.addRelation((Relation)relation);
                    continue block1;
                }
            }
        }
    }

    public static SGraph createGraph_Tree() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("createGraph_Tree");
        String[] nodeNames = new String[]{"node1", "node2", "node3", "node4", "node5", "node6", "node7"};
        String[][] relationNames = new String[][]{{"node1", "node2", "relation1"}, {"node2", "node3", "relation2"}, {"node1", "node4", "relation3"}, {"node4", "node5", "relation4"}, {"node2", "node6", "relation5"}, {"node1", "node7", "relation6"}};
        TestHelper.createGraph(graph, nodeNames, relationNames);
        return graph;
    }

    public static SGraph createGraph_DAG() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("createGraph_DAG");
        String[] nodeNames = new String[]{"node1", "node2", "node3", "node4", "node6"};
        String[][] relationNames = new String[][]{{"node1", "node2", "relation1"}, {"node2", "node3", "relation2"}, {"node2", "node6", "relation3"}, {"node4", "node2", "relation4"}};
        TestHelper.createGraph(graph, nodeNames, relationNames);
        return graph;
    }

    public static SGraph createGraph_Cycle() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("createGraph_Cycle");
        String[] nodeNames = new String[]{"node1", "node2", "node3", "node4", "node6", "node7"};
        String[][] relationNames = new String[][]{{"node1", "node2", "relation1"}, {"node2", "node3", "relation2"}, {"node2", "node6", "relation3"}, {"node4", "node2", "relation4"}, {"node6", "node7", "relation5"}, {"node7", "node2", "relation6"}};
        TestHelper.createGraph(graph, nodeNames, relationNames);
        return graph;
    }

    public static SGraph createGraph_SimpleCycle() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("createGraph_SimpleCycle");
        String[] nodeNames = new String[]{"node1", "node2", "node3", "node6", "node7"};
        String[][] relationNames = new String[][]{{"node1", "node2", "relation1"}, {"node2", "node3", "relation2"}, {"node2", "node6", "relation3"}, {"node6", "node7", "relation5"}, {"node7", "node2", "relation6"}};
        TestHelper.createGraph(graph, nodeNames, relationNames);
        return graph;
    }

    public static SGraph createGraph_PureCycle() {
        SGraph graph = SaltFactory.createSGraph();
        graph.setId("createGraph_PureCycle");
        String[] nodeNames = new String[]{"node1", "node2", "node3"};
        String[][] relationNames = new String[][]{{"node1", "node2", "relation1"}, {"node2", "node3", "relation2"}, {"node3", "node1", "relation3"}};
        TestHelper.createGraph(graph, nodeNames, relationNames);
        return graph;
    }
}

