/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.impl.LabelableElementImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabelTest {
    private Label fixture = null;

    public Label getFixture() {
        return this.fixture;
    }

    public void setFixture(Label fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(this.createLabel());
    }

    @Test
    public void testGetQName() {
        Label label = this.getFixture();
        String qName = null;
        qName = label.getQName();
        Assert.assertEquals((Object)qName, (Object)label.getQName());
        label = this.getFixture();
        qName = null;
        try {
            label.setQName(qName);
            Assert.fail((String)"should fail if an empty QName is set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        label = this.getFixture();
        qName = "";
        try {
            label.setQName(qName);
            Assert.fail((String)"should fail if an empty QName is set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        label = this.createLabel();
        qName = "any name";
        label.setQName(qName);
        Assert.assertEquals((Object)qName, (Object)label.getQName());
        this.setFixture(this.createLabel());
        label = this.getFixture();
        qName = "label1";
        label.setQName(qName);
        Assert.assertEquals((Object)qName, (Object)label.getQName());
        label = this.getFixture();
        qName = "ns::name";
        label.setQName(qName);
        Assert.assertEquals((Object)qName, (Object)label.getQName());
        label = this.getFixture();
        qName = "ns::ns2::name";
        label.setQName(qName);
        Assert.assertEquals((Object)qName, (Object)label.getQName());
        label = this.getFixture();
        qName = "ns::ns::name";
        label.setQName(qName);
        Assert.assertEquals((Object)qName, (Object)label.getQName());
    }

    @Test
    public void testGetQName2() {
        Assert.assertNull((Object)this.getFixture().getQName());
        String name = "name";
        String namespace = "namespace";
        this.getFixture().setName(name);
        Assert.assertEquals((Object)name, (Object)this.getFixture().getQName());
        this.setFixture(this.createLabel());
        this.getFixture().setNamespace(namespace);
        Assert.assertEquals((Object)(namespace + "::"), (Object)this.getFixture().getQName());
        this.getFixture().setName(name);
        Assert.assertEquals((Object)(namespace + "::" + name), (Object)this.getFixture().getQName());
    }

    @Test
    public void testGeneralNameHandling() {
        Label label = this.getFixture();
        String ns = null;
        String name = null;
        String QName = null;
        label = this.getFixture();
        ns = null;
        QName = name = "label1";
        label.setNamespace(ns);
        label.setName(name);
        Assert.assertEquals((Object)QName, (Object)label.getQName());
        label = this.getFixture();
        ns = "ns1";
        name = null;
        label.setNamespace(ns);
        try {
            label.setName(name);
            Assert.fail((String)"should fail if an empty name was given.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        label = this.getFixture();
        ns = "ns1";
        name = "";
        label.setNamespace(ns);
        try {
            label.setName(name);
            Assert.fail((String)"should fail if an empty name was given.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        label = this.getFixture();
        ns = null;
        name = "name1::name2";
        label.setNamespace(ns);
        try {
            label.setName(name);
            Assert.fail((String)"a name with the namespace sperator is illegal.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        label = this.getFixture();
        ns = null;
        name = "label1";
        label.setName(name);
        Assert.assertEquals((Object)name, (Object)label.getQName());
    }

    public void testValueHandling() {
        Label label = this.getFixture();
        String value = null;
        label.setValue(value);
        Assert.assertEquals(value, (Object)label.getValue());
        value = "val1";
        label.setValue((Object)value);
        Assert.assertEquals((Object)value, (Object)label.getValue());
        value = "val1::val2";
        label.setValue((Object)value);
        Assert.assertEquals((Object)value, (Object)label.getValue());
    }

    @Test
    public void testGetValue() {
        Assert.assertNull((Object)this.getFixture().getValue());
        Object obj = new Object();
        this.getFixture().setValue(obj);
        Assert.assertEquals((Object)obj, (Object)this.getFixture().getValue());
        String value = "value";
        this.getFixture().setValue((Object)value);
        Assert.assertEquals((Object)value, (Object)this.getFixture().getValue());
    }

    @Test
    public void testCopy() {
        this.getFixture().setNamespace("namespace1");
        this.getFixture().setName("name1");
        this.getFixture().setValue((Object)"value1");
        Label other = this.createLabel();
        this.getFixture().copy((Object)other);
        Assert.assertEquals((Object)this.getFixture().getNamespace(), (Object)other.getNamespace());
        Assert.assertEquals((Object)this.getFixture().getName(), (Object)other.getName());
        Assert.assertEquals((Object)this.getFixture().getValue(), (Object)other.getValue());
    }

    @Test
    public void testDoubleChaining() {
        LabelableElementImpl container = new LabelableElementImpl(){};
        this.getFixture().setQName("labelName");
        Assert.assertNull((Object)this.getFixture().getContainer());
        container.addLabel(this.getFixture());
        Assert.assertEquals((Object)container, (Object)this.getFixture().getContainer());
    }

    @Test
    public void testMoveLabel() {
        this.getFixture().setName("myLabel");
        LabelableElementImpl container1 = new LabelableElementImpl(){};
        LabelableElementImpl container2 = new LabelableElementImpl(){};
        container1.addLabel(this.getFixture());
        Assert.assertTrue((boolean)container1.containsLabel(this.getFixture().getQName()));
        Assert.assertEquals((Object)container1, (Object)this.getFixture().getContainer());
        container2.addLabel(this.getFixture());
        Assert.assertTrue((boolean)container2.containsLabel(this.getFixture().getQName()));
        Assert.assertEquals((Object)0, (Object)container1.sizeLabels());
        Assert.assertEquals((Object)container2, (Object)this.getFixture().getContainer());
    }

    protected Label createLabel() {
        return GraphFactory.createLabel();
    }
}

