/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl.tests;

import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationTest {
    protected Relation<Node, Node> fixture = null;

    public Relation<Node, Node> getFixture() {
        return this.fixture;
    }

    public void setFixture(Relation<Node, Node> fixture) {
        this.fixture = fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture((Relation<Node, Node>)this.createRelation());
    }

    protected Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> createGraph() {
        return GraphFactory.createGraph();
    }

    protected Node createNode() {
        return GraphFactory.createNode();
    }

    protected Relation createRelation() {
        return GraphFactory.createRelation();
    }

    protected Layer<Node, Relation<Node, Node>> createLayer() {
        return GraphFactory.createLayer();
    }

    @Test
    public void testDoubleChaining_SetGraph() {
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        Node source = this.createNode();
        Node target = this.createNode();
        graph.addNode(source);
        graph.addNode(target);
        this.getFixture().setSource(source);
        this.getFixture().setTarget(target);
        this.getFixture().setGraph(graph);
        Assert.assertTrue((String)("only contains " + graph.getRelations()), (boolean)graph.getRelations().contains(this.getFixture()));
    }

    @Test
    public void testDoubleChaining_SetGraph_remove() {
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        Node source = this.createNode();
        Node target = this.createNode();
        graph.addNode(source);
        graph.addNode(target);
        this.getFixture().setSource(source);
        this.getFixture().setTarget(target);
        this.getFixture().setGraph(graph);
        Assert.assertEquals(graph, (Object)this.getFixture().getGraph());
        this.getFixture().setGraph(null);
        Assert.assertNull((Object)this.getFixture().getGraph());
        this.getFixture().setGraph(graph);
        Assert.assertEquals(graph, (Object)this.getFixture().getGraph());
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph2 = this.createGraph();
        Node source2 = this.createNode();
        Node target2 = this.createNode();
        graph2.addNode(source2);
        graph2.addNode(target2);
        this.getFixture().setSource(source2);
        this.getFixture().setTarget(target2);
        this.getFixture().setGraph(graph2);
        Assert.assertEquals(graph2, (Object)this.getFixture().getGraph());
    }

    @Test
    public void testAddGetLayers() {
        Layer<Node, Relation<Node, Node>> layer = this.createLayer();
        Node source = this.createNode();
        Node target = this.createNode();
        this.getFixture().setSource(source);
        this.getFixture().setTarget(target);
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        graph.addLayer(layer);
        graph.addNode(source);
        graph.addNode(target);
        graph.addRelation(this.getFixture());
        this.getFixture().addLayer(layer);
        Assert.assertEquals((long)1L, (long)this.getFixture().getLayers().size());
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
    }

    @Test
    public void testRemoveLayers() {
        Assert.assertNotNull((Object)this.getFixture().getLayers());
        Layer<Node, Relation<Node, Node>> layer = this.createLayer();
        Node source = this.createNode();
        Node target = this.createNode();
        this.getFixture().setSource(source);
        this.getFixture().setTarget(target);
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        graph.addLayer(layer);
        graph.addNode(source);
        graph.addNode(target);
        graph.addRelation(this.getFixture());
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)this.getFixture().getLayers().contains(layer));
        this.getFixture().removeLayer(layer);
        Assert.assertEquals((long)0L, (long)this.getFixture().getLayers().size());
    }

    @Test
    public void testDoubleChainingLayer() {
        Layer<Node, Relation<Node, Node>> layer = this.createLayer();
        Node source = this.createNode();
        Node target = this.createNode();
        this.getFixture().setSource(source);
        this.getFixture().setTarget(target);
        Graph<Node, Relation<Node, Node>, Layer<Node, Relation<Node, Node>>> graph = this.createGraph();
        graph.addLayer(layer);
        graph.addNode(source);
        graph.addNode(target);
        graph.addRelation(this.getFixture());
        this.getFixture().addLayer(layer);
        Assert.assertTrue((boolean)layer.getRelations().contains(this.getFixture()));
        this.getFixture().removeLayer(layer);
        Assert.assertFalse((boolean)layer.getRelations().contains(this.getFixture()));
    }
}

