/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextOverlappingRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimeOverlappingRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.internal.GetXBySequence;
import org.junit.Before;
import org.junit.Test;

public class GetXBySequenceTest {
    private GetXBySequence fixture;
    private SDocumentGraph documentGraph;

    @Before
    public void beforeEach() {
        SDocument document = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)document);
        this.documentGraph = document.getDocumentGraph();
        this.fixture = new GetXBySequence(this.documentGraph);
    }

    @Test
    public void whenGettingAllNodesOverlappingAText_thenReturnAllNodes() {
        ArrayList expectedNodes = new ArrayList();
        expectedNodes.addAll(this.documentGraph.getTokens());
        expectedNodes.addAll(this.documentGraph.getSpans());
        expectedNodes.addAll(this.documentGraph.getStructures());
        STextualDS overlappedText = (STextualDS)this.documentGraph.getTextualDSs().get(0);
        List actualNodes = this.fixture.getNodeBySequence(new DataSourceSequence.Builder().on((SSequentialDS)overlappedText).from((Number)0).to(overlappedText.getEnd()).build());
        Assertions.assertThat((List)actualNodes).containsExactlyInAnyOrder((Object[])expectedNodes.toArray(new SNode[expectedNodes.size()]));
    }

    @Test
    public void whenGettingAllTokensOverlappingAText_thenReturnAllTokens() {
        ArrayList expectedTokens = new ArrayList();
        expectedTokens.addAll(this.documentGraph.getTokens());
        STextualDS overlappedText = (STextualDS)this.documentGraph.getTextualDSs().get(0);
        List actualNodes = this.fixture.getTokensBySequence(new DataSourceSequence.Builder().on((SSequentialDS)overlappedText).from((Number)0).to(overlappedText.getEnd()).build());
        Assertions.assertThat((List)actualNodes).containsExactlyInAnyOrder((Object[])expectedTokens.toArray(new SToken[expectedTokens.size()]));
    }

    @Test
    public void whenGettingAllSpansOverlappingAText_thenReturnAllSpans() {
        ArrayList expectedSpans = new ArrayList();
        expectedSpans.addAll(this.documentGraph.getSpans());
        STextualDS overlappedText = (STextualDS)this.documentGraph.getTextualDSs().get(0);
        List actualNodes = this.fixture.getSpanBySequence(new DataSourceSequence.Builder().on((SSequentialDS)overlappedText).from((Number)0).to(overlappedText.getEnd()).build());
        Assertions.assertThat((List)actualNodes).containsExactlyInAnyOrder((Object[])expectedSpans.toArray(new SSpan[expectedSpans.size()]));
    }

    @Test
    public void whenGettingAllStructuresOverlappingAText_thenReturnAllStructures() {
        ArrayList expectedStructures = new ArrayList();
        expectedStructures.addAll(this.documentGraph.getStructures());
        STextualDS overlappedText = (STextualDS)this.documentGraph.getTextualDSs().get(0);
        List actualNodes = this.fixture.getStructureBySequence(new DataSourceSequence.Builder().on((SSequentialDS)overlappedText).from((Number)0).to(overlappedText.getEnd()).build());
        Assertions.assertThat((List)actualNodes).containsExactlyInAnyOrder((Object[])expectedStructures.toArray(new SStructure[expectedStructures.size()]));
    }

    @Test
    public void whenFindingRelationTypeForSTextualDS_thenReturnSTextOverlappingRelation() {
        DataSourceSequence sequence = new DataSourceSequence.Builder().on((SSequentialDS)SaltFactory.createSTextualDS()).build();
        Assertions.assertThat((Class)this.fixture.findRelationTypeToDataSourceSequence(sequence)).isEqualTo(STextOverlappingRelation.class);
    }

    @Test
    public void whenFindingRelationTypeForSTimeline_thenReturnSTimeOverlappingRelation() {
        DataSourceSequence sequence = new DataSourceSequence.Builder().on((SSequentialDS)SaltFactory.createSTimeline()).build();
        Assertions.assertThat((Class)this.fixture.findRelationTypeToDataSourceSequence(sequence)).isEqualTo(STimeOverlappingRelation.class);
    }

    @Test
    public void whenFindingRelationTypeForEmptyDataSource_thenReturnNull() {
        DataSourceSequence sequence = new DataSourceSequence.Builder().on(null).build();
        Assertions.assertThat((Class)this.fixture.findRelationTypeToDataSourceSequence(sequence)).isNull();
    }
}

