/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.tests;

import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.samples.SampleGenerator;
import org.corpus_tools.salt.tests.SaltTestsUtil;
import org.corpus_tools.salt.util.VisJsVisualizer;
import org.eclipse.emf.common.util.URI;
import org.json.JSONArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VisJsVisualizerTest {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String OUTPUT_FOLDER = SaltTestsUtil.getTempTestFolder().getAbsolutePath();
    private static final String INPUT_FOLDER = "src" + FSEP + "test" + FSEP + "resources" + FSEP + "VisJsTest" + FSEP + "sources";
    private static final String INPUT_FILE_MAIN_TEST = INPUT_FOLDER + FSEP + "pcc2_salt" + FSEP + "pcc2" + FSEP + "11299.salt";
    private static final String TEST_RESULT_FOLDER = "src" + FSEP + "test" + FSEP + "resources" + FSEP + "VisJsTest" + FSEP + "results";
    private String[] allFileNames;

    @Before
    public void setUp() {
        this.allFileNames = new String[4];
        this.allFileNames[0] = "saltVisJs.html";
        this.allFileNames[1] = "js" + FSEP + "jquery.js";
        this.allFileNames[2] = "js" + FSEP + "vis.min.js";
        this.allFileNames[3] = "css" + FSEP + "vis.min.css";
    }

    @Test
    public void testHtmlWriterWholeDoc() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        String inputFilePath = INPUT_FILE_MAIN_TEST;
        String outputFolderName = "pcc_whole_doc_11299";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        URI uri = URI.createFileURI((String)inputFilePath);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(uri);
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testHtmlWriterSample() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createDocumentStructure((SDocument)doc);
        doc.setName("Sample");
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(doc);
        String outputFolderName = "sample_doc";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testHtmlWriterSampleDependencies() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createDependencies((SDocument)doc);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(doc);
        String outputFolderName = "sample_doc_dependencies";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testHtmlWriterSampleSyntaxStructure() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createSyntaxStructure((SDocument)doc);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(doc);
        String outputFolderName = "sample_doc_syntax_structure";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testHtmlWriterSampleTokens() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createTokens((SDocument)doc);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(doc);
        String outputFolderName = "sample_doc_tokens";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testHtmlWriterSampleMorphologyAnn() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createMorphologyAnnotations((SDocument)doc);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(doc);
        String outputFolderName = "sample_doc_morphology_ann";
        String outputFolderPath = OUTPUT_FOLDER + FSEP + outputFolderName;
        File testFolder = new File(outputFolderPath);
        File resultFolder = new File(TEST_RESULT_FOLDER, outputFolderName);
        URI outputFolderUri = URI.createFileURI((String)outputFolderPath);
        boolean equalFiles = false;
        visJsVisualizer.visualize(outputFolderUri);
        if (VisJsVisualizerTest.folderStructureOk(testFolder) && VisJsVisualizerTest.folderStructureOk(resultFolder)) {
            equalFiles = true;
            for (int i = 0; i < this.allFileNames.length - 1; ++i) {
                equalFiles = equalFiles && VisJsVisualizerTest.filesAreEqual(new File(resultFolder, this.allFileNames[i]), new File(testFolder, this.allFileNames[i]));
            }
        }
        Assert.assertTrue((boolean)equalFiles);
    }

    @Test
    public void testWriterOutput() throws SaltParameterException, SaltResourceException, SaltException, IOException, XMLStreamException {
        SDocument doc = SaltFactory.createSDocument();
        SampleGenerator.createMorphologyAnnotations((SDocument)doc);
        VisJsVisualizer VisJsVisualizer2 = new VisJsVisualizer(doc);
        ByteArrayOutputStream osNodes = new ByteArrayOutputStream();
        ByteArrayOutputStream osEdges = new ByteArrayOutputStream();
        VisJsVisualizer2.setNodeWriter((OutputStream)osNodes);
        VisJsVisualizer2.setEdgeWriter((OutputStream)osEdges);
        VisJsVisualizer2.buildJSON();
        String strNodes = ((Object)osNodes).toString();
        String strEdges = ((Object)osEdges).toString();
        System.out.println(strNodes);
        System.out.println(strEdges);
        JSONArray jsonNodes = new JSONArray(strNodes);
        JSONArray jsonEdges = new JSONArray(strEdges);
        System.out.println(jsonNodes.toString());
        System.out.println(jsonEdges.toString());
    }

    @Test(expected=SaltParameterException.class)
    public void testInputUrlIsNull() throws IOException {
        URI uri = null;
        new VisJsVisualizer(uri);
    }

    @Test(expected=SaltResourceException.class)
    public void testInvalideSaltFormat() throws IOException {
        String inputFilePath = INPUT_FOLDER + FSEP + "pcc2_invalid_format" + FSEP + "pcc2" + FSEP + "11299.salt";
        URI uri = URI.createFileURI((String)inputFilePath);
        new VisJsVisualizer(uri);
    }

    @Test(expected=SaltResourceException.class)
    public void testAbsentSaltResource() throws IOException {
        String inputFilePath = INPUT_FOLDER + FSEP + "pcc2_absent_resource" + FSEP + "pcc2" + FSEP + "11299.salt";
        URI uri = URI.createFileURI((String)inputFilePath);
        new VisJsVisualizer(uri);
    }

    @Test(expected=SaltParameterException.class)
    public void testNodeWriterIsNull() throws IOException {
        URI uri = URI.createFileURI((String)INPUT_FILE_MAIN_TEST);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(uri);
        visJsVisualizer.setEdgeWriter((OutputStream)System.out);
        visJsVisualizer.buildJSON();
    }

    @Test(expected=SaltParameterException.class)
    public void testEdgeWriterIsNull() throws IOException {
        URI uri = URI.createFileURI((String)INPUT_FILE_MAIN_TEST);
        VisJsVisualizer visJsVisualizer = new VisJsVisualizer(uri);
        visJsVisualizer.setNodeWriter((OutputStream)System.out);
        visJsVisualizer.buildJSON();
    }

    private static boolean folderStructureOk(File folder) {
        int nFiles = 3;
        return folder.exists() && folder.isDirectory() && folder.canRead() && folder.listFiles().length == nFiles;
    }

    private static boolean filesAreEqual(File testFile, File resultFile) throws IOException {
        return Files.equal((File)testFile, (File)resultFile);
    }
}

