/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.common.impl.SaltProjectImpl;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.core.impl.SGraphImpl;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;

public class SCorpusGraphImpl
extends SGraphImpl
implements SCorpusGraph {
    protected transient SaltProject saltProject = null;

    public SCorpusGraphImpl() {
    }

    public SCorpusGraphImpl(Graph delegate) {
        super(delegate);
    }

    @Override
    protected void init() {
        super.init();
        this.getIndexMgr().createIndex("idx_sNodeType", Class.class, Node.class, this.expectedNodes / 2, this.expectedNodes);
        this.getIndexMgr().createIndex("idx_sRelationType", Class.class, Relation.class, this.expectedRelations / 2, this.expectedRelations);
    }

    @Override
    public SaltProject getSaltProject() {
        return this.saltProject;
    }

    @Override
    public void setSaltProject(SaltProject saltProject) {
        if (saltProject != null) {
            if (saltProject instanceof SaltProjectImpl) {
                ((SaltProjectImpl)saltProject).basic_addCorpusGraph(this);
            }
        } else if (this.getSaltProject() instanceof SaltProjectImpl) {
            ((SaltProjectImpl)this.getSaltProject()).basic_removeCorpusGraph(this);
        }
        this.basic_setSaltProject(saltProject);
    }

    public void basic_setSaltProject(SaltProject saltProject) {
        this.saltProject = saltProject;
    }

    private void setRelationIdIfNecessary(Relation<? extends Node, ? extends Node> relation) {
        if (Strings.isNullOrEmpty((String)((SRelation)relation).getName())) {
            if (relation instanceof SCorpusRelation) {
                ((SRelation)relation).setName("corpRel" + (this.getCorpusRelations().size() + 1));
            } else if (relation instanceof SCorpusDocumentRelation) {
                ((SRelation)relation).setName("corpDocRel" + (this.getCorpusDocumentRelations().size() + 1));
            } else {
                ((SRelation)relation).setName("rel" + (this.getRelations().size() + 1));
            }
        }
        if (Strings.isNullOrEmpty((String)relation.getId())) {
            ((SRelation)relation).setId("salt:/" + ((SRelation)relation).getName());
        }
    }

    @Override
    protected void basicAddRelation(Relation<? extends Node, ? extends Node> relation) {
        if (!(relation instanceof SRelation)) {
            throw new SaltInsertionException(this, relation, "Cannot insert an edge, which is not a SRelation object. ");
        }
        this.setRelationIdIfNecessary(relation);
        super.basicAddRelation(relation);
    }

    @Override
    public void addRelation(Relation<? extends SNode, ? extends SNode> relation) {
        if (this.getDelegate() != null) {
            this.setRelationIdIfNecessary(relation);
        }
        super.addRelation(relation);
        Class key = relation instanceof SCorpusRelation ? SCorpusRelation.class : (relation instanceof SCorpusDocumentRelation ? SCorpusDocumentRelation.class : relation.getClass());
        this.getIndexMgr().put("idx_sRelationType", key, relation);
    }

    private void setNodeIdIfNecessary(SNode node) {
        if (Strings.isNullOrEmpty((String)node.getName())) {
            if (node instanceof SCorpus) {
                node.setName("corp" + (this.getCorpora().size() + 1));
            } else if (node instanceof SDocument) {
                node.setName("doc" + (this.getDocuments().size() + 1));
            } else {
                node.setName("node" + (this.getDocuments().size() + 1));
            }
        }
        if (Strings.isNullOrEmpty((String)node.getId())) {
            node.setId("salt:/" + node.getName());
        }
    }

    @Override
    protected void basicAddNode(SNode node) {
        this.setNodeIdIfNecessary(node);
        super.basicAddNode(node);
    }

    @Override
    public void addNode(SNode node) {
        if (this.getDelegate() != null) {
            this.setNodeIdIfNecessary(node);
        }
        super.addNode(node);
        Class key = node instanceof SCorpus ? SCorpus.class : (node instanceof SDocument ? SDocument.class : node.getClass());
        this.getIndexMgr().put("idx_sNodeType", key, node);
    }

    @Override
    public List<SCorpus> getCorpora() {
        return this.getIndexMgr().getAll("idx_sNodeType", SCorpus.class);
    }

    @Override
    public List<SDocument> getDocuments() {
        return this.getIndexMgr().getAll("idx_sNodeType", SDocument.class);
    }

    @Override
    public List<SCorpusRelation> getCorpusRelations() {
        return this.getIndexMgr().getAll("idx_sRelationType", SCorpusRelation.class);
    }

    @Override
    public List<SCorpusDocumentRelation> getCorpusDocumentRelations() {
        return this.getIndexMgr().getAll("idx_sRelationType", SCorpusDocumentRelation.class);
    }

    @Override
    public SCorpus getCorpus(Identifier corpusId) {
        SCorpus retVal = null;
        SNode node = (SNode)this.getNode(corpusId.getId());
        if (node instanceof SCorpus) {
            retVal = (SCorpus)node;
        }
        return retVal;
    }

    @Override
    public SDocument getDocument(Identifier documentId) {
        SDocument retVal = null;
        SNode node = (SNode)this.getNode(documentId.getId());
        if (node instanceof SDocument) {
            retVal = (SDocument)node;
        }
        return retVal;
    }

    @Override
    public Identifier addSubCorpus(SCorpus superCorpus, SCorpus subCorpus) {
        if (superCorpus == null) {
            throw new SaltParameterException("superCorpus", "addSubCorpus", this.getClass(), "Cannot add the given subCorpus, because the given superCorpus is null.");
        }
        if (subCorpus == null) {
            throw new SaltParameterException("subCorpus", "addSubCorpus", this.getClass(), "Cannot add the given subCorpus, because it is null.");
        }
        if (superCorpus.getId() == null) {
            throw new SaltInsertionException(this, subCorpus, "Cannot add the given subCorpus, because the given superCorpus is not already contained in corpus graph.");
        }
        if (this.getNode(superCorpus.getId()) == null) {
            throw new SaltInsertionException(this, subCorpus, "Cannot add the given subCorpus, because the given superCorpus is not already contained in corpus graph.");
        }
        String namePart = null;
        namePart = subCorpus.getName();
        if (Strings.isNullOrEmpty((String)namePart)) {
            namePart = "corp_" + this.getCorpora().size();
        }
        GraphFactory.createIdentifier(subCorpus, URI.createURI((String)(superCorpus.getId() + "/" + namePart)).toString());
        this.addNode(subCorpus);
        SCorpusRelation corpRel = SaltFactory.createSCorpusRelation();
        corpRel.setSource(superCorpus);
        corpRel.setTarget(subCorpus);
        this.addRelation(corpRel);
        return corpRel.getIdentifier();
    }

    @Override
    public Identifier addDocument(SCorpus corpus, SDocument document) {
        if (corpus == null) {
            throw new SaltParameterException("corpus", "addDocument", this.getClass(), "Cannot add the given sDocument, because the given sCorpus is null.");
        }
        if (document == null) {
            throw new SaltParameterException("document", "addDocument", this.getClass(), "Cannot add the given sDocument, because it is null.");
        }
        if (this.getNode(corpus.getId()) == null) {
            throw new SaltInsertionException(this, document, "Cannot add the given sDocument, because the given sCorpus is not already contained in corpus graph.");
        }
        String namePart = null;
        namePart = document.getName();
        if (Strings.isNullOrEmpty((String)namePart)) {
            namePart = "doc_" + this.getCorpora().size();
        }
        GraphFactory.createIdentifier(document, URI.createURI((String)(corpus.getId() + "/" + namePart)).toString());
        this.addNode(document);
        SCorpusDocumentRelation corpDocRel = SaltFactory.createSCorpusDocumentRelation();
        corpDocRel.setSource(corpus);
        corpDocRel.setTarget(document);
        this.addRelation(corpDocRel);
        return corpDocRel.getIdentifier();
    }

    @Override
    public SCorpus getCorpus(SDocument document) {
        SCorpus retVal = null;
        if (document != null) {
            List inRels = this.getInRelations(document.getId());
            for (SRelation inEdge : Collections.synchronizedCollection(inRels)) {
                if (!(inEdge instanceof SCorpusDocumentRelation)) continue;
                retVal = (SCorpus)((SCorpusDocumentRelation)inEdge).getSource();
                break;
            }
        }
        return retVal;
    }

    @Override
    public void load(URI corpusGraphUri) {
        SCorpusGraph loaded = SaltUtil.loadCorpusGraph(corpusGraphUri);
        SaltUtil.moveCorpusGraph(loaded, this);
    }

    @Override
    public SCorpus createCorpus(SCorpus superCorpus, String corpusName) {
        SCorpus corpus = SaltFactory.createSCorpus();
        corpus.setName(corpusName);
        if (superCorpus != null) {
            this.addSubCorpus(superCorpus, corpus);
        } else {
            this.addNode(corpus);
        }
        return corpus;
    }

    @Override
    public SDocument createDocument(SCorpus parentCorpus, String documentName) {
        SDocument document = SaltFactory.createSDocument();
        document.setName(documentName);
        this.addDocument(parentCorpus, document);
        return document;
    }

    @Override
    public List<SCorpus> createCorpus(URI corpusPath) {
        URI cPath = SaltUtil.createSaltURI(corpusPath);
        ArrayList<SCorpus> retVal = null;
        if (cPath != null) {
            SCorpus parentCorpus = null;
            for (int i = cPath.segments().length - 1; i >= 0; --i) {
                URI currPath = cPath.trimSegments(i);
                String id = currPath.toString();
                SNode node = (SNode)this.getNode(id);
                if (node == null) {
                    parentCorpus = this.createCorpus(parentCorpus, currPath.lastSegment());
                    if (retVal == null) {
                        retVal = new ArrayList<SCorpus>();
                    }
                    retVal.add(parentCorpus);
                    continue;
                }
                parentCorpus = (SCorpus)node;
            }
        }
        return retVal;
    }

    @Override
    public SDocument createDocument(URI documentPath) {
        URI dPath = SaltUtil.createSaltURI(documentPath);
        SDocument retVal = null;
        List<SCorpus> corpora = this.createCorpus(dPath.trimSegments(1));
        if (corpora == null || corpora.size() == 0) {
            corpora = new ArrayList<SCorpus>();
            String id = dPath.trimSegments(1).toString();
            corpora.add((SCorpus)this.getNode(id));
        }
        retVal = this.createDocument(corpora.get(corpora.size() - 1), dPath.lastSegment());
        return retVal;
    }

    @Override
    public String toTreeString() {
        List<SNode> roots = this.getRoots();
        StringBuilder str = new StringBuilder();
        if (SaltUtil.isNotNullOrEmpty(roots)) {
            for (SNode root : roots) {
                str.append(this.reportCorpusStructure(this, root, "", true));
            }
        }
        return str.toString();
    }

    private String reportCorpusStructure(SGraph sGraph, SNode node, String prefix, boolean isTail) {
        StringBuilder retStr = new StringBuilder();
        retStr.append(prefix);
        retStr.append((isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + node.getName());
        retStr.append("\n");
        List outRelations = sGraph.getOutRelations(node.getId());
        int i = 0;
        for (SRelation out : outRelations) {
            boolean newTail = true;
            if (i < outRelations.size() - 1) {
                newTail = false;
            }
            retStr.append(this.reportCorpusStructure(sGraph, (SNode)out.getTarget(), prefix + (isTail ? "    " : "\u2502   "), newTail));
            ++i;
        }
        return retStr.toString();
    }
}

