/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;

public class LayerImpl<N extends Node, R extends Relation<N, N>>
extends IdentifiableElementImpl
implements Layer<N, R> {
    private Set<N> nodes = new HashSet<N>();
    private Set<R> relations = new HashSet<R>();
    protected Graph graph = null;

    public LayerImpl() {
    }

    public LayerImpl(Layer<N, R> delegate) {
        super(delegate);
    }

    @Override
    protected Layer<N, R> getDelegate() {
        return (Layer)super.getDelegate();
    }

    @Override
    public Graph getGraph() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getGraph();
        }
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        if (this.getDelegate() != null) {
            this.getDelegate().setGraph(graph);
            return;
        }
        if (graph != null) {
            if (graph instanceof GraphImpl) {
                ((GraphImpl)graph).basicAddLayer(this);
            }
        } else if (this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).basicRemoveLayer(this);
        }
        this.basicSetGraph(graph);
    }

    protected void basicSetGraph(Graph graph) {
        if (this.getDelegate() != null && this.getDelegate() instanceof LayerImpl) {
            ((LayerImpl)this.getDelegate()).basicSetGraph(graph);
            return;
        }
        if (this.graph != graph && this.graph instanceof GraphImpl) {
            ((GraphImpl)this.graph).basicRemoveLayer(this);
        }
        this.graph = graph;
    }

    protected void basicSetGraph_WithoutRemoving(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Set<N> getNodes() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getNodes();
        }
        return Collections.unmodifiableSet(this.nodes);
    }

    @Override
    public void addNode(N node) {
        if (this.getDelegate() != null) {
            this.getDelegate().addNode(node);
            return;
        }
        if (this.getGraph() != null && !this.getGraph().containsNode(node.getId())) {
            this.getGraph().addNode(node);
        }
        this.nodes.add(node);
    }

    @Override
    public void removeNode(N node) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeNode(node);
            return;
        }
        if (this.nodes != null) {
            this.nodes.remove(node);
        }
    }

    @Override
    public Set<R> getRelations() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getRelations();
        }
        return Collections.unmodifiableSet(this.relations);
    }

    @Override
    public void addRelation(Relation<? extends N, ? extends N> relation) {
        if (this.getDelegate() != null) {
            this.getDelegate().addRelation(relation);
            return;
        }
        if (this.getGraph() != null && !this.getGraph().containsRelation(relation.getId())) {
            this.getGraph().addRelation(relation);
        }
        this.relations.add(relation);
    }

    @Override
    public void removeRelation(Relation<? extends N, ? extends N> relation) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeRelation(relation);
            return;
        }
        if (relation != null) {
            this.relations.remove(relation);
        }
    }
}

