/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.salt.Beta;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;

public class RelationImpl<S extends Node, T extends Node>
extends IdentifiableElementImpl
implements Relation<S, T> {
    protected S source = null;
    private T target = null;
    protected Graph graph = null;

    public RelationImpl() {
    }

    public RelationImpl(Relation<S, T> delegate) {
        super(delegate);
    }

    @Override
    public Relation<S, T> getDelegate() {
        return (Relation)super.getDelegate();
    }

    @Override
    public S getSource() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getSource();
        }
        return this.source;
    }

    @Override
    public void setSource(S source) {
        if (source == null) {
            return;
        }
        if (this.getDelegate() != null) {
            this.getDelegate().setSource(source);
            return;
        }
        S oldValue = this.getSource();
        this.source = source;
        if (this.getGraph() != null && this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).update(oldValue, this, GraphImpl.UPDATE_TYPE.RELATION_SOURCE);
        }
    }

    @Override
    public T getTarget() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getTarget();
        }
        return this.target;
    }

    @Override
    public void setTarget(T target) {
        if (this.getDelegate() != null) {
            this.getDelegate().setTarget(target);
            return;
        }
        T oldValue = this.getTarget();
        this.target = target;
        if (this.getGraph() != null && this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).update(oldValue, this, GraphImpl.UPDATE_TYPE.RELATION_TARGET);
        }
    }

    @Override
    public Graph getGraph() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getGraph();
        }
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        if (this.getDelegate() != null) {
            this.getDelegate().setGraph(graph);
            return;
        }
        Graph oldGraph = this.getGraph();
        if (graph != null) {
            graph.addRelation(this);
        }
        if (oldGraph != null && oldGraph != graph && oldGraph instanceof GraphImpl) {
            ((GraphImpl)oldGraph).basicRemoveRelation(this);
        }
        this.basicSetGraph(graph);
    }

    protected void basicSetGraph(Graph graph) {
        if (this.getDelegate() != null && this.getDelegate() instanceof RelationImpl) {
            ((RelationImpl)this.getDelegate()).basicSetGraph(graph);
            return;
        }
        if (this.graph != graph && this.graph instanceof GraphImpl) {
            ((GraphImpl)this.graph).basicRemoveRelation(this);
        }
        this.graph = graph;
    }

    @Beta
    public void basicSetGraph_WithoutRemoving(Graph graph) {
        if (this.getDelegate() != null && this.getDelegate() instanceof RelationImpl) {
            ((RelationImpl)this.getDelegate()).basicSetGraph_WithoutRemoving(graph);
            return;
        }
        this.graph = graph;
    }

    @Override
    public Set<? extends Layer> getLayers() {
        Set allLayers;
        if (this.getDelegate() != null) {
            return this.getDelegate().getLayers();
        }
        HashSet<Layer> layers = new HashSet<Layer>();
        if (this.getGraph() != null && (allLayers = this.getGraph().getLayers()) != null && allLayers.size() > 0) {
            for (Layer layer : allLayers) {
                if (!layer.getRelations().contains(this)) continue;
                layers.add(layer);
            }
        }
        return layers;
    }

    @Override
    public void addLayer(Layer layer) {
        if (this.getDelegate() != null) {
            this.getDelegate().addLayer(layer);
        }
        if (layer != null) {
            layer.addRelation(this);
        }
    }

    @Override
    public void removeLayer(Layer layer) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeLayer(layer);
        }
        if (layer != null) {
            layer.removeRelation(this);
        }
    }
}

