/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.AbstractDiff;

public class CorpusStructureDiff
extends AbstractDiff<SCorpusGraph> {
    public CorpusStructureDiff(SCorpusGraph template, SCorpusGraph other) {
        super(template, other);
    }

    public CorpusStructureDiff(SCorpusGraph template, SCorpusGraph other, DiffOptions options) {
        super(template, other, options);
    }

    @Override
    protected boolean findDiffs(boolean diffsRequested) {
        if (!CorpusStructureDiff.compareSize((SCorpusGraph)this.templateObject, (SCorpusGraph)this.otherObject) && !diffsRequested) {
            return false;
        }
        List<SNode> templateRoots = ((SCorpusGraph)this.templateObject).getRoots();
        List<SNode> otherRoots = ((SCorpusGraph)this.otherObject).getRoots();
        boolean isIsomorph = true;
        if (SaltUtil.isNotNullOrEmpty(otherRoots) && SaltUtil.isNotNullOrEmpty(templateRoots)) {
            ArrayList<SNode> remainingOtherNodes = new ArrayList<SNode>(((SCorpusGraph)this.templateObject).getCorpora().size() + ((SCorpusGraph)this.templateObject).getDocuments().size());
            remainingOtherNodes.addAll(((SCorpusGraph)this.otherObject).getCorpora());
            remainingOtherNodes.addAll(((SCorpusGraph)this.otherObject).getDocuments());
            for (SNode templateRoot : templateRoots) {
                boolean hasPartner = false;
                for (SNode otherRoot : otherRoots) {
                    HashSet<Difference> subDiffs = new HashSet<Difference>();
                    this.compareIdentifiableElements(templateRoot, otherRoot, subDiffs);
                    this.compareAnnotationContainers(templateRoot, otherRoot, subDiffs);
                    if (!subDiffs.isEmpty()) continue;
                    this.getIsoNodes().put((Object)templateRoot, (Object)otherRoot);
                    remainingOtherNodes.remove(otherRoot);
                    hasPartner = true;
                    break;
                }
                if (hasPartner) continue;
                if (!diffsRequested) {
                    return false;
                }
                this.addDifference(templateRoot, null, null, DIFF_TYPES.NODE_MISSING, null);
                isIsomorph = false;
            }
            DifferenceHandler handler = new DifferenceHandler();
            handler.remainingOtherNodes = remainingOtherNodes;
            ((SCorpusGraph)this.templateObject).traverse(templateRoots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "diff_" + ((SCorpusGraph)this.templateObject).getId(), handler, false);
            if (this.getDifferences().size() > 0) {
                return false;
            }
            if (remainingOtherNodes.size() > 0) {
                for (SNode remainingNode : remainingOtherNodes) {
                    if (!diffsRequested) {
                        return false;
                    }
                    this.addDifference(null, remainingNode, null, DIFF_TYPES.NODE_MISSING, null);
                }
            }
            if (!this.compareDocumentStructures()) {
                return false;
            }
        }
        return isIsomorph;
    }

    private boolean compareDocumentStructures() {
        boolean retVal = true;
        if (!((Boolean)this.options.get("ignoreDocuments")).booleanValue()) {
            for (SDocument templateDoc : ((SCorpusGraph)this.templateObject).getDocuments()) {
                SDocument otherDoc = (SDocument)this.getIsoNodes().get((Object)templateDoc);
                if (otherDoc == null) continue;
                if (templateDoc.getDocumentGraph() == null && templateDoc.getDocumentGraphLocation() != null) {
                    templateDoc.loadDocumentGraph();
                }
                if (otherDoc.getDocumentGraph() == null && otherDoc.getDocumentGraphLocation() != null) {
                    otherDoc.loadDocumentGraph();
                }
                if (templateDoc.getDocumentGraph() == null || otherDoc.getDocumentGraph() == null) continue;
                boolean isIsomorph = false;
                if (!this.diffsRequested) {
                    isIsomorph = SaltUtil.compare(templateDoc.getDocumentGraph()).with(otherDoc.getDocumentGraph()).useOptions(this.options).andCheckIsomorphie();
                    if (!isIsomorph) {
                        return false;
                    }
                } else {
                    Set<Difference> subDiffs = SaltUtil.compare(templateDoc.getDocumentGraph()).with(otherDoc.getDocumentGraph()).useOptions(this.options).andFindDiffs();
                    if (subDiffs.size() > 0) {
                        this.addDifference(templateDoc, otherDoc, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
                        isIsomorph = false;
                    } else {
                        isIsomorph = true;
                    }
                }
                retVal = retVal && isIsomorph;
            }
        }
        return retVal;
    }

    private static boolean compareSize(SCorpusGraph template, SCorpusGraph other) {
        if (template.getNodes().size() != other.getNodes().size()) {
            return false;
        }
        if (template.getRelations().size() != other.getRelations().size()) {
            return false;
        }
        if (template.getCorpora().size() != other.getCorpora().size()) {
            return false;
        }
        if (template.getCorpusRelations().size() != other.getCorpusRelations().size()) {
            return false;
        }
        if (template.getDocuments().size() != other.getDocuments().size()) {
            return false;
        }
        return template.getCorpusDocumentRelations().size() == other.getCorpusDocumentRelations().size();
    }

    private class DifferenceHandler
    implements GraphTraverseHandler {
        List<SNode> remainingOtherNodes = null;
        private Set<SRelation> visitedRelations = new HashSet<SRelation>();

        private DifferenceHandler() {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation sRelation, SNode currNode, long order) {
            boolean retVal = true;
            if (sRelation != null) {
                if (this.visitedRelations.contains(sRelation)) {
                    retVal = false;
                } else {
                    this.visitedRelations.add(sRelation);
                }
            }
            return retVal;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode templateNode, SRelation sRelation, SNode fromNode, long order) {
            if (fromNode != null && templateNode != null) {
                SNode otherParent = (SNode)CorpusStructureDiff.this.getIsoNodes().get((Object)fromNode);
                boolean hasFoundNode = false;
                if (otherParent != null) {
                    List<SNode> otherChilds = ((SCorpusGraph)CorpusStructureDiff.this.otherObject).getChildren(otherParent, null);
                    for (SNode otherChild : otherChilds) {
                        if (!templateNode.getClass().equals(otherChild.getClass()) || !CorpusStructureDiff.this.compareIdentifiableElements(templateNode, otherChild, null) || !CorpusStructureDiff.this.compareAnnotationContainers(templateNode, otherChild, null)) continue;
                        CorpusStructureDiff.this.getIsoNodes().put((Object)templateNode, (Object)otherChild);
                        this.remainingOtherNodes.remove(otherChild);
                        hasFoundNode = true;
                        break;
                    }
                }
                if (!hasFoundNode) {
                    CorpusStructureDiff.this.addDifference(templateNode, null, null, DIFF_TYPES.NODE_MISSING, null);
                }
            }
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode otherNode, long order) {
        }
    }
}

