/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDocumentGraphObject;
import org.corpus_tools.salt.common.SSequentialRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextOverlappingRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimeOverlappingRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;

public class GetXBySequence {
    private final SDocumentGraph documentGraph;

    public GetXBySequence(SDocumentGraph documentGraph) {
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method please set the document graph first.");
        }
        this.documentGraph = documentGraph;
    }

    public List<SToken> getTokensBySequence(DataSourceSequence DataSourceSequence2) {
        List<SNode> tokens = this.getSNodesBySequence(DataSourceSequence2, Arrays.asList(SToken.class));
        return tokens;
    }

    public List<SSpan> getSpanBySequence(DataSourceSequence DataSourceSequence2) {
        List<SNode> spans = this.getSNodesBySequence(DataSourceSequence2, Arrays.asList(SSpan.class));
        return spans;
    }

    public List<SStructure> getStructureBySequence(DataSourceSequence DataSourceSequence2) {
        List<SNode> structs = this.getSNodesBySequence(DataSourceSequence2, Arrays.asList(SStructure.class));
        return structs;
    }

    public List<SNode> getNodeBySequence(DataSourceSequence DataSourceSequence2) {
        List<SNode> nodes = this.getSNodesBySequence(DataSourceSequence2, Arrays.asList(SNode.class));
        return nodes;
    }

    private List<SNode> getSNodesBySequence(DataSourceSequence sequence, List<Class<? extends SNode>> nodeClasses) {
        if (sequence == null) {
            throw new SaltParameterException("Cannot start returning nodes overlapping a data source, because the 'DataSourceSequence' object, determining the sequence which shall be overlapped is empty.");
        }
        if (sequence.getStart() == null) {
            throw new SaltParameterException("Cannot start returning nodes overlapping a data source, because the 'sStart' value of the 'DataSourceSequence' object, determining the sequence which shall be overlapped is empty.");
        }
        if (sequence.getEnd() == null) {
            throw new SaltParameterException("Cannot start returning nodes overlapping a data source, because the 'sEnd' value of the 'DataSourceSequence' object, determining the sequence which shall be overlapped is empty.");
        }
        List<? extends SSequentialRelation> relations = this.findRelationsToDataSourceSequence(this.documentGraph, sequence);
        List<SToken> tokens = this.findTokensReferedByRelationsInSequence(relations, sequence);
        ArrayList<SNode> nodes = new ArrayList<SNode>();
        nodes.addAll(this.findNodesOverlappingTokens(tokens, nodeClasses, this.findRelationTypeToDataSourceSequence(sequence)));
        return nodes;
    }

    Class<? extends Relation> findRelationTypeToDataSourceSequence(DataSourceSequence<?> sequence) {
        if (sequence == null || sequence.getDataSource() == null) {
            return null;
        }
        if (sequence.getDataSource() instanceof STextualDS) {
            return STextOverlappingRelation.class;
        }
        if (sequence.getDataSource() instanceof STimeline) {
            return STimeOverlappingRelation.class;
        }
        return null;
    }

    private List<? extends SSequentialRelation> findRelationsToDataSourceSequence(SDocumentGraph documentGraph, DataSourceSequence<Number> sequence) {
        List<SDocumentGraphObject> relations = null;
        if (sequence.getDataSource() instanceof STextualDS) {
            relations = documentGraph.getTextualRelations();
        } else if (sequence.getDataSource() instanceof STimeline) {
            relations = documentGraph.getTimelineRelations();
        } else {
            throw new SaltParameterException("Cannot compute overlaped nodes, because the given dataSource is not supported by this method.");
        }
        return relations;
    }

    private List<SToken> findTokensReferedByRelationsInSequence(List<? extends SSequentialRelation> relations, DataSourceSequence sequence) {
        ArrayList<SToken> tokens = new ArrayList<SToken>();
        for (SSequentialRelation sSequentialRelation : relations) {
            if (!sequence.getDataSource().equals(sSequentialRelation.getTarget()) || !(((Number)sSequentialRelation.getStart()).doubleValue() >= ((Number)sequence.getStart()).doubleValue()) || !(((Number)sSequentialRelation.getEnd()).doubleValue() <= ((Number)sequence.getEnd()).doubleValue())) continue;
            tokens.add((SToken)sSequentialRelation.getSource());
        }
        return tokens;
    }

    private Set<SNode> findNodesOverlappingTokens(List<SToken> tokens, final List<Class<? extends SNode>> nodeClasses, final Class<? extends Relation> relationClazz) {
        if (tokens.isEmpty()) {
            return Collections.emptySet();
        }
        final HashSet<SNode> overlappingNodes = new HashSet<SNode>();
        this.documentGraph.traverse(tokens, SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, "", new GraphTraverseHandler(){

            @Override
            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
                if (nodeClasses == null) {
                    return;
                }
                for (Class nodeClass : nodeClasses) {
                    if (!nodeClass.isAssignableFrom(currNode.getClass())) continue;
                    overlappingNodes.add(currNode);
                }
            }

            @Override
            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            @Override
            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation<SNode, SNode> relation, SNode currNode, long order) {
                if (relation == null) {
                    return true;
                }
                return relationClazz != null && relationClazz.isAssignableFrom(relation.getClass());
            }
        }, false);
        return overlappingNodes;
    }
}

