/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.extensions.notification.common.impl;

import java.util.Collection;
import java.util.List;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.common.impl.SCorpusGraphImpl;
import org.corpus_tools.salt.extensions.notification.Listener;
import org.corpus_tools.salt.extensions.notification.graph.Notifier;
import org.corpus_tools.salt.extensions.notification.graph.impl.NotifierHelper;
import org.corpus_tools.salt.graph.GRAPH_ATTRIBUTES;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;

public class CorpusGraphNotifierImpl
extends SCorpusGraphImpl
implements SCorpusGraph,
Notifier {
    protected List<Listener> listenerList = null;

    @Override
    public List<Listener> getListener() {
        return NotifierHelper.getListener(this.listenerList);
    }

    @Override
    public synchronized void addListener(Listener listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public void addListener(Collection<Listener> listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public synchronized void removeListener(Listener listener) {
        this.listenerList = NotifierHelper.removeListener(this.listenerList, listener);
    }

    public void setSaltProject(SaltProject saltProject) {
        SaltProject oldSaltProject = this.getSaltProject();
        super.setSaltProject(saltProject);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.GRAPH_NODES, oldSaltProject, saltProject, this);
    }

    public Identifier addSubCorpus(SCorpus superCorpus, SCorpus subCorpus) {
        Identifier newIdentifier = super.addSubCorpus(superCorpus, subCorpus);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, subCorpus, this);
        return newIdentifier;
    }

    public Identifier addDocument(SCorpus corpus, SDocument document) {
        Identifier newIdentifier = super.addDocument(corpus, document);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, document, this);
        return newIdentifier;
    }

    public SCorpus createCorpus(SCorpus superCorpus, String corpusName) {
        SCorpus newCorpus = super.createCorpus(superCorpus, corpusName);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, newCorpus, this);
        return newCorpus;
    }

    public SDocument createDocument(SCorpus parentCorpus, String documentName) {
        SDocument newDocument = super.createDocument(parentCorpus, documentName);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, newDocument, this);
        return newDocument;
    }

    public List<SCorpus> createCorpus(URI corpusPath) {
        List oldCorporaList = this.getCorpora();
        List corporaList = super.createCorpus(corpusPath);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, oldCorporaList, corporaList, this);
        return corporaList;
    }

    public SDocument createDocument(URI documentPath) {
        SDocument newDocument = super.createDocument(documentPath);
        NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, newDocument, this);
        return newDocument;
    }
}

