/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.extensions.notification.graph.impl;

import java.util.Collection;
import java.util.List;
import org.corpus_tools.salt.extensions.notification.Listener;
import org.corpus_tools.salt.extensions.notification.graph.Notifier;
import org.corpus_tools.salt.extensions.notification.graph.impl.NotifierHelper;
import org.corpus_tools.salt.graph.GRAPH_ATTRIBUTES;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.LayerImpl;

public class LayerNotifierImpl<N extends Node, R extends Relation<N, N>>
extends LayerImpl<N, R>
implements Layer<N, R>,
Notifier {
    protected List<Listener> listenerList = null;

    @Override
    public List<Listener> getListener() {
        return NotifierHelper.getListener(this.listenerList);
    }

    @Override
    public synchronized void addListener(Listener listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public void addListener(Collection<Listener> listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public synchronized void removeListener(Listener listener) {
        this.listenerList = NotifierHelper.removeListener(this.listenerList, listener);
    }

    public void addLabel(Label label) {
        super.addLabel(label);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.LAYER_LABELS, null, label, this);
        }
    }

    public void removeLabel(String qName) {
        Label oldValue = this.getLabel(qName);
        super.removeLabel(qName);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.LAYER_LABELS, oldValue, null, this);
        }
    }

    public void removeAll() {
        Collection oldValue = this.getLabels();
        super.removeAll();
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE_ALL, GRAPH_ATTRIBUTES.LAYER_LABELS, oldValue, null, this);
        }
    }

    public void addNode(N node) {
        super.addNode(node);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.LAYER_NODES, null, node, this);
        }
    }

    public void removeNode(N node) {
        super.removeNode(node);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.LAYER_NODES, node, null, this);
        }
    }

    public void addRelation(Relation<? extends N, ? extends N> relation) {
        super.addRelation(relation);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.LAYER_RELATIONS, null, relation, this);
        }
    }

    public void removeRelation(Relation<? extends N, ? extends N> relation) {
        super.removeRelation(relation);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.LAYER_RELATIONS, relation, null, this);
        }
    }
}

