/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.extensions.notification.graph.impl;

import java.util.Collection;
import java.util.List;
import org.corpus_tools.salt.extensions.notification.Listener;
import org.corpus_tools.salt.extensions.notification.graph.Notifier;
import org.corpus_tools.salt.extensions.notification.graph.impl.NotifierHelper;
import org.corpus_tools.salt.graph.GRAPH_ATTRIBUTES;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.impl.LabelImpl;

public class LabelNotifierImpl
extends LabelImpl
implements Label,
Notifier {
    protected List<Listener> listenerList = null;

    @Override
    public List<Listener> getListener() {
        return NotifierHelper.getListener(this.listenerList);
    }

    @Override
    public synchronized void addListener(Listener listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public void addListener(Collection<Listener> listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public synchronized void removeListener(Listener listener) {
        this.listenerList = NotifierHelper.removeListener(this.listenerList, listener);
    }

    public void addLabel(Label label) {
        super.addLabel(label);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.LABEL_LABELS, null, label, this);
        }
    }

    public void removeLabel(String qName) {
        Label oldValue = this.getLabel(qName);
        super.removeLabel(qName);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.LABEL_LABELS, oldValue, null, this);
        }
    }

    public void removeAll() {
        Collection oldValue = this.getLabels();
        super.removeAll();
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE_ALL, GRAPH_ATTRIBUTES.LABEL_LABELS, oldValue, null, this);
        }
    }

    public void setNamespace(String namespace) {
        String oldValue = this.getNamespace();
        super.setNamespace(namespace);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.LABEL_NAMESPACE, oldValue, namespace, this);
        }
    }

    public void setName(String name) {
        String oldValue = this.getName();
        super.setName(name);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.LABEL_NAME, oldValue, name, this);
        }
    }

    public void setQName(String qName) {
        String oldNamespace = this.getNamespace();
        String oldName = this.getName();
        super.setQName(qName);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.LABEL_NAMESPACE, oldNamespace, this.getNamespace(), this);
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.LABEL_NAME, oldName, this.getName(), this);
        }
    }

    public void setValue(Object value) {
        Object oldValue = this.getValue();
        super.setValue(value);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.LABEL_VALUE, oldValue, value, this);
        }
    }
}

